/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.outils.GLS;
import gls.outils.fichier.FichierCONFIG;
import gls.outils.ui.ComposantGLS;
import gls.outils.ui.ComposantsGLS;
import gls.outils.ui.ConstantesUI;
import gls.outils.ui.LabelGLS;
import gls.outils.ui.saisie.composant.ComposantSaisieGLS;
import gls.outils.ui.saisie.composant.ComposantsSaisieGLS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GlsUI
implements ConstantesUI {
    private static GlsUI instance;
    public static String NOM_FONT;
    public static Font FONT;
    public static Font FONT_LABEL;
    public static Font FONT_LABEL_GLS;
    public static Font FONT_COMBOBOX;
    public static Font FONT_CALENDRIER;
    public static Font FONT_CHECKBOX;
    public static Font FONT_RADIO;
    public static Font FONT_TEXTBOX;
    public static Font FONT_LISTE;
    public static String CHEMIN_IMAGES;
    public static String IMAGE_LABEL;
    public static String IMAGE_LABEL_SECTION;
    public static String IMAGE_LABEL_GAUCHE;
    public static int HAUTEUR_LABEL;
    public static int LARGEUR_LABEL_GAUCHE;
    public static int HAUTEUR_BOUTON;
    public static int LARGEUR_PANNEAU;
    public static int LARGEUR_COMPOSANT;
    public static int HAUTEUR_COMPOSANT;
    public static Color COULEUR_FOND_COMPOSANTS;
    public static Color COULEUR_FOND_CHECKBOX;
    public static Color COULEUR_FOND_LABEL;
    public static Color COULEUR_FOND_RADIO;
    public static Color COULEUR_FOND_COMBOBOX;
    public static Color COULEUR_FOND_PANNEAU;
    public static Color COULEUR_FOND_TEXTBOX;
    public static Color COULEUR_FOND_LISTE;
    public static Color COULEUR_BORDURE_COMPOSANTS;
    public static Color COULEUR_BORDURE_CHECKBOX;
    public static Color COULEUR_BORDURE_LABEL;
    public static Color COULEUR_BORDURE_RADIO;
    public static Color COULEUR_BORDURE_COMBOBOX;
    public static Color COULEUR_BORDURE_PANNEAU;
    public static Color COULEUR_BORDURE_TEXTBOX;
    public static Color COULEUR_BORDURE_LISTE;
    public static int EPAISSEUR_BORDURE_COMPOSANTS;
    public static int EPAISSEUR_BORDURE_PANNEAU;
    public static boolean ACTIVER_BORDURE_COMPOSANTS;
    public static boolean ACTIVER_BORDURE_PANNEAU;
    public static int STYLE_PANNEAU_AFFICHAGE;

    static {
        NOM_FONT = "BankGothic Md BT";
        FONT = FONT_DEFAUT;
        FONT_LABEL = FONT_LABEL_DEFAUT;
        FONT_LABEL_GLS = FONT_LABEL_DEFAUT;
        FONT_COMBOBOX = FONT_DEFAUT;
        FONT_CALENDRIER = FONT_DEFAUT;
        FONT_CHECKBOX = FONT_DEFAUT;
        FONT_RADIO = FONT_DEFAUT;
        FONT_TEXTBOX = FONT_DEFAUT;
        FONT_LISTE = FONT_DEFAUT;
        CHEMIN_IMAGES = "images/";
        IMAGE_LABEL = "labelDefaut";
        IMAGE_LABEL_SECTION = "labelDefaut";
        IMAGE_LABEL_GAUCHE = "labelGaucheDefaut";
        HAUTEUR_LABEL = 18;
        LARGEUR_LABEL_GAUCHE = 100;
        HAUTEUR_BOUTON = 30;
        LARGEUR_PANNEAU = 426;
        LARGEUR_COMPOSANT = 416;
        HAUTEUR_COMPOSANT = 30;
        COULEUR_FOND_COMPOSANTS = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_CHECKBOX = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_LABEL = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_RADIO = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_COMBOBOX = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_PANNEAU = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_TEXTBOX = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_FOND_LISTE = COULEUR_FOND_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_COMPOSANTS = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_CHECKBOX = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_LABEL = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_RADIO = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_COMBOBOX = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_PANNEAU = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_TEXTBOX = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        COULEUR_BORDURE_LISTE = COULEUR_BORDURE_COMPOSANTS_DEFAUT;
        EPAISSEUR_BORDURE_COMPOSANTS = 1;
        EPAISSEUR_BORDURE_PANNEAU = 1;
        ACTIVER_BORDURE_COMPOSANTS = true;
        ACTIVER_BORDURE_PANNEAU = true;
        STYLE_PANNEAU_AFFICHAGE = 0;
    }

    public static Dimension getDimensionsEcran() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (Throwable t) {
            return new Dimension(1024, 768);
        }
    }

    private GlsUI() {
    }

    public static GlsUI instanceOf() {
        if (instance == null) {
            instance = new GlsUI();
        }
        return instance;
    }

    private GlsUI(FichierCONFIG config) {
        GlsUI.initialiser(config);
    }

    public static void initialiser(FichierCONFIG config) {
    }

    public static JScrollPane getScollPane(JComponent composant) {
        return new JScrollPane(composant);
    }

    public static JScrollPane getScollPane(JComponent composant, int largeur, int hauteur) {
        JScrollPane scroll = new JScrollPane(composant);
        GLS.fixerTailleObjet(scroll, largeur, hauteur);
        return scroll;
    }

    public static boolean aExtensionImage(String image) {
        return image.toLowerCase().endsWith(".jpg") || image.toLowerCase().endsWith(".gif") || image.toLowerCase().endsWith(".png");
    }

    public static String getCheminImage(String image) {
        return GlsUI.getCheminImage(CHEMIN_IMAGES, image);
    }

    public static String getCheminImage(String cheminImage, String image) {
        if (!image.startsWith(cheminImage)) {
            image = cheminImage.concat(image);
        }
        if (!GlsUI.aExtensionImage(image)) {
            image = image.concat(".jpg");
        }
        return image;
    }

    public static ImageIcon getImage(String image) {
        return GlsUI.getImage(CHEMIN_IMAGES, image);
    }

    public static ImageIcon getImage(String cheminImage, String image) {
        return new ImageIcon(GlsUI.getCheminImage(cheminImage, image));
    }

    public JButton creerBoutonAction(String libelle, String action, ImageIcon image, ActionListener actionListener, String infoAction) {
        JButton jbAction = new JButton();
        if (image != null) {
            jbAction.setIcon(image);
        }
        if (libelle != null) {
            jbAction.setText(libelle);
        }
        if (infoAction != null) {
            jbAction.setToolTipText(infoAction);
        }
        if (actionListener != null) {
            jbAction.addActionListener(actionListener);
        }
        if (action != null) {
            jbAction.setActionCommand(action);
            jbAction.setName(action);
        }
        jbAction.setBackground(Color.white);
        return jbAction;
    }

    public JButton creerBoutonAction(String image, ActionListener actionListener, String infoAction) {
        return this.creerBoutonAction("", image, actionListener, infoAction);
    }

    public JButton creerBoutonAction(String image, ActionListener actionListener) {
        return this.creerBoutonAction(image, image, actionListener, "");
    }

    public JButton creerBoutonAction(String action, String image, ActionListener actionListener, String infoAction) {
        return this.creerBoutonAction(action, image, actionListener, infoAction, 0);
    }

    public JButton creerBoutonAction(String affichage, ActionListener actionListener, String infoAction, int type) {
        return this.creerBoutonAction("", affichage, actionListener, infoAction);
    }

    public JButton creerBoutonAction(String affichage, ActionListener actionListener, int type) {
        return this.creerBoutonAction(affichage, affichage, actionListener, "");
    }

    public JButton creerBoutonAction(String action, String affichage, ActionListener actionListener, String infoAction, int type) {
        if (type == 0) {
            return this.creerBoutonAction(null, action, new ImageIcon(GlsUI.getCheminImage(affichage)), actionListener, infoAction);
        }
        return this.creerBoutonAction(affichage, action, null, actionListener, infoAction);
    }

    public JPanel creerPanneau(LayoutManager layout, int hauteur) {
        return this.creerPanneau(layout, hauteur, LARGEUR_PANNEAU);
    }

    public JPanel creerPanneau(LayoutManager layout, int hauteur, int largeur) {
        JPanel panneau = new JPanel(layout);
        GLS.fixerTailleObjet(panneau, largeur, hauteur);
        panneau.setBackground(COULEUR_FOND_PANNEAU);
        return panneau;
    }

    public Box creerPanneauVertical(int hauteur, int largeur) {
        Box panneau = Box.createVerticalBox();
        GLS.fixerTailleObjet(panneau, largeur, hauteur);
        panneau.setBackground(COULEUR_FOND_PANNEAU);
        return panneau;
    }

    public Box creerPanneauHorizontal(int hauteur, int largeur) {
        Box panneau = Box.createHorizontalBox();
        GLS.fixerTailleObjet(panneau, largeur, hauteur);
        panneau.setBackground(COULEUR_FOND_PANNEAU);
        return panneau;
    }

    public JPanel creerPanneauComposants(ComposantsGLS composants) {
        JPanel panneauComposants = null;
        if (composants != null) {
            panneauComposants = this.creerPanneau(new FlowLayout(), composants.getHauteur(), composants.getLargeur());
            for (ComposantGLS composant : composants) {
                try {
                    panneauComposants.add(composant.getComposant());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return panneauComposants;
    }

    public JPanel creerPanneauComposantsGrille(ComposantsSaisieGLS composants) {
        JPanel panneauComposants = null;
        if (composants != null) {
            try {
                panneauComposants = (JPanel)this.creerPanneauAffichageGrille(composants.toComponents(), composants.getHauteur(), composants.getLargeur(), composants.size(), 1).getComposant();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return panneauComposants;
    }

    public Box creerPanneauComposantsBox(ComposantsSaisieGLS composants) {
        Box panneauComposants = Box.createVerticalBox();
        if (composants != null) {
            for (ComposantSaisieGLS c : composants) {
                try {
                    panneauComposants.add(c.getComposant());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Box.createVerticalStrut(1);
            }
        }
        GLS.fixerTailleObjet(panneauComposants, composants.getLargeur(), composants.getHauteur());
        return panneauComposants;
    }

    public JPanel creerPanneauComposants(ComposantsSaisieGLS composants) {
        JPanel panneauComposants = this.creerPanneau(new FlowLayout(), composants.getHauteur() + composants.size() * 5, composants.getLargeur());
        this.ajouterComposantsPanneau(panneauComposants, composants);
        return panneauComposants;
    }

    public void ajouterComposantsPanneau(Container panneauComposants, ComposantsSaisieGLS composants) {
        for (ComposantSaisieGLS composant : composants) {
            try {
                panneauComposants.add(composant.getComposant());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JPanel creerPanneauComposantsVertical(ComposantsSaisieGLS composants) {
        Container panneau = null;
        Box panneauComposants = this.creerPanneauVertical(composants.getHauteur() + composants.size() * 5, composants.getLargeur());
        try {
            panneau = this.creerPanneau(new FlowLayout(), composants.getHauteur() + composants.size() * 5, composants.getLargeur());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ajouterComposantsPanneau(panneauComposants, composants);
        panneau.add(panneauComposants);
        return panneau;
    }

    public JPanel creerPanneauActionAnnuler(ActionListener action, int hauteur) {
        return this.creerPanneauActionAnnuler(1, action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionAnnuler(ActionListener action) {
        return this.creerPanneauActionAnnuler(1, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionAnnuler(int type, ActionListener action, int hauteur) {
        return this.creerPanneauActionAnnuler(type, action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionAnnuler(int type, ActionListener action) {
        return this.creerPanneauActionAnnuler(type, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionAnnuler(int type, ActionListener action, int hauteur, int largeur) {
        Vector<JButton> boutons = new Vector<JButton>();
        boutons.add(this.creerBoutonAction("ANNULER", "Annuler", action, null, type));
        return this.creerPanneauAction(boutons, hauteur, largeur);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(int type, ActionListener action, int hauteur) {
        return this.creerPanneauActionOkAppliquerAnnuler(type, action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(int type, ActionListener action) {
        return this.creerPanneauActionOkAppliquerAnnuler(type, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(ActionListener action, int hauteur) {
        return this.creerPanneauActionOkAppliquerAnnuler(action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(ActionListener action) {
        return this.creerPanneauActionOkAppliquerAnnuler(action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(ActionListener action, int hauteur, int largeur) {
        return this.creerPanneauActionOkAppliquerAnnuler(1, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JButton creerBoutonActionAnnuler(ActionListener action) {
        return this.creerBoutonActionAnnuler(action, 0);
    }

    public JButton creerBoutonActionAnnuler(ActionListener action, int type) {
        return this.creerBoutonAction("ANNULER", "Annuler", action, null, type);
    }

    public JPanel creerPanneauActionOkAppliquerAnnuler(int type, ActionListener action, int hauteur, int largeur) {
        Vector<JButton> boutons = new Vector<JButton>();
        boutons.add(this.creerBoutonAction("ANNULER", "Annuler", action, null, type));
        boutons.add(this.creerBoutonAction("APPLIQUER", "Appliquer", action, null, type));
        boutons.add(this.creerBoutonAction("OK", "Ok", action, null, type));
        return this.creerPanneauAction(boutons, hauteur, largeur);
    }

    public JPanel creerPanneauActionOkAnnuler(ActionListener action, int hauteur) {
        return this.creerPanneauActionOkAnnuler(1, action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAnnuler(ActionListener action) {
        return this.creerPanneauActionOkAnnuler(1, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAnnuler(int type, ActionListener action, int hauteur) {
        return this.creerPanneauActionOkAnnuler(type, action, hauteur, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAnnuler(int type, ActionListener action) {
        return this.creerPanneauActionOkAnnuler(type, action, HAUTEUR_BOUTON, LARGEUR_COMPOSANT);
    }

    public JPanel creerPanneauActionOkAnnuler(int type, ActionListener action, int hauteur, int largeur) {
        Vector<JButton> boutons = new Vector<JButton>();
        boutons.add(this.creerBoutonAction("ANNULER", "Annuler", action, null, type));
        boutons.add(this.creerBoutonAction("OK", "Ok", action, null, type));
        return this.creerPanneauAction(boutons, hauteur, largeur);
    }

    public JPanel creerPanneauAction(int[] types, String[] actions, String[] libelles, ActionListener action, int hauteur, int largeur) {
        Vector<JButton> boutons = new Vector<JButton>();
        if (!(GLS.estVide(actions) || GLS.estVide(libelles) || GLS.estVide(types) || actions.length != libelles.length || actions.length != types.length)) {
            int i = 0;
            while (i < actions.length) {
                boutons.add(this.creerBoutonAction(actions[i], libelles[i], action, null, types[i]));
                ++i;
            }
        }
        return this.creerPanneauAction(boutons, hauteur, largeur);
    }

    public JPanel creerPanneauAction(String[] actions, String[] libelles, ActionListener action, int hauteur, int largeur) {
        return this.creerPanneauAction(1, actions, libelles, action, hauteur, largeur);
    }

    public Vector<JButton> creerBoutonsActions(int type, String[] actions, String[] libelles, ActionListener action, int hauteur) {
        Vector<JButton> boutons = new Vector<JButton>();
        if (!GLS.estVide(actions) && !GLS.estVide(libelles) && actions.length == libelles.length) {
            int i = 0;
            while (i < actions.length) {
                boutons.add(this.creerBoutonAction(actions[i], libelles[i], action, null, type));
                ++i;
            }
        }
        return boutons;
    }

    public JPanel creerPanneauAction(int type, String[] actions, String[] libelles, ActionListener action, int hauteur, int largeur) {
        return this.creerPanneauAction(this.creerBoutonsActions(type, actions, libelles, action, hauteur), hauteur, largeur);
    }

    public JPanel creerPanneauAction(Vector<JButton> boutons, int hauteur, int largeur) {
        JPanel panneauAction = null;
        if (!GLS.estVide(boutons)) {
            panneauAction = this.creerPanneau(new GridLayout(1, boutons.size()), hauteur, largeur);
            for (JButton bouton : boutons) {
                panneauAction.add(bouton);
            }
        }
        return panneauAction;
    }

    public ComposantGLS creerPanneauAffichage(ComposantGLS label, ComposantGLS composant, int style) {
        ComposantsGLS composants = new ComposantsGLS();
        composants.add(label);
        composants.add(composant);
        return this.creerPanneauAffichage(composants, style);
    }

    public ComposantGLS creerPanneauAffichage(ComposantGLS label, ComposantGLS composant) {
        return this.creerPanneauAffichage(label, composant, STYLE_PANNEAU_AFFICHAGE);
    }

    public ComposantGLS creerPanneauAffichage(ComposantsGLS composants) {
        return this.creerPanneauAffichage(composants, STYLE_PANNEAU_AFFICHAGE);
    }

    public ComposantGLS creerPanneauAffichage(ComposantsGLS composants, int style) {
        if (style == 0 || style == 4) {
            return this.creerPanneauAffichageLabelEnHaut(composants);
        }
        if (style == 1 || style == 3) {
            return this.creerPanneauAffichageLabelAGauche(composants);
        }
        if (style == 2) {
            return this.creerPanneauAffichageSansLabel(composants);
        }
        return null;
    }

    private ComposantGLS creerPanneauAffichageLabelEnHaut(ComposantsGLS composants) {
        ComposantGLS composant = null;
        if (composants.size() == 2) {
            composant = this.creerPanneauAffichageBordure((ComposantGLS)composants.get(0), null, (ComposantGLS)composants.get(1), null, null);
            composant.setLargeur(LARGEUR_COMPOSANT);
            composant.fixerTailleComposant();
        }
        return composant;
    }

    private ComposantGLS creerPanneauAffichageLabelAGauche(ComposantsGLS composants) {
        ComposantGLS composant = null;
        if (composants.size() == 2) {
            ((ComposantGLS)composants.get(0)).setLargeur(LARGEUR_LABEL_GAUCHE);
            ((ComposantGLS)composants.get(0)).fixerTailleComposant();
            composant = this.creerPanneauAffichageBordure(null, (ComposantGLS)composants.get(0), (ComposantGLS)composants.get(1), null, null);
            composant.setLargeur(LARGEUR_COMPOSANT);
            composant.fixerTailleComposant();
        }
        return composant;
    }

    private ComposantGLS creerPanneauAffichageSansLabel(ComposantsGLS composants) {
        int indice;
        ComposantGLS composant = null;
        if (composants.size() == 1) {
            indice = 0;
        } else if (composants.size() >= 2) {
            indice = 1;
        } else {
            return null;
        }
        composant = this.creerPanneauAffichageBordure(null, null, (ComposantGLS)composants.get(indice), null, null);
        composant.setLargeur(LARGEUR_COMPOSANT);
        composant.fixerTailleComposant();
        return composant;
    }

    public ComposantGLS creerPanneauAffichageGrille(ComposantsGLS composants, int nbLigne, int nbColonne) {
        return this.creerPanneauAffichageGrille(composants.toComponents(), composants.getHauteur(), composants.getLargeur(), nbLigne, nbColonne);
    }

    public ComposantGLS creerPanneauAffichageGrille(ComposantsGLS composants, int hauteur, int nbLigne, int nbColonne) {
        return this.creerPanneauAffichageGrille(composants.toComponents(), hauteur, LARGEUR_COMPOSANT, nbLigne, nbColonne);
    }

    public ComposantGLS creerPanneauAffichageGrille(Vector<JComponent> composants, int hauteur, int largeur, int nbLigne, int nbColonne) {
        ComposantGLS composant = null;
        if (composants.size() > 0) {
            JPanel panneauAffichage = new JPanel(new GridLayout(nbLigne, nbColonne, 1, 1));
            for (JComponent c : composants) {
                try {
                    panneauAffichage.add(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            panneauAffichage.setBackground(COULEUR_FOND_PANNEAU);
            if (ACTIVER_BORDURE_PANNEAU) {
                panneauAffichage.setBorder(BorderFactory.createLineBorder(COULEUR_BORDURE_PANNEAU, EPAISSEUR_BORDURE_PANNEAU));
            }
            composant = new ComposantGLS(hauteur, largeur, panneauAffichage);
        }
        return composant;
    }

    public ComposantGLS creerPanneauAffichageBordure(ComposantGLS composantNord, ComposantGLS composantOuest, ComposantGLS composantCentre, ComposantGLS composantEst, ComposantGLS composantSud) {
        return this.creerPanneauAffichageBordure(LARGEUR_COMPOSANT, composantNord, composantOuest, composantCentre, composantEst, composantSud);
    }

    public ComposantGLS creerPanneauAffichageBordure(int largeur, ComposantGLS composantNord, ComposantGLS composantOuest, ComposantGLS composantCentre, ComposantGLS composantEst, ComposantGLS composantSud) {
        int hauteur = 0;
        ComposantGLS composant = null;
        JPanel panneauAffichage = new JPanel(new BorderLayout());
        if (composantNord != null) {
            try {
                panneauAffichage.add((Component)composantNord.getComposant(), "North");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hauteur += composantNord.getHauteur();
        }
        if (composantOuest != null || composantCentre != null || composantEst != null) {
            boolean hauteurAjoutee = false;
            if (composantOuest != null) {
                try {
                    panneauAffichage.add((Component)composantOuest.getComposant(), "West");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                hauteurAjoutee = true;
                hauteur += composantOuest.getHauteur();
            }
            if (composantCentre != null) {
                try {
                    panneauAffichage.add((Component)composantCentre.getComposant(), "Center");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!hauteurAjoutee) {
                    hauteurAjoutee = true;
                    hauteur += composantCentre.getHauteur();
                }
            }
            if (composantEst != null) {
                try {
                    panneauAffichage.add((Component)composantEst.getComposant(), "East");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!hauteurAjoutee) {
                    hauteurAjoutee = true;
                    hauteur += composantEst.getHauteur();
                }
            }
        }
        if (composantSud != null) {
            try {
                panneauAffichage.add((Component)composantSud.getComposant(), "South");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hauteur += composantSud.getHauteur();
        }
        panneauAffichage.setBackground(COULEUR_FOND_PANNEAU);
        if (ACTIVER_BORDURE_PANNEAU) {
            panneauAffichage.setBorder(BorderFactory.createLineBorder(COULEUR_BORDURE_PANNEAU, EPAISSEUR_BORDURE_PANNEAU));
        }
        composant = new ComposantGLS(hauteur, largeur, panneauAffichage);
        return composant;
    }

    public ComposantGLS creerPanneauAffichage(LabelGLS label, ComposantGLS composant) {
        return this.creerPanneauAffichage(ComposantGLS.toComposantGLS((JComponent)label, HAUTEUR_LABEL, LARGEUR_COMPOSANT), composant);
    }

    public ComposantGLS creerPanneauAffichage(LabelGLS label, JComponent component, int hauteur) {
        return this.creerPanneauAffichage(label, ComposantGLS.toComposantGLS(component, hauteur, LARGEUR_COMPOSANT));
    }

    public ComposantGLS creerPanneauAffichage(String image, JComponent component, int hauteur) {
        return this.creerPanneauAffichage(this.creerLabelAffichage(null, image), ComposantGLS.toComposantGLS(component, hauteur, LARGEUR_COMPOSANT));
    }

    public ComposantGLS creerPanneauAffichage(String libelle, String image, JComponent component, int hauteur) {
        return this.creerPanneauAffichage(this.creerLabelAffichage(libelle, image), ComposantGLS.toComposantGLS(component, hauteur));
    }

    public ComposantGLS creerPanneauAffichage(int style, String libelle, String image, JComponent component, int hauteur) {
        return this.creerPanneauAffichage(this.creerLabelAffichage(libelle, image), ComposantGLS.toComposantGLS(component, hauteur), style);
    }

    public static String getImageStyleDefaut(int style) {
        switch (style) {
            case 1: {
                return IMAGE_LABEL_GAUCHE;
            }
            case 0: {
                return IMAGE_LABEL;
            }
        }
        return "";
    }

    public ComposantGLS creerPanneauAffichage(String libelle, String image, JComponent component, int hauteur, int largeur) {
        return this.creerPanneauAffichage(this.creerLabelAffichage(libelle, image), ComposantGLS.toComposantGLS(component, hauteur, largeur), 0);
    }

    public ComposantGLS creerPanneauAffichage(int style, String libelle, String image, JComponent component, int hauteur, int largeur) {
        return this.creerPanneauAffichage(this.creerLabelAffichage(libelle, image), ComposantGLS.toComposantGLS(component, hauteur, largeur), style);
    }

    public ComposantGLS creerLabelAffichage(int hauteur, int largeur) {
        return this.creerLabelAffichage("", "", hauteur, largeur);
    }

    public ComposantGLS creerLabelAffichage(String libelle, String image, int hauteur, int largeur) {
        return this.creerLabelAffichage(libelle, GlsUI.getImage(image), hauteur, largeur);
    }

    public ComposantGLS creerLabelAffichage(String libelle, String image) {
        return this.creerLabelAffichage(libelle, GlsUI.getImage(image), HAUTEUR_LABEL, LARGEUR_COMPOSANT);
    }

    public ComposantGLS creerLabelAffichage(String libelle, ImageIcon image, int hauteur, int largeur) {
        return ComposantGLS.toComposantGLS((JComponent)GlsUI.creerLabelGLS(libelle, image), hauteur, largeur);
    }

    public static LabelGLS creerLabelGLS(String libelle, String image) {
        return GlsUI.creerLabelGLS(libelle, GlsUI.getImage(image));
    }

    public static LabelGLS creerLabelGLS(String libelle, ImageIcon image) {
        return new LabelGLS(libelle, image);
    }

    public static JButton getBouton(Vector<JButton> liste, String valeur) throws Exception {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if (liste.get(++i).getName().equals(valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return liste.get(i);
        }
        throw new Exception("LE BOUTON " + valeur + " N'A PAS ETE TROUVE");
    }
}

