/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.application.version.Version;
import gls.outils.GLS;
import gls.outils.ui.ComposantGLS;
import gls.outils.ui.ConstantesUI;
import gls.outils.ui.GlsUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public abstract class GLSApplication
extends JFrame
implements WindowListener,
ActionListener,
ConstantesUI {
    private static final Logger LOG = Logger.getLogger(GLSApplication.class);
    protected static GlsUI UI = GlsUI.instanceOf();
    protected String nom;
    protected Version version;
    protected Container contentPane = this.getContentPane();
    protected ComposantGLS composantFinal;
    protected ComposantGLS composantOuest;
    protected ComposantGLS composantNord;
    protected ComposantGLS composantSud;
    protected ComposantGLS composantEst;
    protected ComposantGLS composantCentre;

    public GLSApplication(String nom, Version version) {
        this(nom, version, true, -1, -1);
    }

    public GLSApplication(String nom, Version version, boolean pleinEcran, int largeur, int hauteur) {
        this(nom, version, pleinEcran, true, largeur, hauteur);
    }

    public GLSApplication(String nom, Version version, boolean pleinEcran, boolean afficher, int largeur, int hauteur) {
        super(nom.concat(" V").concat(version.toString()));
        this.nom = nom;
        this.version = version;
        this.initialisation();
        this.initialisationUI();
        this.setDefaultCloseOperation(0);
        this.pack();
        if (pleinEcran) {
            this.mettreEnPleinEcran();
        }
        if (afficher) {
            this.afficher();
        }
        this.actionApresAffichage();
    }

    protected abstract void actionApresAffichage();

    protected abstract String getCheminIconeApplication();

    protected void initialisationIconeApplication() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GLS.getString(this.getCheminIconeApplication(), "")));
    }

    protected WindowListener getWindowListener() {
        return this;
    }

    private void initialisationUI() {
        this.addWindowListener(this.getWindowListener());
        this.initialisationIconeApplication();
        this.initialisationUIHandle();
        this.composantNord = this.getPanneauNordHandle();
        this.composantOuest = this.getPanneauOuestHandle();
        this.composantCentre = this.getPanneauCentreHandle();
        this.composantEst = this.getPanneauEstHandle();
        this.composantSud = this.getPanneauSudHandle();
        this.assemblageUI();
    }

    protected void assemblageUI() {
        this.composantFinal = UI.creerPanneauAffichageBordure(this.composantNord, this.composantOuest, this.composantCentre, this.composantEst, this.composantSud);
        try {
            this.contentPane.add(this.composantFinal.getComposant());
        }
        catch (Exception e) {
            LOG.error((Object)"#--> ERREUR UI GENERALE", (Throwable)e);
        }
    }

    protected abstract ComposantGLS getPanneauNordHandle();

    protected abstract ComposantGLS getPanneauOuestHandle();

    protected abstract ComposantGLS getPanneauCentreHandle();

    protected abstract ComposantGLS getPanneauEstHandle();

    protected abstract ComposantGLS getPanneauSudHandle();

    protected abstract void initialisationUIHandle();

    protected abstract void initialisationHandle();

    protected abstract void initialisationUIEnvironnement();

    private void initialisation() {
        this.contentPane.setLayout(new BorderLayout());
        this.initialisationUIEnvironnement();
        this.initialisationHandle();
    }

    public void afficher(boolean etat) {
        this.setVisible(etat);
    }

    public void afficher() {
        this.afficher(true);
    }

    public void mettreEnPleinEcran() {
        this.setBounds(0, 0, GLSApplication.TAILLE_ECRAN.width, GLSApplication.TAILLE_ECRAN.height);
        this.setSize(TAILLE_ECRAN);
        this.setExtendedState(this.getExtendedState() | 6);
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getActionCommand());
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.fermeture();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void fermeture() {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public abstract void actionPerformed(String var1);
}

