/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.outils.GLS;
import gls.outils.ui.ConstantesUI;
import gls.outils.ui.GlsUIEnvironnement;
import javax.swing.JComponent;

public class ComposantGLS
implements ConstantesUI,
GlsUIEnvironnement {
    protected int largeur;
    protected int hauteur;
    protected JComponent composant;

    public ComposantGLS() {
    }

    public ComposantGLS(JComponent composant) {
        this(-1, 416, composant, true);
    }

    public ComposantGLS(int hauteur, JComponent composant) {
        this(hauteur, 416, composant, true);
    }

    public ComposantGLS(int hauteur, JComponent composant, boolean autoFix) {
        this(hauteur, 416, composant, autoFix);
    }

    public ComposantGLS(int hauteur, int largeur, JComponent composant) {
        this(hauteur, largeur, composant, true);
    }

    public ComposantGLS(int hauteur, int largeur, JComponent composant, boolean autoFix) {
        this.initialiser(hauteur, largeur, composant, autoFix);
    }

    public void initialiser(JComponent composant) {
        this.initialiser(-1, -1, composant, false);
    }

    public void initialiser(ComposantGLS composantGLS) {
        this.initialiser(composantGLS, true);
    }

    public void initialiser(ComposantGLS composantGLS, boolean autoFix) {
        try {
            this.initialiser(composantGLS.getHauteur(), composantGLS.getLargeur(), composantGLS.getComposant(), autoFix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialiser(int hauteur, int largeur, JComponent composant) {
        this.initialiser(hauteur, largeur, composant, false);
    }

    public void initialiser(int hauteur, int largeur, JComponent composant, boolean autoFix) {
        this.hauteur = hauteur;
        this.largeur = largeur;
        this.composant = composant;
        if (autoFix) {
            this.fixerTailleComposant();
        }
    }

    public void fixerTailleComposant() {
        if (this.composant != null && this.hauteur != -1 && this.largeur != -1) {
            GLS.fixerTailleObjet(this.composant, this.largeur, this.hauteur);
        }
    }

    public int getLargeur() {
        return this.largeur;
    }

    public void setLargeur(int largeur) {
        this.largeur = largeur;
    }

    public int getHauteur() {
        return this.hauteur;
    }

    public void setHauteur(int hauteur) {
        this.hauteur = hauteur;
    }

    public JComponent getComposant() throws Exception {
        if (this.composant != null) {
            return this.composant;
        }
        throw new Exception("ERREUR LE COMPOSANT EST NUL");
    }

    public void setComposant(JComponent composant) {
        this.composant = composant;
    }

    public static ComposantGLS toComposantGLS(JComponent composant) {
        return new ComposantGLS(composant);
    }

    public static ComposantGLS toComposantGLS(JComponent composant, int hauteur) {
        return new ComposantGLS(hauteur, composant);
    }

    public static ComposantGLS toComposantGLS(JComponent composant, int hauteur, int largeur) {
        return new ComposantGLS(hauteur, largeur, composant);
    }

    public static ComposantGLS toComposantGLS(JComponent composant, int hauteur, boolean autoFix) {
        return new ComposantGLS(hauteur, composant, autoFix);
    }

    public static ComposantGLS toComposantGLS(JComponent composant, int hauteur, int largeur, boolean autoFix) {
        return new ComposantGLS(hauteur, largeur, composant, autoFix);
    }

    public void afficher(boolean etat) {
        if (this.composant != null) {
            this.composant.setVisible(etat);
        }
    }
}

