/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ui;

import gls.outils.ConstantesGLS;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChoixValeur
extends JComponent
implements ActionListener,
KeyListener {
    protected JButton jbNext = new JButton(new ImageIcon("images/btplus.jpg"));
    protected JButton jbPrev = new JButton(new ImageIcon("images/btmoins.jpg"));
    private JPanel jpBoutons = new JPanel();
    protected JTextField jtfValue = new JTextField("0");
    protected int min;
    protected int max;
    protected int step;
    protected int defaultvalue;

    public ChoixValeur() {
        this(1000, 0, 50000, 500);
    }

    public ChoixValeur(int defaultvalue) {
        this(defaultvalue, 0, 50000, 500);
    }

    public ChoixValeur(int defaultvalue, int min, int max, int step) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.defaultvalue = defaultvalue;
        this.initialiser();
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbNext.setEnabled(enabled);
        this.jbPrev.setEnabled(enabled);
        this.jtfValue.setEditable(enabled);
    }

    private String lng2str(int val) {
        return String.valueOf(val);
    }

    protected void initialiser() {
        this.setLayout(new GridLayout(1, 2));
        this.jpBoutons.setLayout(new GridLayout(1, 2));
        this.jbNext.setBackground(Color.white);
        this.jbPrev.setBackground(Color.white);
        this.jpBoutons.setBackground(Color.white);
        this.jtfValue.setHorizontalAlignment(4);
        this.jtfValue.setText(String.valueOf(this.defaultvalue));
        this.jtfValue.setOpaque(false);
        this.jtfValue.addKeyListener(this);
        this.jpBoutons.add(this.jbPrev);
        this.jpBoutons.add(this.jbNext);
        this.add(this.jtfValue);
        this.add(this.jpBoutons);
        this.ajouterActionListener(this);
    }

    public void ajouterActionListener(ActionListener action) {
        this.jbPrev.addActionListener(action);
        this.jbNext.addActionListener(action);
        this.jtfValue.addActionListener(this);
        this.jbPrev.setActionCommand("prev");
        this.jbNext.setActionCommand("next");
    }

    public void ajouterKeyListener(KeyListener action) {
        KeyListener[] keyListenerArray = this.jtfValue.getKeyListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener k = keyListenerArray[n2];
            this.jtfValue.removeKeyListener(k);
            ++n2;
        }
        this.jtfValue.addKeyListener(action);
    }

    public JTextField getTexteField() {
        return this.jtfValue;
    }

    @Override
    public void setFont(Font font) {
        this.jtfValue.setFont(font);
    }

    public int toInt() {
        return Integer.parseInt(this.jtfValue.getText());
    }

    @Override
    public String toString() {
        return this.jtfValue.getText();
    }

    public double toDouble() {
        return Double.parseDouble(this.jtfValue.getText());
    }

    public void setValue(String value) {
        this.setValue(Double.parseDouble(value));
    }

    public void setValue(double value) {
        this.setValue((int)value);
    }

    public void setValue(int value) {
        this.jtfValue.setText(String.valueOf(value));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char caractereTape = keyEvent.getKeyChar();
        if (!(ConstantesGLS.estNumerique(caractereTape) || this.min < 0 && caractereTape == '-' || caractereTape == '.')) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int x = this.toInt();
        if (a.getSource() == this.jbNext) {
            if ((x += this.step) >= this.max) {
                this.setValue(this.max);
            } else {
                this.setValue(x);
            }
        } else if (a.getSource() == this.jbPrev) {
            if ((x -= this.step) <= this.min) {
                this.setValue(this.min);
            } else {
                this.setValue(x);
            }
        }
    }
}

