/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.sql;

import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.sql.SQL;
import i2.application.banco.db.DataSet;
import java.sql.PreparedStatement;

public class TableSQL {
    public static boolean AJOUTER_TABLES_REQUETE = true;
    public static boolean POSTGRES = true;
    public static final int INDEFINI = -1;
    public static final int VARCHAR = 0;
    public static final int INTEGER = 1;
    public static final int GEOMETRY = 2;
    public static final int DATE_COMPLETE = 3;
    public static final int JOUR = 4;
    public static final int HEURE = 5;
    public static final int DATE_TEXTE_COMPLETE = 6;
    public static final int GEOMETRY_POINT = 7;
    public static final int GEOMETRY_LIGNE = 8;
    public static final int DOUBLE = 9;
    public static final int BOOLEEN = 10;
    public static final int GEOMETRY_LIGNE_ZM = 11;
    private String nom;
    private String cle;
    private String[] champs;
    private int[] format;
    private int epsg;

    public TableSQL(String nom, String[] champs, int[] format, int epsg) {
        this(nom, champs, format, champs[0], epsg);
    }

    public TableSQL(String nom, String[] champs, int[] format) {
        this(nom, champs, format, champs[0], 32630);
    }

    public TableSQL(String nom, String[] champs, int[] format, String cle) {
        this(nom, champs, format, cle, 32630);
    }

    public TableSQL(String nom, String[] champs, int[] format, String cle, int epsg) {
        this.nom = nom;
        this.format = format;
        this.champs = champs;
        this.cle = cle;
        this.epsg = epsg;
    }

    public String getListeChamps() {
        return GLS.getString(this.champs, ",");
    }

    public String getListeChampsAvecTable() {
        String valeur = "";
        if (AJOUTER_TABLES_REQUETE) {
            if (!GLS.estVide(this.champs)) {
                int i = 0;
                while (i < this.champs.length - 1) {
                    valeur = String.valueOf(valeur) + this.getChampAvecTable(this.champs[i]) + ",";
                    ++i;
                }
                valeur = String.valueOf(valeur) + this.getChampAvecTable(this.champs[this.champs.length - 1]);
            }
        } else {
            return this.getListeChamps();
        }
        return valeur;
    }

    public String[] getChamps() {
        return this.champs;
    }

    public String getNom() {
        return this.nom;
    }

    public int getIndiceChamp(String champ) throws Exception {
        int indice = GLS.getIndiceObjetListe(this.champs, champ);
        if (indice != -1) {
            return indice;
        }
        throw new Exception("INDICE NON VALIDE");
    }

    public int getIndiceCle() throws Exception {
        return this.getIndiceChamp(this.cle);
    }

    public String getScriptChamp(int champ, String valeur) {
        return this.getScriptChamp(this.champs[champ], valeur);
    }

    public String getScriptChamp(String champ, long valeur) {
        return this.getScriptChamp(champ, GLS.getString(valeur));
    }

    public String getScriptChamp(String champ, double valeur) {
        return this.getScriptChamp(champ, GLS.getString(valeur));
    }

    public String getScriptChamp(String champ, int valeur) {
        return this.getScriptChamp(champ, GLS.getString(valeur));
    }

    public String getScriptChamp(String champ, String valeur) {
        switch (this.getFormat(champ)) {
            case 1: {
                return SQL.getIntSQL(valeur);
            }
            case 9: {
                return SQL.getDoubleSQL(valeur);
            }
            case 0: {
                return SQL.getStringSQL(valeur);
            }
            case 3: {
                return SQL.getTimestampSQL(valeur, "YYYYMMDDHH24MISS");
            }
            case 4: {
                return SQL.getTimestampSQL(valeur, "DD/MM/YYYY");
            }
            case 5: {
                return SQL.getTimestampSQL(valeur, "HH24:MI");
            }
            case 2: {
                return SQL.getStringSQL(valeur);
            }
            case 10: {
                return SQL.getStringSQL(valeur);
            }
            case 7: {
                return SQL.getChampGeometryPoint(valeur, this.epsg);
            }
            case 8: {
                return SQL.getChampGeometryLine(valeur, this.epsg);
            }
            case 11: {
                return SQL.getChampGeometryLine(valeur, this.epsg);
            }
            case 6: {
                return SQL.getTimestampSQL(valeur, "DD/MM/YYYY HH24:MI:SS");
            }
        }
        return "null";
    }

    public void getScriptChamps(PreparedStatement preparedStatement, String[] champs, String[] valeurs) throws Exception {
        int i = 0;
        while (i < champs.length) {
            this.getScriptChamp(preparedStatement, champs[i], i + 1, valeurs[i]);
            ++i;
        }
    }

    public void getScriptChamp(PreparedStatement preparedStatement, String champ, String valeur) throws Exception {
        this.getScriptChamp(preparedStatement, champ, this.getIndiceChamp(champ), valeur);
    }

    public void getScriptChamp(PreparedStatement preparedStatement, String champ, int indiceChamp, String valeur) {
        try {
            TableSQL.getScriptChamp(preparedStatement, champ, indiceChamp, valeur, this.getFormat(champ));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getScriptChamp(PreparedStatement preparedStatement, String champ, int indiceChamp, Object valeur, int formatChamp) {
        try {
            switch (formatChamp) {
                case 1: {
                    preparedStatement.setInt(indiceChamp, GLS.getInt(valeur));
                    break;
                }
                case 9: {
                    preparedStatement.setDouble(indiceChamp, GLS.getDouble(GLS.getString(valeur)));
                    break;
                }
                case 0: {
                    preparedStatement.setString(indiceChamp, GLS.getString(valeur));
                    break;
                }
                case 10: {
                    preparedStatement.setBoolean(indiceChamp, GLS.getBoolean(GLS.getString(valeur)));
                    break;
                }
                case 2: {
                    if (valeur != null) {
                        preparedStatement.setObject(indiceChamp, valeur);
                        break;
                    }
                    preparedStatement.setNull(indiceChamp, 0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getScriptChamp(String champ, DataSet data) {
        GLS.getLogs().debug((Object)("CHAMP " + champ + "  --> " + this.getFormat(champ)));
        switch (this.getFormat(champ)) {
            case 1: {
                return SQL.getIntSQL(data, champ);
            }
            case 0: {
                return SQL.getStringSQL(data, champ);
            }
            case 3: {
                return SQL.getTimestampSQL(SQL.getDate(data, champ, GLSDate.formatDateDatexComplete), "YYYYMMDDHH24MISS");
            }
            case 2: {
                return SQL.getChampGeometrySQL(data, champ);
            }
        }
        return "null";
    }

    public String getRequeteSuppressionParCle(int cle) {
        return this.getRequeteSuppressionParCle(GLS.getString(cle));
    }

    public String getRequeteSuppressionParCle(String cle) {
        return SQL.getRequeteSuppressionParCle(this, cle, false);
    }

    public String getRequeteSuppression(String where) {
        return SQL.getRequeteSuppression(this, where, false);
    }

    public String getRequeteModification(String[] nouvelleLigne) {
        return SQL.getRequeteModification(this, nouvelleLigne);
    }

    public String getRequeteInsertion(String[] nouvelleLigne) {
        return SQL.getRequeteInsertion(this, nouvelleLigne);
    }

    public String getScriptSelectionCle(String valeurCle) {
        return this.getScriptSelection(this.cle.concat(" = ").concat(this.getScriptChamp(this.cle, valeurCle)), null, -1);
    }

    public String getScriptSelection() {
        return this.getScriptSelection(null, null, -1);
    }

    public String getScriptSelection(String where, String orderby, int limit) {
        return this.getScriptSelection(this.nom, where, orderby, limit);
    }

    public String getScriptSelection(String[] from, String where, String orderby, int limit) {
        return TableSQL.getScriptSelection(this.getListeChampsPourRequete(), " FROM ".concat(GLS.getString(from, ",")), where, orderby, limit);
    }

    public String getScriptSelection(String from, String where, String orderby, int limit) {
        return TableSQL.getScriptSelection(this.getListeChampsPourRequete(), from, where, orderby, limit);
    }

    public String getListeChampsPourRequete() {
        if (AJOUTER_TABLES_REQUETE) {
            return this.getListeChampsAvecTable();
        }
        return this.getListeChamps();
    }

    public static String getScriptSelection(String[] champs, String from, String where, String orderby, int limit) {
        return TableSQL.getScriptSelection(GLS.getString(champs, ","), from, where, orderby, limit);
    }

    public static String getScriptSelection(String[] champs, String[] from, String[] where, String[] orderby, int limit) {
        return TableSQL.getScriptSelection(GLS.getString(champs, ","), GLS.getString(from, ","), GLS.getString(where, " AND "), GLS.getString(orderby, ","), limit);
    }

    public String getScriptSelection(String[] from, String[] where, String[] orderby, int limit) {
        return TableSQL.getScriptSelection(this.getListeChampsPourRequete(), GLS.getString(from, ","), GLS.getString(where, " AND "), GLS.getString(orderby, ","), limit);
    }

    public String getScriptSelection(String[] from, String where, String[] orderby, int limit) {
        return TableSQL.getScriptSelection(this.getListeChampsPourRequete(), GLS.getString(from, ","), where, GLS.getString(orderby, ","), limit);
    }

    public static String getScriptSelection(String champs, String from, String where, String orderby, int limit) {
        return "SELECT ".concat(champs).concat(SQL.getFrom(from)).concat(SQL.getWhere(where)).concat(SQL.getOrderBy(orderby).concat(SQL.getLimit(limit)));
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public int getFormat(String champ) {
        int i = GLS.getIndiceObjetListe(this.champs, champ);
        if (!GLS.estNulle(i)) {
            return this.format[i];
        }
        return -1;
    }

    public String getChamp(int i) {
        return this.champs[i];
    }

    public String getJointure(TableSQL tableJointure, String champSource) {
        return this.getJointure(tableJointure, champSource, champSource);
    }

    public String getJointure(TableSQL tableJointure, String champSource, String champJointure) {
        return TableSQL.getJointure(this, tableJointure, champSource, champJointure);
    }

    public static String getJointure(TableSQL tableSource, TableSQL tableJointure, String champSource, String champJointure) {
        return tableSource.getChampAvecTable(champSource).concat(" = ").concat(tableJointure.getChampAvecTable(champJointure));
    }

    public String getScriptEgaliteChamp(String champ, int valeur) {
        return this.getScriptEgaliteChamp(champ, GLS.getString(valeur));
    }

    public String getScriptEgaliteChamp(String champ, String valeur) {
        return this.getScriptEgaliteChamp(champ, valeur, false, true);
    }

    public String getScriptEgaliteChamp(String champ, String valeur, boolean lower) {
        return this.getScriptEgaliteChamp(champ, valeur, lower, true);
    }

    public String getScriptEgaliteChamp(String champ, String valeur, boolean lower, boolean script) {
        if (lower) {
            return SQL.getLowerSQL(this.getChampPourRequete(champ), valeur);
        }
        return this.getChampPourRequete(champ).concat(" = ").concat(script ? this.getScriptChamp(champ, valeur) : valeur);
    }

    public String getChampPourRequete(String champ) {
        if (AJOUTER_TABLES_REQUETE) {
            return this.getChampAvecTable(champ);
        }
        return champ;
    }

    public String getScriptEgaliteDate(String champ, String valeur, String format) {
        return SQL.getToChar(this, champ, format).concat(" = ").concat(SQL.getStringSQL(valeur));
    }

    public String getScriptInegaliteChamp(String champ, int valeur) {
        return this.getScriptInegaliteChamp(champ, GLS.getString(valeur));
    }

    public String getScriptInegaliteChamp(String champ, String valeur) {
        return this.getScriptInegaliteChamp(champ, valeur, false);
    }

    public String getScriptInegaliteChamp(String champ, String valeur, boolean lower) {
        if (lower) {
            return SQL.getLowerSQL(this.getChampPourRequete(champ)).concat(" <> ").concat(GLS.getLowerString(valeur));
        }
        return this.getChampAvecTable(champ).concat(" <> ").concat(this.getScriptChamp(champ, valeur));
    }

    public String getScriptIsNotNull(String champ) {
        return this.getChampAvecTable(champ).concat(" is not null ");
    }

    public String getChampAvecTable(String champ) {
        return this.nom.concat(".").concat(champ);
    }

    public boolean estCle(int i) {
        return this.estCle(this.getChamp(i));
    }

    public boolean estCle(String champ) {
        return GLS.egal(champ, this.cle);
    }

    public int getNbChamps() {
        return this.champs.length;
    }

    public int[] getFormat() {
        return this.format;
    }

    public void formatterLigne(String[] nouvelleLigne) {
        int i = 0;
        while (i < nouvelleLigne.length) {
            nouvelleLigne[i] = this.getScriptChamp(i, nouvelleLigne[i]);
            ++i;
        }
    }

    public String[] getNouvelleLigne() {
        return new String[this.champs.length];
    }

    public String[] getNouvelleLignePreparedStatement() {
        String[] nouvelleLigne = new String[this.champs.length];
        int i = 0;
        while (i < this.champs.length) {
            nouvelleLigne[i] = "?";
            ++i;
        }
        return nouvelleLigne;
    }

    public String getCle() {
        return this.cle;
    }

    public void setCle(String cle) {
        this.cle = cle;
    }

    public int getEpsg() {
        return this.epsg;
    }

    public void setEpsg(int epsg) {
        this.epsg = epsg;
    }
}

