/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.sql;

import gls.geometry.GeoPoint;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Nombre;
import gls.outils.sql.TableSQL;
import i2.application.banco.db.DataSet;
import java.awt.geom.Point2D;
import java.sql.PreparedStatement;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import org.postgis.ComposedGeom;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.PGbox2d;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.Polygon;

public class SQL {
    private static SQL instance;
    public static String ERREUR_BASE_CONTRAINTE_INTEGRITE;
    public static String ERREUR_BASE_CONTRAINTE_UNIQUE;
    public static final String ENTETE_SELECT = "SELECT ";
    public static final String ENTETE_INSERT = "INSERT INTO ";
    public static final String ENTETE_UPDATE = "UPDATE ";
    public static final String ENTETE_DELETE = "DELETE ";
    public static final String SQL_TO_CHAR = " to_char";
    public static final String SQL_EGAL = " = ";
    public static final String SQL_DIFFERENT = " <> ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_OR = " OR ";
    public static final String SQL_IN = " IN ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_WHERE = " WHERE ";
    public static final String SQL_ORDER_BY = " ORDER BY ";
    public static final String SQL_LIMIT = " LIMIT ";
    public static final String SQL_DESC = " DESC ";
    public static final String SQL_TO_DATE = "to_date";
    public static final String SQL_TO_TIMESTAMP = "to_timestamp";
    public static final String SQL_LOWER = "lower";
    public static final String SQL_TRANSLATE = "translate";
    public static final String SQL_TIMESTAMP = " timestamp ";
    public static final String SQL_VALEUR_PREPAREDSTATEMENT = "?";
    public static final String SQL_IS_NOT_NULL = " is not null ";
    public static final String FORMAT_DATE_COMPLETE_DATEX = "DDMMYYYYHH24MI";
    public static final String FORMAT_DATE_COMPLETE = "YYYYMMDDHH24MISS";
    public static final String FORMAT_DATE_COMPLETE_ORACLE = "DD/MM/YYYY HH24:MI:SS";
    public static final String FORMAT_DATE_JOUR_ORACLE = "DD/MM/YYYY";
    public static final String FORMAT_DATE_HEURE_ORACLE = "HH24:MI";
    public static final String FORMAT_DATE_JOUR = "DD/MM/YYYY";
    public static final String CHAMP_VIDE = "null";
    public static final String HEURE_MIN = "00:00:00";
    public static final String HEURE_MAX = "23:59:59";

    static {
        ERREUR_BASE_CONTRAINTE_INTEGRITE = "viole la contrainte";
        ERREUR_BASE_CONTRAINTE_UNIQUE = "contrainte unique";
    }

    public static SQL instanceOf() {
        if (instance == null) {
            instance = new SQL();
        }
        return instance;
    }

    private SQL() {
    }

    public static String getRequeteInsertion(TableSQL table, String[] donnees) {
        return SQL.getRequeteInsertion(table, donnees, false);
    }

    public static String getRequeteInsertion(TableSQL table, String[] donnees, boolean ajouterFinInstruction) {
        return SQL.getRequeteInsertion(table.getNom(), table.getChamps(), donnees);
    }

    public static String getRequeteInsertion(String table, String[] champs, String[] valeurs) {
        return SQL.getRequeteInsertion(table, champs, valeurs, false);
    }

    public static String getRequeteInsertion(String table, String[] champs, String[] valeurs, boolean ajouterFinInstruction) {
        return ENTETE_INSERT.concat(table).concat(" (").concat(GLS.getString(champs, ",")).concat(") VALUES (").concat(GLS.getString(valeurs, ",").concat(")").concat(ajouterFinInstruction ? ";" : ""));
    }

    public static String getRequeteInsertionPS(TableSQL table, String[] champs, String[] valeurs, boolean ajouterFinInstruction) throws Exception {
        return ENTETE_INSERT.concat(table.getNom()).concat(" (").concat(GLS.getString(champs, ",")).concat(") VALUES (").concat(GLS.getString(SQL.getValeursPreparedStatement(champs.length), ",").concat(")").concat(ajouterFinInstruction ? ";" : ""));
    }

    public static void initialisationValeursInsertionPreparedStatement(PreparedStatement preparedStatement, TableSQL table, String[] champs, String[] valeurs) throws Exception {
        table.getScriptChamps(preparedStatement, champs, valeurs);
    }

    private static String[] getValeursPreparedStatement(int nbChamps) {
        String[] valeursPreparedStatement = new String[nbChamps];
        int i = 0;
        while (i < nbChamps) {
            valeursPreparedStatement[i] = SQL_VALEUR_PREPAREDSTATEMENT;
            ++i;
        }
        return valeursPreparedStatement;
    }

    public static String getRequeteModification(TableSQL table, String[] donnees) {
        return SQL.getRequeteModification(table, donnees, false);
    }

    public static String getToChar(TableSQL table, String champ, String format) {
        return SQL.getToChar(table.getChampAvecTable(champ), format);
    }

    public static String getToChar(String champ, String format) {
        return SQL_TO_CHAR.concat("(").concat(champ).concat(",'").concat(format).concat("') ");
    }

    public static String getRequeteSuppressionParCle(TableSQL table, String valeurCle, boolean ajouterFinInstruction) {
        return SQL.getRequeteSuppression(table, table.getScriptEgaliteChamp(table.getCle(), valeurCle), ajouterFinInstruction);
    }

    public static String getRequeteSuppression(TableSQL table, String where, boolean ajouterFinInstruction) {
        return ENTETE_DELETE.concat(SQL_FROM).concat(table.getNom()).concat(SQL_WHERE).concat(where);
    }

    public static String getRequeteModification(TableSQL table, String[] valeurs, boolean ajouterFinInstruction) {
        String requete = ENTETE_UPDATE.concat(table.getNom()).concat(" SET ");
        Vector<String> liste = new Vector<String>();
        int i = 0;
        while (i < table.getNbChamps()) {
            String champ = table.getChamp(i);
            String valeur = valeurs[i];
            if (!table.estCle(champ)) {
                liste.add(champ.concat(SQL_EGAL).concat(valeur));
            }
            ++i;
        }
        requete = String.valueOf(requete) + GLS.getString(liste, ",");
        try {
            requete = String.valueOf(requete) + SQL_WHERE + table.getCle() + SQL_EGAL + valeurs[table.getIndiceCle()];
        }
        catch (Exception e) {
            GLS.getLogs().error((Object)"ERREUR INDICE CLE IMPOSSIBLE A RECUPERER");
        }
        if (ajouterFinInstruction) {
            requete = String.valueOf(requete) + ";";
        }
        return requete;
    }

    public static String getRequeteModificationPS(TableSQL table, String[] champs, String[] valeurs, boolean ajouterFinInstruction) {
        String requete = ENTETE_UPDATE.concat(table.getNom()).concat(" SET ");
        Vector<String> liste = new Vector<String>();
        int i = 0;
        while (i < champs.length) {
            String champ = champs[i];
            if (!table.estCle(champ)) {
                liste.add(champ.concat(SQL_EGAL).concat(SQL_VALEUR_PREPAREDSTATEMENT));
            }
            ++i;
        }
        requete = String.valueOf(requete) + GLS.getString(liste, ",");
        if (!GLS.estVide(table.getCle())) {
            try {
                requete = String.valueOf(requete) + SQL_WHERE + table.getCle() + SQL_EGAL + SQL_VALEUR_PREPAREDSTATEMENT;
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)"ERREUR INDICE CLE IMPOSSIBLE A RECUPERER");
            }
        }
        if (ajouterFinInstruction) {
            requete = String.valueOf(requete) + ";";
        }
        return requete;
    }

    public static void initialisationValeursModificationPreparedStatement(PreparedStatement preparedStatement, TableSQL table, String[] champs, String[] valeurs) {
        String requete = ENTETE_UPDATE.concat(table.getNom()).concat(" SET ");
        Vector liste = new Vector();
        int indiceChamp = 1;
        int i = 0;
        while (i < champs.length) {
            String champ = champs[i];
            String valeur = valeurs[i];
            if (!table.estCle(champ)) {
                table.getScriptChamp(preparedStatement, champ, indiceChamp++, valeur);
            }
            ++i;
        }
        requete = String.valueOf(requete) + GLS.getString(liste, ",");
        if (!GLS.estVide(table.getCle())) {
            try {
                table.getScriptChamp(preparedStatement, table.getCle(), indiceChamp, valeurs[table.getIndiceCle()]);
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)"ERREUR INDICE CLE IMPOSSIBLE A RECUPERER");
            }
        }
    }

    public static void initialisationValeursSelectionPreparedStatement(PreparedStatement preparedStatement, Object[] valeurs, int[] typeChamp) {
        int i = 0;
        while (i < valeurs.length) {
            TableSQL.getScriptChamp(preparedStatement, "", i + 1, valeurs[i], typeChamp[i]);
            ++i;
        }
    }

    public static String getChampBox2D(PGbox2d pgbox2d) {
        String planCarto = "";
        if (pgbox2d != null) {
            planCarto = "'BOX(" + pgbox2d.getLLB().x + " " + pgbox2d.getLLB().y + "," + pgbox2d.getURT().x + " " + pgbox2d.getURT().y + ")'::box2d";
        }
        return planCarto;
    }

    public static String getChampBox3D(PGbox2d pgbox2d) {
        return SQL.getChampBox3D(pgbox2d.getLLB().x, pgbox2d.getLLB().y, pgbox2d.getURT().x, pgbox2d.getURT().y);
    }

    public static String getChampBox3D(GeoPoint point1, GeoPoint point2) {
        return SQL.getChampBox3D(point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public static String getChampBox3D(String x1, String y1, String x2, String y2) {
        return SQL.getChampBox3D(Nombre.getNombre(x1, 0), Nombre.getNombre(y1, 0), Nombre.getNombre(x2, 0), Nombre.getNombre(y2, 0));
    }

    public static String getChampBox3D(double x1, double y1, double x2, double y2) {
        String planCarto = "";
        planCarto = "st_setsrid(CAST('BOX3D(" + x1 + " " + y1 + "," + x2 + " " + y2 + ")' As box3d),32630)";
        return planCarto;
    }

    public static String getChampBox2D(GeoPoint point1, GeoPoint point2) {
        String planCarto = "";
        if (point1 != null && point2 != null) {
            planCarto = "'BOX(" + point1.getX() + " " + point1.getY() + "," + point2.getX() + " " + point2.getY() + ")'::box2d";
        }
        return planCarto;
    }

    public static String getChampBox2D(Point point1, Point point2) {
        String planCarto = "";
        if (point1 != null && point2 != null) {
            planCarto = "'BOX(" + point1.x + " " + point1.y + "," + point2.x + " " + point2.y + ")'::box2d";
        }
        return planCarto;
    }

    public static Point getChampGeometryPoint(Object obj) {
        Point point = obj != null ? (Point)((PGgeometry)obj).getGeometry() : new Point(0.0, 0.0);
        return point;
    }

    public static String getChampGeometryPoint(String point) {
        return SQL.getChampGeometryPoint(point, 32630);
    }

    public static String getChampGeometryPoint(String point, int epsg) {
        return SQL.getChampGeometryPoint(new GeoPoint(point), epsg);
    }

    public static String getChampGeometryPoint(GeoPoint point, int epsg) {
        if (point != null) {
            return SQL.getChampGeometryPoint(point.getX(), point.getY(), epsg);
        }
        return CHAMP_VIDE;
    }

    public static String getChampGeometryPoint(GeoPoint point) {
        if (point != null) {
            return SQL.getChampGeometryPoint(point.getX(), point.getY(), 32630);
        }
        return CHAMP_VIDE;
    }

    public static String getChampGeometryPoint(Point point) {
        return SQL.getChampGeometryPoint(point.x, point.y, 32630);
    }

    public static String getChampGeometryPoint(String x, String y) {
        return SQL.getChampGeometryPoint(Nombre.getNombre(x, 0), Nombre.getNombre(y, 0), 32630);
    }

    public static String getFormatDateJour(String separateur) {
        if (!GLS.estVide(separateur)) {
            return "DD".concat(separateur).concat("MM").concat(separateur).concat("YYYY");
        }
        return "DD/MM/YYYY";
    }

    public static String getChampGeometrySQL(DataSet data, String champ) {
        Object objet = SQL.getObject(data, champ, null);
        GLS.getLogs().debug((Object)("GEOMETRY " + objet));
        if (objet != null) {
            GLS.getLogs().debug((Object)("GEOMETRY TYPE " + objet.getClass().getSimpleName()));
            if (objet instanceof Point) {
                return SQL.getChampGeometryPoint(SQL.getChampGeometryPoint(objet));
            }
            if (objet instanceof PGbox2d) {
                return SQL.getChampBox2D((PGbox2d)objet);
            }
            if (objet instanceof PGgeometry) {
                if (((PGgeometry)objet).getGeometry().getType() == 1) {
                    return SQL.getChampGeometryPoint(SQL.getChampGeometryPoint(objet));
                }
                if (((PGgeometry)objet).getGeometry().getType() == 2) {
                    return CHAMP_VIDE;
                }
                return CHAMP_VIDE;
            }
            return CHAMP_VIDE;
        }
        return CHAMP_VIDE;
    }

    public static String getChampGeometryPoint(double x, double y, int epsg) {
        GLS.getLogs().debug((Object)("CREATION CHAMP GEOMETRY " + x + "  " + y + " - " + epsg));
        return "st_geometryfromtext('POINT(" + x + " " + y + ")'," + epsg + ")";
    }

    public static String getGeometryPoint(double x, double y) {
        GLS.getLogs().debug((Object)("CREATION CHAMP GEOMETRY " + x + "  " + y + " - "));
        return "POINT(" + x + " " + y + ")";
    }

    public static String getGeometryPointUTM(double x, double y, float z) {
        GLS.getLogs().debug((Object)("CREATION CHAMP GEOMETRY " + x + "  " + y + " - "));
        GeoPoint p = new GeoPoint(x, y).toUTM();
        return "POINT(" + p.getX() + " " + p.getY() + " " + z + ")";
    }

    public static String getGeometryPointUTM(double x, double y) {
        GLS.getLogs().debug((Object)("CREATION CHAMP GEOMETRY " + x + "  " + y + " - "));
        GeoPoint p = new GeoPoint(x, y).toUTM();
        return "POINT(" + p.getX() + " " + p.getY() + ")";
    }

    public static String getChampGeometryLine(String listeCoordonnees) {
        return SQL.getChampGeometryLine(listeCoordonnees, 32630);
    }

    public static String getChampGeometryLine(String listeCoordonnees, int epsg) {
        if (!GLS.estVide(listeCoordonnees)) {
            return "st_geometryfromtext('LINESTRING(" + listeCoordonnees.replace(';', ' ').replace(':', ',') + ")'," + epsg + ")";
        }
        return CHAMP_VIDE;
    }

    public static String getChampGeometryLineZm(String listeCoordonnees, int epsg) {
        if (!GLS.estVide(listeCoordonnees)) {
            return "st_geometryfromtext('LINESTRINGZM(" + listeCoordonnees.replace(';', ' ').replace(':', ',') + ")'," + epsg + ")";
        }
        return CHAMP_VIDE;
    }

    public static String getGeometryLine(String listeCoordonnees) {
        if (!GLS.estVide(listeCoordonnees)) {
            return "'LINESTRING(" + listeCoordonnees.replace(';', ' ').replace(':', ',') + ")'";
        }
        return CHAMP_VIDE;
    }

    public static String getGeometryLine(float[] x, float[] y) {
        if (x != null && y != null) {
            return "LINESTRING(" + Geometry.getFloatToString(x, y) + ")";
        }
        return CHAMP_VIDE;
    }

    public static String getGeometryLineUTM(float[] x, float[] y) {
        if (x != null && y != null) {
            return "LINESTRING(" + Geometry.getFloatToStringUTM(x, y) + ")";
        }
        return CHAMP_VIDE;
    }

    public static String getChampGeometryLine(Vector<Point2D.Double> ligne) {
        return SQL.getChampGeometryLine(Geometry.getPointsToString(ligne), 32630);
    }

    public static String getChampGeometryLine(Vector<Point2D.Double> ligne, int epsg) {
        return SQL.getChampGeometryLine(Geometry.getPointsToString(ligne), epsg);
    }

    public static LineString getChampGeometryLine(Object obj) {
        LineString lineString = obj != null ? (LineString)((PGgeometry)obj).getGeometry() : null;
        return lineString;
    }

    public static Polygon getChampGeometryPolygon(Object obj) {
        Polygon polygon = obj != null ? (Polygon)((PGgeometry)obj).getGeometry() : null;
        return polygon;
    }

    public static Vector<Point2D.Double> getPoints2D(LineString ligne) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        if (ligne != null) {
            Point[] pointArray = ligne.getPoints();
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point point = pointArray[n2];
                points.add(new Point2D.Double(point.getX(), point.getY()));
                ++n2;
            }
        }
        return points;
    }

    public static Vector<Point2D.Double> getPoints2D(Polygon ligne) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        if (ligne != null) {
            int i = 0;
            while (i < ligne.getDimension()) {
                Point point = ligne.getPoint(i);
                points.add(new Point2D.Double(point.getX(), point.getY()));
                ++i;
            }
        }
        return points;
    }

    public static int getInt(DataSet data, String champ) {
        return SQL.getInt(data, champ, -1);
    }

    public static int getInt(DataSet data, String champ, int defaut) {
        try {
            if (!data.isNull(champ)) {
                return data.getInt(champ);
            }
            return defaut;
        }
        catch (Exception e) {
            return defaut;
        }
    }

    public static Object getObject(DataSet data, String champ, Object defaut) {
        try {
            if (!data.isNull(champ)) {
                return data.getObject(champ);
            }
            return defaut;
        }
        catch (Exception e) {
            GLS.getLogs().debug((Object)"ERREUR CONVERSION OBJET", (Throwable)e);
            return defaut;
        }
    }

    public static Date getDate(DataSet data, String champ, Date defaut) {
        try {
            if (!data.isNull(champ)) {
                try {
                    return data.getDate(champ);
                }
                catch (Exception e) {
                    return defaut;
                }
            }
            return defaut;
        }
        catch (Exception e) {
            GLS.getLogs().error((Object)"ERREUR CONVERSION DATE", (Throwable)e);
            return defaut;
        }
    }

    public static final String getDate(DataSet data, String champ, DateFormat format) {
        return SQL.getDate(data, champ, null, format);
    }

    public static final String getDate(DataSet data, String champ, Date defaut, DateFormat format) {
        Date d = SQL.getDate(data, champ, defaut);
        return GLSDate.toDate(d, format);
    }

    public static String getString(DataSet data, String champ) {
        return SQL.getString(data, champ, "");
    }

    public static boolean estVide(DataSet data, String champ) {
        try {
            return data.isNull(champ) || GLS.estVide(data.getString(champ));
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getString(DataSet data, String champ, String defaut) {
        try {
            if (!data.isNull(champ)) {
                return data.getString(champ);
            }
            return defaut;
        }
        catch (Exception e) {
            return defaut;
        }
    }

    public static String getIntSQL(DataSet data, String champ, int defaut) {
        try {
            return GLS.getString(SQL.getInt(data, champ, defaut));
        }
        catch (Exception e) {
            return CHAMP_VIDE;
        }
    }

    public static String getIntSQL(DataSet data, String champ) {
        return SQL.getIntSQL(data, champ, -1);
    }

    public static String getStringSQL(DataSet data, String champ) {
        try {
            return SQL.getStringSQL(SQL.getString(data, champ));
        }
        catch (Exception e) {
            return CHAMP_VIDE;
        }
    }

    public static String getIntSQL(int valeur) {
        if (valeur > -1) {
            return String.valueOf(valeur);
        }
        return CHAMP_VIDE;
    }

    public static String getIntSQL(String valeur) {
        if (GLS.estNumerique(valeur)) {
            return valeur;
        }
        return CHAMP_VIDE;
    }

    public static String getDoubleSQL(String valeur) {
        return String.valueOf(GLS.getDouble(valeur, 0.0));
    }

    public static String getDateSQL(String fonction, String date, String format) {
        if (!GLS.estVide(date)) {
            String d = date.startsWith("'") && date.endsWith("'") ? date : "'" + date + "'";
            return String.valueOf(fonction) + "(" + d + ",'" + format + "')";
        }
        return CHAMP_VIDE;
    }

    public static String supprimeCharXMLNonValide(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (SQL.estCharXmlValide(current)) {
                out.append(current);
            }
            ++i;
        }
        return out.toString();
    }

    public static boolean estCharXmlValide(char current) {
        return current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff';
    }

    public static String getLowerSQL(String champ) {
        StringBuffer sb = new StringBuffer();
        sb.append(SQL_LOWER);
        sb.append("(");
        sb.append(champ);
        sb.append(")");
        return sb.toString();
    }

    public static String getTranslateSQL(String champ) {
        StringBuffer sb = new StringBuffer();
        sb.append(SQL_LOWER);
        sb.append("(");
        sb.append(champ);
        sb.append(")");
        return sb.toString();
    }

    public static String getLowerSQL(String champ, String valeur) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(SQL.getLowerSQL(champ));
        sb.append(SQL_EGAL);
        sb.append(SQL.getStringSQL(GLS.getLowerString(valeur)));
        sb.append(" ");
        return sb.toString();
    }

    public static String getEgaliteSQL(String champ, String valeur) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(champ);
        sb.append(SQL_EGAL);
        sb.append(SQL.getStringSQL(valeur));
        sb.append(" ");
        return sb.toString();
    }

    public static String getIntervalJourTimestampSQL(String champ, String jour) {
        StringBuffer sb = new StringBuffer();
        sb.append(" (");
        sb.append(champ);
        sb.append(">=");
        sb.append(SQL.getTimestampSQL(String.valueOf(jour) + " " + HEURE_MIN, FORMAT_DATE_COMPLETE_ORACLE));
        sb.append(SQL_AND);
        sb.append(champ);
        sb.append("<=");
        sb.append(SQL.getTimestampSQL(String.valueOf(jour) + " " + HEURE_MAX, FORMAT_DATE_COMPLETE_ORACLE));
        sb.append(") ");
        return sb.toString();
    }

    public static String toTimeStampDateSQL(String date) {
        if (GLS.estVide(date)) {
            return CHAMP_VIDE;
        }
        return SQL_TIMESTAMP.concat(SQL.getStringSQL(date));
    }

    public static String getDateSQL(String date, String format) {
        return SQL.getDateSQL(SQL_TO_DATE, date, format);
    }

    public static String getTimestampSQL(String date, String format) {
        return SQL.getDateSQL(SQL_TO_TIMESTAMP, date, format);
    }

    public static String getStringSQL(String valeur) {
        return SQL.getStringSQL(valeur, -1);
    }

    public static String getStringSQL(String valeur, int tailleMax) {
        return SQL.getStringSQL(valeur, true, true, tailleMax);
    }

    public static String getStringSQL(String valeur, boolean remplacerSautLigne, boolean remplacerTabulation, int tailleMax) {
        String newValeur = "";
        if (valeur != null && !valeur.equals("")) {
            int i = 0;
            while (i < valeur.length()) {
                String c = String.valueOf(valeur.charAt(i));
                if (c.equals("'")) {
                    newValeur = String.valueOf(newValeur) + "'";
                } else if (remplacerSautLigne && c.equals("\n")) {
                    c = " ";
                } else if (remplacerTabulation && c.equals("\t")) {
                    c = " ";
                }
                newValeur = String.valueOf(newValeur) + c;
                ++i;
            }
            if (tailleMax > 0 && newValeur.length() > tailleMax) {
                newValeur = newValeur.substring(0, tailleMax);
            }
            return "'" + newValeur + "'";
        }
        return CHAMP_VIDE;
    }

    public static String getFrom(String from) {
        if (GLS.estVide(from)) {
            return "";
        }
        if (from.indexOf(SQL_FROM.trim()) == -1) {
            return SQL_FROM.concat(from);
        }
        return from;
    }

    public static String getWhere(String where) {
        if (GLS.estVide(where)) {
            return "";
        }
        return SQL_WHERE.concat(where);
    }

    public static String getIn(String[] valeurs, int format) {
        if (format == 1) {
            return SQL_IN.concat(" (").concat(GLS.getString(valeurs, ",")).concat(") ");
        }
        String valeur = "";
        if (!GLS.estVide(valeurs)) {
            int i = 0;
            while (i < valeurs.length - 1) {
                valeur = String.valueOf(valeur) + SQL.getStringSQL(valeurs[i]) + ",";
                ++i;
            }
            valeur = String.valueOf(valeur) + SQL.getStringSQL(valeurs[valeurs.length - 1]);
        }
        return SQL_IN.concat(" (").concat(valeur).concat(") ");
    }

    public static String getOrderBy(String orderby) {
        if (GLS.estVide(orderby)) {
            return "";
        }
        return SQL_ORDER_BY.concat(orderby);
    }

    public static String getLimit(int limit) {
        if (GLS.estNulle(limit)) {
            return "";
        }
        return SQL_LIMIT.concat(GLS.getString(limit));
    }

    public static org.postgis.Geometry getChampGeometry(Object obj) {
        org.postgis.Geometry geometry = obj != null ? ((PGgeometry)obj).getGeometry() : null;
        return geometry;
    }

    public static Vector<Point2D.Double> getPoints2D(org.postgis.Geometry geometry) {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        if (geometry != null) {
            int i = 0;
            while (i < geometry.numPoints()) {
                Point point = geometry.getPoint(i);
                points.add(new Point2D.Double(point.getX(), point.getY()));
                ++i;
            }
        }
        return points;
    }

    public static Vector<Vector<Point2D.Double>> getPoints2DByGeometry(org.postgis.Geometry geometry) {
        Vector<Vector<Point2D.Double>> pointsByGeom = new Vector<Vector<Point2D.Double>>();
        if (geometry != null) {
            ComposedGeom cGeom = (ComposedGeom)geometry;
            if (cGeom instanceof MultiLineString) {
                int k = 0;
                while (k < cGeom.numGeoms()) {
                    org.postgis.Geometry g = cGeom.getSubGeometry(k);
                    Vector<Point2D.Double> points = new Vector<Point2D.Double>();
                    int i = 0;
                    while (i < g.numPoints()) {
                        Point point = g.getPoint(i);
                        points.add(new Point2D.Double(point.getX(), point.getY()));
                        ++i;
                    }
                    pointsByGeom.add(points);
                    ++k;
                }
            } else {
                Vector<Point2D.Double> points = new Vector<Point2D.Double>();
                int i = 0;
                while (i < cGeom.numPoints()) {
                    Point point = cGeom.getPoint(i);
                    points.add(new Point2D.Double(point.getX(), point.getY()));
                    ++i;
                }
                pointsByGeom.add(points);
            }
        }
        return pointsByGeom;
    }
}

