/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.son;

import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Son {
    private AudioFormat format;
    private byte[] samples;

    public Son(String filename) throws Exception {
        AudioInputStream stream = AudioSystem.getAudioInputStream(new File(filename));
        this.format = stream.getFormat();
        this.samples = this.getSamples(stream);
    }

    public byte[] getSamples() {
        return this.samples;
    }

    public byte[] getSamples(AudioInputStream stream) {
        int length = (int)(stream.getFrameLength() * (long)this.format.getFrameSize());
        byte[] samples = new byte[length];
        DataInputStream in = new DataInputStream(stream);
        try {
            in.readFully(samples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return samples;
    }

    public void play() {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.getSamples());
        this.play(stream);
    }

    public void play(InputStream source) {
        SourceDataLine line;
        int bufferSize = this.format.getFrameSize() * Math.round(this.format.getSampleRate() / 10.0f);
        byte[] buffer = new byte[bufferSize];
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(this.format, bufferSize);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
        line.start();
        try {
            int numBytesRead = 0;
            while (numBytesRead != -1) {
                numBytesRead = source.read(buffer, 0, buffer.length);
                if (numBytesRead == -1) continue;
                line.write(buffer, 0, numBytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        line.drain();
        line.close();
    }

    public static void main(String[] args) {
        try {
            GLS.getFichier();
            Son player = new Son(Fichier.completerChemin(System.getProperty("user.dir")).concat("sons/validation.wav"));
            player.play();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

