/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.ftp;

import gls.outils.fichier.FichierCONFIG;
import gls.outils.ftp.FtpConnection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.GregorianCalendar;
import javax.swing.Timer;

public class TransfertFTP
implements ActionListener {
    FichierCONFIG config = new FichierCONFIG("config.jcfg");
    String cheminFTPSOURCE = this.config.rechercherValeur("cheminftpsource");
    String utilisateurFTPSOURCE = this.config.rechercherValeur("utilisateurftpsource");
    String passwordFTPSOURCE = this.config.rechercherValeur("passwordftpsource");
    String cheminFTPDESTINATION;
    String utilisateurFTPDESTINATION;
    String passwordFTPDESTINATION;
    int modeDestination;
    int portServeurDestination;
    boolean download = true;
    boolean upload = true;
    int modeSource;
    int portServeurSource;
    String prefixeFichier;
    String suffixeFichier;
    int interval = Integer.parseInt((String)this.config.get("interval"));
    Timer timClose;
    Timer tim;

    public TransfertFTP() {
        this.modeSource = this.config.rechercherValeur("modeftpsource").equals("actif") ? 1 : 0;
        this.portServeurSource = this.config.rechercherValeur("portserveursource").equals("") ? 21 : 2021;
        this.cheminFTPDESTINATION = this.config.rechercherValeur("cheminftpdestination");
        this.utilisateurFTPDESTINATION = (String)this.config.get("utilisateurftpdestination");
        this.passwordFTPDESTINATION = (String)this.config.get("passwordftpdestination");
        this.modeDestination = this.config.rechercherValeur("modeftpdestination").equals("actif") ? 1 : 0;
        this.portServeurDestination = this.config.rechercherValeur("portserveurdestination").equals("") ? 21 : 2021;
        this.prefixeFichier = this.config.rechercherValeur("prefixe");
        this.suffixeFichier = this.config.rechercherValeur("suffixe");
        this.download = this.config.getBoolean("download", true);
        this.upload = this.config.getBoolean("upload", true);
        this.timClose = new Timer(600000, this);
        try {
            this.lancement();
        }
        catch (Exception e) {
            System.out.println("ERREUR LANCEMENT DEMARRAGE " + e.toString());
        }
        System.exit(0);
    }

    public void creerFichierFlag() {
        File fichierFlag = null;
        fichierFlag = new File("tmp/download.tmp");
        try {
            if (!fichierFlag.exists()) {
                fichierFlag.createNewFile();
            }
        }
        catch (Exception e) {
            System.out.println("#--> ERREUR CREATION FLAG " + e.toString());
        }
    }

    public void supprimerFichierFlag() {
        File fichierFlag = null;
        fichierFlag = new File("tmp/download.tmp");
        try {
            fichierFlag.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lancement() {
        try {
            this.timClose.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.download) {
            try {
                this.lancerDownload();
            }
            catch (Exception xLancer) {
                System.out.println("ERREUR LANCEMENT " + xLancer.toString());
            }
        }
        if (this.upload) {
            try {
                this.lancerUpload();
            }
            catch (Exception xLancer) {
                System.out.println("ERREUR LANCEMENT " + xLancer.toString());
            }
        }
        try {
            this.timClose.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tim) {
            try {
                this.tim.stop();
            }
            catch (Exception xStopTimer) {
                System.out.println("ERREUR STOP " + xStopTimer.toString());
            }
            this.lancement();
            try {
                this.tim.start();
            }
            catch (Exception xStartTimer) {
                System.out.println("ERREUR START " + xStartTimer.toString());
            }
        } else if (e.getSource() == this.timClose) {
            System.exit(0);
        }
    }

    public boolean estFichierOk(String fichier) {
        return fichier != null && !fichier.equals("") && fichier.startsWith(this.prefixeFichier) && fichier.endsWith(this.suffixeFichier);
    }

    public FtpConnection connexionFtp() throws Exception {
        boolean etat;
        FtpConnection ftpDestination = new FtpConnection(false, this.modeDestination);
        try {
            System.out.println("+--> Connexion \u00e0 " + this.cheminFTPDESTINATION);
            etat = ftpDestination.connect(this.cheminFTPDESTINATION, this.portServeurDestination);
        }
        catch (Exception e) {
            String libelleErreur = e.toString();
            etat = false;
        }
        if (!etat) {
            ftpDestination = null;
            throw new Exception("ERREUR CONNEXION SERVEUR DESTINATION");
        }
        try {
            System.out.println("+--> Authentification - " + this.utilisateurFTPDESTINATION);
            etat = ftpDestination.login(this.utilisateurFTPDESTINATION, this.passwordFTPDESTINATION);
        }
        catch (Exception e) {
            etat = false;
            String string = e.toString();
        }
        if (!etat) {
            ftpDestination.disconnect();
            ftpDestination = null;
            throw new Exception("ERREUR AUTHENTIFICATION SERVEUR DESTINATION");
        }
        return ftpDestination;
    }

    public void lancerUpload() throws Exception {
        String[] listeMessagesStress;
        FtpConnection ftpDestination;
        System.out.println("+--> D\u00e9but du lancement : " + GregorianCalendar.getInstance().getTime().toString());
        try {
            ftpDestination = this.connexionFtp();
        }
        catch (Exception e) {
            throw new Exception("ERREUR FTP");
        }
        System.out.println("+--> Upload des fichiers");
        try {
            listeMessagesStress = new File("tmp").list();
        }
        catch (Exception exlm) {
            System.out.println("#--> ERREUR REP TMP");
            listeMessagesStress = null;
        }
        if (listeMessagesStress != null) {
            boolean erreur = false;
            int i = 0;
            while (i < listeMessagesStress.length) {
                try {
                    if (ftpDestination != null) {
                        erreur = !ftpDestination.uploadFile(listeMessagesStress[i], "tmp/" + listeMessagesStress[i]);
                    }
                }
                catch (Exception ex1) {
                    erreur = true;
                    System.out.println("ERREUR UPLOAD FICHIER " + ex1.toString());
                }
                ++i;
            }
            System.out.println("+--> Suppression des fichiers en local");
            i = 0;
            while (i < listeMessagesStress.length) {
                try {
                    new File("tmp/" + listeMessagesStress[i]).delete();
                }
                catch (Exception ex3) {
                    System.out.println("ERREUR SUPPRESSION FICHIER " + ex3.toString());
                }
                ++i;
            }
        } else {
            try {
                ftpDestination.logout();
                ftpDestination.disconnect();
                ftpDestination = null;
            }
            catch (Exception e) {
                System.out.println("#--> ERREUR LOGOUT FTP VIDE");
                ftpDestination = null;
            }
            throw new Exception("ERREUR TMP VIDE");
        }
        listeMessagesStress = null;
        if (ftpDestination != null) {
            try {
                ftpDestination.logout();
                ftpDestination.disconnect();
                ftpDestination = null;
            }
            catch (Exception e) {
                System.out.println("#--> ERREUR LOGOUT FTP");
                ftpDestination = null;
            }
        }
        System.out.println("+--> Fin du traitement");
    }

    public void lancerSuppression() throws Exception {
        String[] listeMessagesStress;
        System.out.println("+--> D\u00e9but du lancement : " + GregorianCalendar.getInstance().getTime().toString());
        FtpConnection ftpSource = new FtpConnection(false, this.modeSource);
        try {
            System.out.println("+--> Connexion \u00e0 " + this.cheminFTPSOURCE);
            ftpSource.connect(this.cheminFTPSOURCE, this.portServeurSource);
        }
        catch (Exception e) {
            ftpSource = null;
            throw new Exception("ERREUR CONNEXION SERVEUR SOURCE");
        }
        try {
            System.out.println("+--> Authentification - " + this.utilisateurFTPSOURCE);
            ftpSource.login(this.utilisateurFTPSOURCE, this.passwordFTPSOURCE);
        }
        catch (Exception e) {
            ftpSource.disconnect();
            ftpSource = null;
            throw new Exception("ERREUR AUTHENTIFICATION SERVEUR SOURCE");
        }
        try {
            System.out.println("+--> Recherche des fichiers...");
            listeMessagesStress = ftpSource.listFiles().split("\n");
            System.out.println("+--> Nb fichiers " + listeMessagesStress.length);
            System.out.println("+--> Telechargement des fichiers");
            boolean erreur = false;
            int i = 0;
            while (i < listeMessagesStress.length) {
                if (this.estFichierOk(listeMessagesStress[i])) {
                    erreur = false;
                    try {
                        ftpSource.downloadFile(listeMessagesStress[i], "tmp/" + listeMessagesStress[i]);
                    }
                    catch (Exception ex) {
                        erreur = true;
                        System.out.println("ERREUR TELECHARGEMENT FICHIER " + ex.toString());
                    }
                    if (!erreur) {
                        try {
                            ftpSource.deleteFile(listeMessagesStress[i]);
                        }
                        catch (Exception es) {
                            System.out.println("ERREUR SUPPRESSION FICHIER " + es.toString());
                        }
                    }
                }
                ++i;
            }
            System.out.println("+--> Fin du traitement");
            ftpSource.logout();
            ftpSource.disconnect();
            ftpSource = null;
        }
        catch (Exception e) {
            ftpSource.logout();
            ftpSource.disconnect();
            ftpSource = null;
        }
        listeMessagesStress = null;
    }

    public void lancerDownload() throws Exception {
        String[] listeMessages;
        System.out.println("+--> D\u00e9but du lancement : " + GregorianCalendar.getInstance().getTime().toString());
        FtpConnection ftpSource = new FtpConnection(false, this.modeSource);
        try {
            System.out.println("+--> Connexion \u00e0 " + this.cheminFTPSOURCE);
            ftpSource.connect(this.cheminFTPSOURCE, this.portServeurSource);
        }
        catch (Exception e) {
            ftpSource = null;
            throw new Exception("ERREUR CONNEXION SERVEUR SOURCE");
        }
        try {
            System.out.println("+--> Authentification - " + this.utilisateurFTPSOURCE);
            ftpSource.login(this.utilisateurFTPSOURCE, this.passwordFTPSOURCE);
        }
        catch (Exception e) {
            ftpSource.disconnect();
            ftpSource = null;
            throw new Exception("ERREUR AUTHENTIFICATION SERVEUR SOURCE");
        }
        try {
            System.out.println("+--> Recherche des fichiers...");
            listeMessages = ftpSource.listFiles().split("\n");
            System.out.println("+--> Nb fichiers " + listeMessages.length);
            System.out.println("+--> Telechargement des fichiers");
            boolean erreur = false;
            int i = 0;
            while (i < listeMessages.length) {
                System.out.println("+--> Telechargement du fichier " + listeMessages[i]);
                if (this.estFichierOk(listeMessages[i])) {
                    erreur = false;
                    try {
                        ftpSource.downloadFile(listeMessages[i], "tmp/" + listeMessages[i]);
                    }
                    catch (Exception ex) {
                        erreur = true;
                        System.out.println("ERREUR TELECHARGEMENT FICHIER " + ex.toString());
                    }
                    if (!erreur) {
                        try {
                            ftpSource.deleteFile(listeMessages[i]);
                        }
                        catch (Exception es) {
                            System.out.println("ERREUR SUPPRESSION FICHIER " + es.toString());
                        }
                    }
                } else {
                    System.out.println("#----> Le fichier n'est pas correct");
                }
                ++i;
            }
            System.out.println("+--> Fin du traitement");
            ftpSource.logout();
            ftpSource.disconnect();
            ftpSource = null;
        }
        catch (Exception e) {
            ftpSource.logout();
            ftpSource.disconnect();
            ftpSource = null;
        }
        listeMessages = null;
    }

    public static void main(String[] args) {
        TransfertFTP transfertFTP = new TransfertFTP();
    }
}

