/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier.zip;

import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZIP {
    private static final int BUFFER = 2048;
    public static final String EXTENSION_ZIP = ".zip";
    public static final String EXTENSION_JAR = ".jar";

    public static String unAccent(String s) {
        String temp = s;
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    public static File zipper(String source) throws Exception {
        return ZIP.zipper(source, Fichier.getRepertoire(source));
    }

    public static String getNomArchive(File source, File destination) {
        if (source.isDirectory()) {
            return Fichier.getRepertoire(destination.getPath()).concat(source.getName()).concat(EXTENSION_ZIP);
        }
        return Fichier.getRepertoire(destination.getPath()).concat(Fichier.getNom(source.getName())).concat(EXTENSION_ZIP);
    }

    public static File zipper(String source, String destination) throws Exception {
        File fichierSource = new File(source);
        if (fichierSource.isDirectory()) {
            return ZIP.zipper(fichierSource.list(), destination, fichierSource.getName());
        }
        return ZIP.zipper(new String[]{source}, destination, Fichier.getNom(source));
    }

    public static File zipper(String[] source, String dossierDestination, String nomFichierDestination) throws Exception {
        return ZIP.zipper(source, dossierDestination, nomFichierDestination, EXTENSION_ZIP);
    }

    public static File zipper(Vector source, String dossierDestination, String nomFichierDestination, String extension) throws Exception {
        return ZIP.zipper(GLS.toTableauString(source), dossierDestination, nomFichierDestination, extension);
    }

    public static File zipper(String[] source, String dossierDestination, String nomFichierDestination, String extension) throws Exception {
        if (!(GLS.estVide(source) || GLS.estVide(dossierDestination) || GLS.estVide(nomFichierDestination))) {
            String ext = "";
            ext = !extension.startsWith(".") ? "." + extension : extension;
            String fichierDestination = Fichier.completerChemin(dossierDestination).concat(nomFichierDestination).concat(ext);
            Fichier.verifierDossier(dossierDestination);
            Fichier.effacerFichier(fichierDestination);
            File destination = new File(fichierDestination);
            FileOutputStream dest = new FileOutputStream(destination);
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            BufferedOutputStream buff = new BufferedOutputStream(checksum);
            ZipOutputStream out = new ZipOutputStream(buff);
            out.setMethod(8);
            out.setLevel(9);
            byte[] data = new byte[2048];
            String[] stringArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                int count;
                String file = stringArray[n2];
                File f = new File(file);
                FileInputStream fi = new FileInputStream(file);
                BufferedInputStream buffi = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(ZIP.unAccent(f.getName()));
                out.putNextEntry(entry);
                while ((count = buffi.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                out.closeEntry();
                buffi.close();
                ++n2;
            }
            out.close();
            buff.close();
            checksum.close();
            dest.close();
            return destination;
        }
        throw new Exception("ERREUR LE FICHIER SOURCE OU LE FICHIER DESTINATION EST VIDE");
    }

    public static File dezipper(String source) throws Exception {
        return ZIP.dezipper(source, Fichier.getRepertoire(source));
    }

    public static File dezipper(String source, String destination) throws Exception {
        return ZIP.dezipper(source, destination);
    }

    public static String dezipper(String source, File destination) throws Exception {
        ZipEntry entry;
        BufferedOutputStream dest = null;
        FileInputStream fis = new FileInputStream(source);
        BufferedInputStream buffi = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(buffi);
        File repertoireDestination = !destination.isDirectory() ? new File(Fichier.getRepertoire(destination.getAbsolutePath())) : destination;
        Fichier.verifierDossier(repertoireDestination);
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            System.out.println("Extracting: " + entry);
            byte[] data = new byte[2048];
            FileOutputStream fos = new FileOutputStream(String.valueOf(Fichier.completerChemin(repertoireDestination.getPath())) + entry.getName());
            dest = new BufferedOutputStream(fos, 2048);
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
        }
        zis.close();
        return destination.getAbsolutePath();
    }
}

