/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier.xml;

import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XML {
    public static void validerFichierXML() throws Exception {
        XML.validerFichierXML(Fichier.choixFichier("xml"), Fichier.choixFichier("xsd"));
    }

    public static void validerFichierXML(String cheminFichierXML, File fichierXSD) throws Exception {
        XML.validerFichierXML(new File(cheminFichierXML), fichierXSD);
    }

    public static void validerFichierXML(File fichierXML, String cheminFichierXSD) throws Exception {
        XML.validerFichierXML(fichierXML, new File(cheminFichierXSD));
    }

    public static void validerFichierXML(String cheminfichierXML, String cheminFichierXSD) throws Exception {
        XML.validerFichierXML(new File(cheminfichierXML), new File(cheminFichierXSD));
    }

    public static void validerFichierXML(File fichierXML, File fichierXSD) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Validator validator = factory.newSchema(fichierXSD).newValidator();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document xml = dbf.newDocumentBuilder().parse(fichierXML);
        validator.validate(new DOMSource(xml));
    }

    public static Vector<String> validateXML() throws Exception {
        return XML.validateXML(Fichier.choixFichier("xml"), Fichier.choixFichier("xsd"));
    }

    public static Vector<String> validateXML(String fichierXML, String fichierXSD) throws Exception {
        return XML.validateXML(new File(fichierXML), new File(fichierXSD));
    }

    public static Vector<String> validateXML(File fichierXML, File fichierXSD) throws Exception {
        final Vector<String> errorsList = new Vector<String>();
        File f = fichierXML;
        FileInputStream is = new FileInputStream(f);
        byte[] attBody = new byte[is.available()];
        is.read(attBody);
        String msg = new String(attBody);
        ByteArrayInputStream IS = null;
        try {
            IS = new ByteArrayInputStream(msg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        try {
            saxParser.parse((InputStream)IS, new DefaultHandler(){

                @Override
                public void fatalError(SAXParseException e) {
                    errorsList.add("# FATAL ERROR # " + e.getMessage());
                }

                @Override
                public void error(SAXParseException e) {
                    errorsList.add("# ERROR # " + e.getMessage());
                }

                @Override
                public void warning(SAXParseException e) {
                    errorsList.add("# WARNING # " + e.getMessage());
                }
            });
        }
        catch (IOException ioe) {
            errorsList.add("# IOE EXCEPTION # " + ioe.getMessage());
        }
        catch (SAXException saxe) {
            errorsList.add("# SAX EXCEPTION # " + saxe.getMessage());
        }
        catch (Exception e) {
            errorsList.add("# EXCEPTION # " + e.getMessage());
        }
        return errorsList;
    }

    public static Vector<String> validateStringXML(String msg, File fichierXSD) throws Exception {
        final Vector<String> errorsList = new Vector<String>();
        ByteArrayInputStream IS = null;
        try {
            IS = new ByteArrayInputStream(msg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        try {
            saxParser.parse((InputStream)IS, new DefaultHandler(){

                @Override
                public void fatalError(SAXParseException e) {
                    errorsList.add("# FATAL ERROR # " + e.getMessage());
                }

                @Override
                public void error(SAXParseException e) {
                    errorsList.add("# ERROR # " + e.getMessage());
                }

                @Override
                public void warning(SAXParseException e) {
                    errorsList.add("# WARNING # " + e.getMessage());
                }
            });
        }
        catch (IOException ioe) {
            errorsList.add("# IOE EXCEPTION # " + ioe.getMessage());
        }
        catch (SAXException saxe) {
            errorsList.add("# SAX EXCEPTION # " + saxe.getMessage());
        }
        catch (Exception e) {
            errorsList.add("# EXCEPTION # " + e.getMessage());
        }
        return errorsList;
    }

    public static void main(String ... strings) {
        try {
            System.out.println(GLS.getString(XML.validateXML(), "\n"));
        }
        catch (Exception e) {
            System.err.println("ERREUR VALIDATION " + e.getMessage());
            e.printStackTrace();
        }
    }
}

