/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCONFIG;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class TransfertFichier
extends JFrame
implements ActionListener {
    private Timer timer;
    private FichierCONFIG config = new FichierCONFIG("config.jcfg");
    private int iFichierCourant;
    private String source;
    private String destination;
    private String[] fichiersATraiter;
    private int nbFichiers;
    private int delai = this.config.getInt("delai", 2);
    private JLabel label;

    public TransfertFichier() {
        this.timer = new Timer(this.delai * 1000, this);
        this.source = Fichier.completerChemin(this.config.getString("source"));
        this.destination = Fichier.completerChemin(this.config.getString("destination"));
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mysize = this.getSize();
        this.label = new JLabel();
        GLS.fixerTailleObjet(this.label, 800, 100);
        this.getContentPane().add(this.label);
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setLocation((screensize.width - mysize.width) / 2, (screensize.height - mysize.height) / 2);
        screensize = null;
        mysize = null;
        this.setResizable(false);
        this.setVisible(true);
    }

    public void lancer() {
        File dossierSource = new File(this.source);
        this.iFichierCourant = 0;
        this.label.setText("Lancement du transfert des fichiers toutes les " + this.delai + " seconde(s)");
        this.fichiersATraiter = dossierSource.list();
        if (!GLS.estVide(this.fichiersATraiter)) {
            this.nbFichiers = this.fichiersATraiter.length;
            this.timer.start();
        } else {
            this.label.setText("Aucun fichier \u00e0 traiter");
            this.setVisible(false);
            System.exit(0);
        }
    }

    public static void main(String ... strings) {
        TransfertFichier transfertFichier = new TransfertFichier();
        transfertFichier.lancer();
    }

    public void copierFichierCourant() {
        String fichierSource = this.source.concat(this.fichiersATraiter[this.iFichierCourant]);
        String fichierDestination = this.destination.concat(this.fichiersATraiter[this.iFichierCourant]);
        this.timer.stop();
        try {
            this.label.setText("Copie de " + fichierSource + " vers " + fichierDestination + " (" + (this.iFichierCourant + 1) + "/" + this.nbFichiers + ") - " + Fichier.copier(fichierSource, fichierDestination));
        }
        catch (Exception e) {
            this.label.setText("Erreur lors de la copie de " + fichierSource + " vers " + fichierDestination);
        }
        ++this.iFichierCourant;
        if (this.iFichierCourant < this.nbFichiers) {
            this.timer.start();
        } else {
            System.out.println("Traitement termin\u00e9");
            this.setVisible(false);
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.copierFichierCourant();
    }
}

