/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Vector;

public class MonFichier {
    private BufferedWriter fileWriter;
    private BufferedReader fileReader;
    public static final Charset DEFAUT_CHARSET = StandardCharsets.ISO_8859_1;
    protected File fichier = null;
    protected String chemin = null;
    protected int typeAcces;
    protected boolean fichierOuvert = false;
    public static final int ECRITURE = 1;
    public static final int LECTURE = 2;
    public static final int LECTURE_ECRITURE = 3;

    public MonFichier() {
    }

    public MonFichier(String path, int acces) {
        this.ouvrir(path, acces);
    }

    public MonFichier(String path, int acces, Charset c) {
        this.ouvrir(path, acces, c);
    }

    public void ouvrir() {
        this.ouvrir(this.chemin, this.typeAcces);
    }

    public void ouvrir(String path, int acces) {
        this.ouvrir(path, acces, DEFAUT_CHARSET);
    }

    public void ouvrir(String path, int acces, Charset c) {
        block11: {
            if (path != null) {
                this.chemin = path;
                this.typeAcces = acces;
                try {
                    switch (this.typeAcces) {
                        case 2: {
                            this.fileReader = Files.newBufferedReader(Paths.get(path, new String[0]), c);
                            break;
                        }
                        case 1: {
                            this.fileWriter = Files.newBufferedWriter(Paths.get(path, new String[0]), c, new OpenOption[0]);
                            break;
                        }
                        case 3: {
                            this.fileReader = Files.newBufferedReader(Paths.get(path, new String[0]), c);
                            this.fileWriter = Files.newBufferedWriter(Paths.get(path, new String[0]), c, new OpenOption[0]);
                            break;
                        }
                        default: {
                            this.fileReader = Files.newBufferedReader(Paths.get(path, new String[0]), c);
                        }
                    }
                    if (MonFichier.existe(path)) {
                        this.fichier = new File(path);
                        this.fichierOuvert = true;
                        break block11;
                    }
                    this.fichierOuvert = false;
                }
                catch (FileNotFoundException fexcep) {
                    this.fichierOuvert = false;
                }
                catch (IOException ioexcep) {
                    System.out.println("#--> ERREUR D'OUVERTURE " + ioexcep.toString());
                    this.fichierOuvert = false;
                }
            } else {
                this.chemin = "";
                this.fichierOuvert = false;
            }
        }
    }

    public boolean isOpen() {
        return this.fichierOuvert;
    }

    public boolean isReady() {
        if (this.typeAcces != 2) {
            return false;
        }
        try {
            return this.fileReader.ready();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String lire() throws Exception {
        if (this.typeAcces != 2) {
            return "";
        }
        return this.fileReader.readLine();
    }

    public Vector<String> lireTout() throws Exception {
        Vector<String> lignes = new Vector<String>();
        while (this.isReady()) {
            try {
                lignes.add(this.lire());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lignes;
    }

    public static boolean existe(String cheminFichier) {
        return new File(cheminFichier).exists();
    }

    public boolean existe() {
        return this.fichier.exists();
    }

    public void supprimer() throws Exception {
        this.fichier.delete();
    }

    public static void supprimer(String cheminFichier) throws Exception {
        new File(cheminFichier).delete();
    }

    public void ecrire(String _ligne) throws Exception {
        if (this.typeAcces != 1) {
            return;
        }
        this.fileWriter.write(_ligne);
    }

    public void ecrire(Vector lignes) throws Exception {
        if (this.typeAcces != 1 || lignes == null) {
            return;
        }
        for (Object ligne : lignes) {
            String ligneAEcrire = ligne instanceof String ? (String)ligne : ligne.toString();
            this.fileWriter.write(String.valueOf(ligneAEcrire) + '\n');
        }
    }

    public void ecrire(String[] lignes) throws Exception {
        if (this.typeAcces != 1) {
            return;
        }
        int i = 0;
        while (i < lignes.length) {
            this.fileWriter.write(String.valueOf(lignes[i]) + '\n');
            ++i;
        }
    }

    public void fermer() throws Exception {
        if (this.typeAcces == 2 || this.typeAcces == 3) {
            this.fileReader.close();
        }
        if (this.typeAcces == 1 || this.typeAcces == 3) {
            this.fileWriter.close();
        }
    }
}

