/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.fichier.MonFiltre;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MonChoixFichier
extends JDialog
implements ActionListener {
    private JLabel jlLibelle;
    private JTextField jtChemin;
    private JButton jbParcourir;
    private JButton jbAnnuler;
    private JButton jbOk;
    private JPanel jpBoutons;
    private File file = null;
    private String monFiltre = "*";

    public MonChoixFichier(String label, String filtre) {
        Container content = this.getContentPane();
        this.jpBoutons = new JPanel(new GridLayout(1, 2));
        this.jlLibelle = new JLabel(label);
        this.jtChemin = new JTextField();
        this.jbAnnuler = new JButton("Annuler");
        this.jbOk = new JButton("Ok");
        this.jbParcourir = new JButton("Parcourir");
        this.monFiltre = filtre;
        this.jbParcourir.addActionListener(this);
        this.jbParcourir.setActionCommand("parcourir");
        this.jbAnnuler.addActionListener(this);
        this.jbAnnuler.setActionCommand("annuler");
        this.jbOk.addActionListener(this);
        this.jbOk.setActionCommand("ok");
        this.jpBoutons.add(this.jbAnnuler);
        this.jpBoutons.add(this.jbOk);
        content.setLayout(new GridLayout(1, 4));
        content.add(this.jlLibelle);
        content.add(this.jtChemin);
        content.add(this.jbParcourir);
        content.add(this.jpBoutons);
        this.setModal(true);
        this.pack();
    }

    public String afficher() {
        this.show();
        return this.getPath();
    }

    public String getPath() {
        return this.jtChemin.getText();
    }

    private void setPath(String chemin) {
        this.jtChemin.setText(chemin);
    }

    public String getFolder() {
        if (this.file != null) {
            return this.file.getParent();
        }
        return "";
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        this.file = file;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        String action = a.getActionCommand();
        if (action.equals("parcourir")) {
            JFileChooser fileChooser = new JFileChooser();
            String[] f = new String[]{this.monFiltre};
            fileChooser.setFileFilter(new MonFiltre(f, "Les fichiers " + this.monFiltre));
            fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            int retour = fileChooser.showOpenDialog(this.jtChemin);
            if (retour == 0) {
                this.setFile(fileChooser.getSelectedFile());
                this.setPath(fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (action.equals("annuler")) {
            this.setPath("");
            this.setVisible(false);
        } else if (action.equals("ok")) {
            this.setVisible(false);
        }
    }
}

