/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.fichier.Fichier;
import gls.outils.fichier.MonFichier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class FichierLOG
extends MonFichier {
    private DateFormat formatDateLog = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
    private DateFormat formatDateFichierLog = new SimpleDateFormat("yyyyMMdd");
    public static int NIVEAU_TRACES = 3;
    public static final int AUCUNE_TRACE = 0;
    public static final int TRACE_ERREUR = 1;
    public static final int TRACE_INFO = 2;
    public static final int TOUTES_TRACES = 3;
    public static int TYPE_TRACES = 0;
    public static final int TYPE_FICHIER_ET_CONSOLE = 0;
    public static final int TYPE_CONSOLE = 1;
    public static final int TYPE_FICHIER = 2;
    private static final String CHEMIN_LOGS = "logs/";

    public FichierLOG() {
        this.ouvrirDefaut();
    }

    public FichierLOG(String chemin) {
        super(chemin, 1);
    }

    public FichierLOG(String chemin, int niveauTraces, int typeTraces) {
        super(chemin, 1);
        NIVEAU_TRACES = niveauTraces;
        TYPE_TRACES = typeTraces;
    }

    public FichierLOG(int niveauTraces, int typeTraces) {
        this.ouvrirDefaut();
        NIVEAU_TRACES = niveauTraces;
        TYPE_TRACES = typeTraces;
    }

    public void ouvrirDefaut() {
        if (Fichier.verifierDossier(CHEMIN_LOGS)) {
            this.ouvrir(CHEMIN_LOGS.concat(this.getNomFichier()), 1);
        } else {
            this.ouvrir(this.getNomFichier(), 1);
        }
    }

    private String getNomFichier() {
        return "SERPE_" + this.formatDateFichierLog.format(GregorianCalendar.getInstance().getTime()) + ".log";
    }

    private String getDate() {
        return this.formatDateLog.format(GregorianCalendar.getInstance().getTime());
    }

    public void erreur(String erreur) {
        this.ecrireErreur(erreur);
    }

    public void ecrireErreur(String erreur) {
        if (NIVEAU_TRACES > 0) {
            String log = "ERREUR " + this.getDate() + " # " + erreur;
            switch (TYPE_TRACES) {
                case 0: {
                    System.out.println(erreur);
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    System.out.println(erreur);
                    break;
                }
                case 2: {
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void info(String info) {
        this.ecrireInfo(info);
    }

    public void ecrireInfo(String info) {
        if (NIVEAU_TRACES > 1) {
            String log = "INFO " + this.getDate() + " # " + info;
            switch (TYPE_TRACES) {
                case 0: {
                    System.out.println(info);
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    System.out.println(info);
                    break;
                }
                case 2: {
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void trace(String trace) {
        this.ecrireTrace(trace);
    }

    public void ecrireTrace(String trace) {
        if (trace != null && trace.length() > 0) {
            switch (trace.charAt(0)) {
                case '#': {
                    this.ecrireErreur(trace);
                    break;
                }
                case '!': {
                    this.ecrireInfo(trace);
                    break;
                }
                case '+': {
                    this.ecrireDebug(trace);
                    break;
                }
                default: {
                    this.ecrireLog(trace);
                }
            }
        }
    }

    public void debug(String debug) {
        this.ecrireDebug(debug);
    }

    public void ecrireDebug(String debug) {
        if (NIVEAU_TRACES > 2) {
            String log = "DEBUG " + this.getDate() + " # " + debug;
            switch (TYPE_TRACES) {
                case 0: {
                    System.out.println(debug);
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    System.out.println(debug);
                    break;
                }
                case 2: {
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void log(String message) {
        this.ecrireLog(message);
    }

    public void ecrireLog(String message) {
        if (NIVEAU_TRACES > 2) {
            String log = "LOG " + this.getDate() + " # " + message;
            switch (TYPE_TRACES) {
                case 0: {
                    System.out.println(message);
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    System.out.println(message);
                    break;
                }
                case 2: {
                    try {
                        this.ecrire(String.valueOf(log) + '\n');
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

