/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import cartoj.ICouche;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import gls.outils.fichier.FichierCONFIG;
import java.util.Vector;

public class FichierINFOBULLE
extends FichierCONFIG {
    public FichierINFOBULLE(String fichier) {
        super(fichier);
    }

    @Override
    public void ajouterNouvelleValeur(String champ, String valeur) {
        String[] val;
        ICouche couche;
        if (!LocalisationInfo.estVide(champ) && !LocalisationInfo.estVide(valeur) && (couche = LocalisationInfo.getCouche(champ)) != null && (val = valeur.split(";")).length >= 2) {
            Vector<String[]> vec = new Vector<String[]>();
            vec.add(val);
            this.Vchamp.add(champ);
            this.Vvaleur.add(vec);
        }
    }

    @Override
    public void modifierValeur(int indiceChamp, String valeur) {
        String[] val;
        if (!LocalisationInfo.estVide(valeur) && (val = valeur.split(";")).length >= 2) {
            ((Vector)this.Vvaleur.get(indiceChamp)).add(val);
        }
    }

    public String getCouche(int indice) {
        return (String)this.Vchamp.get(indice);
    }

    @Override
    public int getNbChamps() {
        if (!this.estVide()) {
            return this.Vchamp.size();
        }
        return -1;
    }

    public Vector getChamps(int indice) {
        Vector vec = (Vector)this.Vvaleur.get(indice);
        int[] indices = new int[vec.size()];
        String[] valeurs = new String[vec.size()];
        boolean[] multiLabel = new boolean[vec.size()];
        String[] images = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            String[] val = (String[])vec.get(i);
            int iTmp = ConstantesGLS.getInt(val[0]);
            if (iTmp == -1) {
                return null;
            }
            indices[i] = iTmp;
            String tmp = val[1];
            valeurs[i] = !ConstantesGLS.estVide(tmp) ? String.valueOf(val[1]) + " : " : "";
            if (val.length > 2) {
                images[i] = ConstantesGLS.getString(val[2], "");
                multiLabel[i] = val.length > 3 ? ConstantesGLS.getBoolean(val[3], true) : true;
            } else {
                multiLabel[i] = true;
                images[i] = "";
            }
            ++i;
        }
        Vector<Object[]> vecFinal = new Vector<Object[]>();
        vecFinal.add(indices);
        vecFinal.add(valeurs);
        vecFinal.add(images);
        vecFinal.add(multiLabel);
        return vecFinal;
    }
}

