/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.GLS;
import gls.outils.fichier.MonFichier;
import java.util.Vector;

public class FichierDONNEES
extends MonFichier {
    protected Vector listeDonnees = new Vector();

    public FichierDONNEES(String fichier) {
        super(fichier, 2);
        this.charger();
    }

    protected void charger() {
        if (!this.isOpen()) {
            return;
        }
        String tmp = "";
        try {
            while (this.isReady()) {
                try {
                    tmp = this.lire();
                }
                catch (Exception e) {
                    System.out.println("ERREUR LECTURE FICHIER " + e);
                    e.printStackTrace();
                }
                this.ajouterValeur(tmp);
            }
        }
        catch (Exception ex) {
            System.out.println("ERREUR CHARGEMENT FICHIER " + ex);
            ex.printStackTrace();
        }
        try {
            this.fermer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean valeurOk(String valeur) {
        return !valeur.equals("") && valeur.charAt(0) != '-' && valeur.charAt(0) != '#' && this.getIndiceChamp(valeur) == -1 && this.longueurOk(valeur);
    }

    protected boolean longueurOk(String valeur) {
        int longueurMax = this.getLongueurMax();
        GLS.getLogs().debug((Object)("Valeur source " + valeur.length() + " -- " + longueurMax));
        return longueurMax == -1 || valeur.length() <= longueurMax;
    }

    protected int getLongueurMax() {
        return -1;
    }

    protected void ajouterValeur(String valeur) {
        if (this.valeurOk(valeur)) {
            this.ajouterNouvelleValeur(valeur);
        }
    }

    protected void ajouterNouvelleValeur(String valeur) {
        this.listeDonnees.add(valeur);
    }

    protected int getIndiceChamp(String champ) {
        int i = 0;
        while (i < this.listeDonnees.size()) {
            if (GLS.getString(this.listeDonnees.get(i)).equals(champ)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getListeDonneesVecteur() {
        return this.listeDonnees;
    }

    public String[] getListeDonneesString() {
        if (this.listeDonnees != null && this.listeDonnees.size() > 0) {
            String[] donnees = new String[this.listeDonnees.size()];
            int i = 0;
            while (i < this.listeDonnees.size()) {
                donnees[i] = GLS.getString(this.listeDonnees.get(i));
                ++i;
            }
            return donnees;
        }
        return null;
    }

    public String getDonnee(int indice) {
        if (indice < this.listeDonnees.size() && indice > -1) {
            return GLS.getString(this.listeDonnees.get(indice));
        }
        return null;
    }

    public boolean estVide() {
        return this.listeDonnees == null || this.listeDonnees.size() <= 0;
    }
}

