/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.ConstantesGLS;
import gls.outils.fichier.FichierCONFIG;

public class FichierDATEX
extends FichierCONFIG {
    private static final char SEPARATEUR_DATEX = '#';

    public FichierDATEX(String chemin) {
        super(chemin, '#');
    }

    @Override
    public void ajouterNouvelleValeur(String champ, String valeur) {
        this.Vchamp.add(champ);
        this.Vvaleur.add(this.toValeurDatex(valeur));
    }

    public String toValeurDatex(String valeurFichier) {
        if (!ConstantesGLS.estNulle(valeurFichier)) {
            char dernierCaractere = valeurFichier.charAt(valeurFichier.length() - 1);
            if (dernierCaractere == '#') {
                return valeurFichier.substring(0, valeurFichier.length() - 1);
            }
            return valeurFichier;
        }
        return "";
    }

    @Override
    public void modifierValeur(int champ, String valeur) {
        this.Vvaleur.setElementAt(this.toValeurDatex(valeur), champ);
    }

    public String toDatex(int i) {
        if (i < this.Vchamp.size() && i >= 0) {
            return String.valueOf((String)this.Vchamp.get(i)) + '#' + (String)this.Vvaleur.get(i) + '#';
        }
        return "";
    }

    public String[] toDatex() {
        String[] listeChampsDatex = new String[this.Vchamp.size()];
        int i = 0;
        while (i < this.Vchamp.size()) {
            listeChampsDatex[i] = this.toDatex(i);
            ++i;
        }
        return listeChampsDatex;
    }
}

