/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.CSV;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.MonFichier;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class FichierCSV
extends HashMap<String, String[]> {
    protected static final String EXTENSION_CSV = "csv";
    protected MonFichier fichierCSV;
    protected String[] champs;
    protected int nbChamps;
    protected char separateur;
    protected String chemin;
    protected String SEPARATEUR;
    protected int indiceChampCle;
    protected int nbLignesEntete = 0;
    protected static Fichier fichier = Fichier.instanceOf();
    protected static CSV csv = new CSV();

    public FichierCSV() throws Exception {
        this(CSV.SEPARATEUR_CSV_CHAR);
    }

    public FichierCSV(char separateur) throws Exception {
        this(Fichier.choixFichier(EXTENSION_CSV), separateur, 0);
    }

    public FichierCSV(String cheminFichier, Charset c) {
        this(cheminFichier, CSV.SEPARATEUR_CSV_CHAR, 0, c);
    }

    public FichierCSV(String cheminFichier) {
        this(cheminFichier, CSV.SEPARATEUR_CSV_CHAR, 0);
    }

    public FichierCSV(String cheminFichier, char separateur) {
        this(cheminFichier, separateur, 0);
    }

    public FichierCSV(String cheminFichier, char separateur, int indiceChampCle) {
        this(cheminFichier, separateur, 0, MonFichier.DEFAUT_CHARSET);
    }

    public FichierCSV(String cheminFichier, char separateur, int indiceChampCle, Charset c) {
        this.chemin = cheminFichier;
        this.fichierCSV = new MonFichier(cheminFichier, 2, c);
        this.separateur = separateur;
        this.SEPARATEUR = String.valueOf(separateur);
        this.indiceChampCle = indiceChampCle;
        this.nbChamps = -1;
    }

    public int getIndiceChamp(String champ) throws Exception {
        int i = GLS.getIndiceObjetListe(this.champs, champ);
        if (i != -1) {
            return i;
        }
        throw new Exception("### ERREUR # CHAMP " + champ + " INEXISTANT");
    }

    public MonFichier getFichier() {
        return this.fichierCSV;
    }

    public String getCheminFichier() {
        return this.chemin;
    }

    @Override
    public boolean containsKey(Object objet) {
        Iterator it = this.keySet().iterator();
        boolean trouve = false;
        while (!trouve && it.hasNext()) {
            if (!GLS.egal(it.next(), objet)) continue;
            trouve = true;
        }
        return trouve;
    }

    public int getIndice(Object objet) {
        Iterator it = this.keySet().iterator();
        boolean trouve = false;
        int i = 0;
        int indice = -1;
        while (!trouve && it.hasNext()) {
            if (GLS.egal(it.next(), objet)) {
                indice = i;
                trouve = true;
            }
            ++i;
        }
        return indice;
    }

    @Override
    public String[] get(Object key) {
        Iterator itKey = this.keySet().iterator();
        Iterator itVal = this.values().iterator();
        String tmpKey = null;
        String[] tmpVal = null;
        boolean trouve = false;
        while (!trouve && itKey.hasNext()) {
            tmpKey = (String)itKey.next();
            tmpVal = (String[])itVal.next();
            if (!GLS.egal((Object)tmpKey, key)) continue;
            trouve = true;
        }
        if (trouve) {
            return tmpVal;
        }
        return null;
    }

    public String get(String cle, String champ) throws Exception {
        return this.get(cle, this.getIndiceChamp(champ));
    }

    public String[] getPremiereLigne(int champ, String valeur) throws Exception {
        return this.get(champ, valeur).firstElement();
    }

    public String[] getPremiereLigne(int[] champs, String[] valeurs) throws Exception {
        return this.get(champs, valeurs).firstElement();
    }

    public Vector<String[]> get(int champ, String valeur) throws Exception {
        return this.get(new int[]{champ}, new String[]{valeur});
    }

    public Vector<String[]> get(int[] champs, String[] valeurs) throws Exception {
        Vector<String[]> liste = new Vector<String[]>();
        Iterator itVal = this.values().iterator();
        String[] tmpVal = null;
        while (itVal.hasNext()) {
            tmpVal = (String[])itVal.next();
            if (!this.egal(champs, valeurs, tmpVal)) continue;
            liste.add(tmpVal);
        }
        if (GLS.estVide(liste)) {
            throw new Exception("AUCUNE VALEUR TROUVEE");
        }
        return liste;
    }

    public boolean egal(int[] champs, String[] valeursRecherches, String[] ligne) {
        boolean erreur = false;
        boolean fin = false;
        int i = 0;
        fin = champs.length == 0;
        while (!fin && !erreur) {
            if (!GLS.egal(ligne[champs[i]], valeursRecherches[i])) {
                erreur = true;
            }
            boolean bl = fin = ++i == champs.length;
        }
        return !erreur;
    }

    public String get(String cle, int indiceChamp) throws Exception {
        String[] valeurs;
        if (!GLS.estNulle(indiceChamp) && !GLS.estVide(valeurs = this.get(cle))) {
            return valeurs[indiceChamp];
        }
        throw new Exception("### ERREUR DANS LA RECUPERATION DU CHAMP # " + cle + " # " + indiceChamp);
    }

    public String get(String[] valeurs, String champ) throws Exception {
        return this.get(valeurs, this.getIndiceChamp(champ));
    }

    public String get(String[] valeurs, int indiceChamp) throws Exception {
        if (!GLS.estNulle(indiceChamp) && !GLS.estVide(valeurs)) {
            return valeurs[indiceChamp];
        }
        throw new Exception("### ERREUR DANS LA RECUPERATION DU CHAMP # " + indiceChamp);
    }

    public void initialiser() throws Exception {
        if (this.fichierCSV.isReady()) {
            System.out.println("FichierCSV Ready");
            this.champs = this.fichierCSV.lire().split(this.SEPARATEUR);
            this.nbChamps = this.champs.length;
        } else {
            System.out.println("FichierCSV Not Ready");
        }
    }

    public boolean estValeursValide(String[] valeurs) {
        return this.nbChamps <= 0 || valeurs.length == this.nbChamps;
    }

    public boolean isReady() {
        return this.fichierCSV.isReady();
    }

    public void fermer() throws Exception {
        this.fichierCSV.fermer();
    }

    public String[] lire() throws Exception {
        String[] valeurs = this.fichierCSV.lire().split(this.SEPARATEUR, -1);
        if (this.estValeursValide(valeurs)) {
            return GLS.remplacer(GLS.trim(valeurs), "\"", "");
        }
        throw new Exception("### CSV ERREUR # LE NOMBRE DE CHAMPS N'EST PAS CORRECT # " + this.nbChamps + " <> " + valeurs.length + " # ");
    }

    public Vector<String[]> lireTout() throws Exception {
        Vector<String[]> Donnees = new Vector<String[]>();
        while (this.isReady()) {
            try {
                Donnees.add(this.lire());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Donnees;
    }

    public void ajouter(String[] valeurs) {
        if (this.indiceChampCle > -1 && this.indiceChampCle < this.nbChamps) {
            this.put(valeurs[this.indiceChampCle], valeurs);
        } else {
            this.put(GLS.getString(valeurs), valeurs);
        }
    }

    public void charger() throws Exception {
        int numLigne = 0;
        while (this.fichierCSV.isReady()) {
            try {
                if (numLigne < this.nbLignesEntete) {
                    this.lire();
                } else {
                    this.ajouter(this.lire());
                }
                ++numLigne;
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.fichierCSV.fermer();
    }

    public String[] getChamps() {
        return this.champs;
    }

    public int getIndiceChampCle() {
        return this.indiceChampCle;
    }

    public void setIndiceChampCle(int indiceChampCle) {
        this.indiceChampCle = indiceChampCle;
    }

    public int getNbLignesEntete() {
        return this.nbLignesEntete;
    }

    public void setNbLignesEntete(int nbLignesEntete) {
        this.nbLignesEntete = nbLignesEntete;
    }
}

