/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.ConstantesGLS;
import gls.outils.GLS;
import gls.outils.GLSHashMap;
import gls.outils.fichier.MonFichier;
import java.util.Vector;

public class FichierCONFIG
extends MonFichier {
    public static final String CHAMP_NOM = "nom";
    public static final char SEPARATEUR_CONFIG = '=';
    public static final String SEPARATEUR_CHAMP = ".";
    protected static final String SEPARATEUR_TABLEAU = ";";
    protected static final char FLAG_COMMENTAIRE = '-';
    protected static final char FLAG_COMMENTAIRE2 = '#';
    protected Vector Vvaleur = new Vector();
    protected Vector Vchamp = new Vector();
    protected boolean remplacerSiExistant = false;
    protected char separateur = (char)61;
    public static final int CHAMP_INEXISTANT = -1;

    public FichierCONFIG() {
    }

    public FichierCONFIG(String _path) {
        this(_path, true, '=');
    }

    public FichierCONFIG(String _path, char separateur) {
        this(_path, true, separateur);
    }

    public FichierCONFIG(String _path, boolean remplacerSiExistant) {
        this(_path, remplacerSiExistant, '=');
    }

    public FichierCONFIG(String _path, boolean remplacerSiExistant, char separateur) {
        super(_path, 2);
        this.charger(remplacerSiExistant, separateur);
    }

    public void ouvrirEtCharger(String fichier) {
        this.ouvrirEtCharger(fichier, true, '=');
    }

    public void ouvrirEtCharger(String fichier, char separateur) {
        this.ouvrirEtCharger(fichier, true, separateur);
    }

    public void ouvrirEtCharger(String fichier, boolean remplacerSiExistant) {
        this.ouvrirEtCharger(fichier, remplacerSiExistant, '=');
    }

    public void ouvrirEtCharger(String fichier, boolean remplacerSiExistant, char separateur) {
        this.ouvrir(fichier, 2);
        this.charger(remplacerSiExistant, separateur);
    }

    public void charger() {
        this.charger(true, '=');
    }

    public void charger(boolean remplacerSiExistant, char separateur) {
        this.remplacerSiExistant = remplacerSiExistant;
        this.separateur = separateur;
        if (!this.isOpen()) {
            return;
        }
        String tmp = "";
        try {
            while (this.isReady()) {
                try {
                    tmp = this.lire();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.ajouterValeur(tmp);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.fermer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public char getSeparateur() {
        return this.separateur;
    }

    public boolean estVide() {
        return this.Vchamp.size() == 0;
    }

    protected boolean champExiste(String champ) {
        return ConstantesGLS.getBoolean(this.getIndiceChamp(champ), false);
    }

    public int getIndiceChamp(String champ) {
        int i = 0;
        while (i < this.Vchamp.size()) {
            String s = (String)this.Vchamp.get(i);
            if (s.equals(champ)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean valeurOk(int pos, String tmp) {
        return pos > 0 && pos != tmp.length() && tmp.charAt(0) != '-' && tmp.charAt(0) != '#';
    }

    public void ajouterValeur(String tmp) {
        int pos = tmp.indexOf(this.separateur);
        if (this.valeurOk(pos, tmp)) {
            String champ = tmp.substring(0, pos);
            String valeur = tmp.substring(pos + 1);
            int indiceChamp = this.getIndiceChamp(champ);
            if (indiceChamp == -1) {
                this.ajouterNouvelleValeur(champ, valeur);
            } else if (this.remplacerSiExistant) {
                this.modifierValeur(indiceChamp, valeur);
            }
        }
    }

    public Vector getChamps() {
        return this.Vchamp;
    }

    public int getNbChamps() {
        return this.Vchamp.size();
    }

    public Vector getValeurs() {
        return this.Vvaleur;
    }

    public void ajouterNouvelleValeur(String champ, String valeur) {
        this.Vchamp.add(champ);
        this.Vvaleur.add(valeur);
    }

    public void modifierValeur(int champ, String valeur) {
        this.Vvaleur.setElementAt(valeur, champ);
    }

    public void modifierValeur(String champ, String valeur) {
        int indiceChamp = this.getIndiceChamp(champ);
        if (indiceChamp == -1) {
            this.ajouterNouvelleValeur(champ, valeur);
        } else {
            this.modifierValeur(indiceChamp, valeur);
        }
    }

    public Object get(String champ) {
        int i = 0;
        while (i < this.Vchamp.size()) {
            String s = (String)this.Vchamp.get(i);
            if (s.equals(champ)) {
                return this.Vvaleur.get(i);
            }
            ++i;
        }
        return null;
    }

    public String getString(String champ) {
        return this.getString(champ, "");
    }

    public String getString(String champ, String defaut) {
        Object valeur = this.get(champ);
        if (valeur == null) {
            return defaut;
        }
        if (valeur instanceof String) {
            return (String)valeur;
        }
        return String.valueOf(valeur);
    }

    public float getFloat(String champ) {
        return this.getFloat(champ, -1.0f);
    }

    public float getFloat(String champ, float defaut) {
        try {
            return Float.parseFloat(this.getString(champ));
        }
        catch (Exception exCoeff) {
            return defaut;
        }
    }

    public String[] getTableauString(String champ, String separateur) {
        return this.getTableauString(champ, separateur, null);
    }

    public String[] getTableauString(String champ) {
        return this.getTableauString(champ, SEPARATEUR_TABLEAU, null);
    }

    public String[] getTableauString(String champ, String[] defaut) {
        return this.getTableauString(champ, SEPARATEUR_TABLEAU, defaut);
    }

    public String[] getTableauString(String champ, String separateur, String[] defaut) {
        String valeur = this.getString(champ, null);
        if (valeur == null) {
            return defaut;
        }
        return valeur.split(separateur);
    }

    public double getDouble(String champ) {
        return this.getDouble(champ, -1.0);
    }

    public double getDouble(String champ, double defaut) {
        try {
            return Double.parseDouble(this.getString(champ));
        }
        catch (Exception exCoeff) {
            return defaut;
        }
    }

    public GLSHashMap getConfigObjet(String chemin, String objet) {
        GLSHashMap configObjet = new GLSHashMap();
        String cheminComplet = !chemin.endsWith(SEPARATEUR_CHAMP) ? chemin.concat(SEPARATEUR_CHAMP) : chemin;
        cheminComplet = cheminComplet.concat(objet.trim()).concat(SEPARATEUR_CHAMP);
        int i = 0;
        while (i < this.getNbChamps()) {
            String champ = GLS.getString(this.Vchamp.get(i));
            if (champ.startsWith(cheminComplet)) {
                configObjet.put(champ.replace(cheminComplet, ""), GLS.getString(this.Vvaleur.get(i)));
            }
            ++i;
        }
        if (!configObjet.isEmpty()) {
            configObjet.put(CHAMP_NOM, objet);
        }
        return configObjet;
    }

    public static GLSHashMap getConfigObjet(GLSHashMap map, String chemin, String objet) {
        GLSHashMap configObjet = new GLSHashMap();
        String cheminComplet = !chemin.endsWith(SEPARATEUR_CHAMP) ? chemin.concat(SEPARATEUR_CHAMP) : chemin;
        cheminComplet = cheminComplet.concat(objet.trim()).concat(SEPARATEUR_CHAMP);
        for (String cle : map.keySet()) {
            if (!cle.startsWith(cheminComplet)) continue;
            configObjet.put(cle.replaceFirst(cheminComplet, ""), map.get(cle));
        }
        if (!configObjet.isEmpty()) {
            configObjet.put(CHAMP_NOM, objet);
        }
        return configObjet;
    }

    public int getInt(String champ) {
        return this.getInt(champ, -1);
    }

    public int getInt(String champ, int defaut) {
        try {
            return Integer.parseInt(this.getString(champ));
        }
        catch (Exception exCoeff) {
            return defaut;
        }
    }

    public boolean getBoolean(String champ, boolean defaut) {
        int valeur = this.getInt(champ);
        if (valeur == -1) {
            return defaut;
        }
        return valeur == 1;
    }

    public Vector getContenuSauvegarde() {
        Vector<String> contenuSauvegarde = new Vector<String>();
        int i = 0;
        while (i < this.Vchamp.size()) {
            contenuSauvegarde.add(this.Vchamp.get(i) + String.valueOf(this.separateur) + this.Vvaleur.get(i));
            ++i;
        }
        return contenuSauvegarde;
    }

    public String rechercherValeur(String champ) {
        return this.getString(champ);
    }

    public void sauvegarder() throws Exception {
        this.sauvegarder(this.getContenuSauvegarde());
    }

    public void sauvegarder(Vector liste) throws Exception {
        try {
            if (this.isOpen()) {
                this.fermer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.supprimer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ouvrir(this.chemin, 1);
        this.ecrire(liste);
        this.fermer();
    }

    public static void main(String ... s) {
        try {
            FichierCONFIG config = new FichierCONFIG("e:/parametresLCR.properties");
            config.modifierValeur("parametresLCR.set.echo", "Y");
            System.out.println(config.getString("parametresLCR.set.echo"));
            GLSHashMap set = config.getConfigObjet("parametresLCR", "set");
            config.sauvegarder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

