/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.fichier;

import gls.outils.GLS;
import gls.outils.fichier.FichierCONFIG;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Fichier {
    private static Fichier instance;
    public static final int REPERTOIRES = 1;
    public static final int FICHIERS = 0;
    public static final String TOUT_FICHIERS = "*.*";
    public static final String SEPARATEUR_EXTENSION = ";";
    public static final String FICHIERS_JPG = "jpg";
    public static final String FICHIERS_JPEG = "jpeg";
    public static final String FICHIERS_BMP = "bmp";
    public static final String FICHIERS_GIF = "gif";
    public static final String FICHIERS_PNG = "png";
    public static final String FICHIERS_XML = "xml";
    public static final String[] FICHIERS_IMAGES;
    public static final String SEPARATEUR_FICHIER;

    static {
        FICHIERS_IMAGES = new String[]{FICHIERS_JPG, FICHIERS_JPEG, FICHIERS_BMP, FICHIERS_GIF, FICHIERS_PNG};
        SEPARATEUR_FICHIER = System.getProperty("file.separator");
    }

    public static Fichier instanceOf() {
        if (instance == null) {
            instance = new Fichier();
        }
        return instance;
    }

    private Fichier() {
    }

    public static boolean estUrl(String url) {
        if (!GLS.estVide(url) && url.startsWith("http://")) {
            try {
                URL obj = new URL(url);
                obj.toURI();
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public static final String choixDossier() throws Exception {
        return Fichier.choixFichier(null, new File(""), 1, Fichier.getFiltre());
    }

    public static final String choixFichier() throws Exception {
        return Fichier.choixFichier(null, new File(""), 0, Fichier.getFiltre());
    }

    public static final String choixFichier(File repertoire, String filtre) throws Exception {
        return Fichier.choixFichier(null, repertoire, 0, filtre);
    }

    public static final String choixFichier(String filtre) throws Exception {
        return Fichier.choixFichier(null, new File(""), 0, filtre);
    }

    public static final String choixFichierImages() throws Exception {
        return Fichier.choixFichierImages(new File(""));
    }

    public static final String choixFichierImages(File repertoire) throws Exception {
        return Fichier.choixFichier(null, repertoire, 0, Fichier.getFiltreImages());
    }

    public static final String choixFichier(Component component, File repertoire, int mode, String description, String filtre) throws Exception {
        return Fichier.choixFichier(null, repertoire, 0, Fichier.getFiltre(description, filtre));
    }

    public static final String choixFichier(Component component, File repertoire, int mode, String filtre) throws Exception {
        return Fichier.choixFichier(null, repertoire, 0, Fichier.getFiltre(filtre));
    }

    public static final String choixFichier(Component component, File repertoire, int mode, FileNameExtensionFilter filtre) throws Exception {
        String nomFichier;
        JFileChooser fc = new JFileChooser();
        if (mode != 1 && filtre != null) {
            fc.setFileFilter(filtre);
        }
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(repertoire);
        fc.setFileSelectionMode(mode);
        int returnVal = fc.showOpenDialog(component);
        if (returnVal == 0 && (nomFichier = fc.getSelectedFile().getPath()) != null && !nomFichier.equals("")) {
            if (mode == 1) {
                return Fichier.completerChemin(nomFichier);
            }
            return nomFichier;
        }
        throw new Exception();
    }

    public static File[] getFichiers(String cheminDossier) throws Exception {
        File dossier = new File(cheminDossier);
        if (Fichier.existe(dossier)) {
            return dossier.listFiles();
        }
        throw new Exception("RECUPERATION DES FICHIER IMPOSSIBLE : LE DOSSIER N'EXISTE PAS");
    }

    public static List<File> getFichiersDatantDePlusDe(String cheminDossier, int dureeEnSeconde) {
        ArrayList<File> fichiersAnciens = new ArrayList<File>();
        try {
            File[] fileArray = Fichier.getFichiers(cheminDossier);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (Fichier.dateDePlusDe(f, dureeEnSeconde)) {
                    fichiersAnciens.add(f);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fichiersAnciens;
    }

    public static Vector<File> getFichiersFiltresRecursifs(String cheminFichier, String filtreNom, String filtreExtension) throws Exception {
        File fichier = new File(cheminFichier);
        if (Fichier.existe(fichier)) {
            return Fichier.getFichiersFiltresRecursifs(fichier, filtreNom, Fichier.getFiltre(filtreExtension));
        }
        throw new Exception("RECUPERATION DES FICHIER IMPOSSIBLE : LE DOSSIER N'EXISTE PAS # " + cheminFichier);
    }

    public static Vector<File> getFichiersFiltres(String cheminFichier, String filtreNom, String filtreExtension) throws Exception {
        File fichier = new File(cheminFichier);
        if (Fichier.existe(fichier)) {
            return Fichier.getFichiersFiltres(fichier, filtreNom, Fichier.getFiltre(filtreExtension));
        }
        throw new Exception("RECUPERATION DES FICHIER IMPOSSIBLE : LE DOSSIER N'EXISTE PAS # " + cheminFichier);
    }

    public static Vector<File> getFichiersFiltres(File fichier, String filtreNom, FileNameExtensionFilter filtreExtension) throws Exception {
        Vector<File> fichiers = new Vector<File>();
        if (Fichier.existe(fichier)) {
            if (fichier.isDirectory()) {
                File[] fileArray = fichier.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if ((filtreExtension == null || filtreExtension.accept(f)) && f.getName().startsWith(filtreNom)) {
                        fichiers.add(f);
                    }
                    ++n2;
                }
            } else if (filtreExtension.accept(fichier) && fichier.getName().startsWith(filtreNom)) {
                fichiers.add(fichier);
            }
            return fichiers;
        }
        throw new Exception("ERREUR LE DOSSIER N'EXISTE PAS");
    }

    public static Vector<File> getFichiersFiltresRecursifs(File fichier, String filtreNom, FileNameExtensionFilter filtreExtension) throws Exception {
        Vector<File> fichiers = new Vector<File>();
        if (Fichier.existe(fichier)) {
            if (fichier.isDirectory()) {
                File[] fileArray = fichier.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        fichiers.addAll(Fichier.getFichiersFiltresRecursifs(f, filtreNom, filtreExtension));
                    } else if (filtreExtension.accept(f) && f.getName().startsWith(filtreNom)) {
                        fichiers.add(f);
                    }
                    ++n2;
                }
            } else if (filtreExtension.accept(fichier) && fichier.getName().startsWith(filtreNom)) {
                fichiers.add(fichier);
            }
            return fichiers;
        }
        throw new Exception("ERREUR LE DOSSIER N'EXISTE PAS");
    }

    public static Vector<File> getFichiersRecursifs(String cheminFichier, FileNameExtensionFilter filtre) throws Exception {
        File fichier = new File(cheminFichier);
        if (Fichier.existe(fichier)) {
            return Fichier.getFichiersRecursifs(fichier, filtre);
        }
        throw new Exception("RECUPERATION DES FICHIER IMPOSSIBLE : LE DOSSIER N'EXISTE PAS # " + cheminFichier);
    }

    public static Vector<File> getFichiersRecursifs(File fichier, FileNameExtensionFilter filtre) throws Exception {
        Vector<File> fichiers = new Vector<File>();
        if (Fichier.existe(fichier)) {
            if (fichier.isDirectory()) {
                File[] fileArray = fichier.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        fichiers.addAll(Fichier.getFichiersRecursifs(f, filtre));
                    } else if (filtre.accept(f)) {
                        fichiers.add(f);
                    }
                    ++n2;
                }
            } else if (filtre.accept(fichier)) {
                fichiers.add(fichier);
            }
            return fichiers;
        }
        throw new Exception("ERREUR LE DOSSIER N'EXISTE PAS");
    }

    public static String[] getCheminsFichiers(String cheminDossier) throws Exception {
        File dossier = new File(cheminDossier);
        if (Fichier.existe(dossier)) {
            return dossier.list();
        }
        throw new Exception("RECUPERATION DES FICHIER IMPOSSIBLE : LE DOSSIER N'EXISTE PAS");
    }

    public static FileNameExtensionFilter getFiltreImages() {
        return new FileNameExtensionFilter("Fichiers Images", FICHIERS_JPG, FICHIERS_JPEG, FICHIERS_BMP, FICHIERS_GIF, FICHIERS_PNG);
    }

    public static FileNameExtensionFilter getFiltre() {
        return Fichier.getFiltre("Tous fichiers", TOUT_FICHIERS);
    }

    public static FileNameExtensionFilter getFiltre(String filtre) {
        return Fichier.getFiltre("Fichiers " + filtre, filtre);
    }

    public static FileNameExtensionFilter getFiltre(String description, String filtre) {
        if (filtre == null || filtre.equals("*")) {
            return null;
        }
        return new FileNameExtensionFilter(description, filtre);
    }

    public static FileNameExtensionFilter getFiltreXML() {
        return new FileNameExtensionFilter("Fichiers XML", FICHIERS_XML);
    }

    public static boolean estImage(File fichier) {
        if (fichier != null && fichier.exists()) {
            return Fichier.estImage(fichier.getName());
        }
        return false;
    }

    public static boolean estImage(String nomFichier) {
        if (nomFichier != null && !nomFichier.equals("")) {
            String[] stringArray = FICHIERS_IMAGES;
            int n = FICHIERS_IMAGES.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionImage = stringArray[n2];
                if (nomFichier.toLowerCase().endsWith(extensionImage.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String completerChemin(String chemin) {
        if (!(GLS.estVide(chemin) || chemin.substring(chemin.length() - 1).equals(SEPARATEUR_FICHIER) || chemin.substring(chemin.length() - 1).equals("/"))) {
            chemin = String.valueOf(chemin) + "/";
        }
        return chemin;
    }

    public static String completerCheminSystemSeparator(String chemin) {
        if (!(GLS.estVide(chemin) || chemin.substring(chemin.length() - 1).equals(SEPARATEUR_FICHIER) || chemin.substring(chemin.length() - 1).equals("/"))) {
            chemin = String.valueOf(chemin) + SEPARATEUR_FICHIER;
        }
        return chemin;
    }

    public static String getExtension(String fichier) {
        int indexExtension = fichier.lastIndexOf(".");
        if (indexExtension == -1) {
            return "";
        }
        return fichier.substring(indexExtension + 1);
    }

    public static String getNom(File fichier) {
        return Fichier.getNom(fichier.getPath());
    }

    public static String getNom(String fichier) {
        if (!GLS.estVide(fichier)) {
            File tmpFichier = new File(fichier);
            if (!tmpFichier.isDirectory()) {
                fichier = fichier.replace("\\", "/");
                int indexSlash = fichier.lastIndexOf("/");
                int indexAntiSlash = fichier.lastIndexOf("\\");
                int indexExtension = fichier.lastIndexOf(".");
                int index = Math.max(indexSlash, indexAntiSlash);
                if (indexExtension != -1) {
                    return fichier.substring(index + 1, indexExtension);
                }
                return "";
            }
            return tmpFichier.getName();
        }
        return "";
    }

    public static String changerExtension(String fichier, String extension) {
        return Fichier.getRepertoire(fichier).concat(Fichier.getNom(fichier)).concat(".").concat(extension);
    }

    public static String getRepertoire(String nomFichier) {
        String repertoireChoix = "";
        File fichier = new File(nomFichier);
        if (!GLS.estVide(nomFichier)) {
            if (!fichier.isDirectory()) {
                int indexSlash = nomFichier.lastIndexOf("/");
                int indexAntiSlash = nomFichier.lastIndexOf("\\");
                if (indexSlash != -1 && indexAntiSlash != -1) {
                    repertoireChoix = Fichier.completerChemin(nomFichier.substring(0, Math.max(indexSlash, indexAntiSlash)));
                }
            } else {
                repertoireChoix = Fichier.completerChemin(nomFichier);
            }
        }
        return repertoireChoix;
    }

    public static void effacerFichiers(String dossier) {
        if (!GLS.estVide(dossier)) {
            Fichier.effacerFichiers(new File(dossier));
        }
    }

    public static void effacerFichiers(File dossier) {
        if (dossier != null && dossier.exists()) {
            Fichier.effacerFichiers(dossier.listFiles());
        }
    }

    public static void effacerFichiers(File[] fichiers) {
        if (fichiers != null) {
            File[] fileArray = fichiers;
            int n = fichiers.length;
            int n2 = 0;
            while (n2 < n) {
                File fichier = fileArray[n2];
                Fichier.effacerFichier(fichier);
                ++n2;
            }
        }
    }

    public static void effacerFichiers(List<File> fichiers) {
        if (fichiers != null) {
            for (File fichier : fichiers) {
                Fichier.effacerFichier(fichier);
            }
        }
    }

    public static void effacerFichier(File fichier) {
        if (fichier != null && fichier.isFile()) {
            try {
                fichier.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void effacerFichier(String fichier) {
        if (!GLS.estVide(fichier)) {
            Fichier.effacerFichier(new File(fichier));
        }
    }

    public static void effacerDossiers(String dossier) {
        if (!GLS.estVide(dossier)) {
            Fichier.effacerDossiers(new File(dossier));
        }
    }

    public static void effacerDossiers(File dossier) {
        if (dossier != null && dossier.exists()) {
            Fichier.effacerDossiers(dossier.listFiles());
        }
    }

    public static void effacerDossiers(File[] fichiers) {
        if (fichiers != null) {
            File[] fileArray = fichiers;
            int n = fichiers.length;
            int n2 = 0;
            while (n2 < n) {
                File fichier = fileArray[n2];
                Fichier.effacerDossier(fichier);
                ++n2;
            }
        }
    }

    public static void effacerDossiers(List<File> fichiers) {
        if (fichiers != null) {
            for (File fichier : fichiers) {
                Fichier.effacerDossier(fichier);
            }
        }
    }

    public static boolean effacerDossier(File dossier) {
        if (dossier.isDirectory()) {
            String[] children = dossier.list();
            int i = 0;
            while (i < children.length) {
                boolean success = Fichier.effacerDossier(new File(dossier, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dossier.delete();
    }

    public static void effacerDossier(String fichier) {
        if (!GLS.estVide(fichier)) {
            Fichier.effacerDossier(new File(fichier));
        }
    }

    public static void effacer(File chemin) {
        if (chemin != null) {
            try {
                chemin.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean verifierDossier(String nomDossier) {
        return Fichier.verifierDossier(new File(Fichier.completerChemin(nomDossier)));
    }

    public static boolean existe(String fichier) {
        return Fichier.existe(new File(fichier));
    }

    public static boolean existe(File fichier) {
        return fichier != null && fichier.exists();
    }

    public static long getTaille(String fichier) {
        return Fichier.getTaille(new File(fichier));
    }

    public static long getTaille(File fichier) {
        if (fichier != null && fichier.exists()) {
            return fichier.length();
        }
        return -1L;
    }

    public static boolean dateDeMoinsDe(String nomFichier, int dureeEnSeconde) {
        return Fichier.dateDePlusDe(new File(nomFichier), dureeEnSeconde);
    }

    public static boolean dateDePlusDe(File fichier, int dureeEnSeconde) {
        return fichier.lastModified() + (long)(dureeEnSeconde * 1000) <= GregorianCalendar.getInstance().getTimeInMillis();
    }

    public static boolean verifierDossier(File dossier) {
        boolean verification;
        if (dossier != null) {
            if (!dossier.exists()) {
                try {
                    verification = dossier.mkdirs();
                }
                catch (Exception e) {
                    verification = false;
                }
            } else {
                verification = true;
            }
        } else {
            verification = false;
        }
        return verification;
    }

    public static boolean copier(String fichierSource, String fichierDestination) throws Exception {
        return Fichier.copier(fichierSource, fichierDestination, false);
    }

    public static boolean copier(String fichierSource, String fichierDestination, boolean copieTemporaire) throws Exception {
        boolean resultat = false;
        String extensionTmp = copieTemporaire ? ".tmp" : "";
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(fichierSource).getChannel();
            out = new FileOutputStream(String.valueOf(fichierDestination) + extensionTmp).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            resultat = true;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (resultat && copieTemporaire) {
            try {
                new File(String.valueOf(fichierDestination) + extensionTmp).renameTo(new File(fichierDestination));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultat;
    }

    public static boolean copier(File source, File destination) throws Exception {
        boolean resultat = false;
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        try {
            try {
                int nbLecture;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
                resultat = true;
            }
            catch (FileNotFoundException f) {
                JOptionPane.showMessageDialog(null, f.toString(), "Erreur", 0);
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Erreur", 0);
                try {
                    sourceFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception exception) {}
            try {
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return resultat;
    }

    public static void serialise(String fichier, Object objet) throws Exception {
        FileOutputStream sortie = null;
        try {
            sortie = new FileOutputStream(fichier);
        }
        catch (IOException e) {
            new File(fichier);
            sortie = new FileOutputStream(fichier);
        }
        ObjectOutputStream oos = new ObjectOutputStream(sortie);
        oos.writeObject(objet);
        oos.flush();
        oos.close();
        sortie.close();
    }

    public static Object deserialise(String fichier) throws Exception {
        FileInputStream entree = new FileInputStream(fichier);
        ObjectInputStream ois = new ObjectInputStream(entree);
        Object objet = ois.readObject();
        ois.close();
        entree.close();
        return objet;
    }

    public static <T> T deserialise(String fichier, Class<T> clazz) throws Exception {
        return Fichier.deserialise(fichier, clazz, null);
    }

    public static <T> T deserialise(String fichier, Class<T> clazz, T defaut) {
        try {
            FileInputStream entree = new FileInputStream(fichier);
            ObjectInputStream ois = new ObjectInputStream(entree);
            Object objet = ois.readObject();
            ois.close();
            entree.close();
            return (T)objet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void comparerFichierProperties() {
        String fichier2;
        String fichier1;
        try {
            fichier1 = Fichier.choixFichier();
            fichier2 = Fichier.choixFichier();
        }
        catch (Exception e) {
            return;
        }
        Fichier.comparerFichierProperties(fichier1, fichier2);
    }

    public static void comparerFichierProperties(String fichier1, String fichier2) {
        FichierCONFIG f1 = new FichierCONFIG(fichier1);
        FichierCONFIG f2 = new FichierCONFIG(fichier2);
        ArrayList<String> pasDansF2 = new ArrayList<String>();
        ArrayList<String> pasDansF1 = new ArrayList<String>();
        for (Object e : f1.getChamps()) {
            if (GLS.estDansLaListe(f2.getChamps(), e)) continue;
            pasDansF2.add(GLS.getString(e));
        }
        for (Object e : f2.getChamps()) {
            if (GLS.estDansLaListe(f1.getChamps(), e)) continue;
            pasDansF1.add(GLS.getString(e));
        }
        System.out.println("-+----");
        System.out.println("champs pas dans fichier 1 " + fichier1);
        for (String string : pasDansF1) {
            System.out.println(String.valueOf(string) + "=" + f2.getString(string));
        }
        System.out.println("-+----");
        System.out.println("champs pas dans fichier 2 " + fichier2);
        for (String string : pasDansF2) {
            System.out.println(String.valueOf(string) + "=" + f1.getString(string));
        }
    }

    public static void main(String ... strings) {
        try {
            Fichier.comparerFichierProperties("D:/projets/commercial/prismcentral.properties", "D:/projets/commercial/prismcentral-.properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

