/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.evenement;

import cartoj.CartesG2;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.OutilsCartoJ;
import gls.outils.evenement.ConfigSynchro;
import gls.outils.evenement.ConstantesSynchroNatures;
import gls.outils.fichier.Fichier;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GestionEvenementsDifferentiels
implements ConstantesSynchroNatures {
    private static final Logger log = Logger.getLogger(GestionEvenementsDifferentiels.class);
    private boolean chargementDifferentiel;
    private String dateAvantAuthentification;
    private ConfigSynchro configSynchro;
    private Vector<String> listeNatures;
    private String cheminCartoEvenement;
    private String cheminConfigSynchro;
    private String urlServeur;
    private String restriction;

    public GestionEvenementsDifferentiels(Vector<String> listeNatures, String urlServeur) {
        this(listeNatures, urlServeur, "$ND$");
    }

    public GestionEvenementsDifferentiels(Vector<String> listeNatures, String urlServeur, String restriction) {
        this(listeNatures, CHEMIN_CARTO_EVENEMENT_DEFAUT, "donneesMetiers/".concat("config_synchro_evenement").concat(".").concat("ser"), urlServeur, restriction);
    }

    public GestionEvenementsDifferentiels(Vector<String> listeNatures, String cheminCartoEvenement, String cheminConfigSynchro, String urlServeur, String restriction) {
        this.listeNatures = listeNatures;
        this.cheminCartoEvenement = cheminCartoEvenement;
        this.cheminConfigSynchro = cheminConfigSynchro;
        this.urlServeur = urlServeur;
        this.restriction = restriction;
        this.initialisation();
    }

    public String getCheminCartoEvenement() {
        return this.cheminCartoEvenement;
    }

    private boolean estConfigOk() {
        return this.configSynchro != null && GLS.egal(this.configSynchro.getServeur(), this.urlServeur) && (GLS.egal("$ND$", this.restriction) || GLS.egal(this.configSynchro.getRestriction(), this.restriction)) && !GLS.estVide(this.configSynchro.getDate());
    }

    private void initialiserConfig() {
        this.configSynchro = new ConfigSynchro();
        this.configSynchro.setServeur(this.urlServeur);
        this.configSynchro.setRestriction(this.restriction);
        this.configSynchro.setDate("");
    }

    private void initialisation() {
        this.chargementDifferentiel = true;
        Fichier.verifierDossier(this.cheminCartoEvenement);
        this.configSynchro = null;
        try {
            this.configSynchro = this.deserialiserConfig();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR RECUP SYNCHRO SYNCHRO EVENEMENT", (Throwable)e);
            this.chargementDifferentiel = false;
        }
        if (!this.estConfigOk()) {
            this.chargementDifferentiel = false;
        } else {
            this.restriction = this.configSynchro.getRestriction();
        }
        if (this.chargementDifferentiel) {
            this.chargementDifferentiel = !GLS.estVide(this.listeNatures) ? OutilsCartoJ.verificationExistanceCouches(this.cheminCartoEvenement, this.listeNatures) : false;
        }
        if (!this.chargementDifferentiel) {
            this.initialiserConfig();
            GLS.getFichier();
            Fichier.effacerFichiers(this.cheminCartoEvenement);
        }
    }

    public void actionApresSynchro() {
        this.configSynchro.setDate(this.getDateCourante());
        try {
            this.serialiserConfig();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR SERIALIZATION CONFIG SYNCHRO EVENEMENT");
        }
    }

    private String getDateCourante() {
        GLS.getDate();
        return GLSDate.toDateDatexComplete();
    }

    public void actionApresAuthentification() {
        this.configSynchro.setDate(this.dateAvantAuthentification);
    }

    public void actionAvantAuthentification() {
        this.dateAvantAuthentification = this.getDateCourante();
    }

    public String getDatePourAuthentification() {
        return this.configSynchro.getDate();
    }

    public void actionApresFinService(CartesG2 cartes) {
        this.actionApresFinService(cartes, this.listeNatures);
    }

    public void actionApresFinService(CartesG2 cartes, Vector<String> listeNatures) {
        try {
            this.serialiserConfig();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR SERIALIZATION CONFIG SYNCHRO EVENEMENT");
        }
        OutilsCartoJ.sauvegardeCouche(cartes, this.cheminCartoEvenement, listeNatures);
    }

    private void serialiserConfig() throws Exception {
        Fichier.effacerFichier(this.cheminConfigSynchro);
        log.debug((Object)("S\u00e9rialization du fichier " + this.cheminConfigSynchro));
        Fichier.serialise(this.cheminConfigSynchro, this.configSynchro);
    }

    private ConfigSynchro deserialiserConfig() throws Exception {
        String cheminFichier = this.cheminConfigSynchro;
        if (Fichier.existe(cheminFichier)) {
            log.debug((Object)("des\u00e9rialization du fichier " + cheminFichier));
            return (ConfigSynchro)Fichier.deserialise(cheminFichier);
        }
        throw new Exception("ERREUR DESERIALIZATION FICHIER " + cheminFichier + " N'EXISTE PAS");
    }

    public Vector<String> getListeNatures() {
        return this.listeNatures;
    }

    public void setListeNatures(Vector<String> listeNatures) {
        this.listeNatures = listeNatures;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public void miseAJourRestrictionApresAuthentification(String restriction) {
        if (!GLS.egal(this.restriction, restriction)) {
            this.chargementDifferentiel = false;
        }
        this.restriction = restriction;
        this.configSynchro.setRestriction(restriction);
        try {
            this.serialiserConfig();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public boolean estChargementDifferentiel() {
        return this.chargementDifferentiel;
    }
}

