/*
 * Decompiled with CFR 0.152.
 */
package gls.outils.classe;

import gls.outils.GLS;
import gls.outils.classe.ConstantesMethode;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtils
implements ConstantesMethode {
    public static Class getClasse(String nomClasse) throws Exception {
        return Class.forName(nomClasse);
    }

    public static Class getClasse(String monPackage, String nomClasse) throws Exception {
        if (monPackage != null && !GLS.estVide(nomClasse)) {
            return Class.forName(monPackage.concat(".").concat(nomClasse));
        }
        throw new Exception("ERREUR LE PACKAGE EST NULL OU LA CLASSE EST VIDE # P=" + monPackage + " # C=" + nomClasse);
    }

    public static Object getObject(String nomClasse) throws Exception {
        Class classe = ClassUtils.getClasse(nomClasse);
        return ClassUtils.getObject(classe);
    }

    public static Object getObject(String monPackage, String nomClasse) throws Exception {
        return ClassUtils.getObject(monPackage, nomClasse, null);
    }

    public static Object getObject(String monPackage, String nomClasse, Object[] parametres) throws Exception {
        return ClassUtils.getObject(ClassUtils.getClasse(monPackage, nomClasse), parametres);
    }

    public static Object getObject(Class classe) throws Exception {
        return ClassUtils.getObject(classe, null);
    }

    public static Object getObject(Class classe, Object[] parametres, Class[] typesParametres) throws Exception {
        return ClassUtils.getObject(classe.getConstructor(typesParametres), parametres);
    }

    public static Object getObject(Class classe, Object[] parametres) throws Exception {
        return ClassUtils.getObject(classe, parametres, ClassUtils.getTypesParametres(parametres));
    }

    public static Object getObject(Constructor constructor, Object[] parametres) throws Exception {
        return constructor.newInstance(parametres);
    }

    public static <T> T[] getArray(Class<T> type, int lenght) {
        return (Object[])Array.newInstance(type, lenght);
    }

    public static <T> T[] getArray(Class<T> type, Object objet) throws Exception {
        return ClassUtils.getArray(type, new Object[]{objet});
    }

    public static <T> T[] getArray(Class<T> type, Object[] objets) throws Exception {
        Object[] array = (Object[])Array.newInstance(type, objets.length);
        int i = 0;
        while (i < objets.length) {
            array[i] = objets[i];
            ++i;
        }
        return array;
    }

    public static String getGetter(String champ) throws Exception {
        if (!GLS.estVide(champ)) {
            return "get".concat(GLS.getPremiereLettreMajuscule(champ));
        }
        throw new Exception("IMPOSSIBLE D'OBTENIR LE GETTER : LE CHAMP EST VIDE");
    }

    public static String getSetter(String champ) throws Exception {
        if (!GLS.estVide(champ)) {
            return "set".concat(GLS.getPremiereLettreMajuscule(champ));
        }
        throw new Exception("IMPOSSIBLE D'OBTENIR LE SETTER : LE CHAMP EST VIDE");
    }

    public static Object lancerMethode(Object objet, Object arg, String nomMethode) throws Exception {
        return ClassUtils.lancerMethode(objet, new Object[]{arg}, nomMethode);
    }

    public static Object lancerMethodeGetter(Object objet, String champ) throws Exception {
        return ClassUtils.lancerMethodeGetter(objet, null, champ);
    }

    public static Object lancerMethodeGetter(Object objet, Object[] args, String champ) throws Exception {
        return ClassUtils.lancerMethode(objet, args, ClassUtils.getGetter(champ));
    }

    public static Object lancerMethodeGetter(Object objet, Object arg, String champ) throws Exception {
        return ClassUtils.lancerMethodeGetter(objet, new Object[]{arg}, champ);
    }

    public static Object lancerMethodeSetter(Object objet, Object[] args, String champ) throws Exception {
        return ClassUtils.lancerMethode(objet, args, ClassUtils.getSetter(champ));
    }

    public static Object lancerMethodeSetter(Object objet, Object arg, String champ) throws Exception {
        return ClassUtils.lancerMethodeSetter(objet, new Object[]{arg}, champ);
    }

    public static Class[] getTypesParametres(Object[] param) {
        Class[] paramTypes = null;
        if (param != null) {
            paramTypes = new Class[param.length];
            int i = 0;
            while (i < param.length) {
                paramTypes[i] = ClassUtils.getClasseObjet(param[i]);
                ++i;
            }
        }
        return paramTypes;
    }

    public static Vector<Class> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        Vector<Class> classes = new Vector<Class>();
        ArrayList<File> directories = new ArrayList<File>();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                if (res.getProtocol().equalsIgnoreCase("jar")) {
                    JarURLConnection conn = (JarURLConnection)res.openConnection();
                    JarFile jar = conn.getJarFile();
                    for (JarEntry e : Collections.list(jar.entries())) {
                        if (!e.getName().startsWith(pckgname.replace('.', '/')) || !e.getName().endsWith(".class") || e.getName().contains("$")) continue;
                        String className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                        classes.add(Class.forName(className));
                    }
                    continue;
                }
                directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be " + "a valid package (Null pointer exception)");
        }
        catch (UnsupportedEncodingException encex) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be " + "a valid package (Unsupported encoding)");
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname);
        }
        for (File directory : directories) {
            if (directory.exists()) {
                String[] files = directory.list();
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = stringArray[n2];
                    if (((String)file).endsWith(".class")) {
                        classes.add(Class.forName(String.valueOf(pckgname) + '.' + ((String)file).substring(0, ((String)file).length() - 6)));
                    }
                    ++n2;
                }
                continue;
            }
            throw new ClassNotFoundException(String.valueOf(pckgname) + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    public static boolean isInstanceOf(Class classe, Class superClasse) {
        boolean trouve = false;
        boolean fin = false;
        if (classe != null) {
            Class tmpClasse = classe.getSuperclass();
            fin = tmpClasse == null;
            trouve = !fin && classe.equals(superClasse);
            while (!trouve && !fin) {
                if ((tmpClasse = tmpClasse.getSuperclass()) == null) {
                    fin = true;
                    continue;
                }
                if (!tmpClasse.equals(superClasse)) continue;
                trouve = true;
            }
        }
        return trouve;
    }

    public static Vector<Class> getClassesOfInterface(String thePackage, Class theInterface) {
        Vector<Class> classList = new Vector<Class>();
        try {
            for (Class discovered : ClassUtils.getClassesForPackage(thePackage)) {
                if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
                classList.add(discovered);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classList;
    }

    public static Class getClasseObjet(Object objet) {
        return objet.getClass();
    }

    public static Vector<String> getNomChamps(Class classe) throws Exception {
        Vector<String> nomChamps = new Vector<String>();
        Field[] fieldArray = classe.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            nomChamps.add(f.getName());
            ++n2;
        }
        return nomChamps;
    }

    public static Vector<String> getNomChamps(Class classe, Class typeChamps) throws Exception {
        Field[] champs;
        Vector<String> nomsChamps = new Vector<String>();
        Field[] fieldArray = champs = classe.getDeclaredFields();
        int n = champs.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getType().equals(typeChamps)) {
                nomsChamps.add(f.getName());
            }
            ++n2;
        }
        return nomsChamps;
    }

    public static Field[] getChamps(Class classe) throws Exception {
        return classe.getDeclaredFields();
    }

    public static Vector<Method> getMethodesParNom(Class classe, String nomMethode) throws Exception {
        return ClassUtils.getMethodesParNom(classe, nomMethode, -1);
    }

    public static Vector<Method> getMethodesParNom(Class classe, String nomMethode, int nbParametres) throws Exception {
        Vector<Method> methodes = new Vector<Method>();
        Method[] methodArray = classe.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method methode = methodArray[n2];
            if (methode.getName().equals(nomMethode) && (nbParametres < 0 || nbParametres == GLS.getTaille(methode.getParameterTypes()))) {
                methodes.add(methode);
            }
            ++n2;
        }
        if (!GLS.estVide(methodes)) {
            return methodes;
        }
        methodes = null;
        throw new Exception("AUCUNE METHODE " + nomMethode + " N'EXISTE");
    }

    public static Method getMethode(Class classe, Vector<Method> methodes, String nomMethode, Class[] typesParametres) throws Exception {
        try {
            if (GLS.estVide(methodes) || methodes.size() > 1) {
                return classe.getMethod(nomMethode, typesParametres);
            }
            return methodes.get(0);
        }
        catch (Exception e) {
            throw new Exception("LA METHODE " + nomMethode + " DE LA CLASSE " + classe.getSimpleName() + " AVEC LES PARAMETRES [" + GLS.getString(typesParametres) + "] N'EXISTE PAS");
        }
    }

    public static Method getMethode(Class classe, String nomMethode, Class[] typesParametres) throws Exception {
        return ClassUtils.getMethode(classe, ClassUtils.getMethodesParNom(classe, nomMethode, GLS.getTaille(typesParametres)), nomMethode, typesParametres);
    }

    public static Object lancerMethode(Object objet, Object[] args, String nomMethode) throws Exception {
        return ClassUtils.lancerMethode(objet, objet.getClass(), args, nomMethode);
    }

    public static Object lancerMethode(Object objet, Class classe, Object[] args, String nomMethode) throws Exception {
        return ClassUtils.lancerMethode(objet, args, ClassUtils.getMethode(classe, nomMethode, ClassUtils.getTypesParametres(args)));
    }

    public static Object lancerMethode(Object objet, Object[] args, Method m) throws Exception {
        if (m != null) {
            try {
                return m.invoke(objet, args);
            }
            catch (Exception e) {
                throw new Exception("LA METHODE " + m.getName() + " DE LA CLASSE " + m.getDeclaringClass().getSimpleName() + " AVEC LES PARAMETRES [" + GLS.getString(m.getParameterTypes()) + "] N'EXISTE PAS");
            }
        }
        throw new Exception("LA METHODE APPELLEE EST NULLE");
    }
}

