/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.StringTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final String[] MAJORNAMES = new String[]{"", " mille", " million", " milliard", " trillion", " quadrillion", " quintillion"};
    private static final String[] TENSNAMES = new String[]{"", " dix", " vingt", " trente", " quarante", " cinquante", " soixante", " soixante-dix", " quatre-vingt", " quatre-vingt-dix"};
    private static final String[] NUMNAMES = new String[]{"", " un", " deux", " trois", " quatre", " cinq", " six", " sept", " huit", " neuf", " dix", " onze", " douze", " treize", " quatorze", " quinze", " seize", " dix-sept", " dix-huit", " dix-neuf"};

    public static synchronized boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static synchronized boolean isNumber(String s) {
        try {
            Long.parseLong(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static synchronized boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static synchronized boolean isNumber(char c) {
        String s = new String("");
        s = String.valueOf(s) + c;
        try {
            Integer.parseInt(s);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static synchronized boolean isPositiveNumber(String s) {
        boolean ret = true;
        try {
            int p = Integer.parseInt(s);
            if (p < 0) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static synchronized boolean isPositiveLong(String s) {
        boolean ret = true;
        try {
            long p = Long.parseLong(s);
            if (p < 0L) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static synchronized boolean isNumberBetween(String s, int min, int max) {
        boolean ret = true;
        try {
            int p = Integer.parseInt(s);
            if (p < min || p > max) {
                ret = false;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static synchronized boolean isFloat(String s) {
        try {
            Float.parseFloat(s.replace(',', '.'));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static synchronized boolean isCorrectHeure(String s, String format) {
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat(format);
            formatDate.setLenient(false);
            Date dateTest = formatDate.parse(s);
            String verif = formatDate.format(dateTest);
            return verif.equals(s);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static synchronized boolean isCorrectDate(String s, String format) {
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat(format);
            formatDate.setLenient(false);
            Date dateTest = formatDate.parse(s);
            String verif = formatDate.format(dateTest);
            return verif.equals(s);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static synchronized String[] decoupeListe(String liste, String separateur, int NbElement) {
        String[] tableauRetour = new String[NbElement];
        StringTokenizer token = new StringTokenizer(liste, separateur);
        int i = 0;
        while (i < NbElement && token.hasMoreTokens()) {
            tableauRetour[i] = token.nextToken();
            ++i;
        }
        return tableauRetour;
    }

    public static String[] decoupeListe(String liste, String separateur) {
        ArrayList<String> ar = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(liste, separateur);
        int i = 0;
        while (token.hasMoreTokens()) {
            ar.add(token.nextToken());
            ++i;
        }
        String[] tableauRetour = new String[ar.size()];
        int i2 = 0;
        while (i2 < ar.size()) {
            tableauRetour[i2] = (String)ar.get(i2);
            ++i2;
        }
        return tableauRetour;
    }

    public static synchronized boolean isCorrectFloat(String s, int avant, int apres, String separator) {
        boolean ret = false;
        if (s != null && !s.equals("")) {
            try {
                String number_avt = s;
                String number_ap = "";
                int indice = s.indexOf(separator);
                if (indice != -1) {
                    number_avt = s.substring(0, indice);
                    number_ap = s.substring(indice + 1);
                }
                if (!number_avt.equals("")) {
                    Integer.parseInt(number_avt);
                }
                if (!number_ap.equals("")) {
                    Integer.parseInt(number_ap);
                }
                if (number_avt.length() <= avant && number_ap.length() <= apres) {
                    ret = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public static synchronized float convertToFloat(String s, String separator) {
        float ret = 0.0f;
        if (s != null && !s.equals("")) {
            try {
                String number_avt = s;
                String number_ap = "";
                int indice = s.indexOf(separator);
                if (indice != -1) {
                    number_avt = s.substring(0, indice);
                    number_ap = s.substring(indice + 1);
                }
                if (!number_avt.equals("")) {
                    Integer.parseInt(number_avt);
                }
                if (!number_ap.equals("")) {
                    Integer.parseInt(number_ap);
                }
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                String newNumber = String.valueOf(number_avt) + dfs.getDecimalSeparator() + number_ap;
                Number n = DecimalFormat.getInstance().parse(newNumber);
                ret = Float.parseFloat("" + n);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public String convertionChiffreLettre(int number) {
        if (number == 0) {
            return "zero";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "moins";
        }
        String soFar = "";
        int place = 0;
        boolean pluralPossible = true;
        boolean pluralForm = false;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.trim().equals("un") && place == 1) {
                    soFar = String.valueOf(MAJORNAMES[place]) + soFar;
                } else {
                    if (place == 0) {
                        if (s.trim().endsWith("cent") && !s.trim().startsWith("cent")) {
                            pluralForm = true;
                        } else {
                            pluralPossible = false;
                        }
                    }
                    if (place > 0 && pluralPossible) {
                        if (!s.trim().startsWith("un")) {
                            pluralForm = true;
                        } else {
                            pluralPossible = false;
                        }
                    }
                    soFar = String.valueOf(s) + MAJORNAMES[place] + soFar;
                }
            }
            ++place;
        } while ((number /= 1000) > 0);
        String result = (String.valueOf(prefix) + soFar).trim();
        return pluralForm ? String.valueOf(result) + "s" : result;
    }

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = NUMNAMES[number % 100];
            number /= 100;
        } else {
            soFar = NUMNAMES[number % 10];
            soFar = String.valueOf(TENSNAMES[(number /= 10) % 10]) + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        if (number == 1) {
            return " cent" + soFar;
        }
        return String.valueOf(NUMNAMES[number]) + " cent" + soFar;
    }

    public static String[] parseArray(String b, char separateur) {
        int ind;
        if (b == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        String fin = b;
        while (fin.length() > 0) {
            ind = fin.indexOf(separateur);
            if (ind == -1) {
                v.addElement(fin);
                fin = "";
                continue;
            }
            v.addElement(fin.substring(0, ind));
            fin = fin.substring(ind + 1);
        }
        String[] res = new String[v.size()];
        ind = 0;
        while (ind < v.size()) {
            res[ind] = (String)v.elementAt(ind);
            ++ind;
        }
        return res;
    }

    public static char parseChar(String d) {
        if (d == null) {
            return '\u0000';
        }
        if (d.length() == 0) {
            return '\u0000';
        }
        return d.charAt(0);
    }

    public static int parseInt(String d) {
        try {
            return Integer.parseInt(d);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static long parseLong(String d) {
        try {
            Long i = new Long(d);
            return i;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static double parseDouble(String d) {
        try {
            Double i = new Double(d.replace(',', '.'));
            return i;
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public static float parseFloat(String d) {
        try {
            Float i = new Float(d.replace(',', '.'));
            return i.floatValue();
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    public static boolean parseBool(int i) throws Exception {
        if (i == 0) {
            return false;
        }
        if (i == 1) {
            return true;
        }
        throw new Exception("bad boolean format !");
    }

    public static boolean parseBool(String b, char vrai, char Faux) {
        if (b == null) {
            return false;
        }
        if (b.equals("")) {
            return false;
        }
        return b.charAt(0) == vrai;
    }

    public static boolean parseBool(String b) {
        return Util.parseBool(b, 'O', 'N');
    }

    public static String[] parseArray(String b) {
        return Util.parseArray(b, ';');
    }

    public static String formatArray(String[] res, char separateur) {
        if (res == null) {
            return new String("");
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < res.length) {
            sb.append(res[i]);
            sb.append(separateur);
            ++i;
        }
        return sb.length() > 0 ? sb.toString().substring(0, sb.length() - 1) : "";
    }

    public static String addDateToCheminFic(String s, String formatDate) {
        String result = s;
        char[] c = s.toCharArray();
        int i = c.length - 1;
        while (i > 0) {
            if (c[i] == '/') {
                result = String.valueOf(s.substring(0, i)) + "/" + new SimpleDateFormat(formatDate).format(new Date()) + s.substring(i + 1, s.length());
                break;
            }
            --i;
        }
        return result;
    }

    public static String completeString(String s, char c, int longueurChaine) {
        while (s.length() < longueurChaine) {
            s = String.valueOf(c) + s;
        }
        return s;
    }

    public static String traiterGuillemets(String value) {
        if (value == null) {
            return value;
        }
        value = Util.replaceAll(value, "'", "&#180;");
        return Util.replaceAll(value, "\"", "&#34;");
    }

    public static String replaceAll(String chaine, String valeurARemplacer, String valeurAMettre) {
        if (chaine == null || valeurARemplacer == null) {
            return chaine;
        }
        if (valeurAMettre == null) {
            valeurAMettre = "";
        }
        int i = chaine.indexOf(valeurARemplacer);
        String chaineATraiter = new String(chaine);
        StringBuffer retour = new StringBuffer();
        while (i != -1) {
            String avant = chaineATraiter.substring(0, i);
            chaineATraiter = chaineATraiter.substring(i + valeurARemplacer.length());
            retour.append(avant);
            retour.append(valeurAMettre);
            i = chaineATraiter.indexOf(valeurARemplacer);
        }
        retour.append(chaineATraiter);
        return retour.toString();
    }

    public static String suppressionZeroEspace(String chaine) {
        String chaineATraiter = chaine.trim();
        String retour = null;
        boolean caracTrouve = false;
        while (chaineATraiter.length() > 0 && !caracTrouve) {
            String carac = chaineATraiter.substring(0, 1);
            if (!carac.equals("0")) {
                caracTrouve = true;
                retour = chaineATraiter;
                chaineATraiter = "";
                continue;
            }
            if (chaineATraiter.length() == 1) {
                retour = chaineATraiter;
                chaineATraiter = "";
                continue;
            }
            chaineATraiter = chaineATraiter.substring(1, chaineATraiter.length());
        }
        return retour;
    }

    public static String[] split(String chaine, String separator) {
        if (chaine == null) {
            return null;
        }
        if (separator == null || separator.equals("")) {
            String[] retourT = new String[]{chaine};
            return retourT;
        }
        int i = chaine.indexOf(separator);
        String chaineATraiter = new String(chaine);
        ArrayList<String> retour = new ArrayList<String>();
        while (i != -1) {
            String avant = chaineATraiter.substring(0, i);
            chaineATraiter = chaineATraiter.substring(i + separator.length());
            retour.add(avant);
            i = chaineATraiter.indexOf(separator);
        }
        retour.add(chaineATraiter);
        String[] retourT = new String[retour.size()];
        i = 0;
        while (i < retour.size()) {
            retourT[i] = (String)retour.get(i);
            ++i;
        }
        return retourT;
    }

    public static double arrondiFlottant(double d, int nbDecimales) {
        String pattern = "########.";
        if (nbDecimales > 0) {
            int i = 0;
            while (i < nbDecimales) {
                pattern = String.valueOf(pattern) + "0";
                ++i;
            }
        }
        DecimalFormat nf = new DecimalFormat(pattern);
        double dArrondi = 0.0;
        try {
            dArrondi = Double.parseDouble("" + nf.parse(nf.format(d)));
        }
        catch (Exception ex) {
            dArrondi = 0.0;
        }
        return dArrondi;
    }

    public static String convertMAJ(String t) {
        if (t == null || t.trim().equals("")) {
            return "";
        }
        String r = Util.replaceAll(t, "[\u00e0\u00e2\u00e4\u00c0\u00c2\u00c4]", "a");
        r = Util.replaceAll(t, "[\u00e9\u00e8\u00ea\u00eb\u00c8\u00ca\u00cb]", "e");
        r = Util.replaceAll(t, "[\u00ec\u00ee\u00ef\u00cc\u00ce\u00cf]", "i");
        r = Util.replaceAll(t, "[\u00f2\u00f4\u00f6\u00d2\u00d4\u00d6]", "o");
        r = Util.replaceAll(t, "[\u00f9\u00fb\u00fc\u00d9\u00db\u00dc]", "u");
        return r.toUpperCase();
    }

    public static String cadrageChaine(String chaine, int taille) {
        if (chaine == null) {
            chaine = "";
        }
        if (chaine.length() > taille) {
            return chaine.substring(0, taille);
        }
        StringBuffer chaineSB = new StringBuffer(chaine);
        int i = chaine.length();
        while (i < taille) {
            chaineSB.append(" ");
            ++i;
        }
        return chaineSB.toString();
    }

    public static String cadrageNumerique(String chaine, int taille) {
        if (chaine == null) {
            chaine = "";
        }
        if (chaine.length() > taille) {
            return chaine.substring(0, taille);
        }
        StringBuffer chaineSB = new StringBuffer();
        int i = chaine.length();
        while (i < taille) {
            chaineSB.append("0");
            ++i;
        }
        chaineSB.append(chaine);
        return chaineSB.toString();
    }

    public static String limiterTaille(String chaine, int tailleMax) {
        int taille = tailleMax;
        if (chaine == null) {
            return null;
        }
        if (chaine.length() < taille) {
            taille = chaine.length();
        }
        return chaine.substring(0, taille);
    }

    public static boolean isComplexPassword(String password) throws ExceptionNbCaracteres, ExceptionReglesMotDePasse {
        String regle1 = "[A-Z]";
        String regle2 = "[a-z]";
        String regle3 = "[0-9]";
        String regle4 = "[^A-Za-z0-9]";
        int regle5 = 8;
        boolean regle6 = true;
        boolean rempliRegle1 = false;
        boolean rempliRegle2 = false;
        boolean rempliRegle3 = false;
        boolean rempliRegle4 = false;
        int minConditions = 3;
        boolean rempliRegle5 = true;
        boolean rempliRegle6 = true;
        char[] morceaux = password.toCharArray();
        if (password.length() < regle5) {
            throw new Util().new ExceptionNbCaracteres();
        }
        char[] cArray = morceaux;
        int n = morceaux.length;
        int n2 = 0;
        while (n2 < n) {
            char x = cArray[n2];
            if (Pattern.matches(regle1, String.valueOf(x))) {
                rempliRegle1 = true;
            }
            if (Pattern.matches(regle2, String.valueOf(x))) {
                rempliRegle2 = true;
            }
            if (Pattern.matches(regle3, String.valueOf(x))) {
                rempliRegle3 = true;
            }
            if (Pattern.matches(regle4, String.valueOf(x))) {
                rempliRegle4 = true;
            }
            ++n2;
        }
        int nbConditions = 0;
        if (rempliRegle1) {
            ++nbConditions;
        }
        if (rempliRegle2) {
            ++nbConditions;
        }
        if (rempliRegle3) {
            ++nbConditions;
        }
        if (rempliRegle4) {
            ++nbConditions;
        }
        if (nbConditions >= minConditions) {
            return true;
        }
        throw new Util().new ExceptionReglesMotDePasse();
    }

    public static boolean isStringWithSpecialCharacter(String s) {
        if (s == null || s.trim().isEmpty()) {
            return false;
        }
        Pattern p = Pattern.compile("[^A-Za-z0-9]");
        Matcher m = p.matcher(s);
        return m.find();
    }

    public static String getFilePattern(String pattern, String mse, String vnm, String snm, int evtCpt) {
        Date date = new Date();
        return Util.getFilePattern(date, pattern, mse, vnm, snm, evtCpt);
    }

    public static String getFilePattern(Date date, String pattern, String mse, String vnm, String snm, int evtCpt) {
        String retour = pattern;
        retour = retour.replaceAll("\\[AA\\]", new SimpleDateFormat("yy").format(date));
        retour = retour.replaceAll("\\[AAAA\\]", new SimpleDateFormat("yyyy").format(date));
        retour = retour.replaceAll("\\[MM\\]", new SimpleDateFormat("MM").format(date));
        retour = retour.replaceAll("\\[JJ\\]", new SimpleDateFormat("dd").format(date));
        retour = retour.replaceAll("\\[HH\\]", new SimpleDateFormat("HH").format(date));
        retour = retour.replaceAll("\\[mm\\]", new SimpleDateFormat("mm").format(date));
        retour = retour.replaceAll("\\[ss\\]", new SimpleDateFormat("ss").format(date));
        retour = retour.replaceAll("\\[SSS\\]", new SimpleDateFormat("SSS").format(date));
        retour = retour.replaceAll("\\[MSE\\]", mse);
        retour = retour.replaceAll("\\[VNM\\]", vnm);
        retour = retour.replaceAll("\\[SNM\\]", snm);
        retour = retour.replaceAll("\\[X\\]", String.valueOf(evtCpt));
        return retour;
    }

    public class ExceptionNbCaracteres
    extends Exception {
        private static final long serialVersionUID = 3799625093195961221L;
    }

    public class ExceptionReglesMotDePasse
    extends Exception {
        private static final long serialVersionUID = 6084687787426658911L;
    }
}

