/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

public class StringTokenizer {
    private String data;
    private int dataLength;
    private String delimiters;
    private int position = 0;

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f");
    }

    public StringTokenizer(String str, String delim) {
        this.data = str;
        this.delimiters = delim;
        this.dataLength = this.data.length();
    }

    public boolean hasMoreTokens() {
        return this.position <= this.dataLength;
    }

    public String nextToken() {
        int delPos = this.position;
        while (delPos < this.dataLength) {
            char c = this.data.charAt(delPos);
            if (this.delimiters.indexOf(c) != -1) break;
            ++delPos;
        }
        String ret = this.data.substring(this.position, delPos);
        this.position = delPos + 1;
        return ret;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int savedPosition = this.position;
        int count = 0;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++count;
        }
        this.position = savedPosition;
        return count;
    }
}

