/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import cartoj.Cartes;
import cartoj.CartesG2;
import cartoj.CoucheUUniverselle;
import cartoj.Enregistrement;
import cartoj.FichierContFichierString;
import cartoj.FichierContMemoire;
import cartoj.FichierDonFichierString;
import cartoj.FichierDonMemoire;
import cartoj.FichierProjet;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import cartoj.LiensCD;
import gls.outils.ConstantesOutilsCartoJ;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OutilsCartoJ
implements ConstantesOutilsCartoJ {
    private static final Logger log = Logger.getLogger(OutilsCartoJ.class);
    private Cartes carte;
    private static OutilsCartoJ instance;

    private OutilsCartoJ() {
    }

    public static OutilsCartoJ instanceOf() {
        if (instance == null) {
            instance = new OutilsCartoJ();
        }
        return instance;
    }

    public static void ajoutObjetCouche(ICouche couche, String[] valeurs, float[][] points) throws Exception {
        int taille = couche.getCont().getNbent() + 1;
        couche.ajouteEntite(taille, valeurs, String.valueOf(taille), points[0], points[1]);
    }

    public static String getNomCoucheFichierCont(IFichierCont fichierCont) {
        String nomCouche = fichierCont.getNomFichier();
        nomCouche = nomCouche == null ? fichierCont.getNom() : nomCouche.substring(nomCouche.lastIndexOf("/") + 1, nomCouche.lastIndexOf(".")).toLowerCase();
        return nomCouche;
    }

    public static void ajoutTheme(FichierProjet fichierProjet, String nomTheme) throws Exception {
        OutilsCartoJ.ajoutTheme(fichierProjet, -1, nomTheme);
    }

    public static void ajoutTheme(FichierProjet fichierProjet, int position, String nomTheme) throws Exception {
        OutilsCartoJ.ajoutTheme(fichierProjet, position, nomTheme, NOMS_CHAMPS_DEFAUT, LIBELLES_CHAMPS_DEFAUT, TYPES_CHAMPS_DEFAUT, TAILLES_CHAMPS_DEFAUT);
    }

    public static void ajoutTheme(FichierProjet fichierProjet, int position, String nomTheme, String[] nomsChamps, String[] libellesChamps, char[] typesChamps, int[] taillesChamps) throws Exception {
        FichierDonMemoire fichierDon = new FichierDonMemoire(nomTheme, nomTheme, nomsChamps, libellesChamps, typesChamps, taillesChamps);
        FichierContMemoire fichierCont = new FichierContMemoire(nomTheme, nomTheme, 'l', 4);
        if (position == -1) {
            position = fichierProjet.getNbthem() - 1;
        }
        fichierProjet.ajouterTheme(position, (IFichierDon)fichierDon, (IFichierCont)fichierCont);
    }

    public static HashMap<Integer, String> getCouchesPonctuelles(FichierProjet fichierProjet) {
        return OutilsCartoJ.getCouchesTypes(fichierProjet, 'p');
    }

    public static HashMap<Integer, String> getCouchesLineaires(FichierProjet fichierProjet) {
        return OutilsCartoJ.getCouchesTypes(fichierProjet, 'l');
    }

    public static HashMap<Integer, String> getCouchesSurfaciques(FichierProjet fichierProjet) {
        return OutilsCartoJ.getCouchesTypes(fichierProjet, 's');
    }

    public static HashMap<Integer, String> getCouchesTypes(FichierProjet fichierProjet, char type) {
        HashMap<Integer, String> couchesPonctuelles = new HashMap<Integer, String>();
        int i = 0;
        while (i < fichierProjet.getNbcont()) {
            if (fichierProjet.getFichierCont(i).getType() == type) {
                couchesPonctuelles.put(i, OutilsCartoJ.getNomCoucheFichierCont(fichierProjet.getFichierCont(i)));
            }
            ++i;
        }
        return couchesPonctuelles;
    }

    public static void supprimerEntitesCouche(Cartes carte, String nomCouche) {
        OutilsCartoJ.supprimerEntitesCouche(carte.getCouche(nomCouche));
    }

    public static void supprimerEntitesCouche(ICouche couche) {
        if (couche != null) {
            int j = couche.getDon().getNbval() - 1;
            while (j >= 0) {
                try {
                    couche.supprimeEntite(j);
                }
                catch (Exception e) {
                    log.error((Object)"# ERREUR SUPPRESSION ENTITES #", (Throwable)e);
                }
                --j;
            }
        }
    }

    public static boolean verificationExistanceCouches(String chemin, Vector<String> nomCouches) {
        if (!GLS.estVide(nomCouches)) {
            for (String nomCouche : nomCouches) {
                if (OutilsCartoJ.verificationExistanceCouche(chemin, nomCouche)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean verificationExistanceCouche(String chemin, String nomCouche) {
        String cheminDon = Fichier.completerChemin(chemin).concat(nomCouche).concat(".don");
        String cheminCtr = Fichier.completerChemin(chemin).concat(nomCouche).concat(".ctr");
        return Fichier.existe(cheminDon) && Fichier.existe(cheminCtr);
    }

    public static boolean estCoucheMemoire(ICouche couche) {
        return couche.getDon() instanceof FichierDonMemoire && couche.getCont() instanceof FichierContMemoire;
    }

    public static void sauvegardeCouche(CartesG2 cartes, String chemin, String nomCouche) {
        ICouche couche;
        if (cartes != null && OutilsCartoJ.estCoucheMemoire(couche = cartes.getCouche(nomCouche))) {
            String cheminDon = Fichier.completerChemin(chemin).concat(nomCouche).concat(".don");
            String cheminCtr = Fichier.completerChemin(chemin).concat(nomCouche).concat(".ctr");
            Fichier.effacerFichier(cheminDon);
            Fichier.effacerFichier(cheminCtr);
            try {
                couche.getDon().toFile(cheminDon);
            }
            catch (Exception e) {
                log.error((Object)("ERREUR SAUVEGARDE COUCHE VH DON - " + cheminDon), (Throwable)e);
            }
            try {
                couche.getCont().toFile(cheminCtr);
            }
            catch (Exception e) {
                log.error((Object)("ERREUR SAUVEGARDE COUCHE VH CTR - " + cheminCtr), (Throwable)e);
            }
        }
    }

    public static void sauvegardeCouche(CartesG2 cartes, String chemin, Vector<String> nomCouches) {
        if (cartes != null) {
            for (String nomCouche : nomCouches) {
                OutilsCartoJ.sauvegardeCouche(cartes, chemin, nomCouche);
            }
        }
    }

    public static boolean fichiersCartoExiste(String chemin, String nomCouche) {
        String cheminDon = Fichier.completerChemin(chemin).concat(nomCouche).concat(".don");
        String cheminCtr = Fichier.completerChemin(chemin).concat(nomCouche).concat(".ctr");
        return Fichier.existe(cheminDon) && Fichier.existe(cheminCtr);
    }

    public static LiensCD getCouche(String chemin, String nomCouche) throws Exception {
        if (OutilsCartoJ.fichiersCartoExiste(chemin, nomCouche)) {
            String cheminCouche = String.valueOf(Fichier.completerChemin(chemin)) + nomCouche;
            FichierDonFichierString don = new FichierDonFichierString(String.valueOf(cheminCouche) + ".don");
            FichierContFichierString cont = new FichierContFichierString(String.valueOf(cheminCouche) + ".ctr");
            log.info((Object)("Cr\u00e9ation de la couche VH par fichier - " + cheminCouche + " effectu\u00e9e avec succ\u00e8s"));
            return new LiensCD((IFichierDon)don, (IFichierCont)cont, (IFichierCont)cont);
        }
        throw new Exception("ERREUR CREATION COUCHE");
    }

    public static void genererIdgfRoutesSansNom(CartesG2 carte) {
        String[] couches = new String[]{"class4", "class5", "class6", "class7"};
        int iRoute = 1;
        String[] stringArray = couches;
        int n = couches.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            ICouche couche = carte.getCouche(c);
            log.debug((Object)(" " + c));
            if (couche != null) {
                Enregistrement[] enregistrementArray = couche.getDon().getAllEnreg();
                int n3 = enregistrementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Enregistrement enr = enregistrementArray[n4];
                    String nomRoute = enr.getValeur(1);
                    if (GLS.estVide(nomRoute)) {
                        String nouveauNom = "VC" + c.charAt(c.length() - 1) + "_" + iRoute++;
                        log.debug((Object)("CHANGEMENT NOM " + nouveauNom));
                        enr.getValeurs()[1] = nouveauNom;
                        couche.getDon().modifieEnreg(enr);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static void chargerCouche(FichierProjet ficp, String chemin, String nomCouche, String[] champs, String[] libelles, char[] types, int[] tailles, char typeCouche) throws Exception {
        try {
            FichierContMemoire cont;
            FichierDonMemoire don;
            if (OutilsCartoJ.fichiersCartoExiste(chemin, nomCouche)) {
                String cheminCouche = String.valueOf(Fichier.completerChemin(chemin)) + nomCouche;
                don = new FichierDonFichierString(String.valueOf(cheminCouche) + ".don");
                cont = new FichierContFichierString(String.valueOf(cheminCouche) + ".ctr");
                log.info((Object)("Cr\u00e9ation de la couche VH par fichier - " + cheminCouche + " effectu\u00e9e avec succ\u00e8s"));
            } else {
                don = new FichierDonMemoire(nomCouche, nomCouche, champs, libelles, types, tailles);
                cont = new FichierContMemoire(nomCouche, nomCouche, typeCouche, 10);
            }
            ficp.ajouterTheme(nomCouche, (IFichierDon)don, (IFichierCont)cont);
        }
        catch (Exception e) {
            log.error((Object)("ERREUR CHARGEMENT COUCHE " + nomCouche), (Throwable)e);
        }
    }

    public static CoucheUUniverselle getCoucheParFichier(String chemin, String nomCouche, Color[] couleurFond, Color[] couleurCont, String[] valeur, int[] epaisseur, String[] images, String[] libelle) throws Exception {
        CoucheUUniverselle couche = new CoucheUUniverselle(OutilsCartoJ.getCouche(chemin, nomCouche), 1, nomCouche, 1.0f, Float.MAX_VALUE, valeur, couleurFond, couleurCont, epaisseur, libelle, images, 0, 0, -1, 0, 3, new Font("Arial", 0, 24), Color.black);
        return couche;
    }
}

