/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.GLS;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Nombre {
    private static Nombre instance;

    private Nombre() {
    }

    public static Nombre instanceOf() {
        if (instance == null) {
            instance = new Nombre();
        }
        return instance;
    }

    public static String getRelease(int release) {
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(3);
        df.setMaximumIntegerDigits(3);
        df.setMaximumFractionDigits(0);
        df.setMinimumFractionDigits(0);
        return df.format(release);
    }

    public static String getNombre(int nombre, int nbIntMin, int nbIntMax, int nbFractionMin, int nbFractionMax) {
        DecimalFormat df = new DecimalFormat();
        df.setMinimumIntegerDigits(nbIntMin);
        df.setMaximumIntegerDigits(nbIntMax);
        df.setMaximumFractionDigits(nbFractionMin);
        df.setMinimumFractionDigits(nbFractionMax);
        return df.format(nombre);
    }

    public static double getNombre(double nombre) {
        return Nombre.getNombre(nombre, 3);
    }

    public static double getNombre(String nombre, int nbDecimal) {
        return Nombre.getNombre(GLS.getDouble(nombre, nbDecimal), nbDecimal);
    }

    public static double getNombre(double nombre, int nbDecimal) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(nbDecimal);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        symbols.setGroupingSeparator('\u0000');
        format.setGroupingUsed(false);
        return GLS.getDouble(format.format(GLS.getDouble(String.valueOf(nombre).replace(',', '.'))));
    }

    public static double getNombre(String nombre) {
        return Nombre.getNombre(nombre);
    }

    public static double getNombre(String nombre, DecimalFormat format, double defaut) {
        try {
            return format.parse(nombre.replace(',', '.')).doubleValue();
        }
        catch (Exception e) {
            return defaut;
        }
    }

    public static void main(String ... strings) {
        System.out.println(Nombre.getNombre(3, 2, 2, 0, 0));
    }
}

