/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.GLS;
import java.io.Serializable;
import java.util.Vector;

public class GLSVectorMap
implements Serializable {
    protected Vector cles = new Vector();
    protected Vector donnees = new Vector();

    public Vector getCles() {
        return this.cles;
    }

    public Vector getDonnees() {
        return this.donnees;
    }

    public int size() {
        return this.cles.size();
    }

    public void supprimerTout() {
        this.cles.removeAllElements();
        this.donnees.removeAllElements();
    }

    public void remove(String cle) {
        this.supprimer(cle);
    }

    public void supprimer(String cle) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle >= -1) {
            this.cles.remove(indiceCle);
            this.donnees.remove(indiceCle);
        }
    }

    public void put(String cle, Object donnee) {
        this.ajouter(cle, donnee);
    }

    public void ajouter(String cle, Object donnee) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle == -1) {
            this.cles.add(cle);
            this.donnees.add(donnee);
        } else {
            this.donnees.setElementAt(donnee, indiceCle);
        }
    }

    public void modifier(String cle, Object donnee) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle == -1) {
            this.cles.add(cle);
            this.donnees.add(donnee);
        } else {
            this.donnees.setElementAt(donnee, indiceCle);
        }
    }

    public int getIndice(String cle) {
        return GLS.getIndiceObjetListe(this.cles, (Object)cle);
    }

    public Object get(String cle) {
        return this.get(cle, null);
    }

    public Object get(String cle, Object defaut) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle > -1) {
            return this.donnees.get(indiceCle);
        }
        return defaut;
    }

    public String getString(String cle) {
        return this.getString(cle, "");
    }

    public String getString(String cle, String defaut) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle > -1) {
            return GLS.getString(this.donnees.get(indiceCle), defaut);
        }
        return defaut;
    }

    public boolean getBoolean(String cle) {
        return GLS.getBoolean(this.getInt(cle), false);
    }

    public int getInt(String cle) {
        return this.getInt(cle, -1);
    }

    public int getInt(String cle, int defaut) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle > -1) {
            return GLS.getInt(this.getString(cle), defaut);
        }
        return defaut;
    }

    public Vector getVector(String cle) {
        return this.getVector(cle, null);
    }

    public Vector getVector(String cle, Vector defaut) {
        int indiceCle = this.getIndice(cle);
        if (indiceCle > -1) {
            return GLS.getVector(this.get(cle), defaut);
        }
        return defaut;
    }
}

