/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.GLS;
import java.io.Serializable;
import java.util.Vector;

public class Extension
implements Serializable {
    private Vector champs = new Vector();
    private Vector valeurs = new Vector();

    public Vector getChamps() {
        return this.champs;
    }

    public void setChamps(Vector champs) {
        this.champs = champs;
    }

    public Vector getValeurs() {
        return this.valeurs;
    }

    public void setValeurs(Vector valeurs) {
        this.valeurs = valeurs;
    }

    public boolean estIntVide(String val) {
        return this.getInt(val, -1) == -1;
    }

    public boolean estStringVide(String val) {
        return GLS.estVide(this.getString(val));
    }

    public float getFloat(String champ, float defaut) {
        float i;
        String valeur = this.getString(champ);
        try {
            i = Float.parseFloat(valeur);
        }
        catch (Exception e) {
            i = defaut;
        }
        return i;
    }

    public int champExiste(String champ) {
        if (this.champs != null && this.champs.size() > 0 && champ != null && !champ.equals("")) {
            champ = champ.toLowerCase().trim();
            int i = 0;
            while (i < this.champs.size()) {
                String vChamp = (String)this.champs.get(i);
                if (GLS.egal(vChamp, champ)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean existe(String champ) {
        return this.champExiste(champ) != -1;
    }

    public Object getValeur(String champ) {
        int indice = this.champExiste(champ);
        if (indice > -1) {
            return this.valeurs.get(indice);
        }
        return null;
    }

    public String getString(String champ) {
        Object valeur = this.getValeur(champ);
        if (valeur != null) {
            if (valeur instanceof String) {
                return (String)valeur;
            }
            return valeur.toString();
        }
        return null;
    }

    public boolean getBoolean(String champ, boolean defaut) {
        String valeur = this.getString(champ);
        if (valeur != null) {
            if (valeur.equals("1")) {
                return true;
            }
            if (valeur.equals("true")) {
                return true;
            }
            return valeur.equals("Y");
        }
        return defaut;
    }

    public Vector getVector(String champ, Vector defaut) {
        Object objet = this.getValeur(champ);
        if (objet != null && objet instanceof Vector) {
            return (Vector)objet;
        }
        return defaut;
    }

    public int getInt(String champ, int defaut) {
        int i;
        String valeur = this.getString(champ);
        try {
            i = Integer.parseInt(valeur);
        }
        catch (Exception e) {
            i = defaut;
        }
        return i;
    }

    public long getLong(String champ, long defaut) {
        long i;
        String valeur = this.getString(champ);
        try {
            i = Long.parseLong(valeur);
        }
        catch (Exception e) {
            i = defaut;
        }
        return i;
    }

    public double getDouble(String champ, double defaut) {
        double d;
        String valeur = this.getString(champ);
        try {
            d = Double.parseDouble(valeur);
        }
        catch (Exception e) {
            d = defaut;
        }
        return d;
    }

    public void setValeur(String champ, Object valeur) {
        int iChamp;
        if (this.champs == null) {
            this.champs = new Vector();
            this.valeurs = new Vector();
        }
        if ((iChamp = this.champExiste(champ)) == -1) {
            this.champs.add(champ.toLowerCase().trim());
            this.valeurs.add(valeur);
        } else {
            this.valeurs.set(iChamp, valeur);
        }
    }
}

