/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.ConstantesGLS;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Date {
    public static final String JANVIER = "janvier";
    public static final String FEVRIER = "f\u00e9vrier";
    public static final String MARS = "mars";
    public static final String AVRIL = "avril";
    public static final String MAI = "mai";
    public static final String JUIN = "juin";
    public static final String JUILLET = "juillet";
    public static final String AOUT = "ao\u00fbt";
    public static final String SEPTEMBRE = "septembre";
    public static final String OCTOBRE = "octobre";
    public static final String NOVEMBRE = "novembre";
    public static final String DECEMBRE = "d\u00e9cembre";
    public static DateFormat formatDateCompleteJourMoisAnnee = new SimpleDateFormat("dd MMMMM yyyy", Locale.FRANCE);
    public static DateFormat formatDateDatex = new SimpleDateFormat("yyyyMMddHHmm");
    public static DateFormat formatDateDatexJour = new SimpleDateFormat("yyyyMMdd");
    public static DateFormat formatDateDatexComplete = new SimpleDateFormat("yyyyMMddHHmmss");
    public static DateFormat formatDateSagac = new SimpleDateFormat("yyyyMMddHHmm");
    public static DateFormat formatDateComplete = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static DateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    public static DateFormat formatHeure = new SimpleDateFormat("HH:mm");
    public static DateFormat formatHeureComplete = new SimpleDateFormat("HH:mm:ss");
    public static DateFormat formatDateJour = new SimpleDateFormat("dd/MM/yyyy");
    public static DateFormat formatDateJourPg = new SimpleDateFormat("dd-MM-yyyy");
    public static DateFormat formatDateJourDatex = new SimpleDateFormat("yyyyMMdd");
    public static DateFormat formatDateJourCourt = new SimpleDateFormat("dd/MM");
    public static DateFormat formatDateMoisAnnee = new SimpleDateFormat("MMyyyy");
    public static DateFormat formatDateAnnee = new SimpleDateFormat("yyyy");
    public static DateFormat formatDateLibelleCourtJour = new SimpleDateFormat("EEE");
    public static DateFormat formatDateDatex2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static DateFormat formatDateJourSimple = new SimpleDateFormat("ddMMyy");
    private static Date instance;

    public static Date instanceOf() {
        if (instance == null) {
            instance = new Date();
        }
        return instance;
    }

    private Date() {
    }

    public static void copie(Calendar calendarSource, Calendar calendarDestination) {
        calendarDestination.set(1, calendarSource.get(1));
        calendarDestination.set(2, calendarSource.get(2));
        calendarDestination.set(6, calendarSource.get(6));
        calendarDestination.set(10, calendarSource.get(10));
        calendarDestination.set(12, calendarSource.get(12));
        calendarDestination.set(13, calendarSource.get(13));
    }

    public static void copie(java.util.Date dateSource, Calendar calendarDestination) {
        Calendar calSource = GregorianCalendar.getInstance();
        calSource.setTime(dateSource);
        Date.copie(calSource, calendarDestination);
    }

    public static void setHeure(Calendar source, java.util.Date heure) {
        GregorianCalendar tmpHeureDebut = new GregorianCalendar();
        tmpHeureDebut.setTime(heure);
        source.set(11, tmpHeureDebut.get(11));
        source.set(12, tmpHeureDebut.get(12));
    }

    public static java.util.Date getDateHeure(int jour, int mois, int an, int heures, int minutes, int secondes) {
        GregorianCalendar tmpHeureDebut = new GregorianCalendar();
        tmpHeureDebut.set(5, jour);
        tmpHeureDebut.set(2, mois);
        tmpHeureDebut.set(1, an);
        tmpHeureDebut.set(11, heures);
        tmpHeureDebut.set(12, minutes);
        tmpHeureDebut.set(13, secondes);
        tmpHeureDebut.set(14, 0);
        return tmpHeureDebut.getTime();
    }

    public static String getDiffHeureGMTDatex() {
        return Date.getDiffHeureGMTDatex(Date.maintenant());
    }

    public static String getDiffHeureGMTDatex(Calendar cal) {
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(cal.getTime())) {
            return "P02";
        }
        return "P01";
    }

    public static String getMois(String mois) {
        return Date.getMois(ConstantesGLS.getInt(mois));
    }

    public static String getMois(int mois) {
        switch (mois) {
            case 1: {
                return JANVIER;
            }
            case 2: {
                return FEVRIER;
            }
            case 3: {
                return MARS;
            }
            case 4: {
                return AVRIL;
            }
            case 5: {
                return MAI;
            }
            case 6: {
                return JUIN;
            }
            case 7: {
                return JUILLET;
            }
            case 8: {
                return AOUT;
            }
            case 9: {
                return SEPTEMBRE;
            }
            case 10: {
                return OCTOBRE;
            }
            case 11: {
                return NOVEMBRE;
            }
            case 12: {
                return DECEMBRE;
            }
        }
        return "";
    }

    public static String toDateDatex() throws Exception {
        return Date.toDateDatex(Date.maintenant());
    }

    public static String toDateDatex(Calendar calendrier) throws Exception {
        return formatDateDatex.format(calendrier.getTime()).concat(Date.getDiffHeureGMTDatex(calendrier));
    }

    public static String toDateSagac(Calendar calendrier) throws Exception {
        return formatDateSagac.format(calendrier.getTime()).concat(Date.getDiffHeureGMTDatex(calendrier));
    }

    public static Calendar toDateDatex(String dateDatex) {
        Calendar calendrier = GregorianCalendar.getInstance();
        if (!GLS.estVide(dateDatex)) {
            try {
                if (dateDatex.length() == "yyyyMMddHHmm".length()) {
                    calendrier.setTime(formatDateDatex.parse(dateDatex));
                } else {
                    calendrier.setTime(formatDateDatexComplete.parse(dateDatex));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return calendrier;
    }

    public static String fromDatex2ToFormatPostgres(String dateDatex2) {
        String partieDate = dateDatex2.substring(0, 19);
        String partieTimeZone = dateDatex2.substring(19);
        String partieDatePostgres = partieDate.replace("T", "").replace("-", "").replace(":", "");
        return String.valueOf(partieDatePostgres) + partieTimeZone;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(String date) throws Exception {
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
    }

    public static String toDateCompleteFromXml(String date) throws Exception {
        return Date.toDateComplete(Date.toXMLGregorianCalendar(date));
    }

    public static String toDateCompleteXML() throws Exception {
        return Date.toDateCompleteXML((GregorianCalendar)GregorianCalendar.getInstance());
    }

    public static String toDateCompleteXML(GregorianCalendar calendar) throws Exception {
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar).toXMLFormat();
    }

    public static String toDateComplete(XMLGregorianCalendar calendrier) {
        return Date.toDateComplete(calendrier.toGregorianCalendar());
    }

    public static String toDateComplete(Calendar calendrier) {
        if (calendrier != null) {
            return formatDateComplete.format(calendrier.getTime());
        }
        return "";
    }

    public static String getDiffHeureGMTDatex2(Calendar cal) {
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(cal.getTime())) {
            return "+02:00";
        }
        return "+01:00";
    }

    public static String toDate(Calendar calendrier) {
        return Date.toDate(calendrier, formatDate);
    }

    public static String toDate(java.util.Date date, DateFormat formatDate) {
        if (date != null && formatDate != null) {
            Calendar cal = Date.maintenant();
            cal.setTime(date);
            return Date.toDate(cal, formatDate);
        }
        return null;
    }

    public static String toDate(java.sql.Date date, DateFormat formatDate) {
        Calendar cal = Date.maintenant();
        cal.setTime(date);
        return Date.toDate(cal, formatDate);
    }

    public static String toDate(Calendar calendrier, DateFormat formatDate, DateFormat formatHeure) {
        try {
            return "le ".concat(formatDate.format(calendrier.getTime())).concat(" \u00e0 ").concat(formatHeure.format(calendrier.getTime()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toDate(Calendar calendrier, DateFormat format) {
        try {
            return format.format(calendrier.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean memeJour(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
        }
        return false;
    }

    public static Calendar toDate(String date) {
        return Date.toDate(date, formatDate);
    }

    public static Calendar toDate(String date, DateFormat format) {
        if (!ConstantesGLS.estNulle(date)) {
            try {
                java.util.Date dateConvertie = format.parse(date);
                Calendar cal = Date.maintenant();
                cal.setTime(dateConvertie);
                return cal;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Calendar toDateDatexComplete(String dateDatex) {
        return Date.toDate(dateDatex, formatDateDatexComplete);
    }

    public static long toDateEnMilliseconde(String date) {
        return Date.toDate(date).getTimeInMillis();
    }

    public static Calendar toDate(long dateInMs) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(dateInMs);
        return cal;
    }

    public static String toDateDatexComplete(long dateInMs) {
        Calendar cal = Date.toDate(dateInMs);
        return Date.toDateDatexComplete(cal);
    }

    public static String toDateDatex(long dateInMs) {
        Calendar cal = Date.toDate(dateInMs);
        return Date.toDate(cal, formatDateDatex);
    }

    public static String toDateDatex2(Calendar calendrier) throws Exception {
        return formatDateDatex2.format(calendrier.getTime()).concat(Date.getDiffHeureGMTDatex2(calendrier));
    }

    public static String toDateDatexComplete() {
        return Date.toDateDatexComplete(Date.maintenant());
    }

    public static String toDateDatexComplete(Calendar dateDatex) {
        return Date.toDate(dateDatex, formatDateDatexComplete);
    }

    public static long getTemps() {
        return GregorianCalendar.getInstance().getTime().getTime();
    }

    public static Calendar maintenant() {
        return GregorianCalendar.getInstance();
    }

    public static String toDate(String laDate, boolean formatDateEntreeComplete) {
        SimpleDateFormat dateformatcomplete = !GLS.estVide(laDate) ? (laDate.length() == "yyyyMMddHHmm".length() ? new SimpleDateFormat("yyyyMMddHHmm") : (laDate.length() == "yyyyMMddHHmmss".length() ? new SimpleDateFormat("yyyyMMddHHmmss") : new SimpleDateFormat("yyyyMMddHHmm"))) : new SimpleDateFormat("yyyyMMddHHmm");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat dateformat2 = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
        try {
            if (formatDateEntreeComplete) {
                return dateformat2.format(dateformatcomplete.parse(laDate));
            }
            return dateformat2.format(dateformat.parse(laDate));
        }
        catch (Exception e) {
            return laDate;
        }
    }
}

