/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import cartoj.IFichierDon;
import cartoj.Variable;
import gls.application.version.Version;
import gls.outils.GLS;
import gls.outils.classe.ClassUtils;
import gls.outils.fichier.Fichier;
import gls.outils.ui.checkboxlist.CheckBoxJList;
import gls.utils.transfert.ImageAppareilPhoto;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ConstantesGLS {
    private static final Logger log = Logger.getLogger(ConstantesGLS.class);
    public static final String SEPARATEUR_TABLEAU = ";";
    public static final String SEPARATEUR_MAIL = ";";
    public static final double VAL_DBL_NEANT = -1.0;
    public static final float VAL_FLT_NEANT = -1.0f;
    public static final int VAL_INT_NEANT = -1;
    public static final int VAL_BOOL_OK = 1;
    public static final int VAL_BOOL_PAS_OK = 0;
    public static final String VAL_BOOL_OUI = "oui";
    public static final String VAL_BOOL_TRUE = "true";
    public static final String VAL_BOOL_NON = "non";
    public static final String VAL_BOOL_Y = "Y";
    public static final String VAL_STR_BOOL_OK = "1";
    public static final String VAL_STR_BOOL_PAS_OK = "0";
    public static final String VAL_STR_NEANT = "";
    public static final String VAL_STR_ESPACE = " ";
    public static final int LARGEUR_PANNEAU_SAISIE = 426;
    public static final int[] LISTE_CARACTERES_NUMERIQUES = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public int[] toTableauInt(String[] tableau) {
        int[] tab = new int[tableau.length];
        int i = 0;
        while (i < tableau.length) {
            tab[i] = GLS.getInt(tableau[i]);
            ++i;
        }
        return tab;
    }

    public static int getLongueurTexte(String texte) {
        if (!GLS.estVide(texte)) {
            return texte.length();
        }
        return 0;
    }

    public static void triBulle(int[] tableau) {
        boolean inversion;
        int longueur = tableau.length;
        do {
            inversion = false;
            int i = 0;
            while (i < longueur - 1) {
                if (tableau[i] > tableau[i + 1]) {
                    int tmp = tableau[i];
                    tableau[i] = tableau[i + 1];
                    tableau[i + 1] = tmp;
                    inversion = true;
                }
                ++i;
            }
        } while (inversion);
    }

    public static String getLibelleComposantPlusieursLigne(String ligne1) {
        return "<html><body><center>" + ligne1 + "</center></body></html>";
    }

    public static String getLibelleComposantPlusieursLigneAlignement(String ligne1, String alignement) {
        return "<html><body><" + alignement + ">" + ligne1 + "</" + alignement + "></body></html>";
    }

    public static String getLibelleComposantPlusieursLigne(String ligne1, String ligne2) {
        return "<html><body><center>" + ligne1 + VAL_STR_ESPACE + ligne2 + "</center></body></html>";
    }

    public static boolean estNumerique(char keyCode) {
        int i = 0;
        while (i < LISTE_CARACTERES_NUMERIQUES.length) {
            if (LISTE_CARACTERES_NUMERIQUES[i] == keyCode) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean estNumerique(String valeur) {
        if (!ConstantesGLS.estVide(valeur)) {
            int i = 0;
            while (i < valeur.length()) {
                if (!ConstantesGLS.estNumerique(valeur.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String genererNumeroUnique() {
        return ConstantesGLS.genererNumeroUnique(VAL_STR_NEANT);
    }

    public static String genererNumeroUnique(String prefixe) {
        Date maDate = GregorianCalendar.getInstance().getTime();
        return ConstantesGLS.getString(prefixe).concat(String.valueOf(maDate.getTime())).concat(String.valueOf(maDate.getSeconds())).concat(String.valueOf(Math.round(Math.random() * 1000.0)));
    }

    public static String getValeurListeAleatoireString(Vector liste) throws Exception {
        return GLS.getString(ConstantesGLS.getValeurListeAleatoire(liste));
    }

    public static Object getValeurListeAleatoire(Vector liste) throws Exception {
        if (!GLS.estVide(liste)) {
            return liste.get(ConstantesGLS.genereIntAleatoire(0, liste.size() - 1));
        }
        throw new Exception("ERREUR VALEUR ALEATOIRE : LA LISTE EST VIDE");
    }

    public static String getValeurListeAleatoire(String[] liste) throws Exception {
        if (!GLS.estVide(liste)) {
            return liste[ConstantesGLS.genereIntAleatoire(0, liste.length - 1)];
        }
        throw new Exception("ERREUR VALEUR ALEATOIRE : LA LISTE EST VIDE");
    }

    public static int genereIntAleatoire(int min, int max) {
        return Math.round(ConstantesGLS.genereFloatAleatoire(min, max).floatValue());
    }

    public static Float genereFloatAleatoire(int min, int max) {
        return new Float(Math.random() * (double)(max - min) + (double)min);
    }

    public static boolean estDejaParcouru(Vector vec, String valeur) {
        boolean trouve = false;
        boolean finVecteur = false;
        int i = 0;
        finVecteur = i == vec.size();
        while (!trouve && !finVecteur) {
            if (ConstantesGLS.egal(valeur, ConstantesGLS.getString(vec.get(i)))) {
                trouve = true;
            }
            boolean bl = finVecteur = ++i == vec.size();
        }
        return trouve;
    }

    public static boolean estDansLaListe(JList liste, Object valeur) {
        return ConstantesGLS.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static boolean estDansLaListe(JComboBox liste, Object valeur) {
        return ConstantesGLS.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static int getIndiceObjetListe(CheckBoxJList liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.getModel().getSize() == 0;
        while (!trouve && !fin) {
            ++i;
            try {
                if (liste.getItem(i).equals(valeur)) {
                    trouve = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fin = i == liste.getModel().getSize() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static int getIndiceObjetListe(JComboBox liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.getModel().getSize() == 0;
        while (!trouve && !fin) {
            ++i;
            try {
                if (liste.getItemAt(i).equals(valeur)) {
                    trouve = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fin = i == liste.getModel().getSize() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static int getIndiceChamp(IFichierDon don, String champ) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = don == null || don.getNbvar() == 0;
        while (!trouve && !fin) {
            ++i;
            try {
                Variable var = don.getVar(i);
                String nomVar = var.getComm();
                if (nomVar.equals(champ)) {
                    trouve = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fin = i == don.getNbvar() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static int getIndiceObjetListe(JList liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.getModel().getSize() == 0;
        while (!trouve && !fin) {
            if (liste.getModel().getElementAt(++i).equals(valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.getModel().getSize() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static boolean ressembleObjetListe(JList liste, String valeur) {
        return ConstantesGLS.getIndiceObjetRessemblantListe(liste, valeur) > -1;
    }

    public static int getIndiceObjetRessemblantListe(JList liste, String valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.getModel().getSize() == 0;
        while (!trouve && !fin) {
            if (liste.getModel().getElementAt(++i).toString().toLowerCase().indexOf(valeur.toLowerCase()) > -1) {
                trouve = true;
            }
            boolean bl = fin = i == liste.getModel().getSize() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static int getIndiceObjetRessemblantListe(JComboBox liste, String valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.getModel().getSize() == 0;
        while (!trouve && !fin) {
            if (valeur.toLowerCase().indexOf(liste.getModel().getElementAt(++i).toString().toLowerCase()) > -1) {
                trouve = true;
            }
            boolean bl = fin = i == liste.getModel().getSize() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static boolean estDansLaListe(String[] liste, String valeur) {
        return ConstantesGLS.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static boolean estDansLaListe(List liste, Object valeur) {
        return ConstantesGLS.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static int getIndiceObjetListe(List liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if (liste.get(++i).equals(valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static String[] trim(String[] valeurs) {
        if (!ConstantesGLS.estVide(valeurs)) {
            int i = 0;
            while (i < valeurs.length) {
                valeurs[i] = valeurs[i].trim();
                ++i;
            }
        }
        return valeurs;
    }

    public static <T> Vector<T> trier(Vector<T> array) {
        TreeMap<String, T> map = new TreeMap<String, T>();
        for (T obj : array) {
            map.put(obj.toString(), obj);
        }
        Iterator it = map.values().iterator();
        Vector eltTrie = new Vector();
        while (it.hasNext()) {
            eltTrie.add(it.next());
        }
        return eltTrie;
    }

    public static Vector<String> sortRD(Vector<String> array) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String elt : array) {
            map.put(ConstantesGLS.getNumRD(elt), elt);
        }
        Iterator it = map.values().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add((String)it.next());
        }
        return eltTrie;
    }

    public static List<String> sortPR(List<String> array) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String elt : array) {
            map.put(ConstantesGLS.formatPr(elt), elt);
        }
        Iterator it = map.values().iterator();
        ArrayList<String> eltTrie = new ArrayList<String>();
        while (it.hasNext()) {
            eltTrie.add((String)it.next());
        }
        return eltTrie;
    }

    public static String formatPrAbs(int pr, int abs) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(5);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(pr).concat("+").concat(nf.format(abs));
    }

    public static String formatPr(String pr) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(5);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(GLS.getInt(pr));
    }

    public static String getNumRD(String rd) {
        if (rd.length() >= 2 && GLS.egal(String.valueOf(rd.charAt(0)), "D") && GLS.estNumerique(rd.charAt(1))) {
            String tmp = VAL_STR_NEANT;
            String tmpNumRd = VAL_STR_NEANT;
            String tmpFinRd = VAL_STR_NEANT;
            int i = 1;
            boolean fin = false;
            boolean finNumerique = false;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            tmp = String.valueOf(rd.charAt(0));
            while (!fin) {
                char c = rd.charAt(i++);
                if (!finNumerique && GLS.estNumerique(c)) {
                    tmpNumRd = String.valueOf(tmpNumRd) + c;
                } else {
                    tmpFinRd = String.valueOf(tmpFinRd) + c;
                    finNumerique = true;
                }
                boolean bl = fin = i >= rd.length();
            }
            tmp = tmp.concat(nf.format(GLS.getDouble(tmpNumRd)).concat(tmpFinRd));
            return tmp;
        }
        return rd;
    }

    public static String[] remplacer(String[] valeurs, String ancienneValeur, String nouvelleValeur) {
        if (!ConstantesGLS.estVide(valeurs)) {
            int i = 0;
            while (i < valeurs.length) {
                valeurs[i] = ConstantesGLS.remplacer(valeurs[i], ancienneValeur, nouvelleValeur);
                ++i;
            }
        }
        return valeurs;
    }

    public void trim(String valeur) {
        if (!ConstantesGLS.estVide(valeur)) {
            valeur = valeur.trim();
        }
    }

    public static int getIndiceObjetListe(String[] liste, String valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.length == 0;
        while (!trouve && !fin) {
            if (GLS.egal(liste[++i], valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.length - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static int getIndiceObjetListe(Object[] liste, String valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.length == 0;
        while (!trouve && !fin) {
            if (GLS.egal(liste[++i], (Object)valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.length - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static boolean estNulle(int valeur) {
        return valeur == -1;
    }

    public static boolean estNulle(long valeur) {
        return valeur == -1L;
    }

    public static boolean estNulle(double valeur) {
        return valeur == -1.0;
    }

    public static boolean estNulle(String valeur) {
        return valeur == null;
    }

    public static boolean estNulle(Vector valeur) {
        return valeur == null;
    }

    public static boolean egal(Object valeur1, Object valeur2) {
        return ConstantesGLS.egal(GLS.getString(valeur1), GLS.getString(valeur2));
    }

    public static boolean egal(String valeur1, String valeur2) {
        if (!ConstantesGLS.estNulle(valeur1) && !ConstantesGLS.estNulle(valeur2)) {
            return valeur1.compareToIgnoreCase(valeur2) == 0;
        }
        return ConstantesGLS.getString(valeur1).compareToIgnoreCase(ConstantesGLS.getString(valeur2)) == 0;
    }

    public static boolean estVide(String valeur) {
        return valeur == null || valeur.trim().equals(VAL_STR_NEANT);
    }

    public static boolean estVideOuEgale(String valeur, String valeurEgale) {
        return ConstantesGLS.estVide(valeur) || ConstantesGLS.egal(valeur, valeurEgale);
    }

    public static boolean estVide(List vector) {
        return vector == null || vector.isEmpty();
    }

    public static boolean estVide(int[] valeur) {
        return valeur == null || valeur.length <= 0;
    }

    public static boolean estVide(String[] valeur) {
        return valeur == null || valeur.length <= 0;
    }

    public static boolean estVide(Object[] valeur) {
        return valeur == null || valeur.length <= 0;
    }

    public static void fixerTailleObjet(JComponent composant, int hauteur) {
        ConstantesGLS.fixerTailleObjet(composant, 426, hauteur);
    }

    public static void fixerTailleObjet(JComponent composant, int largeur, int hauteur) {
        composant.setPreferredSize(new Dimension(largeur, hauteur));
        composant.setMinimumSize(new Dimension(largeur, hauteur));
        composant.setMaximumSize(new Dimension(largeur, hauteur));
    }

    public static final Font getFontGLS(int taille, boolean gras) {
        return ConstantesGLS.getFont("BankGothic Md BT", taille, gras);
    }

    public static final Font getFont(String nom, int taille, boolean gras) {
        return new Font(nom, gras ? 1 : 0, taille);
    }

    public static String getCorrespondanceValeurListe(String valeur, String[] listeOriginale, Vector<String> listeCorrespondance) {
        int indice;
        if (listeOriginale != null && listeCorrespondance != null && listeOriginale.length == listeCorrespondance.size() && (indice = GLS.getIndiceObjetListe(listeOriginale, valeur)) > -1) {
            return listeCorrespondance.get(indice);
        }
        return valeur;
    }

    public static String getCorrespondanceValeurListe(String valeur, String[] listeOriginale, String[] listeCorrespondance) {
        int indice;
        if (listeOriginale != null && listeCorrespondance != null && listeOriginale.length == listeCorrespondance.length && (indice = GLS.getIndiceObjetListe(listeOriginale, valeur)) > -1) {
            return listeCorrespondance[indice];
        }
        return valeur;
    }

    public static int getInt(boolean etat) {
        if (etat) {
            return 1;
        }
        return 0;
    }

    public static String[] getTableauString(String champ, String separateur) {
        return ConstantesGLS.getTableauString(champ, separateur, null);
    }

    public static String[] getTableauString(String champ) {
        return ConstantesGLS.getTableauString(champ, ";", null);
    }

    public static String[] getTableauString(String champ, String[] defaut) {
        return ConstantesGLS.getTableauString(champ, ";", defaut);
    }

    public static String[] getTableauString(String champ, String separateur, String[] defaut) {
        String valeur = ConstantesGLS.getString(champ, null);
        if (GLS.estVide(valeur)) {
            return defaut;
        }
        return valeur.split(separateur, 0);
    }

    public static String getString(boolean etat) {
        return String.valueOf(ConstantesGLS.getInt(etat));
    }

    public static int getInt(String valeur) {
        return ConstantesGLS.getInt(valeur, -1);
    }

    public static boolean getBoolean(String champ) {
        return ConstantesGLS.getBoolean(champ, false);
    }

    public static boolean getBoolean(String champ, boolean defaut) {
        if (GLS.estVide(champ)) {
            return false;
        }
        if (ConstantesGLS.estNumerique(champ)) {
            return ConstantesGLS.getBoolean(ConstantesGLS.getInt(champ), defaut);
        }
        if (champ.equals(VAL_BOOL_OUI)) {
            return true;
        }
        if (VAL_BOOL_Y.equalsIgnoreCase(champ)) {
            return true;
        }
        return VAL_BOOL_TRUE.equalsIgnoreCase(champ);
    }

    public static boolean getBoolean(int valeur, boolean defaut) {
        if (valeur == -1) {
            return defaut;
        }
        return valeur == 1;
    }

    public static String getString(String champ) {
        return ConstantesGLS.getString(champ, VAL_STR_NEANT);
    }

    public static Vector getVector(Object objet) {
        return ConstantesGLS.getVector(objet, null);
    }

    public static Object getObjectAtIndice(Vector vecteur, int i) {
        return ConstantesGLS.getObjectAtIndice(vecteur, i, null);
    }

    public static Object getObjectAtIndice(Vector vecteur, int i, Object defaut) {
        if (vecteur != null && i < vecteur.size() && i >= 0) {
            return vecteur.get(i);
        }
        return defaut;
    }

    public static Object getObjectAtIndice(String[] t, int i) {
        return ConstantesGLS.getObjectAtIndice(t, i, null);
    }

    public static Object getObjectAtIndice(String[] t, int i, Object defaut) {
        if (t != null && i < t.length && i >= 0) {
            return t[i];
        }
        return defaut;
    }

    public static String getStringAtIndice(String[] t, int i) {
        return ConstantesGLS.getStringAtIndice(t, i, null);
    }

    public static String getStringAtIndice(String[] t, int i, String defaut) {
        return GLS.getString(ConstantesGLS.getObjectAtIndice(t, i), defaut);
    }

    public static String getStringAtIndice(Vector vecteur, int i) {
        return ConstantesGLS.getStringAtIndice(vecteur, i, null);
    }

    public static String getStringAtIndice(Vector vecteur, int i, String defaut) {
        return GLS.getString(ConstantesGLS.getObjectAtIndice(vecteur, i), defaut);
    }

    public static Vector getVector(Object objet, Vector defaut) {
        if (objet != null && objet instanceof Vector) {
            return (Vector)objet;
        }
        return defaut;
    }

    public static Version getVersion(HashMap hashMap, String champ, Version defaut) {
        Object v = hashMap.get(champ);
        if (v != null && v instanceof Version) {
            return (Version)v;
        }
        return defaut;
    }

    public static Object getObject(Hashtable hashtable, String champ, Object defaut) {
        Object objet = hashtable.get(champ);
        if (objet != null) {
            return objet;
        }
        return defaut;
    }

    public static Object getObject(Object objet, Object defaut) {
        if (objet != null) {
            return objet;
        }
        return defaut;
    }

    public static Object getObject(HashMap hashMap, String champ, Object defaut) {
        Object objet = hashMap.get(champ);
        if (objet != null) {
            return objet;
        }
        return defaut;
    }

    public static Vector getVector(Hashtable hashtable, String champ, Vector defaut) {
        return ConstantesGLS.getVector(hashtable.get(champ), defaut);
    }

    public static Vector getVector(HashMap hashMap, String champ, Vector defaut) {
        return ConstantesGLS.getVector(hashMap.get(champ), defaut);
    }

    public static String getString(Vector liste) {
        return ConstantesGLS.getString(liste, ";");
    }

    public static String getString(String[] liste) {
        return ConstantesGLS.getString(liste, ";");
    }

    public static String getString(String[] liste, String separateur) {
        String valeur = VAL_STR_NEANT;
        if (!ConstantesGLS.estVide(liste)) {
            int i = 0;
            while (i < liste.length - 1) {
                valeur = String.valueOf(valeur) + liste[i] + separateur;
                ++i;
            }
            valeur = String.valueOf(valeur) + liste[liste.length - 1];
        }
        return valeur;
    }

    public static String getString(Object[] liste) {
        return ConstantesGLS.getString(liste, ";");
    }

    public static String getString(Object[] liste, String separateur) {
        String valeur = VAL_STR_NEANT;
        if (!ConstantesGLS.estVide(liste)) {
            int i = 0;
            while (i < liste.length - 1) {
                valeur = String.valueOf(valeur) + ConstantesGLS.getString(liste[i]) + separateur;
                ++i;
            }
            valeur = String.valueOf(valeur) + ConstantesGLS.getString(liste[liste.length - 1]);
        }
        return valeur;
    }

    public static void ajouterObjet(GridBagLayout gridLayout, GridBagConstraints gridConstraints, int width, int height, int x, int y, JComponent obj, JComponent component) {
        gridConstraints.fill = 0;
        gridConstraints.gridheight = height;
        gridConstraints.gridwidth = width;
        gridConstraints.gridx = x;
        gridConstraints.gridy = y;
        gridLayout.setConstraints(obj, gridConstraints);
        component.add(obj);
    }

    public static void ajouterObjet(GridBagLayout gridLayout, GridBagConstraints gridConstraints, int height, int width, int x, int y, Canvas obj, JComponent component) {
        gridConstraints.fill = 1;
        gridConstraints.gridheight = height;
        gridConstraints.gridwidth = width;
        gridConstraints.gridx = x;
        gridConstraints.gridy = y;
        gridLayout.setConstraints(obj, gridConstraints);
        component.add(obj);
    }

    public static String getString(List liste, String separateur) {
        String valeur = VAL_STR_NEANT;
        if (liste != null && liste.size() > 0) {
            int i = 0;
            while (i < liste.size() - 1) {
                valeur = String.valueOf(valeur) + ConstantesGLS.getString(liste.get(i), VAL_STR_NEANT) + separateur;
                ++i;
            }
            valeur = String.valueOf(valeur) + ConstantesGLS.getString(liste.get(liste.size() - 1), VAL_STR_NEANT);
        }
        return valeur;
    }

    public static String getString(Iterator it, String separateur) {
        String valeur = VAL_STR_NEANT;
        if (it != null && it.hasNext()) {
            valeur = ConstantesGLS.getString(it.next());
            while (it.hasNext()) {
                valeur = String.valueOf(valeur) + separateur.concat(ConstantesGLS.getString(it.next()));
            }
        }
        return valeur;
    }

    public static Vector getVector(Iterator it) {
        Vector valeurs = new Vector();
        if (it != null && it.hasNext()) {
            while (it.hasNext()) {
                valeurs.add(it.next());
            }
        }
        return valeurs;
    }

    public static List getListe(Iterator it) {
        ArrayList valeurs = new ArrayList();
        if (it != null && it.hasNext()) {
            while (it.hasNext()) {
                valeurs.add(it.next());
            }
        }
        return valeurs;
    }

    public static Vector getVector(Object[] objs) {
        Vector<Object> valeurs = new Vector<Object>();
        if (!GLS.estVide(objs)) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                valeurs.add(obj);
                ++n2;
            }
        }
        return valeurs;
    }

    public static String getString(String valeur, String defaut) {
        if (ConstantesGLS.estVide(valeur)) {
            return defaut;
        }
        return valeur;
    }

    public static String getString(Object valeur) {
        return ConstantesGLS.getString(valeur, VAL_STR_NEANT);
    }

    public static String getString(Object valeur, String defaut) {
        if (valeur == null) {
            return defaut;
        }
        if (valeur instanceof String) {
            return (String)valeur;
        }
        return valeur.toString();
    }

    public static String getStringNonVide(Object valeur, String defaut) {
        if (valeur == null) {
            return defaut;
        }
        if (valeur instanceof String) {
            return GLS.getString((String)valeur, defaut);
        }
        return GLS.getString(valeur.toString(), defaut);
    }

    public static int getInt(Object valeur) {
        return ConstantesGLS.getInt(ConstantesGLS.getString(valeur), -1);
    }

    public static int getInt(Object valeur, int defaut) {
        return ConstantesGLS.getInt(ConstantesGLS.getString(valeur), defaut);
    }

    public static int getInt(String valeur, int defaut) {
        int i;
        try {
            i = Integer.parseInt(valeur);
        }
        catch (Exception e) {
            i = defaut;
        }
        return i;
    }

    public static String getLibelleChampEnClair(String champ) {
        StringBuffer champEnClair = new StringBuffer();
        if (!ConstantesGLS.estVide(champ)) {
            champEnClair.append(Character.toUpperCase(champ.charAt(0)));
            if (champ.length() > 1) {
                int i = 1;
                while (i < champ.length() - 1) {
                    char c = champ.charAt(i);
                    char cSuivant = champ.charAt(i + 1);
                    if (Character.isUpperCase(c) && Character.isLowerCase(cSuivant)) {
                        champEnClair.append(VAL_STR_ESPACE);
                    }
                    champEnClair.append(c);
                    ++i;
                }
                champEnClair.append(champ.charAt(champ.length() - 1));
            }
        }
        return champEnClair.toString();
    }

    public static double getDouble(String valeur) {
        return ConstantesGLS.getDouble(valeur, -1.0);
    }

    public static double getDouble(String valeur, double defaut) {
        double d;
        try {
            d = Double.parseDouble(valeur);
        }
        catch (Exception e) {
            d = defaut;
        }
        return d;
    }

    public static String[] getTableauString(Object objet) {
        if (objet != null) {
            if (objet instanceof String) {
                return ConstantesGLS.getTableauString((String)objet);
            }
            if (objet instanceof String[]) {
                return (String[])objet;
            }
            if (objet instanceof Vector) {
                return ConstantesGLS.toTableauString((Vector)objet);
            }
        }
        return new String[0];
    }

    public static int getTaille(int[] liste) {
        if (!ConstantesGLS.estVide(liste)) {
            return liste.length;
        }
        return 0;
    }

    public static String verifierCharacterInvalidesXML(String source, boolean supprimer) {
        String HtmlEncode = VAL_STR_NEANT;
        if (source == null) {
            return null;
        }
        if (source == VAL_STR_NEANT) {
            return VAL_STR_NEANT;
        }
        int spot = 0;
        while (spot < source.length()) {
            char c = source.charAt(spot);
            if (c > '`' && c < '{' || c > '@' && c < '[' || c == ' ' || c > '/' && c < ':' || c >= ',' && c <= '.' || c == '_') {
                HtmlEncode = String.valueOf(HtmlEncode) + String.valueOf(c);
            } else if (!supprimer) {
                HtmlEncode = String.valueOf(HtmlEncode) + "&#" + c + ";";
            }
            ++spot;
        }
        return HtmlEncode;
    }

    public static int getTaille(Object[] liste) {
        if (!ConstantesGLS.estVide(liste)) {
            return liste.length;
        }
        return 0;
    }

    public static int getTaille(String[] liste) {
        if (!ConstantesGLS.estVide(liste)) {
            return liste.length;
        }
        return 0;
    }

    public static int[] concat(int[] liste1, int[] liste2) {
        int tailleListe2;
        int tailleListe1 = ConstantesGLS.getTaille(liste1);
        int[] listeFinale = new int[tailleListe1 + (tailleListe2 = ConstantesGLS.getTaille(liste2))];
        if (!ConstantesGLS.estVide(listeFinale)) {
            int i = 0;
            while (i < tailleListe1) {
                listeFinale[i] = liste1[i];
                ++i;
            }
            i = tailleListe1;
            while (i < tailleListe1 + tailleListe2) {
                listeFinale[i] = liste2[i - tailleListe1];
                ++i;
            }
        }
        return listeFinale;
    }

    public static Map<String, String> vertorToMap(Vector champs, Vector valeurs) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (champs != null && valeurs != null) {
            int i = 0;
            while (i < champs.size()) {
                m.put(ConstantesGLS.getString(champs.get(i)), ConstantesGLS.getString(valeurs.get(i)));
                ++i;
            }
        }
        return m;
    }

    public static String[] concat(String[] liste1, String[] liste2) {
        int tailleListe2;
        int tailleListe1 = ConstantesGLS.getTaille(liste1);
        String[] listeFinale = new String[tailleListe1 + (tailleListe2 = ConstantesGLS.getTaille(liste2))];
        if (!ConstantesGLS.estVide(listeFinale)) {
            int i = 0;
            while (i < tailleListe1) {
                listeFinale[i] = liste1[i];
                ++i;
            }
            i = tailleListe1;
            while (i < tailleListe1 + tailleListe2) {
                listeFinale[i] = liste2[i - tailleListe1];
                ++i;
            }
        }
        return listeFinale;
    }

    public static <T> T[] concat(Class<T> type, T[] liste1, T[] liste2) {
        int tailleListe2;
        int tailleListe1 = ConstantesGLS.getTaille(liste1);
        Object[] listeFinale = ClassUtils.getArray(type, tailleListe1 + (tailleListe2 = ConstantesGLS.getTaille(liste2)));
        if (!ConstantesGLS.estVide(listeFinale)) {
            int i = 0;
            while (i < tailleListe1) {
                listeFinale[i] = liste1[i];
                ++i;
            }
            i = tailleListe1;
            while (i < tailleListe1 + tailleListe2) {
                listeFinale[i] = liste2[i - tailleListe1];
                ++i;
            }
        }
        return listeFinale;
    }

    public static Vector<byte[]> getImagesBytes(Vector<Image> images) {
        Vector<byte[]> v = new Vector<byte[]>();
        for (Image img : images) {
            v.add(ConstantesGLS.getImagesBytes(img));
        }
        return v;
    }

    public static byte[] getImagesBytes(Image img) {
        byte[] result = null;
        BufferedImage buf = (BufferedImage)img;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        try {
            ImageIO.write((RenderedImage)buf, "jpeg", baos);
            baos.flush();
            result = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            log.debug((Object)"Erreur ecriture image", (Throwable)e);
        }
        return result;
    }

    public static Vector<byte[]> getImagesBytes(File[] fichiers) throws Exception {
        if (fichiers != null) {
            Vector<byte[]> imagesBytes = new Vector<byte[]>();
            File[] fileArray = fichiers;
            int n = fichiers.length;
            int n2 = 0;
            while (n2 < n) {
                File fichier = fileArray[n2];
                if (Fichier.estImage(fichier)) {
                    imagesBytes.add(ConstantesGLS.getBytes(fichier));
                }
                ++n2;
            }
            return imagesBytes;
        }
        throw new Exception("ERREUR CONVERSION IMAGE BYTES # AUCUN FICHIER OU DOSSIER INEXISTANT");
    }

    public static Vector<byte[]> getImagesBytes(File dossier) throws Exception {
        if (dossier != null) {
            return ConstantesGLS.getImagesBytes(dossier.listFiles());
        }
        throw new Exception("ERREUR CONVERSION IMAGE BYTES # DOSSIER NUL");
    }

    public static Vector<byte[]> getImagesBytes(String dossier) throws Exception {
        if (dossier != null) {
            return ConstantesGLS.getImagesBytes(new File(dossier));
        }
        throw new Exception("ERREUR CONVERSION IMAGE BYTES # CHEMIN DOSSIER NUL");
    }

    public static byte[] getBytes(File fichier) throws Exception {
        return ConstantesGLS.getBytes(ConstantesGLS.getImage(fichier));
    }

    public static byte[] getBytes(String fichier) throws Exception {
        return ConstantesGLS.getBytes(new File(fichier));
    }

    public static byte[] getBytes(BufferedImage image) throws Exception {
        byte[] result = null;
        if (image != null) {
            BufferedImage buf = image;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            try {
                ImageIO.write((RenderedImage)buf, "png", baos);
                baos.flush();
                result = baos.toByteArray();
                baos.close();
            }
            catch (IOException e) {
                throw new Exception("ERREUR DANS LA CONVERSION DE L'IMAGE #" + e.getMessage());
            }
        } else {
            throw new Exception("ERREUR DANS LA CONVERSION DE L'IMAGE # IMAGE NULLE");
        }
        if (result == null) {
            throw new Exception("ERREUR DANS LA CONVERSION DE L'IMAGE # RESULTAT NUL");
        }
        return result;
    }

    public static BufferedImage getImage(File fichier) throws Exception {
        return ConstantesGLS.getImage(fichier, 300, 300);
    }

    public static BufferedImage getImage(String fichier) throws Exception {
        return ConstantesGLS.getImage(new File(fichier), 300, 300);
    }

    public static BufferedImage getImage(File fichier, int largeurMax, int hauteurMax) throws Exception {
        if (Fichier.estImage(fichier)) {
            return ConstantesGLS.getImage(new ImageAppareilPhoto(fichier).getImageIcon(), largeurMax, hauteurMax);
        }
        throw new Exception("Erreur dans la r\u00ef\u00bf\u00bdcup\u00ef\u00bf\u00bdration de l'image");
    }

    public static BufferedImage getImage(Object b) {
        BufferedImage bufferedImage = null;
        ImageIcon image = b instanceof byte[] ? new ImageIcon((byte[])b) : (b instanceof Image ? new ImageIcon((Image)b) : null);
        if (image != null) {
            bufferedImage = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image.getImage(), 0, 0, null);
            g.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage getImage(ImageIcon image, int largeurMax, int hauteurMax) throws Exception {
        return ConstantesGLS.getImage(image, largeurMax, hauteurMax, 6, true);
    }

    public static BufferedImage getImage(ImageIcon image, int largeurMax, int hauteurMax, int type, boolean transparent) throws Exception {
        ImageIcon ic = image;
        int w = ic.getIconWidth();
        int h = ic.getIconHeight();
        double scaleX = (double)largeurMax / (double)w;
        double scaleY = (double)hauteurMax / (double)h;
        double scale = Math.min(scaleX, scaleY);
        BufferedImage smallImg = ImageAppareilPhoto.scale(ImageAppareilPhoto.toBufferedImage(image.getImage(), type, transparent), scale);
        if (smallImg != null) {
            return smallImg;
        }
        throw new Exception("ERREUR DANS LA RECUPERATION DE L'IMAGE # IMAGE NULL");
    }

    public static Vector<String> ecrireImages(String cheminImages, Vector images) throws Exception {
        return ConstantesGLS.ecrireImages(cheminImages, images, false);
    }

    public static void ecrireImage(String nomFichier, Object image) throws Exception {
        ConstantesGLS.ecrireImage(nomFichier, image, "png");
    }

    public static void ecrireImageTransparente(String nomFichier, Object image, String format) throws Exception {
        ImageIcon imgIcon;
        if (image instanceof byte[]) {
            imgIcon = new ImageIcon((byte[])image);
        } else if (image instanceof Image) {
            imgIcon = new ImageIcon((Image)image);
        } else {
            throw new Exception("ERREUR ECRITURE IMAGE");
        }
        ConstantesGLS.ecrireImage(nomFichier, ImageAppareilPhoto.toTransparentBufferedImage(imgIcon.getImage()), format);
    }

    public static void ecrireImage(String nomFichier, Object image, String format) throws Exception {
        ImageIcon imgIcon;
        if (image instanceof byte[]) {
            imgIcon = new ImageIcon((byte[])image);
        } else if (image instanceof Image) {
            imgIcon = new ImageIcon((Image)image);
        } else {
            throw new Exception("ERREUR ECRITURE IMAGE");
        }
        ConstantesGLS.ecrireImage(nomFichier, ImageAppareilPhoto.toBufferedImage(imgIcon.getImage()), format);
    }

    public static String ecrireImage(String nomFichier, BufferedImage image) throws Exception {
        return ConstantesGLS.ecrireImage(nomFichier, image, "png");
    }

    public static String ecrireImage(String nomFichier, BufferedImage image, String format) throws Exception {
        if (!ConstantesGLS.estVide(nomFichier)) {
            File outDirectory = null;
            try {
                outDirectory = new File(nomFichier);
                if (!outDirectory.exists()) {
                    outDirectory.mkdirs();
                } else {
                    Fichier.effacerFichier(outDirectory);
                }
            }
            catch (Exception e) {
                throw new Exception("IMPOSSIBLE DE CREER LE DOSSIER " + nomFichier, e);
            }
            if (image != null) {
                Graphics2D g = image.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                if (!ImageIO.write((RenderedImage)image, format, new File(nomFichier))) {
                    throw new Exception("Format d'\u00ef\u00bf\u00bdcriture non pris en charge");
                }
                log.debug((Object)("Image " + nomFichier + " ecrite "));
                return nomFichier;
            }
            throw new Exception("Erreur dans l'enregistrement de l'image # L'image n'est pas au bon format byte[] ou Image ");
        }
        throw new Exception("Fichier image vide");
    }

    public static Vector<String> ecrireImages(String cheminImages, Vector images, boolean effacer) throws Exception {
        return ConstantesGLS.ecrireImages(cheminImages, images, "png", effacer);
    }

    public static Vector<String> ecrireImages(String cheminImages, Vector images, String extension, boolean effacer) throws Exception {
        Vector<String> listeImages = new Vector<String>();
        int cpt = 1;
        if (!GLS.estVide(cheminImages) && !GLS.estVide(images)) {
            File outDirectory = null;
            try {
                outDirectory = new File(cheminImages);
                if (!outDirectory.exists()) {
                    outDirectory.mkdirs();
                } else if (effacer) {
                    Fichier.effacerFichiers(outDirectory);
                }
            }
            catch (Exception e) {
                throw new Exception("IMPOSSIBLE DE CREER LE DOSSIER " + cheminImages, e);
            }
            if (!ConstantesGLS.estVide(images)) {
                for (Object b : images) {
                    ImageIcon image = b instanceof byte[] ? new ImageIcon((byte[])b) : (b instanceof Image ? new ImageIcon((Image)b) : null);
                    if (image != null) {
                        BufferedImage bufferedImage = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
                        Graphics2D g = bufferedImage.createGraphics();
                        g.drawImage(image.getImage(), 0, 0, null);
                        g.dispose();
                        cheminImages = Fichier.completerChemin(cheminImages);
                        try {
                            String fichierImage = String.valueOf(cheminImages) + cpt++ + "." + extension;
                            if (!ImageIO.write((RenderedImage)bufferedImage, extension, new File(fichierImage))) {
                                throw new Exception("Format d'\u00ef\u00bf\u00bdcriture non pris en charge");
                            }
                            listeImages.add(fichierImage);
                            log.debug((Object)("Image " + fichierImage + " ecrite " + cheminImages));
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception("Erreur dans l'enregistrement de l'image :", e);
                        }
                    }
                    throw new Exception("Erreur dans l'enregistrement de l'image # L'image n'est pas au bon format byte[] ou Image ");
                }
            } else {
                log.debug((Object)("Aucune image \u00ef\u00bf\u00bd ecrire " + cheminImages));
            }
        } else {
            throw new Exception("Dossier image vide");
        }
        return listeImages;
    }

    public static String[] toTableauString(List vec) {
        if (vec != null && vec.size() > 0) {
            String[] donnees = new String[vec.size()];
            int i = 0;
            while (i < vec.size()) {
                donnees[i] = ConstantesGLS.getString(vec.get(i));
                ++i;
            }
            return donnees;
        }
        return null;
    }

    public static String remplacer(String champ, String ancienneValeur, String nouvelleValeur) {
        if (!ConstantesGLS.estVide(champ)) {
            if (!ConstantesGLS.estNulle(ancienneValeur) && !ConstantesGLS.estNulle(nouvelleValeur)) {
                return champ.replaceAll(ancienneValeur, nouvelleValeur);
            }
            return champ;
        }
        return VAL_STR_NEANT;
    }

    public static String getPremiereLettreMajuscule(String valeur) {
        if (!ConstantesGLS.estVide(valeur)) {
            StringBuilder result = new StringBuilder(valeur);
            result.replace(0, 1, result.substring(0, 1).toUpperCase());
            return result.toString();
        }
        return VAL_STR_NEANT;
    }

    public static String getLowerString(String valeur) {
        return ConstantesGLS.getLowerString(valeur, VAL_STR_NEANT);
    }

    public static String getLowerString(String valeur, String defaut) {
        if (!ConstantesGLS.estVide(valeur)) {
            return valeur.toLowerCase();
        }
        return defaut;
    }

    public static String genereUniqueChaine(String chaine, int longueurRandom, boolean uuid) {
        StringBuilder code = new StringBuilder();
        String codeUnique = GLS.estSansAccent(chaine);
        codeUnique = codeUnique.replace(VAL_STR_ESPACE, VAL_STR_NEANT);
        codeUnique = codeUnique.replace("'", VAL_STR_NEANT);
        if ((codeUnique = codeUnique.toLowerCase()).length() > 10) {
            codeUnique = codeUnique.substring(0, 10);
        }
        code.append(codeUnique);
        if (uuid) {
            String unique = UUID.randomUUID().toString();
            code.append(unique);
        } else {
            Random rnd = new Random();
            int nombre = rnd.nextInt(longueurRandom);
            code.append(String.valueOf(nombre));
        }
        return code.toString();
    }

    public static JPanel creerPanneauAffichage(JLabel label, JComponent component, int hauteur, int largeur) {
        JPanel panneauAffichage = new JPanel(new BorderLayout());
        ConstantesGLS.fixerTailleObjet(label, largeur, 18);
        ConstantesGLS.fixerTailleObjet(component, largeur, hauteur);
        ConstantesGLS.fixerTailleObjet(panneauAffichage, largeur, hauteur + 18);
        panneauAffichage.add((Component)label, "North");
        panneauAffichage.add((Component)component, "Center");
        panneauAffichage.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        panneauAffichage.setBackground(Color.white);
        return panneauAffichage;
    }

    public static String estSansAccent(String source) {
        String chaine = Normalizer.normalize(source, Normalizer.Form.NFD);
        chaine.replaceAll("[\u0300-\u036f]", VAL_STR_NEANT);
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "a");
        source = source.replace("\u00ef\u00bf\u00bd", "a");
        source = source.replace("\u00ef\u00bf\u00bd", "o");
        source = source.replace("\u00ef\u00bf\u00bd", "o");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "i");
        source = source.replace("\u00ef\u00bf\u00bd", "i");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "E");
        source = source.replace("\u00ef\u00bf\u00bd", "E");
        source = source.replace(VAL_STR_ESPACE, VAL_STR_NEANT);
        return chaine;
    }

    public static String formatIdentifiantCompatibleBaliseHTML(String source) {
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "e");
        source = source.replace("\u00ef\u00bf\u00bd", "a");
        source = source.replace("\u00ef\u00bf\u00bd", "a");
        source = source.replace("\u00ef\u00bf\u00bd", "o");
        source = source.replace("\u00ef\u00bf\u00bd", "o");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "i");
        source = source.replace("\u00ef\u00bf\u00bd", "i");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "u");
        source = source.replace("\u00ef\u00bf\u00bd", "E");
        source = source.replace("\u00ef\u00bf\u00bd", "E");
        source = source.replace(":", VAL_STR_NEANT);
        source = source.replace(";", VAL_STR_NEANT);
        source = source.replace("?", VAL_STR_NEANT);
        source = source.replace("!", VAL_STR_NEANT);
        source = source.replace("'", VAL_STR_NEANT);
        source = source.replace(";", VAL_STR_NEANT);
        source = source.replace("/", VAL_STR_NEANT);
        source = source.replace("^", VAL_STR_NEANT);
        source = source.replace("\\", VAL_STR_NEANT);
        source = source.replace("~", VAL_STR_NEANT);
        source = source.replace("*", VAL_STR_NEANT);
        source = source.replace("}", VAL_STR_NEANT);
        source = source.replace("{", VAL_STR_NEANT);
        source = source.replace("[", VAL_STR_NEANT);
        source = source.replace("]", VAL_STR_NEANT);
        source = source.replace("|", VAL_STR_NEANT);
        source = source.replace("#", VAL_STR_NEANT);
        source = source.replace("<", VAL_STR_NEANT);
        source = source.replace(">", VAL_STR_NEANT);
        source = source.replace(".>", VAL_STR_NEANT);
        source = source.replace("\u00ef\u00bf\u00bd", VAL_STR_NEANT);
        source = source.replace("\u00ef\u00bf\u00bd", VAL_STR_NEANT);
        source = source.replace("@", VAL_STR_NEANT);
        source = source.replace(VAL_STR_ESPACE, VAL_STR_NEANT);
        return source;
    }

    public static JPanel creerPanneauAffichage(JLabel label, JComponent component, int hauteur) {
        return ConstantesGLS.creerPanneauAffichage(label, component, hauteur, 416);
    }

    public static JPanel creerPanneauAffichage(String image, JComponent component, int hauteur) {
        return ConstantesGLS.creerPanneauAffichage(new JLabel(new ImageIcon(image)), component, hauteur, 416);
    }

    public static JPanel creerPanneauAffichage(String image, JComponent component, int hauteur, int largeur) {
        return ConstantesGLS.creerPanneauAffichage(new JLabel(new ImageIcon(image)), component, hauteur, largeur);
    }

    public static JLabel creerLabelAffichage(String image) {
        return new JLabel(new ImageIcon(image));
    }
}

