/*
 * Decompiled with CFR 0.152.
 */
package gls.outils;

import gls.outils.ConstantesGLS;

public class CSV {
    public static final String SEPARATEUR_CSV = ";";
    public static final String SEPARATEUR_CSV_SECONDAIRE = "\u00a7";
    public static final char SEPARATEUR_CSV_CHAR = ";".charAt(0);
    public static final char SEPARATEUR_CSV_SECONDAIRE_CHAR = "\u00a7".charAt(0);

    public static String toCSV(String champ) {
        return CSV.toCSV(champ, true);
    }

    public static String toCSV(int champ) {
        return CSV.toCSV(String.valueOf(champ));
    }

    public static String toCSV(String champ, boolean ajouterGuillemets) {
        String champCsv = champ == null ? "" : champ;
        champCsv = ConstantesGLS.remplacer(champCsv, SEPARATEUR_CSV, " ");
        if (ajouterGuillemets) {
            champCsv = "\"" + champCsv + "\"";
        }
        return champCsv;
    }

    public static String ajouterChampsCSV(String ... champs) {
        StringBuffer sb = new StringBuffer();
        if (champs != null && champs.length > 0) {
            sb.append(CSV.toCSV(champs[0]));
            int i = 1;
            while (i < champs.length) {
                String champ = champs[i];
                sb.append(SEPARATEUR_CSV.concat(CSV.toCSV(champ)));
                ++i;
            }
        }
        return sb.toString();
    }

    public static String ajouterChampCSV(String champ) {
        return SEPARATEUR_CSV.concat(CSV.toCSV(champ));
    }

    public static String ajouterChampCSV(int champ) {
        return SEPARATEUR_CSV.concat(CSV.toCSV(champ));
    }
}

