/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.tri;

import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.exception.ErreurTriTroncon;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriRondPoint;
import java.util.Vector;

public class TriRoute
extends Tri {
    private Vector listeEnregistrementsRoute = null;
    private Vector listeTronconDoubleSens = null;
    private Vector listeTronconSensUnique = null;
    private Vector listeTronconRondPoint = null;
    private TriRondPoint triRondPoint = null;
    private boolean routeRondPoint = false;
    private boolean routeDoubleSens = false;
    private boolean routeASensUnique = false;
    private boolean retrier = true;

    public TriRoute() {
    }

    public TriRoute(ICouche couche, Enregistrement troncon, GeoPoint point) {
        this.initialiser(couche, troncon, point);
    }

    public TriRoute(GeoPositionnement geoPositionnement) {
        this.initialiser(geoPositionnement);
    }

    public TriRoute(BretelleInfo bretelleInfo) {
        this.initialiser(bretelleInfo.getGeoPositionnement());
    }

    @Override
    public void initialiser(GeoPositionnement geoPositionnement) {
        boolean rechercherTronconsMemeNom = true;
        this.retrier = true;
        if (this.geoPositionnement != null && this.nomRoute != null) {
            rechercherTronconsMemeNom = !this.nomRoute.equals(geoPositionnement.getTroncon().getNom());
        }
        this.geoPositionnement = geoPositionnement;
        if (rechercherTronconsMemeNom) {
            this.nomRoute = geoPositionnement.getTroncon().getNom();
            this.initialiserListeEnregistrements(geoPositionnement.getTroncon().getCouche(), this.nomRoute);
            this.initialiserTypeRoute(geoPositionnement.getTroncon().getCouche(), this.listeEnregistrementsRoute);
        }
    }

    public void initialiser(ICouche couche, Enregistrement troncon, GeoPoint point) {
        this.initialiser(couche, troncon, point);
    }

    public void initialiser(BretelleInfo bretelleInfo) {
        this.initialiser(bretelleInfo.getGeoPositionnement());
    }

    public void ajouterListeEnregistrements(ICouche couche, String nomRoute) {
        Vector listeEnregistrementsTmp;
        if (couche != null && nomRoute != null && (listeEnregistrementsTmp = Recherche.getTroncons(couche, 1, nomRoute)) != null && listeEnregistrementsTmp.size() > 0) {
            if (this.listeEnregistrementsRoute == null) {
                this.listeEnregistrementsRoute = listeEnregistrementsTmp;
            } else {
                int i = 0;
                while (i < listeEnregistrementsTmp.size()) {
                    this.listeEnregistrementsRoute.add(listeEnregistrementsTmp.get(i));
                    ++i;
                }
            }
        }
    }

    public void initialiserListeEnregistrements(ICouche couche, String nomRoute) {
        if (!LocalisationInfo.rechercheMultiCouche) {
            this.listeEnregistrementsRoute = Recherche.getTroncons(couche, 1, nomRoute);
        } else if (couche != null && (couche.equals("mainroad") || couche.equals("class1"))) {
            this.listeEnregistrementsRoute = Recherche.getTroncons(couche, 1, nomRoute);
        } else {
            this.listeEnregistrementsRoute = null;
            int i = 1;
            while (i < LocalisationInfo.LISTE_ROUTES_PRINCIPALES.length - 1) {
                this.ajouterListeEnregistrements(LocalisationInfo.getCouche(LocalisationInfo.LISTE_ROUTES_PRINCIPALES[i]), nomRoute);
                ++i;
            }
        }
    }

    public Vector getListeTronconsSensUnique() {
        return this.listeTronconSensUnique;
    }

    public Vector getListeTronconsDoubleSens() {
        return this.listeTronconDoubleSens;
    }

    private void initialiserTypeRoute(ICouche couche, Vector listeEnregistrements) {
        LocalisationInfo.ecrireLog("+--> Definition du type de la route et tri de la route");
        if (listeEnregistrements != null) {
            boolean finRecherche = false;
            boolean finListe = false;
            int i = 0;
            int nbEnregistrements = listeEnregistrements.size();
            finListe = nbEnregistrements == 0;
            this.listeTronconDoubleSens = null;
            this.listeTronconSensUnique = null;
            this.listeTronconDoubleSens = new Vector();
            this.listeTronconSensUnique = new Vector();
            while (!finListe) {
                InfoTroncon troncon = (InfoTroncon)listeEnregistrements.get(i);
                if (troncon.estADoubleSens()) {
                    this.listeTronconDoubleSens.add(troncon);
                } else if (troncon.estASensUnique()) {
                    this.listeTronconSensUnique.add(troncon);
                }
                boolean bl = finListe = ++i == nbEnregistrements;
            }
            if (this.listeTronconRondPoint == null) {
                this.listeTronconRondPoint = LocalisationInfo.getListeTronconRondPoint();
            }
            LocalisationInfo.ecrireLog("+--> Nb troncon double sens " + this.listeTronconDoubleSens.size());
            LocalisationInfo.ecrireLog("+--> Nb troncon sens unique " + this.listeTronconSensUnique.size());
            LocalisationInfo.ecrireLog("+--> Nb troncon rond point " + this.listeTronconRondPoint.size());
            this.routeRondPoint = true;
            this.routeDoubleSens = this.listeTronconDoubleSens.size() > 0;
            this.routeASensUnique = !this.routeDoubleSens && this.listeTronconSensUnique.size() > 0;
        }
    }

    @Override
    public void trier() {
        this.trier(true);
    }

    @Override
    public boolean estBretelle() {
        return false;
    }

    public boolean estASensVariable() {
        return this.routeDoubleSens;
    }

    public boolean estASensUnique() {
        return this.routeASensUnique;
    }

    private boolean estRondPointFinDeRoute(InfoTroncon troncon) {
        if (this.triRondPoint == null) {
            this.triRondPoint = new TriRondPoint();
            this.triRondPoint.setTriRoute(this);
        }
        this.triRondPoint.initialiser(troncon);
        return this.triRondPoint.estEnFinDeRoute();
    }

    public void trier(boolean sensChainageOk) {
        this.initialiserInversionTronconDepart(sensChainageOk);
        LocalisationInfo.ecrireLog("+--> Retrier " + this.retrier + " -- " + sensChainageOk + " - ");
        if (this.retrier) {
            this.listeTronconSuivant = null;
            this.listeTronconPrecedent = null;
            try {
                this.listeTronconSuivant = this.getTronconsChaines(sensChainageOk, true);
                this.listeTronconPrecedent = this.getTronconsChaines(sensChainageOk, false);
                LocalisationInfo.ecrireLogDebug("InfoTri --> Suivants " + this.listeTronconSuivant.size() + " -- Precedents " + this.listeTronconPrecedent.size());
            }
            catch (ErreurTriTroncon e) {
                LocalisationInfo.ecrireLog("#--> ERREUR TRI TRONCON " + e.toString());
            }
        }
    }

    public Vector getTronconsChaines(ICouche couche, Enregistrement troncon, boolean sensChainageOk, boolean sensPositif) throws ErreurTriTroncon {
        Vector vector = sensChainageOk ? (sensPositif ? this.getTronconsSuivant(troncon, couche) : this.getTronconsPrecedent(troncon, couche)) : (sensPositif ? this.getTronconsInverseSuivant(troncon, couche) : this.getTronconsInversePrecedent(troncon, couche));
        return vector;
    }

    public Vector getTronconsChaines(boolean sensChainageOk, boolean sensPositif) throws ErreurTriTroncon {
        Vector vector = sensChainageOk ? (sensPositif ? this.getTronconsSuivant(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche()) : this.getTronconsPrecedent(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche())) : (sensPositif ? this.getTronconsInverseSuivant(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche()) : this.getTronconsInversePrecedent(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche()));
        return vector;
    }

    @Override
    public Vector getTronconsPrecedent(Enregistrement tronconDebut, ICouche couche) {
        InfoTroncon infoTroncon = new InfoTroncon(tronconDebut, couche);
        if (infoTroncon.getDF().equals("2")) {
            infoTroncon.setInverse(true);
        }
        return this.getTronconsPrecedent(infoTroncon);
    }

    public Vector getTronconsPrecedent(InfoTroncon infoTronconDepart) {
        return this.getTronconsPrecedent(infoTronconDepart, this.getListeIdgdfSuivant());
    }

    public Vector getTronconsPrecedent(InfoTroncon infoTronconDepart, Vector<String> vecIdgdf) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTroncon = null;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector listeTronconsSensUniquePrecedent = null;
        InfoTroncon dernierInfoTroncon = new InfoTroncon();
        boolean verifierErreurChainageTronconSensUnique = false;
        boolean initialiserListeTronconsUniquePrecedent = false;
        infoTroncon = new InfoTroncon();
        infoTroncon.set(infoTronconDepart);
        vecIdgdf.add(infoTronconDepart.getIdgdf());
        if (infoTroncon.estInverse()) {
            inverser = true;
            infoTroncon.inverserPoints();
        }
        LocalisationInfo.ecrireLog("+--> TRI troncon Precedent double sens");
        while (!finRecherche) {
            if (inverser) {
                inverser = false;
                if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("2")) {
                                        inverser = true;
                                    }
                                }
                            } else {
                                if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                                if (listeTronconsSensUniquePrecedent != null) {
                                    verifierErreurChainageTronconSensUnique = true;
                                }
                            }
                        } else {
                            inverser = true;
                        }
                    }
                } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("2")) {
                                        inverser = true;
                                    }
                                }
                            } else if (infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                        } else {
                            inverser = true;
                            initialiserListeTronconsUniquePrecedent = true;
                        }
                    } else {
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon)) == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                        } else if (infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        LocalisationInfo.ecrireLog("+--> Infotroncon " + infoTronconTmp);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                            }
                        } else {
                            if (infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                            if (listeTronconsSensUniquePrecedent != null) {
                                verifierErreurChainageTronconSensUnique = true;
                            }
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                            }
                        } else if (infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else {
                    initialiserListeTronconsUniquePrecedent = true;
                }
            } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon)) == null) {
                infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else if (infoTronconTmp.getDF().equals("2")) {
                        inverser = true;
                    }
                } else {
                    inverser = true;
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, infoTronconTmp.getIdgdf())) {
                infoTronconTmp.setInverse(inverser);
                if (initialiserListeTronconsUniquePrecedent) {
                    dernierInfoTroncon.set(infoTroncon);
                    listeTronconsSensUniquePrecedent = this.rechercherListeTronconSensUniqueTmp(infoTroncon);
                    initialiserListeTronconsUniquePrecedent = false;
                }
                if (verifierErreurChainageTronconSensUnique) {
                    if (LocalisationInfo.estDejaParcouru(listeTronconsSensUniquePrecedent, infoTronconTmp.getIdgdf())) {
                        infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, dernierInfoTroncon);
                        if (infoTronconTmp == null) {
                            LocalisationInfo.ecrireLog("#--> ERREUR de chainage vecteur double sens -> simple sens");
                            return vector;
                        }
                        if (infoTronconTmp.getDF().equals("2")) {
                            infoTronconTmp.setInverse(true);
                            inverser = true;
                        } else {
                            infoTronconTmp.setInverse(false);
                            inverser = false;
                        }
                        while (vector.size() > 0 && LocalisationInfo.estTronconDoubleSens((InfoTroncon)vector.get(vector.size() - 1))) {
                            LocalisationInfo.ecrireLog("+--> Suppression troncon double sens");
                            vector.remove(vector.size() - 1);
                        }
                        infoTroncon.set(dernierInfoTroncon);
                        listeTronconsSensUniquePrecedent = null;
                        LocalisationInfo.ecrireLog("+--> Erreur corrig\u00e9e " + infoTronconTmp.getIdgdf());
                    }
                    verifierErreurChainageTronconSensUnique = false;
                }
                infoTroncon.set(infoTronconTmp);
                vector.add(new InfoTroncon(infoTronconTmp));
                vecIdgdf.add(infoTronconTmp.getIdgdf());
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }

    public Vector getTronconsInversePrecedent() {
        return this.getTronconsInversePrecedent(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche());
    }

    public Vector getTronconsInversePrecedent(Enregistrement tronconDebut, ICouche couche) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = new Vector<String>();
        Vector listeTronconsSensUniquePrecedent = null;
        InfoTroncon dernierInfoTroncon = new InfoTroncon();
        boolean verifierErreurChainageTronconSensUnique = false;
        boolean initialiserListeTronconsUniquePrecedent = false;
        InfoTroncon infoTroncon = new InfoTroncon(tronconDebut, couche);
        LocalisationInfo.ecrireLog("+--> TRI troncon inverse precedent double sens");
        while (!finRecherche) {
            String idgdfCourant = infoTroncon.getIdgdf();
            if (inverser) {
                inverser = false;
                if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("3")) {
                                        inverser = true;
                                    }
                                }
                            } else {
                                if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                                if (listeTronconsSensUniquePrecedent != null) {
                                    verifierErreurChainageTronconSensUnique = true;
                                }
                            }
                        } else {
                            inverser = true;
                        }
                    }
                } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("3")) {
                                        inverser = true;
                                    }
                                }
                            } else if (infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                        } else {
                            inverser = true;
                            initialiserListeTronconsUniquePrecedent = true;
                        }
                    } else {
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon)) == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null && infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                        } else if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                            }
                        } else {
                            if (infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                            if (listeTronconsSensUniquePrecedent != null) {
                                verifierErreurChainageTronconSensUnique = true;
                            }
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                            }
                        } else if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else {
                    initialiserListeTronconsUniquePrecedent = true;
                }
            } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon)) == null) {
                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else if (infoTronconTmp.getDF().equals("3")) {
                        inverser = true;
                    }
                } else {
                    inverser = true;
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, idgdfCourant)) {
                infoTronconTmp.setInverse(!inverser);
                if (initialiserListeTronconsUniquePrecedent) {
                    dernierInfoTroncon.set(infoTroncon);
                    listeTronconsSensUniquePrecedent = this.rechercherListeTronconSensUniqueTmp(infoTroncon);
                    initialiserListeTronconsUniquePrecedent = false;
                }
                if (verifierErreurChainageTronconSensUnique) {
                    if (LocalisationInfo.estDejaParcouru(listeTronconsSensUniquePrecedent, infoTronconTmp.getIdgdf())) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, dernierInfoTroncon);
                        if (infoTronconTmp == null) {
                            LocalisationInfo.ecrireLog("#--> ERREUR de chainage vecteur double sens -> simple sens");
                            return vector;
                        }
                        if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                            infoTronconTmp.setInverse(!inverser);
                        } else {
                            inverser = false;
                            infoTronconTmp.setInverse(!inverser);
                        }
                        while (vector.size() > 0 && LocalisationInfo.estTronconDoubleSens((InfoTroncon)vector.get(vector.size() - 1))) {
                            LocalisationInfo.ecrireLog("+--> Suppression troncon double sens");
                            vector.remove(vector.size() - 1);
                        }
                        infoTroncon.set(dernierInfoTroncon);
                        listeTronconsSensUniquePrecedent = null;
                        LocalisationInfo.ecrireLog("+--> Erreur corrig\u00e9e " + infoTronconTmp.getIdgdf());
                    }
                    verifierErreurChainageTronconSensUnique = false;
                }
                infoTroncon.set(infoTronconTmp);
                vector.add(new InfoTroncon(infoTronconTmp));
                vecIdgdf.add(idgdfCourant);
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }

    public Vector getTronconsInverseSuivant() {
        return this.getTronconsInverseSuivant(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche());
    }

    public Vector getTronconsInverseSuivant(Enregistrement tronconDebut, ICouche couche) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTroncon = null;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = new Vector<String>();
        Vector listeTronconsSensUniquePrecedent = null;
        InfoTroncon dernierInfoTroncon = new InfoTroncon();
        boolean verifierErreurChainageTronconSensUnique = false;
        boolean initialiserListeTronconsUniquePrecedent = false;
        infoTroncon = new InfoTroncon(tronconDebut, couche);
        LocalisationInfo.ecrireLog("+--> TRI troncon inverse suivant double sens");
        while (!finRecherche) {
            String idgdfCourant = infoTroncon.getIdgdf();
            if (inverser) {
                inverser = false;
                if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("3")) {
                                        inverser = true;
                                    }
                                }
                            } else {
                                if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                                if (listeTronconsSensUniquePrecedent != null) {
                                    verifierErreurChainageTronconSensUnique = true;
                                }
                            }
                        } else {
                            inverser = true;
                        }
                    }
                } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("3")) {
                                        inverser = true;
                                    }
                                }
                            } else if (infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                        } else {
                            inverser = true;
                            initialiserListeTronconsUniquePrecedent = true;
                        }
                    } else {
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon)) == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null && infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                        } else if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                            }
                        } else {
                            if (infoTronconTmp.getDF().equals("3")) {
                                inverser = true;
                            }
                            if (listeTronconsSensUniquePrecedent != null) {
                                verifierErreurChainageTronconSensUnique = true;
                            }
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("3")) {
                                    inverser = true;
                                }
                            }
                        } else if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else {
                    initialiserListeTronconsUniquePrecedent = true;
                }
            } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon)) == null) {
                infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                        }
                    } else if (infoTronconTmp.getDF().equals("3")) {
                        inverser = true;
                    }
                } else {
                    inverser = true;
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, idgdfCourant)) {
                infoTronconTmp.setInverse(!inverser);
                if (initialiserListeTronconsUniquePrecedent) {
                    dernierInfoTroncon.set(infoTroncon);
                    listeTronconsSensUniquePrecedent = this.rechercherListeTronconSensUniqueTmp(infoTroncon);
                    initialiserListeTronconsUniquePrecedent = false;
                }
                if (verifierErreurChainageTronconSensUnique) {
                    if (LocalisationInfo.estDejaParcouru(listeTronconsSensUniquePrecedent, infoTronconTmp.getIdgdf())) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, dernierInfoTroncon);
                        if (infoTronconTmp == null) {
                            LocalisationInfo.ecrireLog("#--> ERREUR de chainage vecteur double sens -> simple sens");
                            return vector;
                        }
                        if (infoTronconTmp.getDF().equals("3")) {
                            inverser = true;
                            infoTronconTmp.setInverse(!inverser);
                        } else {
                            inverser = false;
                            infoTronconTmp.setInverse(!inverser);
                        }
                        while (vector.size() > 0 && LocalisationInfo.estTronconDoubleSens((InfoTroncon)vector.get(vector.size() - 1))) {
                            LocalisationInfo.ecrireLog("+--> Suppression troncon double sens");
                            vector.remove(vector.size() - 1);
                        }
                        infoTroncon.set(dernierInfoTroncon);
                        listeTronconsSensUniquePrecedent = null;
                        LocalisationInfo.ecrireLog("+--> Erreur corrig\u00e9e " + infoTronconTmp.getIdgdf());
                    }
                    verifierErreurChainageTronconSensUnique = false;
                }
                infoTroncon.set(infoTronconTmp);
                vector.add(new InfoTroncon(infoTronconTmp));
                vecIdgdf.add(idgdfCourant);
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }

    private Vector rechercherListeTronconSensUniqueTmp(InfoTroncon infoTroncon) {
        Vector<String> vector = new Vector<String>();
        boolean finRecherche = false;
        InfoTroncon infoTronconTmp = new InfoTroncon();
        InfoTroncon infoTronconCourant = new InfoTroncon();
        boolean memeIdgdfTrouve = false;
        infoTronconCourant.set(infoTroncon);
        if (infoTronconCourant.getDF().equals("2")) {
            infoTronconCourant.inverserPoints();
        }
        String idgdfDebut = infoTronconCourant.getIdgdf();
        LocalisationInfo.ecrireLogDebug("Recherche liste troncons sens unique tmp " + idgdfDebut);
        vector.add(idgdfDebut);
        while (!finRecherche) {
            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
            if (infoTronconTmp == null) {
                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
            }
            if (infoTronconTmp != null) {
                if (!infoTronconTmp.getIdgdf().equals(idgdfDebut) && !LocalisationInfo.estDejaParcouru(vector, infoTronconTmp.getIdgdf())) {
                    vector.add(infoTronconTmp.getIdgdf());
                    infoTronconCourant.set(infoTronconTmp);
                    if (!infoTronconCourant.getDF().equals("2")) continue;
                    infoTronconCourant.inverserPoints();
                    continue;
                }
                memeIdgdfTrouve = true;
                finRecherche = true;
                continue;
            }
            finRecherche = true;
        }
        if (!memeIdgdfTrouve) {
            infoTronconCourant.set(infoTroncon);
            finRecherche = false;
            if (infoTronconCourant.getDF().equals("2")) {
                infoTronconCourant.inverserPoints();
            }
            while (!finRecherche) {
                infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
                }
                if (infoTronconTmp != null) {
                    if (!infoTronconTmp.getIdgdf().equals(idgdfDebut) && !LocalisationInfo.estDejaParcouru(vector, infoTronconTmp.getIdgdf())) {
                        vector.add(infoTronconTmp.getIdgdf());
                        infoTronconCourant.set(infoTronconTmp);
                        if (!infoTronconCourant.getDF().equals("2")) continue;
                        infoTronconCourant.inverserPoints();
                        continue;
                    }
                    memeIdgdfTrouve = true;
                    finRecherche = true;
                    continue;
                }
                finRecherche = true;
            }
            if (!memeIdgdfTrouve && infoTronconCourant != null) {
                boolean tronconSensUniqueTrouve = false;
                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTronconCourant);
                if (infoTronconTmp != null) {
                    finRecherche = false;
                    infoTronconCourant.set(infoTronconTmp);
                    if (infoTronconCourant.getDF().equals("2")) {
                        infoTronconCourant.inverserPoints();
                    }
                    while (!finRecherche) {
                        infoTronconTmp = TriRoute.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTronconCourant);
                        } else {
                            tronconSensUniqueTrouve = true;
                        }
                        if (infoTronconTmp != null) {
                            if (!infoTronconTmp.getIdgdf().equals(idgdfDebut) && !LocalisationInfo.estDejaParcouru(vector, infoTronconTmp.getIdgdf())) {
                                if (tronconSensUniqueTrouve) {
                                    finRecherche = true;
                                }
                                vector.add(infoTronconTmp.getIdgdf());
                                infoTronconCourant.set(infoTronconTmp);
                                if (!infoTronconCourant.getDF().equals("2")) continue;
                                infoTronconCourant.inverserPoints();
                                continue;
                            }
                            memeIdgdfTrouve = true;
                            finRecherche = true;
                            continue;
                        }
                        finRecherche = true;
                    }
                    if (tronconSensUniqueTrouve) {
                        finRecherche = false;
                        while (!finRecherche) {
                            infoTronconTmp = TriRoute.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTronconCourant);
                            if (infoTronconTmp != null) {
                                if (!infoTronconTmp.getIdgdf().equals(idgdfDebut) && !LocalisationInfo.estDejaParcouru(vector, infoTronconTmp.getIdgdf())) {
                                    vector.add(infoTronconTmp.getIdgdf());
                                    infoTronconCourant.set(infoTronconTmp);
                                    if (!infoTronconTmp.getDF().equals("2")) continue;
                                    infoTronconCourant.inverserPoints();
                                    continue;
                                }
                                memeIdgdfTrouve = true;
                                finRecherche = true;
                                continue;
                            }
                            finRecherche = true;
                        }
                    }
                }
            }
        }
        return vector;
    }

    @Override
    public Vector getTronconsSuivant(Enregistrement tronconDebut, ICouche couche) {
        InfoTroncon infoTroncon = new InfoTroncon(tronconDebut, couche);
        if (infoTroncon.getDF().equals("2")) {
            infoTroncon.setInverse(true);
        }
        return this.getTronconsSuivant(infoTroncon);
    }

    public Vector getTronconsSuivant(InfoTroncon infoTronconDepart) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = new Vector<String>();
        Vector listeTronconsSensUniquePrecedent = null;
        InfoTroncon dernierInfoTroncon = new InfoTroncon();
        boolean verifierErreurChainageTronconSensUnique = false;
        boolean initialiserListeTronconsUniquePrecedent = false;
        boolean verifierRondPoint = false;
        InfoTroncon infoTroncon = new InfoTroncon();
        infoTroncon.set(infoTronconDepart);
        vecIdgdf.add(infoTronconDepart.getIdgdf());
        if (infoTroncon.estInverse()) {
            inverser = true;
            infoTroncon.inverserPoints();
        }
        LocalisationInfo.ecrireLog("+--> TRI troncon suivant double sens");
        while (!finRecherche) {
            if (inverser) {
                inverser = false;
                if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("2")) {
                                        inverser = true;
                                    }
                                }
                            } else {
                                if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                                if (listeTronconsSensUniquePrecedent != null) {
                                    verifierErreurChainageTronconSensUnique = true;
                                }
                            }
                        } else {
                            inverser = true;
                        }
                    }
                } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                    infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                            if (infoTronconTmp == null) {
                                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                                if (infoTronconTmp != null) {
                                    if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                        infoTronconTmp = null;
                                    } else if (infoTronconTmp.getDF().equals("2")) {
                                        inverser = true;
                                    }
                                }
                            } else if (infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                        } else {
                            inverser = true;
                            initialiserListeTronconsUniquePrecedent = true;
                        }
                    } else {
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon)) == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                        } else if (infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconDoubleSens(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                            }
                        } else {
                            if (infoTronconTmp.getDF().equals("2")) {
                                inverser = true;
                            }
                            if (listeTronconsSensUniquePrecedent != null) {
                                verifierErreurChainageTronconSensUnique = true;
                            }
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else if (LocalisationInfo.estTronconSensUnique(infoTroncon)) {
                infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                        if (infoTronconTmp == null) {
                            infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                            if (infoTronconTmp != null) {
                                if (this.estRondPointFinDeRoute(infoTronconTmp)) {
                                    infoTronconTmp = null;
                                } else if (infoTronconTmp.getDF().equals("2")) {
                                    inverser = true;
                                }
                            }
                        } else if (infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                        initialiserListeTronconsUniquePrecedent = true;
                    }
                } else {
                    initialiserListeTronconsUniquePrecedent = true;
                }
            } else if (this.routeRondPoint && (infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon)) == null) {
                infoTronconTmp = TriRoute.rechercherTronconInverseSuivantDansListeContrainteGeographique(this.listeTronconDoubleSens, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconSensUnique, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDF(this.listeTronconRondPoint, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else if (infoTronconTmp.getDF().equals("2")) {
                        inverser = true;
                    }
                } else {
                    inverser = true;
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, infoTronconTmp.getIdgdf())) {
                infoTronconTmp.setInverse(inverser);
                if (initialiserListeTronconsUniquePrecedent) {
                    dernierInfoTroncon.set(infoTroncon);
                    listeTronconsSensUniquePrecedent = this.rechercherListeTronconSensUniqueTmp(infoTroncon);
                    initialiserListeTronconsUniquePrecedent = false;
                }
                if (verifierErreurChainageTronconSensUnique) {
                    if (LocalisationInfo.estDejaParcouru(listeTronconsSensUniquePrecedent, infoTronconTmp.getIdgdf())) {
                        infoTronconTmp = TriRoute.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(this.listeTronconSensUnique, dernierInfoTroncon);
                        if (infoTronconTmp == null) {
                            LocalisationInfo.ecrireLog("#--> ERREUR de chainage vecteur double sens -> simple sens");
                            return vector;
                        }
                        if (infoTronconTmp.getDF().equals("2")) {
                            infoTronconTmp.setInverse(true);
                            inverser = true;
                        } else {
                            infoTronconTmp.setInverse(false);
                            inverser = false;
                        }
                        LocalisationInfo.ecrireLog("+--> taille vecteur " + vector.size());
                        while (vector.size() > 0 && LocalisationInfo.estTronconDoubleSens((InfoTroncon)vector.get(vector.size() - 1))) {
                            LocalisationInfo.ecrireLog("+--> Suppression troncon double sens");
                            vector.remove(vector.size() - 1);
                        }
                        infoTroncon.set(dernierInfoTroncon);
                        listeTronconsSensUniquePrecedent = null;
                        LocalisationInfo.ecrireLog("+--> Erreur corrig\u00e9e " + infoTronconTmp.getIdgdf());
                    }
                    verifierErreurChainageTronconSensUnique = false;
                }
                infoTroncon.set(infoTronconTmp);
                vector.add(new InfoTroncon(infoTronconTmp));
                vecIdgdf.add(infoTronconTmp.getIdgdf());
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }
}

