/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.tri;

import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriRoute;
import java.util.Vector;

public class TriRondPoint
extends Tri {
    private Vector listeTronconsAssociesRondPoint = null;
    private int nbTronconsSensUnique = -1;
    private int nbTronconsDoubleSens = -1;
    private TriRoute triRoute;

    public TriRondPoint() {
    }

    public TriRondPoint(InfoTroncon troncon, TriRoute triRoute) {
        this.initialiser(troncon, triRoute);
    }

    public void setTriRoute(TriRoute triRoute) {
        this.triRoute = triRoute;
    }

    public void initialiser(InfoTroncon troncon) {
        if (this.triRoute != null && troncon != null) {
            this.listeTronconsAssociesRondPoint = this.getTronconsAssociesRondPoint(troncon, this.triRoute);
            this.initialiserTriRondPoint();
        }
    }

    public void initialiser(InfoTroncon troncon, TriRoute triRoute) {
        if (triRoute != null && troncon != null) {
            this.triRoute = triRoute;
            this.listeTronconsAssociesRondPoint = this.getTronconsAssociesRondPoint(troncon, triRoute);
            this.initialiserTriRondPoint();
        }
    }

    public boolean tronconsSensUniquesDansMemeSens() {
        boolean memeSens;
        block5: {
            if (this.getNbTronconsAssocies() == 2 && this.nbTronconsSensUnique == 2) {
                try {
                    InfoTroncon troncon1 = this.getTronconAssocie(0);
                    InfoTroncon troncon2 = this.getTronconAssocie(1);
                    if (Geometry.getSensGeographique(troncon1) == Geometry.getSensGeographique(troncon2)) {
                        memeSens = true;
                        break block5;
                    }
                    memeSens = false;
                }
                catch (Exception e) {
                    memeSens = false;
                }
            } else {
                memeSens = false;
            }
        }
        return memeSens;
    }

    public void initialiserTriRondPoint() {
        int nbTronconsAssocies = this.getNbTronconsAssocies();
        if (nbTronconsAssocies > 0) {
            this.nbTronconsSensUnique = 0;
            this.nbTronconsDoubleSens = 0;
            int i = 0;
            while (i < nbTronconsAssocies) {
                InfoTroncon troncon = this.getTronconAssocie(i);
                if (troncon != null) {
                    if (troncon.estADoubleSens()) {
                        ++this.nbTronconsDoubleSens;
                    } else if (troncon.estASensUnique()) {
                        ++this.nbTronconsSensUnique;
                    }
                }
                ++i;
            }
        } else {
            this.nbTronconsSensUnique = -1;
            this.nbTronconsDoubleSens = -1;
        }
    }

    public int getNbTronconsASensUnique() {
        return this.nbTronconsSensUnique;
    }

    public int getNbTronconsADoubleSens() {
        return this.nbTronconsDoubleSens;
    }

    public boolean estEnFinDeRoute() {
        int nbChoixSortie = this.nbTronconsSensUnique + this.nbTronconsDoubleSens * 2;
        if (nbChoixSortie < 3) {
            LocalisationInfo.ecrireLogDebug("Rond point fin de route true " + nbChoixSortie);
            return true;
        }
        LocalisationInfo.ecrireLogDebug("Rond point fin de route false " + nbChoixSortie);
        return false;
    }

    public int getNbTronconsAssocies() {
        if (this.listeTronconsAssociesRondPoint != null) {
            return this.listeTronconsAssociesRondPoint.size();
        }
        return -1;
    }

    public InfoTroncon getTronconAssocie(int i) {
        if (i < this.getNbTronconsAssocies() && i >= 0) {
            return (InfoTroncon)this.listeTronconsAssociesRondPoint.get(i);
        }
        return null;
    }

    @Override
    public void initialiser(GeoPositionnement geoPositionnement) {
    }

    @Override
    public Vector getTronconsSuivant(Enregistrement troncon, ICouche couche) {
        return null;
    }

    @Override
    public Vector getTronconsPrecedent(Enregistrement troncon, ICouche couche) {
        return null;
    }

    @Override
    public void trier() {
    }

    @Override
    public boolean estBretelle() {
        return false;
    }

    public Vector getTronconsAssociesRondPoint(InfoTroncon troncon, TriRoute triRoute) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = new Vector<String>();
        Vector<String> vecIdgdfTroncons = new Vector<String>();
        Object listeTronconsSensUniquePrecedent = null;
        InfoTroncon dernierInfoTroncon = new InfoTroncon();
        boolean verifierErreurChainageTronconSensUnique = false;
        boolean initialiserListeTronconsUniquePrecedent = false;
        InfoTroncon infoTroncon = new InfoTroncon(troncon.getTroncon(), troncon.getCouche());
        if (infoTroncon.getDF().equals("2")) {
            inverser = true;
            infoTroncon.inverserPoints();
        }
        LocalisationInfo.ecrireLog("+--> TRI rond point");
        while (!finRecherche) {
            String idgdfCourant = infoTroncon.getIdgdf();
            infoTronconTmp = TriRondPoint.rechercherTronconSuivantDansListeContrainteGeographique(triRoute.getListeTronconsDoubleSens(), infoTroncon);
            if (infoTronconTmp == null && (infoTronconTmp = TriRondPoint.rechercherTronconInverseSuivantDansListeContrainteGeographique(triRoute.getListeTronconsDoubleSens(), infoTroncon)) == null && (infoTronconTmp = TriRondPoint.rechercherTronconSuivantDansListeContrainteGeographiqueDF(triRoute.getListeTronconsSensUnique(), infoTroncon)) == null) {
                infoTronconTmp = TriRondPoint.rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(triRoute.getListeTronconsSensUnique(), infoTroncon);
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdfTroncons, infoTronconTmp.getIdgdf())) {
                vecIdgdfTroncons.add(infoTronconTmp.getIdgdf());
                vector.add(infoTronconTmp);
            }
            if (inverser) {
                inverser = false;
                infoTronconTmp = TriRondPoint.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(LocalisationInfo.getListeTronconRondPoint(), infoTroncon);
                if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                    inverser = true;
                }
            } else {
                infoTronconTmp = TriRondPoint.rechercherTronconSuivantDansListeContrainteGeographiqueDF(LocalisationInfo.getListeTronconRondPoint(), infoTroncon);
                if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                    inverser = true;
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, idgdfCourant)) {
                infoTronconTmp.setInverse(inverser);
                infoTroncon.set(infoTronconTmp);
                vecIdgdf.add(idgdfCourant);
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }
}

