/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.tri;

import cartoj.ICouche;
import gls.geometry.GeoPositionnement;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.exception.ErreurTriTroncon;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriBretelle;
import gls.localisation.tri.TriRoute;

public class TriFactory {
    public static Tri initialiser(Localisation localisation, GeoPositionnement geoPositionnement, Tri tri) {
        LocalisationInfo.ecrireLog("+--> Initialisation tri ");
        if (tri == null) {
            if (LocalisationInfo.estCoucheBretelle(geoPositionnement.getTroncon().getCouche())) {
                TriBretelle triBretelle = new TriBretelle(geoPositionnement);
                triBretelle.setVerrouillerIdgdfBretelle(localisation.getVerrouillageIdgdfRouteAssociee(), localisation.getIdgdfRouteAssociee());
                triBretelle.setVerrouillerNomRoute(localisation.getVerrouillageNomRoute(), localisation.getRoute());
                return triBretelle;
            }
            return new TriRoute(geoPositionnement);
        }
        if (LocalisationInfo.estCoucheBretelle(geoPositionnement.getTroncon().getCouche())) {
            LocalisationInfo.ecrireLog("+--> Init bretelle");
            if (tri instanceof TriBretelle) {
                tri.initialiser(geoPositionnement);
            } else {
                tri = null;
                tri = new TriBretelle(geoPositionnement);
            }
            LocalisationInfo.ecrireLog("+--> Init bretelle Ok");
            if (localisation.getSens().get() == 3) {
                localisation.getSens().set(1);
            }
        } else {
            if (tri instanceof TriRoute) {
                tri.initialiser(geoPositionnement);
            } else {
                tri = null;
                tri = new TriRoute(geoPositionnement);
            }
            if (tri.getTronconDepart().estUnRondPoint() && localisation.getSens().get() == 3) {
                localisation.getSens().set(1);
            }
        }
        return tri;
    }

    public static void trier(Localisation localisation, Tri tri) throws ErreurTriTroncon {
        if (tri.estBretelle()) {
            tri.trier();
            if (((TriBretelle)tri).aDesRoutesAssociees()) {
                LocalisationInfo.ecrireLog("+--> Tri de la route associ\u00e9e");
                ((TriBretelle)tri).trierRouteAssociee();
            }
        } else {
            ((TriRoute)tri).trier(localisation.getSens().getSensChainageOk());
        }
    }

    public static TriRoute getTriRoute(Tri tri) {
        if (tri != null) {
            if (tri.estBretelle()) {
                return ((TriBretelle)tri).getTriRouteAssociee();
            }
            return (TriRoute)tri;
        }
        return null;
    }

    public static ICouche getCoucheRoute(Tri tri) {
        if (tri != null) {
            if (tri.estBretelle()) {
                return ((TriBretelle)tri).getTriRouteAssociee().getGeoPositionnement().getTroncon().getCouche();
            }
            return ((TriRoute)tri).getGeoPositionnement().getTroncon().getCouche();
        }
        return null;
    }
}

