/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.tri;

import cartoj.Enregistrement;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriRoute;
import gls.outils.GLS;
import java.util.Vector;

public class TriBretelle
extends Tri {
    private Vector listeTronconsBretelle = null;
    private ICouche coucheBretelle = null;
    private IFichierDon donBretelle = null;
    private IFichierCont contBretelle = null;
    private Vector listeTronconBretelle = null;
    private Vector listeRoutesAssociees = null;
    private String idgdfRoute = null;
    private BretelleInfo bretelleInfoAssociee = null;
    private TriRoute triRouteAssociee = null;
    private boolean verrouillerIdgdfBretelle = false;
    private boolean verrouillerNomRoute = false;
    private boolean clicDroit = false;
    private boolean retrier = true;

    public TriBretelle() {
    }

    public TriBretelle(GeoPositionnement geoPositionnement) {
        this.initialiser(geoPositionnement);
    }

    public TriBretelle(ICouche ICouche2, Enregistrement troncon, GeoPoint point) {
        this.initialiser(ICouche2, troncon, point);
    }

    @Override
    public void initialiser(GeoPositionnement geoPositionnement) {
        this.retrier = true;
        this.setCoucheBretelle(geoPositionnement.getTroncon().getCouche());
        if (this.geoPositionnement != null) {
            this.retrier = !this.getTronconDepart().equals(geoPositionnement.getTroncon());
        }
        this.geoPositionnement = geoPositionnement;
        if (!this.verrouillerNomRoute) {
            this.setVerrouillerNomRoute(null);
        }
        if (!this.verrouillerIdgdfBretelle) {
            this.setVerrouillerIdgdfBretelle(null);
        }
    }

    public void initialiser(ICouche ICouche2, Enregistrement troncon, GeoPoint point) {
        this.initialiser(new GeoPositionnement(point, troncon, ICouche2));
    }

    private void setCoucheBretelle(ICouche ICouche2) {
        if (ICouche2.getNom().equals("sliproad")) {
            this.coucheBretelle = LocalisationInfo.getCoucheBretelleSecondaire();
            this.donBretelle = LocalisationInfo.getDonBretelleSecondaire();
            this.contBretelle = LocalisationInfo.getContBretelleSecondaire();
            this.listeTronconBretelle = LocalisationInfo.getListeTronconBretelleSecondaire();
        } else if (ICouche2.getNom().equals("sliproad2")) {
            this.coucheBretelle = LocalisationInfo.getCoucheBretellePrincipale();
            this.donBretelle = LocalisationInfo.getDonBretellePrincipale();
            this.contBretelle = LocalisationInfo.getContBretellePrincipale();
            this.listeTronconBretelle = LocalisationInfo.getListeTronconBretellePrincipale();
        }
    }

    private void setClicDroit(boolean clicDroit) {
        this.clicDroit = clicDroit;
    }

    public void setVerrouillerNomRoute(boolean verrouiller, String nomRoute) {
        this.nomRoute = nomRoute;
        this.verrouillerNomRoute = verrouiller;
    }

    public void setVerrouillerIdgdfBretelle(boolean verrouiller, String idgdfRoute) {
        this.idgdfRoute = idgdfRoute;
        this.verrouillerIdgdfBretelle = verrouiller;
    }

    public void setVerrouillerNomRoute(String nomRoute) {
        this.setVerrouillerNomRoute(nomRoute != null, nomRoute);
    }

    public void setVerrouillerIdgdfBretelle(String idgdfRoute) {
        this.setVerrouillerIdgdfBretelle(idgdfRoute != null, idgdfRoute);
    }

    private Vector<BretelleInfo> rechercherIdgdfTronconsBretelle(boolean verouillerNomRoute, boolean verouillerIdgdfRoute) {
        boolean tronconsTrouves;
        Enregistrement enregistrementTmp;
        Vector vecteurTronconsFinTrouves;
        Vector vecteurTronconsDebutTrouves;
        IFichierCont contRouteTmp;
        IFichierDon donRouteTmp;
        ICouche coucheRouteTmp;
        GeoPoint pointFin;
        GeoPoint pointDebut;
        if (this.listeRoutesAssociees != null) {
            this.listeRoutesAssociees.clear();
        } else {
            this.listeRoutesAssociees = new Vector();
        }
        try {
            pointDebut = this.getPremierTroncon().getPremierPoint();
        }
        catch (Exception e) {
            pointDebut = null;
        }
        LocalisationInfo.ecrireLog("+--> test 2");
        try {
            pointFin = this.getDernierTroncon().getDernierPoint();
        }
        catch (Exception e) {
            pointFin = null;
        }
        LocalisationInfo.ecrireLog("+--> Point debut " + pointDebut + " - " + this.getPremierTroncon().estInverse() + " --- Point fin " + pointFin + " - " + this.getDernierTroncon().estInverse());
        int i = 0;
        while (i < LocalisationInfo.LISTE_ROUTES_PRINCIPALES.length - 1) {
            coucheRouteTmp = LocalisationInfo.getCouche(LocalisationInfo.LISTE_ROUTES_PRINCIPALES[i]);
            if (coucheRouteTmp != null) {
                int j;
                donRouteTmp = coucheRouteTmp.getDon();
                contRouteTmp = coucheRouteTmp.getCont();
                LocalisationInfo.ecrireLog("+--> Recherche sur la ICouche " + LocalisationInfo.LISTE_ROUTES_PRINCIPALES[i]);
                vecteurTronconsDebutTrouves = pointDebut != null ? TriBretelle.rechercherTronconsChainesPrecedentAtPointContrainteDF(contRouteTmp, donRouteTmp, pointDebut) : null;
                vecteurTronconsFinTrouves = pointFin != null ? TriBretelle.rechercherTronconsChainesSuivantAtPointContrainteDF(contRouteTmp, donRouteTmp, pointFin) : null;
                LocalisationInfo.ecrireLog("+--> Fin recherche troncon");
                if (!GLS.estVide(vecteurTronconsDebutTrouves)) {
                    LocalisationInfo.ecrireLog("+--> On a trouve des troncons au d\u00e9but");
                    j = 0;
                    while (j < vecteurTronconsDebutTrouves.size()) {
                        enregistrementTmp = (Enregistrement)vecteurTronconsDebutTrouves.get(j);
                        if (!verouillerNomRoute) {
                            if (!enregistrementTmp.getValeur(1).trim().equals("") && !enregistrementTmp.getValeur(0).trim().equals("")) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                            }
                        } else if (verouillerIdgdfRoute) {
                            LocalisationInfo.ecrireLog("+--> Idgdf troncons " + enregistrementTmp.getValeur(0));
                            if (enregistrementTmp.getValeur(0).equals(String.valueOf(this.idgdfRoute))) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                                return this.listeRoutesAssociees;
                            }
                        } else if (enregistrementTmp.getValeur(1).equals(this.nomRoute)) {
                            this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                        }
                        ++j;
                    }
                }
                if (!GLS.estVide(vecteurTronconsFinTrouves)) {
                    LocalisationInfo.ecrireLog("+--> On a trouve des troncons en fin");
                    j = 0;
                    while (j < vecteurTronconsFinTrouves.size()) {
                        enregistrementTmp = (Enregistrement)vecteurTronconsFinTrouves.get(j);
                        if (!verouillerNomRoute) {
                            if (!enregistrementTmp.getValeur(1).trim().equals("") && !enregistrementTmp.getValeur(0).trim().equals("")) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                            }
                        } else if (verouillerIdgdfRoute) {
                            LocalisationInfo.ecrireLog("+--> Idgdf troncons " + enregistrementTmp.getValeur(0));
                            if (enregistrementTmp.getValeur(0).equals(String.valueOf(this.idgdfRoute))) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                                return this.listeRoutesAssociees;
                            }
                        } else if (enregistrementTmp.getValeur(1).equals(this.nomRoute)) {
                            this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        boolean bl = tronconsTrouves = this.listeRoutesAssociees.size() != 0;
        if (!tronconsTrouves || this.clicDroit) {
            int i2 = 0;
            while (i2 < LocalisationInfo.LISTE_ROUTES_SECONDAIRES.length - 1) {
                coucheRouteTmp = LocalisationInfo.getCouche(LocalisationInfo.LISTE_ROUTES_SECONDAIRES[i2]);
                if (coucheRouteTmp != null) {
                    int j;
                    donRouteTmp = coucheRouteTmp.getDon();
                    contRouteTmp = coucheRouteTmp.getCont();
                    LocalisationInfo.ecrireLog("+--> Recherche sur la ICouche " + LocalisationInfo.LISTE_ROUTES_SECONDAIRES[i2]);
                    vecteurTronconsDebutTrouves = pointDebut != null ? TriBretelle.rechercherTronconsChainesPrecedentAtPointContrainteDF(contRouteTmp, donRouteTmp, pointDebut) : null;
                    vecteurTronconsFinTrouves = pointFin != null ? TriBretelle.rechercherTronconsChainesSuivantAtPointContrainteDF(contRouteTmp, donRouteTmp, pointFin) : null;
                    LocalisationInfo.ecrireLog("+--> Fin recherche troncon");
                    if (!GLS.estVide(vecteurTronconsDebutTrouves)) {
                        LocalisationInfo.ecrireLog("+--> On a trouve des troncons");
                        j = 0;
                        while (j < vecteurTronconsDebutTrouves.size()) {
                            enregistrementTmp = (Enregistrement)vecteurTronconsDebutTrouves.get(j);
                            if (!verouillerNomRoute) {
                                if (!enregistrementTmp.getValeur(1).trim().equals("") && !enregistrementTmp.getValeur(0).trim().equals("")) {
                                    this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                                }
                            } else if (verouillerIdgdfRoute) {
                                LocalisationInfo.ecrireLog("+--> Idgdf troncons " + enregistrementTmp.getValeur(0));
                                if (enregistrementTmp.getValeur(0).equals(String.valueOf(this.idgdfRoute))) {
                                    this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                                    return this.listeRoutesAssociees;
                                }
                            } else if (enregistrementTmp.getValeur(1).equals(this.nomRoute)) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointDebut, "d", enregistrementTmp));
                            }
                            ++j;
                        }
                    }
                    if (!GLS.estVide(vecteurTronconsFinTrouves)) {
                        LocalisationInfo.ecrireLog("+--> On a trouve des troncons");
                        j = 0;
                        while (j < vecteurTronconsFinTrouves.size()) {
                            enregistrementTmp = (Enregistrement)vecteurTronconsFinTrouves.get(j);
                            if (!verouillerNomRoute) {
                                if (!enregistrementTmp.getValeur(1).trim().equals("") && !enregistrementTmp.getValeur(0).trim().equals("")) {
                                    this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                                }
                            } else if (verouillerIdgdfRoute) {
                                LocalisationInfo.ecrireLog("+--> Idgdf troncons " + enregistrementTmp.getValeur(0));
                                if (enregistrementTmp.getValeur(0).equals(String.valueOf(this.idgdfRoute))) {
                                    this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                                    return this.listeRoutesAssociees;
                                }
                            } else if (enregistrementTmp.getValeur(1).equals(this.nomRoute)) {
                                this.listeRoutesAssociees.add(TriBretelle.creerInfoRoute(coucheRouteTmp, pointFin, "f", enregistrementTmp));
                            }
                            ++j;
                        }
                    }
                }
                ++i2;
            }
        }
        return this.listeRoutesAssociees;
    }

    public static BretelleInfo creerInfoRoute(ICouche ICouche2, GeoPoint point, String valeur, Enregistrement enregistrement) {
        return new BretelleInfo(new InfoTroncon(enregistrement, ICouche2), point, valeur);
    }

    public Vector getListeNomRoutes() {
        if (this.listeRoutesAssociees != null && this.listeRoutesAssociees.size() > 0) {
            String nomRoute;
            Vector<String> listeRoutes = new Vector<String>();
            int i = 0;
            while (i < this.listeRoutesAssociees.size()) {
                nomRoute = ((BretelleInfo)this.listeRoutesAssociees.get(i)).getGeoPositionnement().getTroncon().getNom();
                listeRoutes.add(nomRoute);
                ++i;
            }
            i = 0;
            while (i < listeRoutes.size()) {
                nomRoute = (String)listeRoutes.get(i);
                int nbOccurenceRoute = 1;
                int j = i + 1;
                while (j < listeRoutes.size()) {
                    if (nomRoute.equals((String)listeRoutes.get(j))) {
                        if (nbOccurenceRoute == 1) {
                            nomRoute.concat(" (1)");
                        }
                        listeRoutes.setElementAt(String.valueOf(nomRoute) + " (" + ++nbOccurenceRoute + ")", j);
                    }
                    ++j;
                }
                ++i;
            }
            return listeRoutes;
        }
        return null;
    }

    public Vector getListeRoutesAssociees() {
        return this.listeRoutesAssociees;
    }

    public boolean aDesRoutesAssociees() {
        return this.getNbRoutesAssociees() > 0;
    }

    public int getNbRoutesAssociees() {
        if (this.listeRoutesAssociees != null) {
            return this.listeRoutesAssociees.size();
        }
        return 0;
    }

    @Override
    public boolean estBretelle() {
        return true;
    }

    @Override
    public void trier() {
        this.trier(this.nomRoute, this.idgdfRoute);
    }

    public void trier(String nomRoute, String idgdfRoute) {
        this.initialiserInversionTronconDepart(true);
        if (this.retrier) {
            this.listeTronconSuivant = null;
            this.listeTronconPrecedent = null;
            this.listeTronconSuivant = this.getTronconsSuivant(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche(), this.listeTronconBretelle);
            this.listeTronconPrecedent = this.getTronconsPrecedent(this.getTronconDepart().getTroncon(), this.getTronconDepart().getCouche(), this.listeTronconBretelle);
            this.setVerrouillerIdgdfBretelle(idgdfRoute);
            this.setVerrouillerNomRoute(nomRoute);
            this.rechercherIdgdfTronconsBretelle(this.verrouillerNomRoute, this.verrouillerIdgdfBretelle);
            if (GLS.estVide(this.listeRoutesAssociees) && this.verrouillerIdgdfBretelle && this.verrouillerNomRoute) {
                this.rechercherIdgdfTronconsBretelle(this.verrouillerNomRoute, false);
            }
            this.setBretelleInfoAssociee(0);
        }
    }

    public void trierRouteAssociee() {
        this.trierRouteAssociee(this.getBretelleInfoAssociee());
    }

    public void trierRouteAssociee(boolean sensChainageOk) {
        this.trierRouteAssociee(this.getBretelleInfoAssociee(), sensChainageOk);
    }

    public void trierRouteAssociee(BretelleInfo bretelleInfo) {
        this.trierRouteAssociee(bretelleInfo, true);
    }

    public void trierRouteAssociee(BretelleInfo bretelleInfo, boolean sensChainageOk) {
        LocalisationInfo.ecrireLog("+--> init tri route associee " + this.listeRoutesAssociees);
        LocalisationInfo.ecrireLog("+--> nb routes associees " + this.listeRoutesAssociees.size());
        if (bretelleInfo != null) {
            this.bretelleInfoAssociee = bretelleInfo;
            LocalisationInfo.ecrireLog("+--> init tri " + bretelleInfo.getGeoPositionnement().getTroncon().getNom() + " - " + bretelleInfo.getGeoPositionnement().getTroncon().getIdgdf());
            if (this.triRouteAssociee == null) {
                this.triRouteAssociee = new TriRoute(this.bretelleInfoAssociee);
            } else {
                this.triRouteAssociee.initialiser(this.bretelleInfoAssociee);
            }
            this.triRouteAssociee.trier(sensChainageOk);
        } else {
            if (this.triRouteAssociee != null) {
                this.triRouteAssociee = null;
            }
            this.bretelleInfoAssociee = null;
        }
    }

    public int getIndiceRouteAssociee(BretelleInfo bretelleInfoRecherche) {
        int indiceRouteAssociee = -1;
        int nbRoutesAssociees = this.getNbRoutesAssociees();
        if (nbRoutesAssociees > 0 && bretelleInfoRecherche != null) {
            boolean trouve = false;
            boolean fin = false;
            int i = 0;
            BretelleInfo bretelleInfoCourant = null;
            while (!trouve && !fin) {
                bretelleInfoCourant = (BretelleInfo)this.listeRoutesAssociees.get(i);
                if (bretelleInfoCourant.equals(bretelleInfoRecherche)) {
                    trouve = true;
                    indiceRouteAssociee = i;
                }
                boolean bl = fin = ++i == nbRoutesAssociees;
            }
        }
        return indiceRouteAssociee;
    }

    public void supprimerRouteAssociee() {
        this.supprimerRouteAssociee(this.bretelleInfoAssociee);
        this.bretelleInfoAssociee = null;
    }

    public void supprimerRouteAssociee(BretelleInfo bretelleInfoRecherche) {
        int indiceRouteAssociee = this.getIndiceRouteAssociee(bretelleInfoRecherche);
        if (!LocalisationInfo.estNulle(indiceRouteAssociee)) {
            this.listeRoutesAssociees.remove(indiceRouteAssociee);
        }
    }

    public void setBretelleInfoAssociee(int numRouteAssociee) {
        this.bretelleInfoAssociee = this.aDesRoutesAssociees() && numRouteAssociee < this.listeRoutesAssociees.size() ? (BretelleInfo)this.listeRoutesAssociees.get(numRouteAssociee) : null;
    }

    public void setBretelleInfoAssociee(BretelleInfo bretelleInfoAssociee) {
        this.bretelleInfoAssociee = bretelleInfoAssociee;
    }

    public BretelleInfo getBretelleInfoAssociee() {
        if (this.bretelleInfoAssociee == null) {
            this.setBretelleInfoAssociee(0);
        }
        return this.bretelleInfoAssociee;
    }

    @Override
    public String getRoute() {
        if (this.triRouteAssociee != null) {
            return this.triRouteAssociee.getRoute();
        }
        return null;
    }

    public TriRoute getTriRouteAssociee() {
        return this.triRouteAssociee;
    }

    @Override
    public Vector getTronconsSuivant(Enregistrement tronconDebut, ICouche coucheBretelle) {
        return this.getTronconsSuivant(tronconDebut, coucheBretelle, this.listeTronconBretelle);
    }

    @Override
    public Vector getTronconsPrecedent(Enregistrement tronconDebut, ICouche coucheBretelle) {
        return this.getTronconsPrecedent(tronconDebut, coucheBretelle, this.listeTronconBretelle);
    }

    public Vector getTronconsSuivant(Enregistrement tronconDebut, ICouche coucheBretelle, Vector listeTronconBretelle) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = new Vector<String>();
        InfoTroncon infoTroncon = new InfoTroncon(tronconDebut, coucheBretelle);
        if (infoTroncon.getDF().equals("2")) {
            inverser = true;
            infoTroncon.inverserPoints();
        }
        LocalisationInfo.ecrireLog("+--> TRI troncon suivant bretelle");
        while (!finRecherche) {
            String idgdfCourant = infoTroncon.getIdgdf();
            if (inverser) {
                inverser = false;
                LocalisationInfo.ecrireLog("+--> Recherche bretelle precedente");
                infoTronconTmp = TriBretelle.rechercherTronconSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriBretelle.rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriBretelle.rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else {
                LocalisationInfo.ecrireLog("+--> Recherche bretelle precedente");
                infoTronconTmp = TriBretelle.rechercherTronconSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriBretelle.rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriBretelle.rechercherTronconSuivantDansListeContrainteGeographiqueDFCouche(listeTronconBretelle, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, idgdfCourant)) {
                infoTronconTmp.setInverse(inverser);
                LocalisationInfo.ecrireLog("+--> Ajout bretelle");
                vector.add(infoTronconTmp);
                infoTroncon.set(infoTronconTmp);
                vecIdgdf.add(idgdfCourant);
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        LocalisationInfo.ecrireLog("+--> Fin recherche");
        return vector;
    }

    public Vector getTronconsPrecedent(Enregistrement tronconDebut, ICouche coucheBretelle, Vector listeTronconBretelle) {
        boolean finRecherche = false;
        boolean inverser = false;
        InfoTroncon infoTronconTmp = null;
        Vector<InfoTroncon> vector = new Vector<InfoTroncon>();
        Vector<String> vecIdgdf = this.getListeIdgdfSuivant();
        InfoTroncon infoTroncon = new InfoTroncon(tronconDebut, coucheBretelle);
        if (infoTroncon.getDF().equals("2")) {
            inverser = true;
            infoTroncon.inverserPoints();
        }
        LocalisationInfo.ecrireLog("+--> TRI troncon precedent bretelle");
        while (!finRecherche) {
            String idgdfCourant = infoTroncon.getIdgdf();
            if (inverser) {
                inverser = false;
                LocalisationInfo.ecrireLog("+--> Recherche bretelle precedente");
                infoTronconTmp = TriBretelle.rechercherTronconPrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriBretelle.rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriBretelle.rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            } else {
                LocalisationInfo.ecrireLog("+--> Recherche bretelle precedente");
                infoTronconTmp = TriBretelle.rechercherTronconPrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                if (infoTronconTmp == null) {
                    infoTronconTmp = TriBretelle.rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(listeTronconBretelle, infoTroncon);
                    if (infoTronconTmp == null) {
                        infoTronconTmp = TriBretelle.rechercherTronconPrecedentDansListeContrainteGeographiqueDFCouche(listeTronconBretelle, infoTroncon);
                        if (infoTronconTmp != null && infoTronconTmp.getDF().equals("2")) {
                            inverser = true;
                        }
                    } else {
                        inverser = true;
                    }
                }
            }
            if (infoTronconTmp != null && !LocalisationInfo.estDejaParcouru(vecIdgdf, idgdfCourant)) {
                infoTronconTmp.setInverse(inverser);
                vector.add(infoTronconTmp);
                infoTroncon.set(infoTronconTmp);
                vecIdgdf.add(idgdfCourant);
                if (!inverser) continue;
                infoTroncon.inverserPoints();
                continue;
            }
            finRecherche = true;
        }
        return vector;
    }
}

