/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.tri;

import cartoj.Enregistrement;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.exception.ErreurPR;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Tri {
    protected GeoPositionnement geoPositionnement = null;
    protected String nomRoute = null;
    protected Vector<InfoTroncon> listeTronconPrecedent = null;
    protected Vector<InfoTroncon> listeTronconSuivant = null;

    public GeoPositionnement getGeoPositionnement() {
        return this.geoPositionnement;
    }

    public void setGeoPositionnement(GeoPositionnement geoPositionnement) {
        this.geoPositionnement = geoPositionnement;
    }

    public int getIndiceTronconDepart() {
        if (this.listeTronconPrecedent != null && this.listeTronconSuivant != null && this.geoPositionnement != null) {
            return this.listeTronconPrecedent.size();
        }
        return -1;
    }

    public Vector<String> getListeIdgdfSuivant() {
        Vector<String> listeIdgdfSuivant = new Vector<String>();
        if (!GLS.estVide(this.listeTronconSuivant)) {
            for (InfoTroncon troncon : this.listeTronconSuivant) {
                listeIdgdfSuivant.add(troncon.getIdgdf());
            }
        }
        return listeIdgdfSuivant;
    }

    public boolean getSensCirculation() {
        return Geometry.getSensCirculation(this);
    }

    public GeoPoint getIntersectionPoint(InfoTroncon troncon) throws Exception {
        boolean trouve = false;
        boolean fin = false;
        GeoPoint point = null;
        int i = 0;
        while (!trouve && !fin) {
            try {
                point = Geometry.getIntersectionPoint(this.getTroncon(i), troncon);
            }
            catch (Exception exception) {
                // empty catch block
            }
            trouve = point != null;
            boolean bl = fin = ++i >= this.getNbTroncons();
        }
        if (point != null) {
            return point;
        }
        throw new Exception("AUCUNE INTERSECTION AVEC LE TRI");
    }

    public boolean estDedans(GeoPositionnement tronconRecherche) {
        if (tronconRecherche != null) {
            return this.estDedans(tronconRecherche.getTroncon());
        }
        return false;
    }

    public boolean estDedans(InfoTroncon tronconRecherche) {
        return this.getIndiceTroncon(tronconRecherche) != -1;
    }

    public int getNbTroncons() {
        if (this.listeTronconPrecedent != null && this.listeTronconSuivant != null) {
            return this.listeTronconPrecedent.size() + this.listeTronconSuivant.size() + 1;
        }
        return -1;
    }

    public int getNbPr() {
        int nbPr = 0;
        int i = 0;
        while (i < this.getNbTroncons()) {
            try {
                nbPr += this.getTroncon(i).getPR().size();
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return nbPr;
    }

    public List<LocalisantPr> getPr() {
        ArrayList<LocalisantPr> listePr = new ArrayList<LocalisantPr>();
        int i = 0;
        while (i < this.getNbTroncons()) {
            try {
                listePr.addAll(this.getTroncon(i).getPR());
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return listePr;
    }

    public boolean aPr(LocalisantPr pr) {
        int i = 0;
        while (i < this.getNbTroncons()) {
            try {
                if (this.getTroncon(i).getPR(pr) != null) {
                    return true;
                }
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return false;
    }

    public int getNbAlertc() {
        int nbAlertc = 0;
        int i = 0;
        while (i < this.getNbTroncons()) {
            try {
                nbAlertc += this.getTroncon(i).getAlertc().size();
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return nbAlertc;
    }

    public boolean estVide() {
        return this.getNbTroncons() == 0;
    }

    public InfoTroncon getTronconAtIdgdf(String idgdf) {
        int i = this.getIndiceTronconAtIdgdf(idgdf);
        if (!LocalisationInfo.estNulle(i)) {
            try {
                return this.getTroncon(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean estApres(GeoPositionnement positionnementDebut, GeoPositionnement positionnementFin) throws Exception {
        if (positionnementDebut != null && positionnementFin != null) {
            int indicePositionnementFin;
            int indicePositionnementDebut = this.getIndiceTroncon(positionnementDebut);
            if (indicePositionnementDebut == (indicePositionnementFin = this.getIndiceTroncon(positionnementFin))) {
                if (positionnementDebut.getTroncon().estInverse() == positionnementFin.getTroncon().estInverse()) {
                    return positionnementDebut.getDistanceDebut() <= positionnementFin.getDistanceDebut();
                }
                return positionnementDebut.getDistanceDebut() <= positionnementFin.getDistanceFin();
            }
            return indicePositionnementDebut < indicePositionnementFin;
        }
        throw new Exception("#--> SENS IMPOSSIBLE A DETERMINER # LOCALISANTS NULS");
    }

    public boolean estApres(GeoPositionnement positionnementFin) throws Exception {
        return this.estApres(this.geoPositionnement, positionnementFin);
    }

    public boolean estAvant(GeoPositionnement positionnementDebut, GeoPositionnement positionnementFin) throws Exception {
        if (positionnementDebut != null && positionnementFin != null) {
            int indicePositionnementFin;
            int indicePositionnementDebut = this.getIndiceTroncon(positionnementDebut);
            if (indicePositionnementDebut == (indicePositionnementFin = this.getIndiceTroncon(positionnementFin))) {
                if (positionnementDebut.getTroncon().estInverse() == positionnementFin.getTroncon().estInverse()) {
                    return positionnementDebut.getDistanceDebut() >= positionnementFin.getDistanceDebut();
                }
                return positionnementDebut.getDistanceDebut() >= positionnementFin.getDistanceFin();
            }
            return indicePositionnementDebut > indicePositionnementFin;
        }
        throw new ErreurPR("SENS DE LA ROUTE IMPOSSIBLE A DETERMINER");
    }

    public boolean estAvant(GeoPositionnement positionnementFin) throws Exception {
        return this.estAvant(this.geoPositionnement, positionnementFin);
    }

    public int getIndiceTroncon(GeoPositionnement positionnement) {
        if (positionnement != null) {
            return this.getIndiceTroncon(positionnement.getTroncon());
        }
        return -1;
    }

    public int getIndiceTroncon(InfoTroncon troncon) {
        if (troncon != null) {
            return this.getIndiceTronconAtIdgdf(troncon.getIdgdf());
        }
        return -1;
    }

    public int getIndiceTronconAtIdgdf(String idgdf) {
        if (idgdf != null) {
            boolean fin = this.getNbTroncons() == 0;
            boolean trouve = false;
            InfoTroncon troncon = null;
            int i = 0;
            while (!trouve && !fin) {
                try {
                    troncon = this.getTroncon(i);
                }
                catch (Exception e) {
                    troncon = null;
                    fin = true;
                }
                if (troncon != null && troncon.getIdgdf().equals(idgdf)) {
                    trouve = true;
                } else {
                    ++i;
                }
                boolean bl = fin = i == this.getNbTroncons();
            }
            if (trouve) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public int getIndiceTronconPrecedentRocadeAtIdgdf(String idgdf) {
        if (idgdf != null) {
            boolean fin = this.estVide();
            boolean trouve = false;
            InfoTroncon troncon = null;
            int i = this.getNbTroncons() - 1;
            while (!trouve && !fin) {
                try {
                    troncon = this.getTroncon(i);
                }
                catch (Exception e) {
                    troncon = null;
                    fin = true;
                }
                if (troncon != null && troncon.getIdgdf().equals(idgdf)) {
                    trouve = true;
                } else {
                    --i;
                }
                boolean bl = fin = i == this.getNbTroncons();
            }
            if (trouve) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public int getIndiceTronconPrecedentRocadeAtIdgdfSensInverse(String idgdf) {
        return this.getIndiceTronconAtIdgdf(idgdf) - this.getNbTroncons();
    }

    public LocalisantPr getPrMax() {
        return this.getPrMax(null);
    }

    public LocalisantPr getPrMax(LocalisantPr prAEviter) {
        int i = this.getNbTroncons() - 1;
        boolean trouve = false;
        boolean fin = i == -1;
        LocalisantPr prMax = null;
        while (!trouve && !fin) {
            try {
                prMax = this.getTroncon(i).getPrMax(prAEviter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (prMax != null) {
                trouve = true;
            }
            boolean bl = fin = --i < 0;
        }
        return prMax;
    }

    public LocalisantPr getPrMin() {
        return this.getPrMin(null);
    }

    public LocalisantPr getPrMin(LocalisantPr prAEviter) {
        int i = 0;
        boolean trouve = false;
        boolean fin = this.getNbTroncons() == 0;
        LocalisantPr prMin = null;
        while (!trouve && !fin) {
            try {
                prMin = this.getTroncon(i).getPrMin(prAEviter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (prMin != null) {
                trouve = true;
            }
            boolean bl = fin = ++i >= this.getNbTroncons();
        }
        return prMin;
    }

    public boolean aAlertcDebut() {
        return this.getPremierTroncon().aAlertcDebut();
    }

    public boolean aAlertcFin() {
        return this.getDernierTroncon().aAlertcFin();
    }

    public boolean aPrDebut() {
        return this.getPremierTroncon().aPrDebut();
    }

    public boolean aPrFin() {
        return this.getDernierTroncon().aPrFin();
    }

    public LocalisantAlertc getAlertcMax() {
        return this.getAlertcMax(null);
    }

    public LocalisantAlertc getAlertcMax(LocalisantAlertc alertcAEviter) {
        int i = this.getNbTroncons() - 1;
        boolean trouve = false;
        boolean fin = i == -1;
        LocalisantAlertc alertcMax = null;
        while (!trouve && !fin) {
            try {
                alertcMax = this.getTroncon(i).getAlertcMax(alertcAEviter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alertcMax != null) {
                trouve = true;
            }
            boolean bl = fin = --i < 0;
        }
        return alertcMax;
    }

    public LocalisantAlertc getAlertcMin() {
        return this.getAlertcMin(null);
    }

    public LocalisantAlertc getAlertcMin(LocalisantAlertc alertcAEviter) {
        int i = 0;
        boolean trouve = false;
        boolean fin = this.getNbTroncons() == 0;
        LocalisantAlertc alertcMin = null;
        while (!trouve && !fin) {
            try {
                alertcMin = this.getTroncon(i).getAlertcMin(alertcAEviter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alertcMin != null) {
                trouve = true;
            }
            boolean bl = fin = ++i >= this.getNbTroncons();
        }
        return alertcMin;
    }

    public InfoTroncon getPremierTronconAlertc() throws Exception {
        int i = 0;
        boolean trouve = false;
        boolean fin = this.getNbTroncons() == 0;
        InfoTroncon troncon = null;
        while (!trouve && !fin) {
            troncon = this.getTroncon(i);
            if (troncon.estAlertc()) {
                trouve = true;
            }
            boolean bl = fin = ++i >= this.getNbTroncons();
        }
        if (trouve) {
            return troncon;
        }
        throw new Exception("AUCUN TRONCON ALERTC TROUVE EN DEBUT DE ROUTE");
    }

    public InfoTroncon getPremierTronconPr() throws Exception {
        int i = 0;
        boolean trouve = false;
        boolean fin = this.getNbTroncons() == 0;
        InfoTroncon troncon = null;
        while (!trouve && !fin) {
            troncon = this.getTroncon(i);
            if (troncon.estPR()) {
                trouve = true;
            }
            boolean bl = fin = ++i >= this.getNbTroncons();
        }
        if (trouve) {
            return troncon;
        }
        throw new Exception("AUCUN TRONCON PR TROUVE EN DEBUT DE ROUTE");
    }

    public GeoPositionnement getPositionnementAtAlertc(LocalisantAlertc alertc) throws Exception {
        return Recherche.getPositionnementAtAlertc(this, alertc);
    }

    public InfoTroncon getDernierTronconAlertc() throws Exception {
        int i = this.getNbTroncons() - 1;
        boolean trouve = false;
        boolean fin = i == -1;
        InfoTroncon troncon = null;
        while (!trouve && !fin) {
            troncon = this.getTroncon(i);
            if (troncon.estAlertc()) {
                trouve = true;
            }
            boolean bl = fin = --i < 0;
        }
        if (trouve) {
            return troncon;
        }
        throw new Exception("AUCUN TRONCON ALERTC TROUVE EN DEBUT DE ROUTE");
    }

    public InfoTroncon getDernierTronconPr() throws Exception {
        int i = this.getNbTroncons() - 1;
        boolean trouve = false;
        boolean fin = i == -1;
        InfoTroncon troncon = null;
        while (!trouve && !fin) {
            troncon = this.getTroncon(i);
            if (troncon.estPR()) {
                trouve = true;
            }
            boolean bl = fin = --i < 0;
        }
        if (trouve) {
            return troncon;
        }
        throw new Exception("AUCUN TRONCON PR TROUVE EN DEBUT DE ROUTE");
    }

    public boolean estRocade() {
        if (!this.estVide()) {
            LocalisationInfo.log.debug((Object)("ROCADE TRONCON DEBUT " + this.getDernierTroncon().getIdgdf() + " -- " + this.getDernierTroncon().getPremierPoint() + " -- " + this.getDernierTroncon().getDernierPoint()));
            LocalisationInfo.log.debug((Object)("ROCADE TRONCON FIN " + this.getPremierTroncon().getIdgdf() + " -- " + this.getPremierTroncon().getPremierPoint() + " -- " + this.getPremierTroncon().getDernierPoint()));
            return !this.getDernierTroncon().equals(this.getPremierTroncon()) && this.getDernierTroncon().getDernierPoint().equals(this.getPremierTroncon().getPremierPoint());
        }
        return false;
    }

    public int getLongueur() {
        int longueur = 0;
        int i = 0;
        while (i < this.getNbTroncons()) {
            try {
                longueur += this.getTroncon(i).getLongueur();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return longueur;
    }

    public int getDistanceDebut() {
        int longueur = this.geoPositionnement.getDistanceDebut();
        int i = 0;
        while (i < this.getIndiceTronconDepart()) {
            try {
                longueur += this.getTroncon(i).getLongueur();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return longueur;
    }

    public int getDistanceFin() {
        int longueur = this.geoPositionnement.getDistanceFin();
        int i = this.getIndiceTronconDepart() + 1;
        while (i < this.getNbTroncons()) {
            try {
                longueur += this.getTroncon(i).getLongueur();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return longueur;
    }

    public InfoTroncon getPremierTroncon() {
        try {
            return this.getTroncon(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InfoTroncon getDernierTroncon() {
        try {
            return this.getTroncon(this.getNbTroncons() - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GeoPositionnement getPremierPositionnement() {
        GeoPositionnement position = new GeoPositionnement();
        position.repositionnerPremierPoint(this.getPremierTroncon());
        position.setIndiceTri(0);
        return position;
    }

    public GeoPoint getPremierPoint() {
        return this.getPremierTroncon().getPremierPoint();
    }

    public GeoPoint getDernierPoint() {
        return this.getDernierTroncon().getDernierPoint();
    }

    public GeoPositionnement getDernierPositionnement() {
        GeoPositionnement position = new GeoPositionnement();
        position.repositionnerDernierPoint(this.getDernierTroncon());
        position.setIndiceTri(this.getNbTroncons() - 1);
        return position;
    }

    public InfoTroncon getTronconSansException(int i) {
        try {
            return this.getTroncon(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void reinitialiserTriRocade(String positionnement) {
        if (positionnement.equals("t")) {
            if (GLS.estVide(this.listeTronconPrecedent)) {
                this.listeTronconPrecedent = this.listeTronconSuivant;
            }
        } else if (GLS.estVide(this.listeTronconSuivant)) {
            this.listeTronconSuivant = this.listeTronconPrecedent;
        }
    }

    public InfoTroncon getTroncon(int i) throws Exception {
        InfoTroncon troncon = null;
        if (this.listeTronconPrecedent != null && this.listeTronconSuivant != null && this.geoPositionnement != null) {
            if (i >= 0 && i < this.getNbTroncons()) {
                troncon = i == this.listeTronconPrecedent.size() ? this.geoPositionnement.getTroncon() : (i < this.listeTronconPrecedent.size() ? this.listeTronconPrecedent.get(this.listeTronconPrecedent.size() - 1 - i) : this.listeTronconSuivant.get(i - (this.listeTronconPrecedent.size() + 1)));
            } else if (this.estRocade() && i < 0 && i >= this.getNbTroncons() * -1 + 1) {
                return this.getTroncon(i + this.getNbTroncons());
            }
        }
        if (troncon != null) {
            return troncon;
        }
        throw new Exception("ERREUR AUCUN TRONCON A L'INDICE DEMANDE " + i);
    }

    public InfoTroncon getTronconPrecedent(int i) {
        if (this.listeTronconPrecedent != null && i >= 0 && i < this.listeTronconPrecedent.size()) {
            return this.listeTronconPrecedent.get(i);
        }
        return null;
    }

    public InfoTroncon getTronconSuivant(int i) {
        if (this.listeTronconSuivant != null && i >= 0 && i < this.listeTronconSuivant.size()) {
            return this.listeTronconSuivant.get(i);
        }
        return null;
    }

    public Vector getTronconsSuivant() {
        return this.listeTronconSuivant;
    }

    public Vector getTronconsPrecedent() {
        return this.listeTronconPrecedent;
    }

    public InfoTroncon getTronconDepart() {
        if (this.geoPositionnement != null && this.geoPositionnement.getTroncon() != null) {
            return this.geoPositionnement.getTroncon();
        }
        return null;
    }

    public String getRoute() {
        return this.nomRoute;
    }

    public GeoPositionnement reinitialiser(LocalisantAlertc alertc) {
        try {
            this.reinitialiser(this.getPositionnementAtAlertc(alertc));
            return this.geoPositionnement;
        }
        catch (Exception e) {
            LocalisationInfo.ecrireLogErreur("POINT ALERTC " + alertc + " INTROUVABLE");
            return null;
        }
    }

    public void reinitialiser(GeoPositionnement geoPositionnement) {
        this.reinitialiser(geoPositionnement, true);
    }

    public boolean getSensTroncon(InfoTroncon troncon) throws Exception {
        int iTroncon = this.getIndiceTroncon(troncon);
        if (!LocalisationInfo.estNulle(iTroncon)) {
            return !troncon.estInverse();
        }
        return true;
    }

    public void reinitialiser(GeoPositionnement geoPositionnement, boolean sensChainage) {
        LocalisationInfo.ecrireLogInfo("Reinitialisation du tri");
        if (geoPositionnement != null) {
            if (this.geoPositionnement != null) {
                int iTroncon = this.getIndiceTroncon(geoPositionnement.getTroncon());
                if (!LocalisationInfo.estNulle(iTroncon)) {
                    InfoTroncon troncon = null;
                    try {
                        troncon = this.getTroncon(iTroncon);
                    }
                    catch (Exception e) {
                        troncon = null;
                    }
                    geoPositionnement.setTroncon(troncon);
                    if (iTroncon < this.listeTronconPrecedent.size()) {
                        int iTronconOk = this.listeTronconPrecedent.size() - iTroncon - 1;
                        this.listeTronconSuivant.add(0, this.geoPositionnement.getTroncon());
                        int i = 0;
                        while (i < iTronconOk) {
                            this.listeTronconSuivant.add(0, this.listeTronconPrecedent.get(i));
                            ++i;
                        }
                        i = iTronconOk;
                        while (i >= 0) {
                            this.listeTronconPrecedent.removeElementAt(i);
                            --i;
                        }
                    } else if (iTroncon > this.listeTronconPrecedent.size()) {
                        int iTronconOk = iTroncon - (this.listeTronconPrecedent.size() + 1);
                        this.listeTronconPrecedent.add(0, this.geoPositionnement.getTroncon());
                        int i = 0;
                        while (i < iTronconOk) {
                            this.listeTronconPrecedent.add(0, this.listeTronconSuivant.get(i));
                            ++i;
                        }
                        i = iTronconOk;
                        while (i >= 0) {
                            this.listeTronconSuivant.removeElementAt(i);
                            --i;
                        }
                    }
                    this.geoPositionnement = geoPositionnement;
                    this.geoPositionnement.repositionner();
                } else {
                    this.initialiser(geoPositionnement);
                }
            } else {
                this.initialiser(geoPositionnement);
            }
        }
    }

    public static boolean tronconDepartInverse(InfoTroncon troncon, boolean sensChainage) {
        boolean inverse = troncon.estASensUnique() || troncon.estUnRondPoint() ? troncon.getDF().equals("2") : (troncon.estADoubleSens() ? !sensChainage : false);
        return inverse;
    }

    public void initialiserInversionTronconDepart(boolean sensChainage) {
        if (this.getTronconDepart() != null) {
            this.getTronconDepart().setInverse(Tri.tronconDepartInverse(this.getTronconDepart(), sensChainage));
            if (this.geoPositionnement != null) {
                this.getTronconDepart().setInverse(this.getTronconDepart().estInverse());
                this.geoPositionnement.repositionner();
            }
        }
    }

    public GeoPositionnement intersectionRapide(Tri tri) {
        GeoPositionnement positionnementTriSuivant = Recherche.getPositionnementProcheAtPoint(tri, this.geoPositionnement.getPoint(), Double.MAX_VALUE);
        GeoPositionnement positionnementTriCourant = Recherche.getPositionnementProcheAtPoint(this, positionnementTriSuivant.getPoint(), Double.MAX_VALUE);
        try {
            GeoPoint pointIntersection = Geometry.getIntersectionPoint(positionnementTriCourant.getTroncon(), positionnementTriSuivant.getTroncon());
        }
        catch (Exception e) {
            Object pointIntersection = null;
        }
        double distance = positionnementTriSuivant.getPoint().distance(positionnementTriCourant.getPoint());
        return positionnementTriCourant;
    }

    public static GeoPositionnement intersection(Tri tri, Tri tri2) {
        return tri.intersection(tri2, null, -1);
    }

    public GeoPositionnement intersection(Tri tri, GeoPositionnement dernierePosition, int distanceMax) {
        InfoTroncon t2;
        int iTronconDepart;
        boolean trouve = false;
        boolean fin = false;
        int i = iTronconDepart = this.getIndiceTronconDepart();
        int nbTroncons = this.getNbTroncons();
        GeoPositionnement positionnement = null;
        while (!trouve && !fin) {
            try {
                t2 = this.getTroncon(i);
                positionnement = Tri.intersection(tri, t2, dernierePosition, distanceMax);
                if (positionnement != null) {
                    trouve = true;
                }
            }
            catch (Exception t2) {
                // empty catch block
            }
            boolean bl = fin = ++i >= nbTroncons;
        }
        fin = iTronconDepart == 0;
        i = 0;
        while (!trouve && !fin) {
            try {
                t2 = this.getTroncon(i);
                positionnement = Tri.intersection(tri, t2, dernierePosition, distanceMax);
                if (positionnement != null) {
                    trouve = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fin = ++i >= iTronconDepart;
        }
        return positionnement;
    }

    public static GeoPositionnement intersection(Tri tri, InfoTroncon troncon, GeoPositionnement dernierePosition, int distanceMaxDernierePosition) {
        boolean trouve = false;
        boolean fin = false;
        int i = 0;
        GeoPositionnement positionnement = null;
        while (!trouve && !fin) {
            try {
                InfoTroncon t = tri.getTroncon(i);
                GeoPoint point = Geometry.getIntersectionPoint(troncon, t);
                if (point != null) {
                    positionnement = new GeoPositionnement(point, troncon);
                    if (dernierePosition == null || dernierePosition != null && dernierePosition.getPoint().distance(point) < (double)distanceMaxDernierePosition) {
                        trouve = true;
                        positionnement.setObjet(t);
                    } else {
                        positionnement = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fin = ++i >= tri.getNbTroncons();
        }
        return positionnement;
    }

    public abstract boolean estBretelle();

    protected abstract void trier();

    protected abstract Vector getTronconsPrecedent(Enregistrement var1, ICouche var2);

    protected abstract Vector getTronconsSuivant(Enregistrement var1, ICouche var2);

    protected abstract void initialiser(GeoPositionnement var1);

    public static Vector rechercherTronconsChainesPrecedentAtPointContrainteDF(IFichierCont contRoute, IFichierDon donRoute, GeoPoint point) {
        int nbTroncons = contRoute.getNbent();
        String[] colonneDF = donRoute.getColonne(10).getValeursToString();
        Vector<Enregistrement> listeEnregistrements = new Vector<Enregistrement>();
        int i = 0;
        while (i < nbTroncons) {
            float[] listeX = contRoute.getX(i);
            float[] listeY = contRoute.getY(i);
            int dernierPoint = listeX.length - 1;
            boolean trouve = false;
            String df = colonneDF[i];
            if (point.equals(listeX[0], listeY[0])) {
                if (df.equals("2") || df.equals(LocalisationInfo.DF_DOUBLE_SENS[0])) {
                    listeEnregistrements.add(donRoute.getEnreg(i));
                }
            } else if (point.equals(listeX[dernierPoint], listeY[dernierPoint]) && (df.equals("3") || df.equals(LocalisationInfo.DF_DOUBLE_SENS[0]))) {
                listeEnregistrements.add(donRoute.getEnreg(i));
            }
            ++i;
        }
        return listeEnregistrements;
    }

    public static Vector rechercherTronconsChainesSuivantAtPointContrainteDF(IFichierCont contRoute, IFichierDon donRoute, GeoPoint point) {
        int nbTroncons = contRoute.getNbent();
        String[] colonneDF = donRoute.getColonne(10).getValeursToString();
        Vector<Enregistrement> listeEnregistrements = new Vector<Enregistrement>();
        int i = 0;
        while (i < nbTroncons) {
            float[] listeX = contRoute.getX(i);
            float[] listeY = contRoute.getY(i);
            int dernierPoint = listeX.length - 1;
            boolean trouve = false;
            String df = colonneDF[i];
            if (point.equals(listeX[0], listeY[0])) {
                if (df.equals("3") || df.equals(LocalisationInfo.DF_DOUBLE_SENS[0])) {
                    listeEnregistrements.add(donRoute.getEnreg(i));
                }
            } else if (point.equals(listeX[dernierPoint], listeY[dernierPoint]) && (df.equals("2") || df.equals(LocalisationInfo.DF_DOUBLE_SENS[0]))) {
                listeEnregistrements.add(donRoute.getEnreg(i));
            }
            ++i;
        }
        return listeEnregistrements;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2")) && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2")) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2")) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographique(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDFIdgdfCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin())) && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueNoDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueNoDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueNoDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueNoDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("") && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDFIdgdf(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("") && !tronconTmp.getIdgdf().equals(infoTroncon.getIdgdf())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueNoDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueNoDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueNoDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueNoDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographique(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointFin())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographique(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographique(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut())) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2")) && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconSuivantDansListeContrainteGeographiqueDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconPrecedentDansListeContrainteGeographiqueDFCouche(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if ((tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) && (infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfDeb().equals(tronconTmp.getIdgdfFin()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfDeb()) || infoTroncon.getIdgdfFin().equals(tronconTmp.getIdgdfFin()))) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInverseSuivantDansListeContrainteGeographiqueDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("3") || tronconTmp.getPointFin().equals(infoTroncon.getPointDebut()) && tronconTmp.getDF().equals("2")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    protected static InfoTroncon rechercherTronconInversePrecedentDansListeContrainteGeographiqueDF(Vector listeTroncons, InfoTroncon infoTroncon) {
        boolean fin = false;
        InfoTroncon tronconTmp = null;
        int i = 0;
        int nbTroncons = listeTroncons.size();
        fin = nbTroncons == 0;
        while (!fin) {
            tronconTmp = (InfoTroncon)listeTroncons.get(i);
            if (tronconTmp.getPointDebut().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("2") || tronconTmp.getPointFin().equals(infoTroncon.getPointFin()) && tronconTmp.getDF().equals("3")) {
                return tronconTmp;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        tronconTmp = null;
        return null;
    }

    public boolean estSensFixe() {
        return this.getTronconDepart().estUnRondPoint() || this.estBretelle();
    }
}

