/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.recherche;

import cartoj.Enregistrement;
import cartoj.EntGeo;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import gls.comparator.CollatorFactory;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.InfoTroncon;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.EntiteAlertc;
import gls.localisation.alertc.ListeEntiteAlertc;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.distance.Distance;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.exception.ErreurAucunTronconEnFace;
import gls.localisation.exception.ErreurAucuneRoute;
import gls.localisation.exception.ErreurAxeInconnu;
import gls.localisation.exception.ErreurLimiteRoute;
import gls.localisation.exception.ErreurPR;
import gls.localisation.exception.ErreurRouteModification;
import gls.localisation.pr.GestionPr;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriBretelle;
import gls.localisation.tri.TriRoute;
import gls.outils.Extension;
import gls.outils.GLS;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Recherche {
    private Localisation localisation;

    public Recherche(Localisation localisation) {
        this.localisation = localisation;
    }

    public GeoPositionnement getRouteAtPoint(GeoPoint pointClic, boolean clicDroit) throws Exception {
        if (this.localisation != null) {
            return Recherche.getRouteAtPoint(this.localisation, pointClic, clicDroit);
        }
        return null;
    }

    public static GeoPositionnement getRouteAtPoint(Localisation localisation, GeoPoint pointClic, boolean clicDroit) throws ErreurAucuneRoute, ErreurPR, ErreurRouteModification {
        boolean routeTrouve = false;
        boolean tronconTrouve = false;
        boolean routeSansNomTrouve = false;
        boolean verrouillerNomRoute = false;
        boolean verrouillerIdgdfRoute = false;
        boolean verrouillerIdgdfRouteBretelle = false;
        boolean autoriserLocalisationSansRoute = false;
        boolean tronconPlusProche = false;
        GeoPositionnement positionRoute = null;
        int codeErreur = 0;
        String routeTemp = "";
        String[] listeRoutesPrincipales = localisation.getCouchesPrimaires();
        String[] listeRoutesSecondaires = localisation.getCouchesSecondaires();
        LocalisationInfo.ecrireLog("+--> Recherche au point " + pointClic);
        verrouillerNomRoute = localisation.getVerrouillageNomRoute();
        verrouillerIdgdfRoute = localisation.getVerrouillageIdgdfRoute();
        verrouillerIdgdfRouteBretelle = localisation.getVerrouillageIdgdfRouteAssociee();
        autoriserLocalisationSansRoute = localisation.estAutoriserLocalisationSansRoute();
        GeoPoint pointRoute = pointClic;
        Vector<InfoTroncon> listeTronconsTrouves = null;
        int margeRechercheRoute = LocalisationInfo.margeRechercheRoute;
        positionRoute = new GeoPositionnement();
        positionRoute.setPointClic(pointClic);
        if (margeRechercheRoute != -1) {
            if (!verrouillerNomRoute) {
                InfoTroncon troncon;
                int iTroncon;
                listeTronconsTrouves = Recherche.getTroncons(listeRoutesPrincipales, pointRoute, 1000);
                if (listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                                if (!routeSansNomTrouve) {
                                    routeSansNomTrouve = true;
                                }
                                LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                            } else {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves");
                                tronconTrouve = true;
                            }
                        }
                        ++iTroncon;
                    }
                }
                if ((!tronconTrouve || clicDroit) && (listeTronconsTrouves = Recherche.getTroncons(listeRoutesSecondaires, pointRoute, 1000)).size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                                if (!routeSansNomTrouve) {
                                    routeSansNomTrouve = true;
                                }
                                LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                            } else {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves");
                                tronconTrouve = true;
                            }
                        }
                        ++iTroncon;
                    }
                }
            } else {
                LocalisationInfo.ecrireLog("+--> Recherche nom route verrouill\u00e9");
                LocalisationInfo.ecrireLog("+--> ICouche recherche " + localisation.getCoucheRoute() + " -- ");
                if (localisation.getCoucheRoute() != null) {
                    InfoTroncon troncon;
                    int iTroncon;
                    listeTronconsTrouves = Recherche.getTroncons(localisation.getCoucheRoute(), pointRoute, 1000);
                    if (listeTronconsTrouves.size() > 0) {
                        LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                        iTroncon = 0;
                        while (iTroncon < listeTronconsTrouves.size()) {
                            troncon = listeTronconsTrouves.get(iTroncon);
                            tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                            if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                                if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                                    if (!routeSansNomTrouve) {
                                        routeSansNomTrouve = true;
                                    }
                                    LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                                } else {
                                    LocalisationInfo.ecrireLog("+--> Troncons trouves route");
                                    tronconTrouve = true;
                                }
                            }
                            ++iTroncon;
                        }
                    }
                    if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretellePrincipale(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                        LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                        iTroncon = 0;
                        while (iTroncon < listeTronconsTrouves.size()) {
                            troncon = listeTronconsTrouves.get(iTroncon);
                            tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                            if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves bretelle 1");
                                tronconTrouve = true;
                            }
                            ++iTroncon;
                        }
                    }
                    if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretelleSecondaire(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                        LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                        iTroncon = 0;
                        while (iTroncon < listeTronconsTrouves.size()) {
                            troncon = listeTronconsTrouves.get(iTroncon);
                            tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                            if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves bretelle 2");
                                tronconTrouve = true;
                            }
                            ++iTroncon;
                        }
                    }
                } else if (verrouillerIdgdfRoute) {
                    LocalisationInfo.ecrireLog("+--> Recherche Idgdf " + localisation.getIdgdfRoute() + " - recherche sur les troncons");
                    InfoTroncon troncon = verrouillerIdgdfRouteBretelle ? Recherche.rechercherPremierTroncon(LocalisationInfo.LISTE_BRETELLES, 0, localisation.getIdgdfRoute()) : Recherche.rechercherPremierTroncon(LocalisationInfo.LISTE_TOUTES_ROUTES, 0, localisation.getIdgdfRoute());
                    if (troncon == null) {
                        listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.LISTE_ROUTES, pointRoute, 1000);
                        if (listeTronconsTrouves != null && listeTronconsTrouves.size() > 0) {
                            LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                            int iTroncon = 0;
                            while (iTroncon < listeTronconsTrouves.size()) {
                                troncon = listeTronconsTrouves.get(iTroncon);
                                tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                                if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                                    LocalisationInfo.ecrireLog("+--> Troncons trouves");
                                    tronconTrouve = true;
                                }
                                ++iTroncon;
                            }
                        }
                    } else {
                        positionRoute.repositionner(troncon);
                        tronconTrouve = true;
                    }
                } else {
                    LocalisationInfo.ecrireLog("+--> Recherche sur toutes les routes ayant le meme nom " + localisation.getRoute() + " au point " + pointRoute + " " + localisation.getNomRouteVerrouillee());
                    listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.LISTE_ROUTES, pointRoute, 1000);
                    if (listeTronconsTrouves.size() > 0) {
                        LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                        LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                        int iTroncon = 0;
                        while (iTroncon < listeTronconsTrouves.size()) {
                            InfoTroncon troncon = listeTronconsTrouves.get(iTroncon);
                            if (LocalisationInfo.estCoucheBretelle(troncon.getCouche()) || GLS.egal(troncon.getNom(), localisation.getNomRouteVerrouillee())) {
                                LocalisationInfo.ecrireLog("IDGDF TRONCON COURANT " + troncon.getIdgdf());
                                tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                                if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                                    LocalisationInfo.ecrireLog("+--> Troncons trouves " + positionRoute.getDistanceProjection());
                                    tronconTrouve = true;
                                }
                            }
                            ++iTroncon;
                        }
                    } else {
                        LocalisationInfo.ecrireLog("Aucun troncon aux alentours");
                    }
                }
            }
        }
        if (tronconTrouve) {
            routeTemp = positionRoute.getTroncon().getNom();
            LocalisationInfo.ecrireLogDebug("ICouche troncon trouve " + positionRoute.getTroncon().getCouche().getNom());
            LocalisationInfo.ecrireLogDebug("Idgdf troncon trouve " + positionRoute.getTroncon().getIdgdf());
            LocalisationInfo.ecrireLogDebug("Distance projection " + positionRoute.getDistanceProjection());
            LocalisationInfo.ecrireLogDebug("Nom route trouve " + routeTemp);
            if (LocalisationInfo.estCoucheBretelle(positionRoute.getTroncon().getCouche())) {
                routeTrouve = true;
            } else if (!routeTemp.equals("")) {
                if (!verrouillerNomRoute) {
                    routeTrouve = true;
                } else if (routeTemp.equals(localisation.getRoute())) {
                    routeTrouve = true;
                } else {
                    routeTrouve = false;
                    codeErreur = 2;
                }
            } else if (autoriserLocalisationSansRoute) {
                routeTrouve = true;
            } else {
                LocalisationInfo.ecrireLog("#--> ERREUR TRONCON SANS NOM # Localisation impossible");
                codeErreur = 1;
            }
        } else if (autoriserLocalisationSansRoute) {
            positionRoute.initialiser();
            positionRoute.setPoint(pointClic);
            routeTrouve = true;
        } else {
            codeErreur = !verrouillerNomRoute ? (routeSansNomTrouve ? 1 : 0) : (routeSansNomTrouve ? 1 : 2);
        }
        if (!routeTrouve) {
            LocalisationInfo.ecrireLog("+--> Code erreur " + codeErreur);
            switch (codeErreur) {
                case 0: {
                    throw new ErreurAucuneRoute();
                }
                case 2: {
                    throw new ErreurRouteModification();
                }
                case 1: {
                    throw new ErreurPR();
                }
            }
            throw new ErreurAucuneRoute();
        }
        return positionRoute;
    }

    public static GeoPositionnement getRouteAtPoint(Localisation localisation, String[] TOUTES_ROUTES, String[] ROUTES_PRINCIPALES, String[] ROUTES_SECONDAIRES, GeoPoint pointClic, boolean clicDroit) throws ErreurAucuneRoute, ErreurPR, ErreurRouteModification {
        boolean routeTrouve = false;
        boolean tronconTrouve = false;
        boolean routeSansNomTrouve = false;
        boolean verrouillerNomRoute = false;
        boolean verrouillerIdgdfRoute = false;
        boolean tronconPlusProche = false;
        GeoPositionnement positionRoute = null;
        int codeErreur = 0;
        String routeTemp = "";
        LocalisationInfo.ecrireLog("+--> Recherche au point " + pointClic);
        verrouillerNomRoute = localisation.getVerrouillageNomRoute();
        verrouillerIdgdfRoute = localisation.getVerrouillageIdgdfRouteAssociee();
        GeoPoint pointRoute = pointClic;
        Vector<InfoTroncon> listeTronconsTrouves = null;
        int margeRechercheRoute = LocalisationInfo.margeRechercheRoute;
        positionRoute = new GeoPositionnement();
        positionRoute.setPointClic(pointClic);
        if (!verrouillerNomRoute) {
            InfoTroncon troncon;
            int iTroncon;
            listeTronconsTrouves = Recherche.getTroncons(ROUTES_PRINCIPALES, pointRoute, 1000);
            if (listeTronconsTrouves.size() > 0) {
                LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                iTroncon = 0;
                while (iTroncon < listeTronconsTrouves.size()) {
                    troncon = listeTronconsTrouves.get(iTroncon);
                    tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                    if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                        if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                            if (!routeSansNomTrouve) {
                                routeSansNomTrouve = true;
                            }
                            LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                        } else {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves");
                            tronconTrouve = true;
                        }
                    }
                    ++iTroncon;
                }
            }
            if ((!tronconTrouve || clicDroit) && (listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.LISTE_ROUTES_SECONDAIRES, pointRoute, 1000)).size() > 0) {
                LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                iTroncon = 0;
                while (iTroncon < listeTronconsTrouves.size()) {
                    troncon = listeTronconsTrouves.get(iTroncon);
                    tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                    if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                        if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                            if (!routeSansNomTrouve) {
                                routeSansNomTrouve = true;
                            }
                            LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                        } else {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves");
                            tronconTrouve = true;
                        }
                    }
                    ++iTroncon;
                }
            }
        } else {
            LocalisationInfo.ecrireLog("+--> Recherche nom route verrouill\u00e9");
            LocalisationInfo.ecrireLog("+--> ICouche recherche " + localisation.getCoucheRoute() + " -- " + verrouillerIdgdfRoute);
            if (localisation.getCoucheRoute() != null) {
                InfoTroncon troncon;
                int iTroncon;
                listeTronconsTrouves = Recherche.getTroncons(localisation.getCoucheRoute(), pointRoute, 1000);
                if (listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                                if (!routeSansNomTrouve) {
                                    routeSansNomTrouve = true;
                                }
                                LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                            } else {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves route");
                                tronconTrouve = true;
                            }
                        }
                        ++iTroncon;
                    }
                }
                if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretellePrincipale(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves bretelle 1");
                            tronconTrouve = true;
                        }
                        ++iTroncon;
                    }
                }
                if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretelleSecondaire(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves bretelle 2");
                            tronconTrouve = true;
                        }
                        ++iTroncon;
                    }
                }
            } else if (verrouillerIdgdfRoute) {
                LocalisationInfo.ecrireLog("+--> Recherche Idgdf " + localisation.getIdgdfRouteAssociee() + " - recherche sur les troncons");
                listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.LISTE_ROUTES, pointRoute, 1000);
                if (listeTronconsTrouves != null && listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    int iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        InfoTroncon troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves");
                            tronconTrouve = true;
                        }
                        ++iTroncon;
                    }
                }
            } else {
                InfoTroncon troncon;
                int iTroncon;
                LocalisationInfo.ecrireLog("+--> Recherche sur toutes les routes ayant le meme nom " + localisation.getRoute() + " au point " + pointRoute);
                listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.LISTE_TOUTES_ROUTES, pointRoute, 1000);
                if (listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            if (troncon.getNom().equals("") && !LocalisationInfo.estCoucheBretelle(troncon.getCouche())) {
                                if (!routeSansNomTrouve) {
                                    routeSansNomTrouve = true;
                                }
                                LocalisationInfo.ecrireLog("+--> Erreur troncon sans nom " + troncon.getIdgdf());
                            } else {
                                LocalisationInfo.ecrireLog("+--> Troncons trouves " + positionRoute.getDistanceProjection());
                                tronconTrouve = true;
                            }
                        }
                        ++iTroncon;
                    }
                }
                if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretellePrincipale(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves bretelle 1 " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves " + positionRoute.getDistanceProjection());
                            tronconTrouve = true;
                        }
                        ++iTroncon;
                    }
                }
                if ((listeTronconsTrouves = Recherche.getTroncons(LocalisationInfo.getCoucheBretelleSecondaire(), pointRoute, 1000)) != null && listeTronconsTrouves.size() > 0) {
                    LocalisationInfo.ecrireLog("+--> Nb troncons trouves bretelle 2 " + listeTronconsTrouves.size());
                    iTroncon = 0;
                    while (iTroncon < listeTronconsTrouves.size()) {
                        troncon = listeTronconsTrouves.get(iTroncon);
                        tronconPlusProche = positionRoute.repositionnerSiPlusProche(troncon);
                        if (tronconPlusProche && positionRoute.getDistanceProjection() < (double)margeRechercheRoute) {
                            LocalisationInfo.ecrireLog("+--> Troncons trouves");
                            tronconTrouve = true;
                        }
                        ++iTroncon;
                    }
                }
            }
        }
        if (tronconTrouve) {
            routeTemp = positionRoute.getTroncon().getNom();
            LocalisationInfo.ecrireLogDebug("ICouche troncon trouve " + positionRoute.getTroncon().getCouche().getNom());
            LocalisationInfo.ecrireLogDebug("Idgdf troncon trouve " + positionRoute.getTroncon().getIdgdf());
            LocalisationInfo.ecrireLogDebug("Distance projection " + positionRoute.getDistanceProjection());
            LocalisationInfo.ecrireLogDebug("Nom route trouve " + routeTemp);
            if (LocalisationInfo.estCoucheBretelle(positionRoute.getTroncon().getCouche())) {
                routeTrouve = true;
            } else if (!routeTemp.equals("")) {
                if (!verrouillerNomRoute) {
                    routeTrouve = true;
                } else if (routeTemp.equals(localisation.getRoute())) {
                    routeTrouve = true;
                } else {
                    routeTrouve = false;
                    codeErreur = 2;
                }
            } else {
                LocalisationInfo.ecrireLog("#--> ERREUR TRONCON SANS NOM # Localisation impossible");
                codeErreur = 1;
            }
        } else {
            codeErreur = !verrouillerNomRoute ? (routeSansNomTrouve ? 1 : 0) : (routeSansNomTrouve ? 1 : 2);
        }
        if (!routeTrouve) {
            LocalisationInfo.ecrireLog("+--> Code erreur " + codeErreur);
            switch (codeErreur) {
                case 0: {
                    throw new ErreurAucuneRoute();
                }
                case 2: {
                    throw new ErreurRouteModification();
                }
                case 1: {
                    throw new ErreurPR();
                }
            }
            throw new ErreurAucuneRoute();
        }
        return positionRoute;
    }

    public GeoPositionnement getTronconEnFace() throws ErreurAucunTronconEnFace {
        return Recherche.getTronconEnFace(this.localisation);
    }

    public static GeoPositionnement getTronconEnFace(Localisation localisation) throws ErreurAucunTronconEnFace {
        if (localisation == null) {
            return null;
        }
        return Recherche.getTronconEnFace(localisation.getTriRoute());
    }

    public static GeoPositionnement getTronconEnFace(TriRoute tri) throws ErreurAucunTronconEnFace {
        GeoPositionnement geoPositionnement;
        LocalisationInfo.ecrireLog("+--> Recherche troncon en face ");
        try {
            geoPositionnement = tri.getGeoPositionnement();
        }
        catch (Exception e) {
            LocalisationInfo.ecrireLogErreur("#--> ERREUR " + e.getMessage());
            geoPositionnement = tri.getGeoPositionnement();
        }
        if (!tri.estSensFixe() && geoPositionnement.getTroncon().estASensUnique()) {
            Vector listeTronconSensUnique = tri.getListeTronconsSensUnique();
            Vector<InfoTroncon> listeTronconSensUniqueEnFace = new Vector<InfoTroncon>();
            int i = 0;
            while (i < listeTronconSensUnique.size()) {
                InfoTroncon troncon = (InfoTroncon)listeTronconSensUnique.get(i);
                if (!tri.estDedans(troncon)) {
                    listeTronconSensUniqueEnFace.add(troncon);
                }
                ++i;
            }
            if (listeTronconSensUniqueEnFace.size() > 0) {
                GeoPositionnement tronconEnFace = new GeoPositionnement(geoPositionnement.getPoint(), (InfoTroncon)listeTronconSensUniqueEnFace.get(0));
                int i2 = 1;
                while (i2 < listeTronconSensUniqueEnFace.size()) {
                    tronconEnFace.repositionnerSiPlusProche((InfoTroncon)listeTronconSensUniqueEnFace.get(i2));
                    ++i2;
                }
                if (tronconEnFace.getDistanceProjection() <= (double)LocalisationInfo.DISTANCE_MAX_RECHERCHE_TRONCON_EN_FACE) {
                    LocalisationInfo.ecrireLog("+--> Distance min troncon en face " + tronconEnFace.getDistanceProjection());
                    return tronconEnFace;
                }
            }
        }
        if (tri.getGeoPositionnement() != null && tri.getGeoPositionnement().getTroncon() != null) {
            throw new ErreurAucunTronconEnFace(tri.getGeoPositionnement().getTroncon().getIdgdf());
        }
        throw new ErreurAucunTronconEnFace();
    }

    public static String getNomRouteAlertc(long id) throws Exception {
        EntiteAlertc entiteAlertc = ListeEntiteAlertc.getLocalisant(id);
        if (entiteAlertc != null) {
            return entiteAlertc.getNomRoute();
        }
        throw new Exception("LE POINT ALERTC " + id + " N'EXISTE PAS");
    }

    public static int getIndiceCommune(String nomCommune) {
        if (LocalisationInfo.getListeNomsCommunes() != null && LocalisationInfo.getListeNomsCommunes().length > 0) {
            boolean trouve = false;
            boolean fin = false;
            boolean communeAvecDepartement = false;
            String dpt = null;
            int i = 0;
            nomCommune = nomCommune.toLowerCase().replace('\u00e9', 'e').replace('\u00e8', 'e').replace('\u00ea', 'e').replace('\u00f9', 'u');
            Collator c = CollatorFactory.create();
            if (LocalisationInfo.estCommuneAvecDepartement(nomCommune)) {
                LocalisationInfo.ecrireLog("+--> Recherche sur " + nomCommune);
                communeAvecDepartement = true;
                dpt = nomCommune.substring(0, 2);
                nomCommune = nomCommune.substring(2);
                LocalisationInfo.ecrireLog("+--> Recherche commune avec departement " + nomCommune + " - " + dpt);
            } else {
                LocalisationInfo.ecrireLog("+--> Recherche commune sans departement " + nomCommune);
                communeAvecDepartement = false;
            }
            while (!trouve && !fin) {
                if (c.compare(LocalisationInfo.getListeNomsCommunes()[i].toLowerCase(), nomCommune) == 0) {
                    if (communeAvecDepartement) {
                        if (LocalisationInfo.getListeDptCommunes()[i].equals(dpt)) {
                            trouve = true;
                        } else {
                            ++i;
                        }
                    } else {
                        trouve = true;
                    }
                } else {
                    ++i;
                }
                boolean bl = fin = i == LocalisationInfo.getListeNomsCommunes().length;
            }
            if (trouve) {
                int num = LocalisationInfo.getCoucheCommuneZone().getCont().getEnt(i).getNum();
                EntGeo[] entGeo = LocalisationInfo.getCoucheCommuneZone().getCont().getTabEnt();
                int j = 0;
                while (j < entGeo.length) {
                    if (entGeo[j].getNum() == i) {
                        num = j;
                        break;
                    }
                    ++j;
                }
                LocalisationInfo.ecrireLog("Nbent " + LocalisationInfo.getCoucheCommuneZone().getCont().getNbent());
                LocalisationInfo.ecrireLog("Nbval " + LocalisationInfo.getCoucheCommuneZone().getDon().getNbval());
                LocalisationInfo.ecrireLog("Nbnomcom " + LocalisationInfo.getListeNomsCommunes().length);
                return num;
            }
            return -1;
        }
        return -1;
    }

    public static GeoPositionnement getPositionAtDistance(Tri tri, double distanceAParcourir, boolean sensPr) throws ErreurLimiteRoute {
        return Recherche.getPositionAtDistance(tri, tri.getGeoPositionnement(), sensPr != distanceAParcourir >= 0.0 ? distanceAParcourir * -1.0 : distanceAParcourir);
    }

    public static GeoPositionnement getPositionAtDistance(Tri tri, GeoPositionnement position, double distanceAParcourir, boolean sensPr) throws ErreurLimiteRoute {
        return Recherche.getPositionAtDistance(tri, position, sensPr != distanceAParcourir >= 0.0 ? distanceAParcourir * -1.0 : distanceAParcourir);
    }

    public static GeoPositionnement getPositionAtDistance(Tri tri, double distanceAParcourir) throws ErreurLimiteRoute {
        return Recherche.getPositionAtDistance(tri, tri.getGeoPositionnement(), distanceAParcourir);
    }

    public static GeoPositionnement getPositionAtDistance(Tri tri, GeoPositionnement position, double distanceAParcourir) throws ErreurLimiteRoute {
        GeoPositionnement positionAtDistance = null;
        if (tri != null && position != null) {
            double distanceRestante = distanceAParcourir;
            if (distanceRestante >= 0.0) {
                if (distanceRestante <= (double)position.getDistanceFin()) {
                    positionAtDistance = new GeoPositionnement(position.getTroncon(), distanceAParcourir + (double)position.getDistanceDebut());
                    positionAtDistance.setIndiceTri(tri.getIndiceTroncon(position));
                } else {
                    int i = tri.getIndiceTroncon(position.getTroncon()) + 1;
                    boolean fin = false;
                    distanceRestante -= (double)position.getDistanceFin();
                    while (positionAtDistance == null && !fin) {
                        try {
                            InfoTroncon troncon = tri.getTroncon(i);
                            if ((double)troncon.getLongueur() >= distanceRestante) {
                                positionAtDistance = new GeoPositionnement(troncon, distanceRestante);
                                positionAtDistance.setIndiceTri(i);
                            } else {
                                distanceRestante -= (double)troncon.getLongueur();
                            }
                            ++i;
                        }
                        catch (Exception e) {
                            fin = true;
                        }
                    }
                }
            } else if ((distanceRestante *= -1.0) <= (double)position.getDistanceDebut()) {
                positionAtDistance = new GeoPositionnement(position.getTroncon(), (double)position.getDistanceDebut() - distanceRestante);
                positionAtDistance.setIndiceTri(tri.getIndiceTroncon(position));
            } else {
                int i = tri.getIndiceTroncon(position.getTroncon()) - 1;
                boolean fin = false;
                distanceRestante -= (double)position.getDistanceDebut();
                while (positionAtDistance == null && !fin) {
                    try {
                        InfoTroncon troncon = tri.getTroncon(i);
                        if ((double)troncon.getLongueur() >= distanceRestante) {
                            positionAtDistance = new GeoPositionnement(troncon, (double)troncon.getLongueur() - distanceRestante);
                            positionAtDistance.setIndiceTri(i);
                        } else {
                            distanceRestante -= (double)troncon.getLongueur();
                        }
                        --i;
                    }
                    catch (Exception e) {
                        fin = true;
                    }
                }
            }
        }
        if (positionAtDistance == null) {
            throw new ErreurLimiteRoute();
        }
        return positionAtDistance;
    }

    public static Enregistrement getEnregistrement(ICouche couche, int champ, String valeur) {
        Enregistrement[] enregistrements = Recherche.getEnregistrements(couche, champ, valeur);
        if (enregistrements != null && enregistrements.length > 0) {
            return enregistrements[0];
        }
        return null;
    }

    public static Enregistrement getAdresseProche(Localisation l, GeoPoint p, int distanceMax) throws Exception {
        ICouche couche = LocalisationInfo.getCouche("adresse");
        String adresse = l.getAdresse();
        int[] champ = new int[]{3};
        String[] valeur = new String[]{adresse};
        String sensRoute = l.getSens().getSensChainageOk() ? "Droite" : "Gauche";
        Enregistrement[] enrs = Recherche.getEnregistrements(couche, champ, valeur);
        Enregistrement adresseProche = null;
        Enregistrement adresseProcheAutreSens = null;
        Enregistrement adresseProcheAutPart = null;
        double distanceMin = Double.MAX_VALUE;
        Enregistrement[] enregistrementArray = enrs;
        int n = enrs.length;
        int n2 = 0;
        while (n2 < n) {
            Enregistrement enr = enregistrementArray[n2];
            double[] d = Geometry.getCoordonneesEnregistrementDouble(couche.getCont(), enr);
            double distance = p.distance((float)d[0], (float)d[1]);
            if (distance < (double)distanceMax && distance < distanceMin) {
                if (l.getTri().getIndiceTronconAtIdgdf(enr.getValeur(0)) > -1) {
                    if (l.getTri().getGeoPositionnement().getTroncon().estASensUnique() || GLS.egal(enr.getValeur(5), sensRoute) || GLS.egal(enr.getValeur(5), "NR")) {
                        adresseProche = enr;
                    } else {
                        adresseProcheAutreSens = enr;
                    }
                } else {
                    adresseProcheAutPart = enr;
                }
                distanceMin = distance;
            }
            ++n2;
        }
        if (adresseProche != null) {
            return adresseProche;
        }
        if (adresseProcheAutreSens != null) {
            return adresseProcheAutreSens;
        }
        throw new Exception("Aucune adresse trouv\u00e9e");
    }

    public static GeoPositionnement getPositionnementProcheAtPoint(String[] listeCouches, int[] champ, String[] valeur, GeoPoint point) throws Exception {
        Vector<InfoTroncon> troncons = Recherche.getTroncons(listeCouches, champ, valeur);
        GeoPositionnement position = new GeoPositionnement(point);
        for (InfoTroncon troncon : troncons) {
            position.repositionnerSiPlusProche(troncon);
        }
        return position;
    }

    public static GeoPositionnement getPositionnementProcheAtPoint(String[] listeCouches, GeoPoint point, int distance) throws Exception {
        Vector<InfoTroncon> troncons = Recherche.getTroncons(listeCouches, point, distance);
        GeoPositionnement position = new GeoPositionnement(point);
        position.setDistanceProjectionMaximum(distance);
        for (InfoTroncon troncon : troncons) {
            position.repositionnerSiPlusProche(troncon);
        }
        return position;
    }

    public static Enregistrement getEntiteCouchePr(String nomRoute, String entitePr) throws Exception {
        int[] champs = new int[]{0, 1};
        String[] valeurs = new String[]{nomRoute, entitePr};
        ICouche couche = LocalisationInfo.getCouche("pr");
        if (couche != null) {
            Enregistrement enr = Recherche.getEnregistrement(couche, champs, valeurs);
            if (enr != null) {
                return enr;
            }
            throw new Exception("LE PR " + entitePr + " DE LA ROUTE " + nomRoute + " N'EXISTE PAS");
        }
        throw new Exception("ERREUR COUCHE PR INEXISTANTE");
    }

    public static Enregistrement getEntiteCouchePr(String nomRoute, String entitePr, String type) throws Exception {
        int[] champs = new int[]{0, 1, 3};
        String[] valeurs = new String[]{nomRoute, entitePr};
        valeurs[2] = type;
        ICouche couche = LocalisationInfo.getCouche("pr");
        if (couche != null) {
            Enregistrement enr = Recherche.getEnregistrement(couche, champs, valeurs);
            if (enr != null) {
                return enr;
            }
            throw new Exception("LE PR " + entitePr + " DE LA ROUTE " + nomRoute + " N'EXISTE PAS");
        }
        throw new Exception("ERREUR COUCHE PR INEXISTANTE");
    }

    public static Enregistrement getEntiteCouchePlo(String nomRoute, String plo, String abscissePlo) throws Exception {
        int[] champs = new int[]{0, 1, 2};
        String[] valeurs = new String[]{nomRoute, plo, abscissePlo};
        ICouche couche = LocalisationInfo.getCouche("plo");
        if (couche != null) {
            Enregistrement enr = Recherche.getEnregistrement(couche, champs, valeurs);
            if (enr != null) {
                return enr;
            }
            throw new Exception("LE PLO " + plo + "+" + abscissePlo + " DE LA ROUTE " + nomRoute + " N'EXISTE PAS");
        }
        throw new Exception("ERREUR COUCHE PLO INEXISTANTE");
    }

    public static List<String> getRoutes() {
        Extension listeAxe = new Extension();
        String[] stringArray = LocalisationInfo.LISTE_TOUTES_ROUTES;
        int n = LocalisationInfo.LISTE_TOUTES_ROUTES.length;
        int n2 = 0;
        while (n2 < n) {
            String nomCouche = stringArray[n2];
            ICouche couche = LocalisationInfo.getCouche(nomCouche);
            if (couche != null) {
                String[] colAxe;
                String[] stringArray2 = colAxe = couche.getDon().getColonne(1).getValeursToString();
                int n3 = colAxe.length;
                int n4 = 0;
                while (n4 < n3) {
                    String nomAxe = stringArray2[n4];
                    if (!listeAxe.existe(nomAxe)) {
                        listeAxe.setValeur(nomAxe, nomAxe);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return listeAxe.getValeurs();
    }

    public static Vector<GeoPositionnement> getPositionnementsProcheAtPoint(String[] listeCouches, GeoPoint point) throws Exception {
        Vector<GeoPositionnement> positions = new Vector<GeoPositionnement>();
        Vector<InfoTroncon> troncons = Recherche.getTroncons(listeCouches, point, 1);
        for (InfoTroncon troncon : troncons) {
            positions.add(new GeoPositionnement(point, troncon));
        }
        return positions;
    }

    public static Vector<BretelleInfo> getBretelleInfoProcheAtPoint(String[] listeCouches, GeoPoint point) {
        Vector<BretelleInfo> positions = new Vector<BretelleInfo>();
        Vector<InfoTroncon> troncons = Recherche.getTroncons(listeCouches, point, 1);
        for (InfoTroncon troncon : troncons) {
            positions.add(TriBretelle.creerInfoRoute(troncon.getCouche(), point, "", troncon.getTroncon()));
        }
        return positions;
    }

    public static Vector<InfoTroncon> getTroncons(String[] listeCouches, int[] champ, String[] valeur) throws Exception {
        if (listeCouches != null && listeCouches.length > 0 && valeur != null && champ != null) {
            Vector<InfoTroncon> troncons = new Vector<InfoTroncon>();
            String[] stringArray = listeCouches;
            int n = listeCouches.length;
            int n2 = 0;
            while (n2 < n) {
                String nomCouche = stringArray[n2];
                try {
                    for (InfoTroncon troncon : Recherche.getTroncons(LocalisationInfo.getCouche(nomCouche), champ, valeur)) {
                        troncons.add(troncon);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            if (troncons.size() > 0) {
                return troncons;
            }
            throw new Exception("AUCUN TRONCONS TROUVE");
        }
        throw new Exception("VERIFIEZ LES PARAMETRES DE RECHERCHE");
    }

    public static Vector<InfoTroncon> getTroncons(ICouche couche, int[] champ, String[] valeur) throws Exception {
        if (couche != null && valeur != null && champ != null) {
            Enregistrement[] enregistrements = couche.getDon().getEnreg(champ, valeur);
            if (enregistrements != null && enregistrements.length > 0) {
                Vector<InfoTroncon> troncons = new Vector<InfoTroncon>();
                Enregistrement[] enregistrementArray = enregistrements;
                int n = enregistrements.length;
                int n2 = 0;
                while (n2 < n) {
                    Enregistrement enregistrement = enregistrementArray[n2];
                    troncons.add(new InfoTroncon(enregistrement, couche));
                    ++n2;
                }
                return troncons;
            }
            throw new Exception("AUCUN TRONCON TROUVE");
        }
        throw new Exception("VERIFIER LES PARAMETRES DE RECHERCHE");
    }

    public static Enregistrement[] getEnregistrements(ICouche couche, int[] champ, String[] valeur) {
        if (couche != null && valeur != null && champ != null) {
            return couche.getDon().getEnreg(champ, valeur);
        }
        return null;
    }

    public static Enregistrement getEnregistrement(ICouche couche, int[] champ, String[] valeur) {
        Enregistrement[] enregistrements = Recherche.getEnregistrements(couche, champ, valeur);
        if (enregistrements != null && enregistrements.length > 0) {
            return enregistrements[0];
        }
        return null;
    }

    public static Enregistrement[] getEnregistrements(ICouche couche, int champ, String valeur) {
        if (champ != -1 && valeur != null) {
            int[] champsRecherches = new int[]{champ};
            String[] valeursRecherches = new String[]{valeur};
            return Recherche.getEnregistrements(couche, champsRecherches, valeursRecherches);
        }
        return null;
    }

    public static Vector<InfoTroncon> getTroncons(ICouche couche, Enregistrement[] troncons) {
        if (troncons != null && troncons.length > 0) {
            Vector<InfoTroncon> listeTroncons = new Vector<InfoTroncon>();
            LocalisationInfo.ecrireLog("Cont " + couche.getCont().getNbent() + " - Don " + couche.getDon().getNbval());
            int i = 0;
            while (i < troncons.length) {
                listeTroncons.add(new InfoTroncon(troncons[i], couche));
                ++i;
            }
            return listeTroncons;
        }
        LocalisationInfo.ecrireLog("+--> Aucun troncons trouves " + couche.getNom());
        return null;
    }

    public static Vector<InfoTroncon> getTroncons(ICouche couche, Vector troncons) {
        if (troncons != null && troncons.size() > 0) {
            LocalisationInfo.ecrireLog("+--> Troncons trouves " + couche.getNom());
            Vector<InfoTroncon> listeTroncons = new Vector<InfoTroncon>();
            int i = 0;
            while (i < troncons.size()) {
                listeTroncons.add(new InfoTroncon((Enregistrement)troncons.get(i), couche));
                ++i;
            }
            return listeTroncons;
        }
        LocalisationInfo.ecrireLog("+--> Aucun troncons trouves " + couche.getNom());
        return null;
    }

    public static InfoTroncon getTroncon(String[] listeCouches, int champ, String valeur) {
        Enregistrement enregistrement = null;
        InfoTroncon troncon = null;
        int i = 0;
        boolean trouve = false;
        while (!trouve && i < listeCouches.length) {
            ICouche couche = LocalisationInfo.getCouche(listeCouches[i]);
            if (couche != null && (enregistrement = Recherche.rechercherTroncon(couche.getDon(), champ, valeur)) != null) {
                troncon = new InfoTroncon(enregistrement, couche);
                trouve = true;
            }
            ++i;
        }
        return troncon;
    }

    public static InfoTroncon getTroncon(String[] listeCouches, int champ, String valeur, GeoPoint point, int etendue) {
        Enregistrement enregistrement = null;
        InfoTroncon troncon = null;
        int i = 0;
        boolean trouve = false;
        while (!trouve && i < listeCouches.length) {
            ICouche couche = LocalisationInfo.getCouche(listeCouches[i]);
            if (couche != null && (enregistrement = Recherche.rechercherTroncon(couche.getDon(), Recherche.rechercherTroncons(couche.getCont(), point, etendue), champ, valeur)) != null) {
                troncon = new InfoTroncon(enregistrement, couche);
                trouve = true;
            }
            ++i;
        }
        return troncon;
    }

    public static Vector getTroncons(String[] listeCouches, int champ, String valeur) {
        Vector listeTroncons = new Vector();
        int i = 0;
        while (i < listeCouches.length) {
            Vector listeTronconsTmp;
            ICouche couche = LocalisationInfo.getCouche(listeCouches[i]);
            if (couche != null && (listeTronconsTmp = Recherche.getTroncons(couche, champ, valeur)) != null && listeTronconsTmp.size() > 0) {
                int j = 0;
                while (j < listeTronconsTmp.size()) {
                    listeTroncons.add(listeTronconsTmp.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return listeTroncons;
    }

    public static Vector<InfoTroncon> getTroncons(String[] listeCouches, GeoPoint point, int etendue) {
        Vector<InfoTroncon> listeTroncons = new Vector<InfoTroncon>();
        int i = 0;
        while (i < listeCouches.length) {
            Vector<InfoTroncon> listeTronconsTmp;
            LocalisationInfo.ecrireLog("+-->Recherche sur: " + listeCouches[i]);
            ICouche couche = LocalisationInfo.getCouche(listeCouches[i]);
            if (couche != null && (listeTronconsTmp = Recherche.getTroncons(couche, point, etendue)) != null && listeTronconsTmp.size() > 0) {
                listeTroncons.addAll(listeTronconsTmp);
            }
            ++i;
        }
        return listeTroncons;
    }

    public static Vector getTroncons(String[] listeCouches, int champ, String valeur, GeoPoint point, int etendue) {
        Vector listeTroncons = new Vector();
        int i = 0;
        while (i < listeCouches.length) {
            Vector listeTronconsTmp;
            ICouche couche = LocalisationInfo.getCouche(listeCouches[i]);
            if (couche != null && (listeTronconsTmp = Recherche.getTroncons(couche, champ, valeur, point, etendue)) != null && listeTronconsTmp.size() > 0) {
                int j = 0;
                while (j < listeTronconsTmp.size()) {
                    listeTroncons.add(listeTronconsTmp.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return listeTroncons;
    }

    public static Vector getTroncons(ICouche couche, int champ, String valeur, GeoPoint point, int etendue) {
        if (couche != null) {
            return Recherche.getTroncons(couche, Recherche.rechercherTroncons(couche.getCont(), couche.getDon(), Recherche.getEnregistrements(couche, champ, valeur), point, etendue));
        }
        return null;
    }

    public static Vector<InfoTroncon> getTroncons(ICouche couche, GeoPoint point, int etendue) {
        if (couche != null) {
            return Recherche.getTroncons(couche, Recherche.rechercherTroncons(couche.getCont(), couche.getDon(), point, etendue));
        }
        return null;
    }

    public static int getDepartementAtPoint(GeoPoint point) {
        int numero = -1;
        if (point != null) {
            if (LocalisationInfo.aCoucheDepartement) {
                Enregistrement enr = Recherche.rechercherPremierDepartementDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[0]);
                if (enr != null) {
                    numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                } else {
                    enr = Recherche.rechercherPremierDepartementDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[1]);
                    if (enr != null) {
                        numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                    } else {
                        enr = Recherche.rechercherPremierDepartementDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[2]);
                        if (enr != null) {
                            numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                        }
                    }
                }
            } else if (LocalisationInfo.estLocalisableParCommune) {
                Enregistrement enr = Recherche.rechercherPremiereCommuneDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[0]);
                if (enr != null) {
                    numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                } else {
                    enr = Recherche.rechercherPremiereCommuneDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[1]);
                    if (enr != null) {
                        numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                    } else {
                        enr = Recherche.rechercherPremiereCommuneDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[2]);
                        if (enr != null) {
                            numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                        }
                    }
                }
            }
        }
        return numero;
    }

    public static boolean estDepartementProche(LocalisantPr pr, GeoPoint point) {
        boolean trouve = false;
        int numero = -1;
        if (LocalisationInfo.aCoucheDepartement) {
            Enregistrement enr = Recherche.rechercherPremierDepartementDistance(point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[0]);
            if (enr != null) {
                numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                if (numero == pr.getDepartement()) {
                    trouve = true;
                }
            } else {
                enr = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheDepartement(), point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[1]);
                if (enr != null) {
                    numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                    if (numero == pr.getDepartement()) {
                        trouve = true;
                    }
                } else {
                    enr = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheDepartement(), point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[2]);
                    if (enr != null && (numero = LocalisationInfo.getInt(enr.getValeur(1), -1)) == pr.getDepartement()) {
                        trouve = true;
                    }
                }
            }
        } else if (LocalisationInfo.estLocalisableParCommune) {
            Enregistrement enr = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[0]);
            if (enr != null) {
                numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                if (numero == pr.getDepartement()) {
                    trouve = true;
                }
            } else {
                enr = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[1]);
                if (enr != null) {
                    numero = LocalisationInfo.getInt(enr.getValeur(1), -1);
                    if (numero == pr.getDepartement()) {
                        trouve = true;
                    }
                } else {
                    enr = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), point, LocalisationInfo.DISTANCE_RECHERCHE_DEPARTEMENT[2]);
                    if (enr != null && (numero = LocalisationInfo.getInt(enr.getValeur(1), -1)) == pr.getDepartement()) {
                        trouve = true;
                    }
                }
            }
        }
        return trouve;
    }

    public static Vector getTroncons(ICouche couche, int champ, String valeur) {
        return Recherche.getTroncons(couche, Recherche.getEnregistrements(couche, champ, valeur));
    }

    public static List<float[][]> getCoordonneesCommune(String commune) {
        ArrayList<float[][]> listeCoordonnees = new ArrayList<float[][]>();
        if (!GLS.estVide(commune)) {
            try {
                int[] indices = new int[1];
                String[] valeurs = new String[]{commune};
                ICouche couche = LocalisationInfo.getCouche("zonecommune");
                Vector enregistrements = couche.getDon().getEnregVector(indices, valeurs);
                if (!GLS.estVide(enregistrements)) {
                    couche.reinitialisationSelection();
                    for (Enregistrement enr : enregistrements) {
                        listeCoordonnees.add(Geometry.toLL(Geometry.getListeCoordonneesEnregistrement(couche.getCont(), enr)));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listeCoordonnees;
    }

    public static List<float[][]> getCoordonneesRoute(String route) {
        ArrayList<float[][]> listeCoordonnees = new ArrayList<float[][]>();
        if (!GLS.estVide(route)) {
            try {
                int[] indices = new int[]{1};
                String[] valeurs = new String[]{route};
                ICouche couche = LocalisationInfo.getCouche(LocalisationInfo.CALQUE_CLASS2);
                Vector enregistrements = couche.getDon().getEnregVector(indices, valeurs);
                if (!GLS.estVide(enregistrements)) {
                    couche.reinitialisationSelection();
                    for (Enregistrement enr : enregistrements) {
                        listeCoordonnees.add(Geometry.toLL(Geometry.getListeCoordonneesEnregistrement(couche.getCont(), enr)));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listeCoordonnees;
    }

    public static GeoPositionnement getPositionnementAtAlertc(Tri tri, LocalisantAlertc localisantAlertc) {
        boolean trouve = false;
        boolean finListe = false;
        int j = 0;
        GeoPositionnement geoPositionnement = null;
        j = 0;
        finListe = tri.getNbTroncons() == 0;
        while (!trouve && !finListe) {
            InfoTroncon troncon;
            try {
                troncon = tri.getTroncon(j);
            }
            catch (Exception e) {
                troncon = null;
            }
            if (troncon.estAlertc()) {
                geoPositionnement = troncon.getPositionnementAlertc(localisantAlertc);
                trouve = geoPositionnement != null;
            }
            boolean bl = finListe = ++j == tri.getNbTroncons();
        }
        return geoPositionnement;
    }

    public static LocalisantPr getPrAtPositionnementDansTri(Localisation l, GeoPositionnement g) {
        GeoPositionnement positionPr = null;
        LocalisantPr pr = null;
        int indiceGeopositionnement = l.getTri().getIndiceTronconAtIdgdf(g.getTroncon().getIdgdf());
        if (l.getPosition().equals("t")) {
            if (l.getSens().getSensRoutePrpkOk()) {
                positionPr = GestionPr.getPositionPrPrecedent(l.getTriRoute(), indiceGeopositionnement, g, null);
                if (positionPr != null) {
                    pr = (LocalisantPr)positionPr.getObjet();
                    DistanceInfo d = Distance.distanceEntrePositionnements(l.getTri(), g, positionPr, indiceGeopositionnement, positionPr.getIndiceTri());
                    pr.setDistancePr(d.getDistance());
                }
            } else {
                positionPr = GestionPr.getPositionPrSuivant(l.getTriRoute(), indiceGeopositionnement, g, null);
                if (positionPr != null) {
                    pr = (LocalisantPr)positionPr.getObjet();
                    DistanceInfo d = Distance.distanceEntrePositionnements(l.getTri(), g, positionPr, indiceGeopositionnement, positionPr.getIndiceTri());
                    pr.setDistancePr(d.getDistance());
                }
            }
        } else if (l.getSens().getSensRoutePrpkOk()) {
            positionPr = GestionPr.getPositionPrPrecedent(l.getTriRoute(), indiceGeopositionnement, g, null);
            if (positionPr != null) {
                pr = (LocalisantPr)positionPr.getObjet();
                DistanceInfo d = Distance.distanceEntrePositionnements(l.getTri(), g, positionPr, indiceGeopositionnement, positionPr.getIndiceTri());
                pr.setDistancePr(d.getDistance());
            }
        } else {
            positionPr = GestionPr.getPositionPrSuivant(l.getTriRoute(), indiceGeopositionnement, g, null);
            if (positionPr != null) {
                pr = (LocalisantPr)positionPr.getObjet();
                DistanceInfo d = Distance.distanceEntrePositionnements(l.getTri(), g, positionPr, indiceGeopositionnement, positionPr.getIndiceTri());
                pr.setDistancePr(d.getDistance());
            }
        }
        if (pr == null) {
            String message = "ERREUR RECHERCHE PR " + l.getPosition() + " - " + l.getSens().getSensRoutePrpkOk() + " - IND " + indiceGeopositionnement + " - " + g.getTroncon().estInverse() + " (" + g + ") ";
            System.out.println("DEBUG ####################");
            System.out.println(message);
            positionPr = GestionPr.getPositionPrPrecedent(l.getTriRoute(), indiceGeopositionnement, g, null);
            System.out.println("LISTE PR " + GestionPr.getPr(l.getTri().getRoute()));
            System.out.println("PREC " + positionPr);
            positionPr = GestionPr.getPositionPrSuivant(l.getTriRoute(), indiceGeopositionnement, g, null);
            System.out.println("SUIV " + positionPr);
            System.out.println("####################");
        }
        return pr;
    }

    public static GeoPositionnement getPositionnementProcheAtPoint(Tri tri, GeoPoint point, double distanceMax) {
        boolean trouve = false;
        boolean finListe = false;
        int j = 0;
        GeoPositionnement geoPositionnement = null;
        j = 1;
        boolean bl = finListe = tri.getNbTroncons() == 0;
        if (!finListe) {
            InfoTroncon troncon;
            try {
                troncon = tri.getTroncon(0);
            }
            catch (Exception e) {
                troncon = null;
            }
            geoPositionnement = new GeoPositionnement(point, troncon);
            finListe = tri.getNbTroncons() == 1;
            while (!trouve && !finListe) {
                try {
                    troncon = tri.getTroncon(j);
                }
                catch (Exception e) {
                    troncon = null;
                }
                geoPositionnement.repositionnerSiPlusProche(troncon);
                boolean bl2 = finListe = ++j == tri.getNbTroncons() || troncon == null;
            }
            if (geoPositionnement != null && distanceMax != Double.MAX_VALUE && geoPositionnement.getDistanceProjection() > distanceMax) {
                geoPositionnement = null;
            }
        }
        return geoPositionnement;
    }

    public static GeoPositionnement getPositionnementProcheAtPoint(Vector listeTroncons, GeoPoint point, double distanceMax) {
        boolean trouve = false;
        boolean finListe = false;
        int j = 0;
        GeoPositionnement geoPositionnement = null;
        j = 1;
        boolean bl = finListe = listeTroncons.size() == 0;
        if (!finListe) {
            geoPositionnement = new GeoPositionnement(point, (InfoTroncon)listeTroncons.get(0));
            finListe = listeTroncons.size() == 1;
            while (!trouve && !finListe) {
                geoPositionnement.repositionnerSiPlusProche((InfoTroncon)listeTroncons.get(j));
                boolean bl2 = finListe = ++j == listeTroncons.size();
            }
            if (geoPositionnement != null && distanceMax != Double.MAX_VALUE && geoPositionnement.getDistanceProjection() > distanceMax) {
                geoPositionnement = null;
            }
        }
        return geoPositionnement;
    }

    public static GeoPositionnement getPositionAtAlertc(TriRoute tri, LocalisantAlertc localisantAlertc) {
        if (tri != null && localisantAlertc != null) {
            GeoPositionnement positionnementAlertc = null;
            int i = 0;
            LocalisationInfo.ecrireLog("+--> Nb troncons tri " + tri.getNbTroncons());
            while (positionnementAlertc == null && i < tri.getNbTroncons()) {
                InfoTroncon troncon;
                try {
                    troncon = tri.getTroncon(i);
                }
                catch (Exception e) {
                    troncon = null;
                }
                if (troncon.estAlertc()) {
                    positionnementAlertc = troncon.getPositionnementAlertc(localisantAlertc);
                }
                ++i;
            }
            return positionnementAlertc;
        }
        return null;
    }

    public static GeoPositionnement getPositionAtAlertc(LocalisantAlertc localisantAlertc) {
        GeoPositionnement geoPositionnement = null;
        InfoTroncon troncon = null;
        LocalisationInfo.ecrireLog("+--> Recherche sur la route " + localisantAlertc.getEntiteAlertc().getNomRoute());
        troncon = Recherche.getTroncon(localisantAlertc);
        if (troncon != null) {
            geoPositionnement = troncon.getPositionnementAlertc(localisantAlertc);
        }
        LocalisationInfo.ecrireLog("+--> Geopositionnement " + geoPositionnement);
        return geoPositionnement;
    }

    public static GeoPositionnement getPositionAtPR(TriRoute tri, LocalisantPr localisantPR) {
        return Recherche.getPositionAtPR(tri, localisantPR, true);
    }

    public static GeoPositionnement getPositionAtPR(TriRoute tri, LocalisantPr localisantPR, boolean testBaionnette) {
        if (tri != null && localisantPR != null) {
            GeoPositionnement positionnementPr = null;
            int i = 0;
            LocalisationInfo.ecrireLog("+--> Nb troncons tri " + tri.getNbTroncons());
            while (positionnementPr == null && i < tri.getNbTroncons()) {
                InfoTroncon troncon = tri.getTronconSansException(i);
                if (troncon.estPR()) {
                    positionnementPr = troncon.getPositionnementPR(localisantPR, testBaionnette);
                }
                ++i;
            }
            return positionnementPr;
        }
        return null;
    }

    public static GeoPositionnement rechercherObjetPlusProche(ICouche couche, GeoPoint point, int margeRecherche) {
        InfoTroncon enregistrementTmp = null;
        GeoPositionnement enregistrementTrouve = null;
        IFichierCont contRoute = couche.getCont();
        double distancePointProche = Double.MAX_VALUE;
        if (couche != null) {
            Enregistrement[] enregistrementArray = couche.getDon().getAllEnreg();
            int n = enregistrementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enregistrement enregistrement = enregistrementArray[n2];
                enregistrementTmp = new InfoTroncon(enregistrement, couche);
                GeoPoint pointTmp = Geometry.getProjectionPointTroncon(enregistrementTmp, point);
                double distanceTmp = pointTmp.distance(point);
                if (distanceTmp < (double)margeRecherche && distanceTmp < distancePointProche) {
                    if (enregistrementTrouve == null) {
                        enregistrementTrouve = new GeoPositionnement(pointTmp, enregistrementTmp);
                    } else {
                        enregistrementTrouve.repositionner(pointTmp, enregistrementTmp);
                    }
                    distancePointProche = distanceTmp;
                }
                ++n2;
            }
        }
        return enregistrementTrouve;
    }

    public static GeoPositionnement getPositionAtPR(String entitePr, String route) {
        LocalisantPr localisantPr = new LocalisantPr(entitePr);
        localisantPr.setRoute(route);
        if (!localisantPr.estVide()) {
            try {
                return Recherche.getPositionAtPR(localisantPr);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static GeoPositionnement getPositionAtPR(LocalisantPr localisantPR) throws ErreurAxeInconnu {
        return Recherche.getPositionAtPR(localisantPR, true);
    }

    public static GeoPositionnement getPositionAtPR(LocalisantPr localisantPR, boolean testBaionnette) throws ErreurAxeInconnu {
        boolean trouve = false;
        boolean finCouche = false;
        boolean finListe = false;
        int i = 0;
        int j = 0;
        GeoPositionnement geoPositionnement = null;
        InfoTroncon troncon = null;
        boolean aucunAxe = true;
        LocalisationInfo.ecrireLog("+--> Recherche sur la route " + localisantPR.getRoute());
        while (!trouve && !finCouche) {
            ICouche coucheRouteTmp = LocalisationInfo.getCouche(LocalisationInfo.LISTE_TOUTES_ROUTES[i]);
            if (coucheRouteTmp != null) {
                Vector listeTroncons = null;
                listeTroncons = Recherche.getTroncons(coucheRouteTmp, 1, localisantPR.getRoute());
                if (!GLS.estVide(listeTroncons)) {
                    aucunAxe = false;
                    Vector<GeoPositionnement> tronconsPR = new Vector<GeoPositionnement>();
                    j = 0;
                    finListe = listeTroncons.size() == 0;
                    LocalisationInfo.ecrireLog("+--> Nb troncons " + listeTroncons.size());
                    LocalisationInfo.ecrireLog("LOCALISANT RECHERCHE " + localisantPR);
                    while (!trouve && !finListe) {
                        GeoPositionnement geoPositionnementCourant;
                        troncon = (InfoTroncon)listeTroncons.get(j);
                        if (troncon.estPR() && (geoPositionnementCourant = troncon.getPositionnementPR(localisantPR, testBaionnette)) != null) {
                            tronconsPR.add(geoPositionnementCourant);
                        }
                        boolean bl = finListe = ++j == listeTroncons.size();
                    }
                    if (!GLS.estVide(tronconsPR)) {
                        if (tronconsPR.size() == 1) {
                            geoPositionnement = (GeoPositionnement)tronconsPR.get(0);
                        } else {
                            LocalisantPr localisantPrPosition2;
                            for (GeoPositionnement position : tronconsPR) {
                                try {
                                    localisantPrPosition2 = (LocalisantPr)position.getObjet();
                                    if (localisantPrPosition2.getEntitePr().getAbscisse() <= 0 || (long)localisantPrPosition2.getEntitePr().getAbscisse() > localisantPR.getDistancePr()) continue;
                                    geoPositionnement = position;
                                }
                                catch (Exception localisantPrPosition2) {
                                    // empty catch block
                                }
                            }
                            if (geoPositionnement == null) {
                                for (GeoPositionnement position : tronconsPR) {
                                    try {
                                        localisantPrPosition2 = (LocalisantPr)position.getObjet();
                                        if (localisantPrPosition2.getEntitePr().getAbscisse() != 0) continue;
                                        geoPositionnement = position;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        trouve = true;
                    }
                }
            }
            boolean bl = finCouche = ++i == LocalisationInfo.LISTE_TOUTES_ROUTES.length;
        }
        if (aucunAxe) {
            throw new ErreurAxeInconnu();
        }
        return geoPositionnement;
    }

    public static GeoPositionnement rechercherPremierTronconProcheDansCouche(ICouche couche, GeoPoint point, int etendue) {
        if (couche != null) {
            IFichierDon donRoute = couche.getDon();
            IFichierCont contRoute = couche.getCont();
            int nbTroncons = donRoute.getNbval();
            Enregistrement enregistrement = null;
            int i = 0;
            while (i < nbTroncons) {
                enregistrement = donRoute.getEnreg(i);
                GeoPoint projection = Geometry.getProjectionPointTroncon(contRoute, enregistrement, point);
                if (point.distance(projection) <= (double)etendue) {
                    return new GeoPositionnement(point, enregistrement, couche);
                }
                ++i;
                ++i;
            }
        }
        return null;
    }

    public static GeoPositionnement rechercherTronconPlusProche(ICouche couche, Vector listeTroncons, GeoPoint point, int margeRecherche) {
        InfoTroncon enregistrementTmp = null;
        GeoPositionnement enregistrementTrouve = null;
        IFichierCont contRoute = couche.getCont();
        double distancePointProche = Double.MAX_VALUE;
        int iTroncon = 0;
        while (iTroncon < listeTroncons.size()) {
            enregistrementTmp = (InfoTroncon)listeTroncons.get(iTroncon);
            GeoPoint pointTmp = Geometry.getProjectionPointTroncon(enregistrementTmp, point);
            double distanceTmp = pointTmp.distance(point);
            if (distanceTmp < (double)margeRecherche && distanceTmp < distancePointProche) {
                if (enregistrementTrouve == null) {
                    enregistrementTrouve = new GeoPositionnement(pointTmp, enregistrementTmp);
                } else {
                    enregistrementTrouve.repositionner(pointTmp, enregistrementTmp);
                }
                distancePointProche = distanceTmp;
            }
            ++iTroncon;
        }
        return enregistrementTrouve;
    }

    public static double rechercherDistancePlusProche(GeoPoint point, IFichierCont fichierCont, Enregistrement enregistrement, double distanceLaPlusProche) {
        double distanceMin = Double.MAX_VALUE;
        int iTroncon = enregistrement.getNum();
        float[] listeXTroncon = fichierCont.getX(iTroncon);
        float[] listeYTroncon = fichierCont.getY(iTroncon);
        int iPoint = 0;
        while (iPoint < listeXTroncon.length) {
            double distanceTmp = point.distance(listeXTroncon[iPoint], listeYTroncon[iPoint]);
            if (distanceTmp < distanceMin) {
                distanceMin = distanceTmp;
            }
            ++iPoint;
        }
        return distanceMin;
    }

    public static double rechercherDistancePlusProche(GeoPoint point, IFichierCont fichierCont, Enregistrement enregistrement) {
        return Recherche.rechercherDistancePlusProche(point, fichierCont, enregistrement, Double.MAX_VALUE);
    }

    public static int rechercherTroncon(IFichierCont contRoute, GeoPoint point) {
        boolean tronconsTrouves = false;
        int[] listeRoutesTrouvees = Recherche.rechercherTroncons(contRoute, point);
        tronconsTrouves = listeRoutesTrouvees.length > 0;
        LocalisationInfo.ecrireLog("+--> Nb routes trouvees # " + listeRoutesTrouvees.length);
        if (tronconsTrouves) {
            return listeRoutesTrouvees[0];
        }
        return -1;
    }

    public static int rechercherTroncon(IFichierCont contRoute, GeoPoint point, int etendue) {
        boolean tronconsTrouves = false;
        int[] listeRoutesTrouvees = Recherche.rechercherTroncons(contRoute, point, etendue);
        boolean bl = tronconsTrouves = listeRoutesTrouvees.length > 0;
        if (tronconsTrouves) {
            return listeRoutesTrouvees[0];
        }
        return -1;
    }

    public static InfoTroncon rechercherPremierTroncon(String[] listeCouches, int champ, String valeurRecherche) {
        String[] stringArray = listeCouches;
        int n = listeCouches.length;
        int n2 = 0;
        while (n2 < n) {
            Enregistrement troncon;
            String nomCouche = stringArray[n2];
            ICouche couche = LocalisationInfo.getCouche(nomCouche);
            if (couche != null && (troncon = Recherche.rechercherTroncon(couche.getDon(), champ, valeurRecherche)) != null) {
                return new InfoTroncon(troncon, couche);
            }
            ++n2;
        }
        return null;
    }

    public static Enregistrement rechercherTroncon(IFichierDon donRoute, int champ, String valeurRecherche) {
        int nbTroncons = donRoute.getNbval();
        String[] colonneChamp = donRoute.getColonne(champ).getValeursToString();
        boolean trouve = false;
        boolean fin = nbTroncons == 0;
        Enregistrement troncon = null;
        int i = 0;
        while (!trouve && !fin) {
            if (valeurRecherche.equals(colonneChamp[i])) {
                troncon = donRoute.getEnreg(i);
                trouve = true;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        return troncon;
    }

    public static Enregistrement rechercherTroncon(IFichierDon donRoute, int[] indicesEnregistrements, int champ, String valeurRecherche) {
        int nbTroncons = indicesEnregistrements.length;
        String[] colonneChamp = donRoute.getColonne(champ).getValeursToString();
        boolean trouve = false;
        boolean fin = nbTroncons == 0;
        Enregistrement troncon = null;
        int i = 0;
        while (!trouve && !fin) {
            if (valeurRecherche.equals(colonneChamp[indicesEnregistrements[i]])) {
                troncon = donRoute.getEnreg(i);
                trouve = true;
            }
            boolean bl = fin = ++i == nbTroncons;
        }
        return troncon;
    }

    public static InfoTroncon getTroncon(LocalisantAlertc alertc) {
        InfoTroncon troncon;
        ICouche couche;
        try {
            couche = LocalisationInfo.getCouche(alertc.getEntiteAlertc().getNomCouche());
        }
        catch (Exception e) {
            GLS.getLogs().error((Object)("### ERREUR LA COUCHE ENTITE ALERTC EST NULLE " + alertc));
            couche = null;
        }
        if (couche != null) {
            if (alertc.getEntiteAlertc().aGeometry()) {
                troncon = Recherche.getTronconAvecGeometrie(alertc, new String[]{alertc.getEntiteAlertc().getNomCouche()});
                if (troncon == null) {
                    troncon = Recherche.getTroncon(alertc, new String[]{alertc.getEntiteAlertc().getNomCouche()});
                }
            } else {
                troncon = Recherche.getTroncon(alertc, new String[]{alertc.getEntiteAlertc().getNomCouche()});
            }
        } else if (alertc.getEntiteAlertc().aGeometry()) {
            troncon = Recherche.getTronconAvecGeometrie(alertc, LocalisationInfo.LISTE_TOUTES_ROUTES);
            if (troncon == null) {
                troncon = Recherche.getTroncon(alertc, LocalisationInfo.LISTE_TOUTES_ROUTES);
            }
        } else {
            troncon = Recherche.getTroncon(alertc, LocalisationInfo.LISTE_TOUTES_ROUTES);
        }
        return troncon;
    }

    public static InfoTroncon getTroncon(LocalisantAlertc alertc, String[] nomCouches) {
        boolean finCouche = nomCouches == null || nomCouches.length == 0;
        boolean trouve = false;
        InfoTroncon troncon = null;
        int iCouche = 0;
        while (!trouve && !finCouche) {
            ICouche couche;
            try {
                couche = LocalisationInfo.getCouche(nomCouches[iCouche]);
            }
            catch (Exception e) {
                GLS.getLogs().error((Object)("### ERREUR LA COUCHE ENTITE ALERTC EST NULLE " + alertc));
                couche = null;
            }
            if (couche != null) {
                IFichierDon donRoute = couche.getDon();
                int nbTroncons = donRoute.getNbval();
                String[] colonneChamp = donRoute.getColonne(8).getValeursToString();
                boolean fin = nbTroncons == 0;
                int i = 0;
                while (!trouve && !fin) {
                    String valeurChamp = colonneChamp[i];
                    if (!LocalisationInfo.estVide(valeurChamp) && alertc.contains(valeurChamp)) {
                        troncon = new InfoTroncon(donRoute.getEnreg(i), couche);
                        trouve = true;
                    }
                    boolean bl = fin = ++i == nbTroncons;
                }
            }
            boolean bl = finCouche = ++iCouche == nomCouches.length;
        }
        return troncon;
    }

    public static InfoTroncon getTronconAvecGeometrie(LocalisantAlertc alertc, String[] nomCouches) {
        InfoTroncon troncon = null;
        if (alertc.getEntiteAlertc().aGeometry()) {
            boolean finCouche = nomCouches == null || nomCouches.length == 0;
            boolean trouve = false;
            int iCouche = 0;
            GeoPoint point = new GeoPoint(alertc.getEntiteAlertc().getPoint()).toNewUTM();
            while (!trouve && !finCouche) {
                Vector<InfoTroncon> troncons;
                ICouche couche;
                try {
                    couche = LocalisationInfo.getCouche(nomCouches[iCouche]);
                }
                catch (Exception e) {
                    GLS.getLogs().error((Object)("### ERREUR LA COUCHE ENTITE ALERTC EST NULLE " + alertc));
                    couche = null;
                }
                if (couche != null && !GLS.estVide(troncons = Recherche.getTroncons(couche, point, 1000))) {
                    int nbTroncons = troncons.size();
                    boolean fin = nbTroncons == 0;
                    int i = 0;
                    while (!trouve && !fin) {
                        InfoTroncon tronconTmp = troncons.get(i);
                        String valeurChamp = tronconTmp.getValeur(8);
                        if (!LocalisationInfo.estVide(valeurChamp) && alertc.contains(valeurChamp)) {
                            troncon = tronconTmp;
                            trouve = true;
                        }
                        boolean bl = fin = ++i == nbTroncons;
                    }
                }
                boolean bl = finCouche = ++iCouche == nomCouches.length;
            }
        }
        return troncon;
    }

    public static InfoTroncon rechercherTroncon(int champ, String valeurRecherche) {
        int nbCalque = LocalisationInfo.LISTE_TOUTES_ROUTES.length;
        boolean fin = nbCalque == 0;
        boolean trouve = false;
        ICouche couche = null;
        Enregistrement troncon = null;
        int i = 0;
        while (!trouve && !fin) {
            couche = LocalisationInfo.getCouche(LocalisationInfo.LISTE_TOUTES_ROUTES[i]);
            if (couche != null) {
                troncon = Recherche.rechercherTroncon(couche.getDon(), champ, valeurRecherche);
                trouve = troncon != null;
            }
            boolean bl = fin = i == LocalisationInfo.LISTE_TOUTES_ROUTES.length;
        }
        if (!trouve) {
            return null;
        }
        return new InfoTroncon(troncon, couche);
    }

    public static Vector rechercherTroncons(ICouche couche, GeoPoint point, int etendue) {
        if (couche != null && point != null) {
            return Recherche.rechercherTroncons(couche.getCont(), couche.getDon(), point, etendue);
        }
        return null;
    }

    public static Vector rechercherTroncons(IFichierCont contRoute, IFichierDon donRoute, GeoPoint point, int etendue) {
        if (point != null) {
            int[] listeEntites;
            Vector<Enregistrement> listeEnregistrements = new Vector<Enregistrement>();
            int[] nArray = listeEntites = contRoute.getAllNumEntXY((float)point.getX(), (float)point.getY(), (double)etendue);
            int n = listeEntites.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                listeEnregistrements.add(donRoute.getEnreg(i));
                ++n2;
            }
            return listeEnregistrements;
        }
        return new Vector();
    }

    public static Vector rechercherTroncons(IFichierCont contRoute, IFichierDon donRoute, Enregistrement[] listeEnregistrements, GeoPoint point, int etendue) {
        if (point != null && listeEnregistrements != null) {
            int nbTroncons = listeEnregistrements.length;
            Vector<Enregistrement> listeTroncons = new Vector<Enregistrement>();
            int i = 0;
            while (i < nbTroncons) {
                Enregistrement enregistrement = listeEnregistrements[i];
                int num = enregistrement.getNum();
                float[] listeX = contRoute.getX(i);
                float[] listeY = contRoute.getY(i);
                int nbPoints = listeX.length;
                int j = 0;
                boolean trouve = false;
                boolean fin = nbPoints == 0;
                while (!fin && !trouve) {
                    if (GeoPoint.distance(point, listeX[j], listeY[j]) <= (double)etendue) {
                        trouve = true;
                        listeTroncons.add(enregistrement);
                    }
                    boolean bl = fin = ++j == nbPoints;
                }
                ++i;
            }
            return listeTroncons;
        }
        return new Vector();
    }

    public static Vector rechercherTroncons(IFichierDon donRoute, int champ, String valeurRecherche) {
        int nbTroncons = donRoute.getNbval();
        String[] colonneChamp = donRoute.getColonne(champ).getValeursToString();
        Vector<Enregistrement> listeEnregistrements = new Vector<Enregistrement>();
        int i = 0;
        while (i < nbTroncons) {
            if (valeurRecherche.equals(colonneChamp[i])) {
                listeEnregistrements.add(donRoute.getEnreg(i));
            }
            ++i;
        }
        return listeEnregistrements;
    }

    public static String getChampEnregistrement(int numChamp, Enregistrement enregistrement) {
        if (numChamp != -1 && enregistrement != null) {
            try {
                return enregistrement.getValeur(numChamp);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static Enregistrement rechercherPremiereZoneDistance(ICouche couche, GeoPoint point, int etendue) {
        if (couche != null && point != null) {
            int[] indice = Recherche.rechercherEnregistrementsDistance(couche.getCont(), point, etendue);
            if (indice.length > 0) {
                int num = couche.getCont().getEnt(indice[0]).getNum();
                if (num < couche.getDon().getNbval()) {
                    return couche.getDon().getEnreg(num);
                }
                return null;
            }
            LocalisationInfo.ecrireLog("Aucun indice trouve " + couche.getNom());
            return null;
        }
        LocalisationInfo.ecrireLog("La couche ou le point est vide");
        return null;
    }

    public static Enregistrement rechercherPremierDepartementDistance(GeoPoint point, int etendue) {
        ICouche couche = LocalisationInfo.getCoucheDepartement();
        return Recherche.rechercherPremiereZoneDistance(couche, point, etendue);
    }

    public static Enregistrement rechercherPremiereCommuneDistance(GeoPoint point, int etendue) {
        ICouche couche = LocalisationInfo.getCoucheCommuneZone();
        return Recherche.rechercherPremiereZoneDistance(couche, point, etendue);
    }

    public static String rechercherPremiereCommune(float x, float y) {
        ICouche couche = LocalisationInfo.getCoucheCommuneZone();
        Enregistrement enr = Recherche.rechercherPremiereZoneDistance(couche, new GeoPoint(x, y), 1);
        if (enr != null) {
            return enr.getValeur(0);
        }
        return "";
    }

    public static Enregistrement rechercherPremierEnregistrementDistance(ICouche couche, GeoPoint point, int etendue) {
        if (couche != null) {
            int[] indice = Recherche.rechercherEnregistrementsDistance(couche.getCont(), point, etendue);
            if (indice.length > 0) {
                int num = couche.getCont().getEnt(indice[0]).getNum();
                LocalisationInfo.ecrireLog("Indices " + couche.getNom() + " (" + indice.length + ") " + indice[0] + " - num " + num);
                LocalisationInfo.ecrireLog("Type ICouche " + couche.getType());
                if (indice[0] != num) {
                    if (indice[0] < couche.getDon().getNbval()) {
                        num = indice[0];
                    } else if (num >= couche.getDon().getNbval()) {
                        num = -1;
                    }
                } else if (num >= couche.getDon().getNbval()) {
                    num = -1;
                }
                if (num != -1) {
                    return couche.getDon().getEnreg(num);
                }
                return null;
            }
            LocalisationInfo.ecrireLog("Aucun indice trouve " + couche.getNom());
            return null;
        }
        LocalisationInfo.ecrireLog("La couche n'existe pas");
        return null;
    }

    public static InfoTroncon rechercherPremierEnregistrementDistance(Vector couches, GeoPoint point, int etendue) {
        InfoTroncon infoTroncon = null;
        double distance = Double.MAX_VALUE;
        if (couches != null && couches.size() > 0) {
            int i = 0;
            while (i < couches.size()) {
                double distanceTmp;
                Enregistrement enregistrementTmp;
                ICouche couche = LocalisationInfo.getCouche((String)couches.get(i));
                if (couche != null && (enregistrementTmp = Recherche.rechercherPremierEnregistrementDistance(couche, point, etendue)) != null && (distanceTmp = Recherche.rechercherDistancePlusProche(point, couche.getCont(), infoTroncon.getTroncon(), distance)) < distance) {
                    if (infoTroncon != null) {
                        infoTroncon.set(enregistrementTmp, couche);
                    } else {
                        infoTroncon = new InfoTroncon(enregistrementTmp, couche);
                    }
                    distance = distanceTmp;
                }
                ++i;
            }
        }
        return infoTroncon;
    }

    public static int[] rechercherEnregistrementsDistance(IFichierCont cont, GeoPoint point, int etendue) {
        return cont.getAllNumEntXYPlusProche((float)point.getX(), (float)point.getY(), (double)etendue);
    }

    public static int[] rechercherTroncons(IFichierCont contRoute, GeoPoint point, int etendue) {
        return Recherche.rechercherEnregistrementsDistance(contRoute, point, etendue);
    }

    public static int[] rechercherTroncons(IFichierCont contRoute, GeoPoint point) {
        boolean tronconsTrouves = false;
        int iMargeRecherche = 0;
        int[] listeRoutesTrouvees = new int[]{};
        while (iMargeRecherche <= LocalisationInfo.margeRechercheRoute && !tronconsTrouves) {
            listeRoutesTrouvees = Recherche.rechercherTroncons(contRoute, point, iMargeRecherche);
            tronconsTrouves = listeRoutesTrouvees.length > 0;
            ++iMargeRecherche;
        }
        return listeRoutesTrouvees;
    }
}

