/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.pr;

import gls.localisation.InfoDepartement;
import gls.localisation.LocalisationInfo;
import gls.localisation.pr.EntitePr;
import gls.outils.GLS;

public class LocalisantPr {
    private EntitePr entitePr;
    private long distancePr;

    public LocalisantPr() {
    }

    public LocalisantPr(int pr, long distancePr) {
        this.entitePr = new EntitePr(pr);
        this.distancePr = distancePr;
    }

    public LocalisantPr(EntitePr entitePr, long distancePr) {
        this.entitePr = entitePr;
        this.distancePr = distancePr;
    }

    public LocalisantPr(String localisantPr) {
        this.setLocalisantPr(localisantPr);
    }

    public LocalisantPr(String localisantPr, String distancePr) {
        this.setPr(localisantPr);
        this.setDistancePr(distancePr);
    }

    public LocalisantPr(String localisantPr, long distancePr) {
        this.setPr(localisantPr);
        this.setDistancePr(distancePr);
    }

    public boolean aDepartement() {
        return this.entitePr != null && this.entitePr.aDepartement();
    }

    public void setPr(int pr) {
        if (pr == -1) {
            this.entitePr = null;
        } else {
            this.setEntitePr(new EntitePr(pr));
        }
    }

    public void setPr(String pr) {
        if (pr == null || pr.equals("")) {
            this.entitePr = null;
        } else {
            this.setEntitePr(new EntitePr(pr));
        }
    }

    public boolean estNulle() {
        return this.entitePr == null || this.entitePr.estNulle();
    }

    public void setDepartement(int departement) {
        if (!this.estNulle()) {
            this.entitePr.setDepartement(departement);
        }
    }

    public int getDepartement() {
        if (!this.estNulle()) {
            return this.entitePr.getDepartement();
        }
        return -1;
    }

    public void setRoute(String route) {
        if (!this.estNulle()) {
            this.entitePr.setRoute(route);
        }
    }

    public String getRoute() {
        if (!this.estNulle()) {
            return this.entitePr.getRoute();
        }
        return null;
    }

    public int getPr() {
        if (!this.estNulle()) {
            return this.entitePr.getPr();
        }
        return -1;
    }

    public void setLocalisantPr(String pr, long distance) {
        this.setPr(pr);
        this.setDistancePr(distance);
    }

    public void setLocalisantPr(LocalisantPr localisantPr) {
        this.setEntitePr(localisantPr.getEntitePr());
        this.setDistancePr(localisantPr.getDistancePr());
    }

    public boolean estVide() {
        return this.entitePr == null || this.entitePr.getPr() == -1;
    }

    public void setLocalisantPr(String pr) {
        int positionPlusPrpk = pr.indexOf(43);
        if (positionPlusPrpk == -1) {
            this.setPr(pr.trim());
            this.setDistancePr(0L);
        } else {
            this.setPr(pr.substring(0, positionPlusPrpk).trim());
            if (positionPlusPrpk == pr.length()) {
                this.setDistancePr(0L);
            } else {
                this.setDistancePr(pr.substring(positionPlusPrpk + 1));
            }
        }
    }

    public void setEntitePr(EntitePr entitePr) {
        this.entitePr = entitePr;
    }

    public void setDistancePr(long distancePr) {
        this.distancePr = this.entitePr == null ? 0L : distancePr + (long)this.entitePr.getAbscisse();
    }

    public void initialiseDistancePr(long distancePr) {
        this.distancePr = distancePr;
    }

    public void setDistancePr(String distancePr) {
        if (this.entitePr == null) {
            this.distancePr = 0L;
        } else {
            try {
                this.distancePr = Long.parseLong(distancePr);
            }
            catch (Exception e) {
                this.distancePr = 0L;
            }
        }
    }

    public boolean estBaionnette() {
        if (this.entitePr != null) {
            return this.entitePr.estBaionnette();
        }
        return false;
    }

    public boolean estAbscisseNegatif() {
        if (this.entitePr != null) {
            return this.entitePr.estAbscisseNegatif();
        }
        return false;
    }

    public EntitePr getEntitePr() {
        return this.entitePr;
    }

    public long getDistancePr() {
        return this.distancePr;
    }

    public boolean equals(EntitePr pr) {
        return this.equals(pr, false);
    }

    public boolean equals(EntitePr pr, boolean testBaionnette) {
        return !this.estNulle() && this.entitePr.equals(pr, testBaionnette);
    }

    public boolean equals(LocalisantPr pr) {
        return pr != null && this.equals(pr.getEntitePr());
    }

    public boolean equals(Object pr) {
        return this.equals(new LocalisantPr(GLS.getString(pr)));
    }

    public boolean equals(LocalisantPr pr, boolean distance) {
        if (!distance) {
            return this.equals(pr);
        }
        return this.equals(pr) && this.distancePr == pr.getDistancePr();
    }

    public boolean estApres(LocalisantPr pr) {
        return this.estApres(pr, false);
    }

    public boolean estApres(LocalisantPr pr, boolean testBaionnette) {
        boolean val = false;
        if (!this.estNulle() && pr != null && !pr.estNulle()) {
            if (this.aDepartement() && pr.aDepartement() && pr.getDepartement() != this.getDepartement()) {
                val = this.getPr() < pr.getPr();
            } else if (this.getPr() > pr.getPr()) {
                val = true;
            } else if (this.equals(pr.getEntitePr(), testBaionnette)) {
                val = this.estAbscisseNegatif() && pr.estAbscisseNegatif() ? this.distancePr < pr.getDistancePr() : (this.estAbscisseNegatif() || pr.estAbscisseNegatif() ? pr.estAbscisseNegatif() : this.distancePr > pr.getDistancePr());
            }
        }
        return val;
    }

    public boolean estAvant(LocalisantPr pr) {
        return this.estAvant(pr, false);
    }

    public boolean estAvant(LocalisantPr pr, boolean testBaionnette) {
        boolean val = false;
        if (!this.estNulle() && pr != null && !pr.estNulle()) {
            if (this.aDepartement() && pr.aDepartement() && pr.getDepartement() != this.getDepartement()) {
                val = this.getPr() > pr.getPr();
            } else if (this.getPr() < pr.getPr()) {
                val = true;
            } else if (this.equals(pr.getEntitePr(), testBaionnette)) {
                val = this.estAbscisseNegatif() && pr.estAbscisseNegatif() ? this.distancePr > pr.getDistancePr() : (this.estAbscisseNegatif() || pr.estAbscisseNegatif() ? this.estAbscisseNegatif() : this.distancePr < pr.getDistancePr());
            }
        }
        return val;
    }

    public static String toString(String pr, String distance, String departement) {
        if (!LocalisationInfo.estVide(pr) && GLS.getInt(pr) != -1) {
            String stringPr = "";
            stringPr = !LocalisationInfo.estNulle(departement) ? "(" + departement + ")" + pr : pr;
            if (!LocalisationInfo.estNulle(distance) && GLS.getInt(distance) != -1) {
                stringPr = String.valueOf(stringPr) + "+" + distance;
            }
            return stringPr;
        }
        return "";
    }

    public static String toString(String pr, InfoDepartement departement) {
        if (!LocalisationInfo.estVide(pr)) {
            if (departement != null) {
                return "(" + departement.getNumero() + ")" + pr;
            }
            return pr;
        }
        return "";
    }

    public static String toString(int pr, String departement) {
        return LocalisantPr.toString(String.valueOf(pr), departement);
    }

    public static String toString(String pr, String departement) {
        if (!LocalisationInfo.estNulle(pr)) {
            if (!LocalisationInfo.estNulle(departement) && !departement.equals("-1")) {
                if (GLS.estNumerique(departement)) {
                    int num = GLS.getInt(departement);
                    if (num < 10 && num > -1) {
                        return "(0" + String.valueOf(num) + ")" + pr;
                    }
                    return "(" + departement + ")" + pr;
                }
                return "(" + departement + ")" + pr;
            }
            return pr;
        }
        return "";
    }

    public String toString(boolean afficherDepartement) {
        if (this.entitePr == null || this.entitePr.estNulle()) {
            return "";
        }
        if (afficherDepartement) {
            return this.entitePr + "+" + this.distancePr;
        }
        return String.valueOf(this.entitePr.getPr()) + "+" + this.distancePr;
    }

    public String toString() {
        return this.toString(true);
    }
}

