/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.pr;

import cartoj.Enregistrement;
import cartoj.ICouche;
import gls.comparator.CollatorFactory;
import gls.comparator.MyCollator;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.distance.Distance;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.exception.ErreurPR;
import gls.localisation.pr.EntitePr;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.TriRoute;
import gls.outils.GLS;
import gls.outils.OutilsCartoJ;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GestionPr {
    private static final Logger log = Logger.getLogger(GestionPr.class);

    public static Vector<String> getPr(String route) {
        return GestionPr.getPr(route, false);
    }

    public static boolean estMemeDepartement(LocalisantPr pr1, LocalisantPr pr2) {
        if (pr1 != null && pr2 != null) {
            return GestionPr.estMemeDepartement(pr1.getDepartement(), pr2.getDepartement());
        }
        return true;
    }

    public static boolean estMemeDepartement(int deptPr1, int deptPr2) {
        return deptPr1 == -1 || deptPr2 == -1 || deptPr1 == deptPr2;
    }

    public static Vector<String> getPr(String route, boolean pourComboBox) {
        Vector<String> listePr = new Vector<String>();
        try {
            int[] indices = new int[1];
            String[] valeurs = new String[]{route};
            Object[] enregistrements = Recherche.getEnregistrements(LocalisationInfo.getCouche("pr"), indices, valeurs);
            if (!GLS.estVide(enregistrements)) {
                Object[] objectArray = enregistrements;
                int n = enregistrements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object enr = objectArray[n2];
                    String pr = enr.getValeur(1);
                    if (!GLS.estVide(pr)) {
                        listePr.add(pr);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception erreur) {
            log.debug((Object)("#--> ERREUR GET PR ROUTE INEXISTANT " + route));
        }
        MyCollator cfr_ignored_0 = (MyCollator)CollatorFactory.create();
        listePr = MyCollator.sortIntegerPositif(listePr);
        if (pourComboBox) {
            listePr.add(0, "");
        }
        return listePr;
    }

    public static final int getNumeroPr(String pr) {
        LocalisantPr localisantPr = new LocalisantPr(pr);
        return localisantPr.getPr();
    }

    public static DistanceInfo getDistanceInterPrPrecedent(TriRoute tri, LocalisantPr pr, boolean sensPr) {
        if (!sensPr) {
            return GestionPr.getDistanceInterPrSuivant(tri, pr);
        }
        return GestionPr.getDistanceInterPrPrecedent(tri, pr);
    }

    public static DistanceInfo getDistanceInterPrPrecedent(TriRoute tri, GeoPositionnement positionPr, LocalisantPr pr, boolean sensPr) {
        if (!sensPr) {
            return GestionPr.getDistanceInterPrSuivant(tri, positionPr, pr);
        }
        return GestionPr.getDistanceInterPrPrecedent(tri, positionPr, pr);
    }

    public static DistanceInfo getDistanceInterPrPrecedent(TriRoute tri, LocalisantPr pr) {
        if (tri != null) {
            return GestionPr.getDistanceInterPrPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), pr);
        }
        return new DistanceInfo();
    }

    public static DistanceInfo getDistanceInterPrPrecedent(TriRoute tri, int iTroncon, GeoPositionnement positionPr, LocalisantPr pr) {
        DistanceInfo distanceInterPr = new DistanceInfo();
        if (!LocalisationInfo.estNulle(iTroncon)) {
            GeoPositionnement positionPrPrecedent;
            if (tri.getNbPr() == 1) {
                if (tri.aPrDebut()) {
                    positionPrPrecedent = tri.getDernierPositionnement();
                    positionPrPrecedent.setObjet(tri.getPrMin());
                } else {
                    positionPrPrecedent = tri.getPremierPositionnement();
                    positionPrPrecedent.setObjet(tri.getPrMax());
                }
            } else {
                positionPrPrecedent = GestionPr.getPositionPrPrecedent(tri, iTroncon, positionPr, pr);
            }
            if (positionPrPrecedent != null) {
                LocalisationInfo.ecrireLog("+--> Le pr precedent a \u00e9t\u00e9 trouv\u00e9");
                distanceInterPr = Distance.distanceEntrePositionnements(tri, positionPr, positionPrPrecedent);
            } else {
                LocalisationInfo.ecrireLog("+--> Le pr precedent n'a pas \u00e9t\u00e9 trouv\u00e9");
                distanceInterPr.setDistance(positionPr.getDistanceDebut());
                int i = 0;
                while (i < iTroncon) {
                    distanceInterPr.ajouterDistance(tri.getTronconSansException(i).getLongueur());
                    ++i;
                }
            }
            if (LocalisationInfo.appliquerMalusDistanceInterPr && distanceInterPr.getDistance() > 0) {
                distanceInterPr.enleverDistance(1);
            }
        }
        return distanceInterPr;
    }

    public static DistanceInfo getDistanceInterPrPrecedent(TriRoute tri, GeoPositionnement positionPr, LocalisantPr pr) {
        int iTroncon = tri.getIndiceTroncon(positionPr.getTroncon());
        return GestionPr.getDistanceInterPrPrecedent(tri, iTroncon, positionPr, pr);
    }

    public static LocalisantPr getPrPrecedent(TriRoute tri) {
        return GestionPr.getPrPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), null);
    }

    public static LocalisantPr getPrPrecedent(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        if (tronconRecherche != null) {
            InfoTroncon troncon = tronconRecherche.getTroncon();
            LocalisantPr prPrecedent = null;
            LocalisationInfo.ecrireLogDebug("Est troncon pr courant " + tronconRecherche.getTroncon().estPR());
            if (tronconRecherche.getTroncon().estPR()) {
                LocalisationInfo.ecrireLogDebug("Recherche sur troncon courant precedents");
                prPrecedent = tronconRecherche.getTroncon().getPrMax(pr, -1L, tronconRecherche.getDistanceDebut());
            }
            --i;
            while (prPrecedent == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                LocalisationInfo.ecrireLogDebug("Est troncon pr prec " + troncon.estPR());
                prPrecedent = troncon.getPrMax(pr);
                LocalisationInfo.ecrireLogDebug("Recherche sur les troncons precedents " + i);
                --i;
            }
            return prPrecedent;
        }
        return null;
    }

    public static void ajouterEntiteCouchePr(String nomRoute, String pr, GeoPoint point) throws Exception {
        GestionPr.ajouterEntiteCouchePr(nomRoute, pr, "PR", point);
    }

    public static void ajouterEntiteCouchePr(String nomRoute, String pr, String type, GeoPoint point) throws Exception {
        Enregistrement entiteCouchePr;
        try {
            entiteCouchePr = Recherche.getEntiteCouchePr(nomRoute, pr, type);
        }
        catch (Exception e) {
            entiteCouchePr = null;
        }
        if (entiteCouchePr != null) {
            GestionPr.deplacerEntiteCouchePr(nomRoute, pr, point);
        } else {
            float[][] nouvellesCoordonnees = Geometry.toFloat(point);
            String[] donnees = new String[]{nomRoute, pr, " ", type, GLS.egal(type, "PR") ? pr : " "};
            OutilsCartoJ.ajoutObjetCouche(LocalisationInfo.getCouche("pr"), donnees, nouvellesCoordonnees);
        }
    }

    public static void deplacerEntiteCouchePr(String nomRoute, String pr, GeoPoint point) throws Exception {
        Enregistrement entiteCouchePr = Recherche.getEntiteCouchePr(nomRoute, pr);
        ICouche couchePr = LocalisationInfo.getCouche("pr");
        float[][] nouvellesCoordonnees = Geometry.toFloat(point);
        couchePr.modifieContourEntite(entiteCouchePr.getNum(), nouvellesCoordonnees[0], nouvellesCoordonnees[1]);
    }

    public static boolean verrificationDistanceInterPr(int distanceInterPr, LocalisantPr pr) {
        if ((long)distanceInterPr >= pr.getDistancePr() || pr.estAbscisseNegatif()) {
            return true;
        }
        LocalisationInfo.ecrireLog("ERREUR DISTANCE INTER PR " + pr + " ERREUR - distance inter:" + distanceInterPr + " < " + pr.getDistancePr());
        if (LocalisationInfo.correctionAutoAbscissePr) {
            if (LocalisationInfo.differenceMaximumCorrectionAutoAbscissePr == -1 || pr.getDistancePr() - (long)distanceInterPr < (long)LocalisationInfo.differenceMaximumCorrectionAutoAbscissePr) {
                LocalisationInfo.ecrireLog("CORRECTION AUTO " + pr + " --> NOUVELLE ABSCISSE " + distanceInterPr);
                if (distanceInterPr > 0) {
                    pr.setDistancePr(distanceInterPr - 1);
                } else {
                    pr.setDistancePr(0L);
                }
                return true;
            }
            LocalisationInfo.ecrireLog("ERREUR CORRECTION AUTO IMPOSSIBLE " + (pr.getDistancePr() - (long)distanceInterPr) + " > " + LocalisationInfo.differenceMaximumCorrectionAutoAbscissePr);
            return false;
        }
        return false;
    }

    public static LocalisantPr getPrPrecedent(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPrPrecedent(tri, i, tronconRecherche, pr);
    }

    public static LocalisantPr getPrPrecedent(TriRoute tri, GeoPositionnement tronconRecherche) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPrPrecedent(tri, i, tronconRecherche, null);
    }

    public static GeoPositionnement getPositionPrPrecedent(TriRoute tri, LocalisantPr pr) {
        return GestionPr.getPositionPrPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), pr);
    }

    public static GeoPositionnement getPositionPrPrecedent(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        if (tronconRecherche != null) {
            GeoPositionnement positionnementPrPrecedent = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            if (tronconRecherche.getTroncon().estPR()) {
                troncon = tronconRecherche.getTroncon();
                LocalisationInfo.ecrireLog("+--> PR A EVITER " + pr);
                positionnementPrPrecedent = troncon.getPositionnementPR(troncon.getPrMax(pr, -1L, tronconRecherche.getDistanceDebut()));
                if (positionnementPrPrecedent != null) {
                    positionnementPrPrecedent.setIndiceTri(i);
                }
            }
            --i;
            while (positionnementPrPrecedent == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                if (troncon.estPR() && (positionnementPrPrecedent = troncon.getPositionnementPR(troncon.getPrMax(pr))) != null) {
                    positionnementPrPrecedent.setIndiceTri(i);
                }
                --i;
            }
            return positionnementPrPrecedent;
        }
        return null;
    }

    public static GeoPositionnement getPositionPrPrecedent(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPositionPrPrecedent(tri, i, tronconRecherche, pr);
    }

    public static DistanceInfo getDistanceInterPrSuivant(TriRoute tri, LocalisantPr pr, boolean sensPr) {
        if (sensPr) {
            return GestionPr.getDistanceInterPrSuivant(tri, pr);
        }
        return GestionPr.getDistanceInterPrPrecedent(tri, pr);
    }

    public static DistanceInfo getDistanceInterPrSuivant(TriRoute tri, GeoPositionnement positionPr, LocalisantPr pr, boolean sensPr) {
        if (sensPr) {
            return GestionPr.getDistanceInterPrSuivant(tri, positionPr, pr);
        }
        return GestionPr.getDistanceInterPrPrecedent(tri, positionPr, pr);
    }

    public static DistanceInfo getDistanceInterPrSuivant(TriRoute tri, LocalisantPr pr) {
        if (tri != null) {
            return GestionPr.getDistanceInterPrSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), pr);
        }
        return new DistanceInfo();
    }

    public static DistanceInfo getDistanceInterPrSuivant(TriRoute tri, GeoPositionnement positionPr, LocalisantPr pr) {
        int iTroncon = tri.getIndiceTroncon(positionPr.getTroncon());
        return GestionPr.getDistanceInterPrSuivant(tri, iTroncon, positionPr, pr);
    }

    public static DistanceInfo getDistanceInterPrSuivant(TriRoute tri, int iTroncon, GeoPositionnement positionPr, LocalisantPr pr) {
        DistanceInfo distanceInterPr = new DistanceInfo();
        if (!LocalisationInfo.estNulle(iTroncon)) {
            GeoPositionnement positionPrSuivant;
            if (tri.getNbPr() == 1) {
                if (tri.aPrDebut()) {
                    positionPrSuivant = tri.getDernierPositionnement();
                    positionPrSuivant.setObjet(tri.getPrMin());
                } else {
                    positionPrSuivant = tri.getPremierPositionnement();
                    positionPrSuivant.setObjet(tri.getPrMax());
                }
            } else {
                positionPrSuivant = GestionPr.getPositionPrSuivant(tri, positionPr, pr);
            }
            if (positionPrSuivant != null) {
                LocalisationInfo.ecrireLog("+--> Le pr suivant a \u00e9t\u00e9 trouv\u00e9");
                distanceInterPr = Distance.distanceEntrePositionnements(tri, positionPr, positionPrSuivant);
            } else {
                LocalisationInfo.ecrireLog("+--> Le pr suivant n'a pas \u00e9t\u00e9 trouv\u00e9");
                distanceInterPr.setDistance(positionPr.getDistanceFin());
                int i = iTroncon + 1;
                while (i < tri.getNbTroncons()) {
                    distanceInterPr.ajouterDistance(tri.getTronconSansException(i).getLongueur());
                    ++i;
                }
            }
            if (LocalisationInfo.appliquerMalusDistanceInterPr && distanceInterPr.getDistance() > 0) {
                distanceInterPr.enleverDistance(1);
            }
        }
        return distanceInterPr;
    }

    public static LocalisantPr getPrSuivant(TriRoute tri) {
        if (tri != null) {
            return GestionPr.getPrSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), null);
        }
        return null;
    }

    public static LocalisantPr getPrSuivant(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        if (tronconRecherche != null) {
            LocalisantPr prSuivant = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            if (tronconRecherche.getTroncon().estPR()) {
                prSuivant = tronconRecherche.getTroncon().getPrMin(pr, tronconRecherche.getDistanceDebut(), Long.MAX_VALUE);
            }
            ++i;
            while (prSuivant == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                prSuivant = troncon.getPrMin(pr);
                ++i;
            }
            return prSuivant;
        }
        return null;
    }

    public static LocalisantPr getPrSuivant(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPrSuivant(tri, i, tronconRecherche, pr);
    }

    public static LocalisantPr getPrSuivant(TriRoute tri, GeoPositionnement tronconRecherche) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPrSuivant(tri, i, tronconRecherche, null);
    }

    public static GeoPositionnement getPositionPrSuivant(TriRoute tri, LocalisantPr pr) {
        if (tri != null) {
            return GestionPr.getPositionPrSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), pr);
        }
        return null;
    }

    public static void miseAJourDepartementPR(TriRoute tri, LocalisantPr pr) {
        if (!pr.aDepartement()) {
            GeoPositionnement positionPr = Recherche.getPositionAtPR(tri, pr);
            if (positionPr != null) {
                pr.setDepartement(positionPr.getDepartement());
            } else {
                pr.setDepartement(-1);
            }
        }
    }

    public static GeoPositionnement getPositionPrSuivant(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        if (tronconRecherche != null) {
            GeoPositionnement positionnementPrSuivant = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            LocalisationInfo.ecrireLogDebug("Nb troncons " + tri.getNbTroncons());
            if (troncon.estPR()) {
                LocalisationInfo.ecrireLogDebug("Est pr troncon recherche");
                positionnementPrSuivant = troncon.getPositionnementPR(troncon.getPrMin(pr, tronconRecherche.getDistanceDebut(), Long.MAX_VALUE));
                if (positionnementPrSuivant != null) {
                    positionnementPrSuivant.setIndiceTri(i);
                }
            }
            ++i;
            while (positionnementPrSuivant == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                LocalisationInfo.ecrireLogDebug("Recherche sur le troncon " + i + troncon.estPR());
                if (troncon.estPR() && (positionnementPrSuivant = troncon.getPositionnementPR(troncon.getPrMin(pr))) != null) {
                    positionnementPrSuivant.setIndiceTri(i);
                }
                ++i;
            }
            return positionnementPrSuivant;
        }
        return null;
    }

    public static GeoPositionnement getPositionPrSuivant(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantPr pr) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionPr.getPositionPrSuivant(tri, i, tronconRecherche, pr);
    }

    public static boolean getSensPr(TriRoute tri, GeoPositionnement positionnementFin) throws ErreurPR {
        if (tri != null) {
            try {
                return tri.estApres(positionnementFin);
            }
            catch (Exception e) {
                throw new ErreurPR("SENS PR IMPOSSIBLE A DETERMINER # TRI NUL");
            }
        }
        throw new ErreurPR("SENS PR IMPOSSIBLE A DETERMINER # TRI NUL");
    }

    public static boolean getSensPr(TriRoute tri, GeoPositionnement positionnementDebut, GeoPositionnement positionnementFin) throws ErreurPR {
        if (tri != null) {
            try {
                return tri.estApres(positionnementDebut, positionnementFin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ErreurPR("#--> SENS PR IMPOSSIBLE A DETERMINER # TRI NUL");
    }

    public static boolean getSensPr(LocalisantPr prAvant, LocalisantPr prApres) throws ErreurPR {
        if (prAvant != null && prApres != null) {
            return prAvant.estAvant(prApres, false);
        }
        throw new ErreurPR("#--> SENS PR IMPOSSIBLE A DETERMINER # LOCALISANTS NULS");
    }

    public static boolean getSensPr(EntitePr prAvant, EntitePr prApres) throws ErreurPR {
        if (prAvant != null && prApres != null) {
            if (prAvant.aDepartement() && prApres.aDepartement() && GestionPr.estMemeDepartement(prAvant.getDepartement(), prApres.getDepartement())) {
                if (prApres.getPr() == 0) {
                    return true;
                }
                if (prAvant.getPr() == 0) {
                    return false;
                }
                return prAvant.getPr() <= prApres.getPr();
            }
            if (prAvant.getPr() <= prApres.getPr()) {
                return LocalisationInfo.autoriserPrNonConsecutif || prAvant.getPr() + 1 == prApres.getPr();
            }
            return !LocalisationInfo.autoriserPrNonConsecutif && prAvant.getPr() - 1 != prApres.getPr();
        }
        throw new ErreurPR("#--> SENS PR IMPOSSIBLE A DETERMINER # ENTITES NULLES");
    }
}

