/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.pr;

import gls.localisation.pr.GestionPr;
import gls.outils.GLS;

public class EntitePr {
    private int numPr;
    private String nomRoute;
    private int departement;
    private int abscisse;

    public int getAbscisse() {
        return this.abscisse;
    }

    public void setAbscisse(int abscisse) {
        this.abscisse = abscisse;
    }

    public EntitePr() {
    }

    public boolean estBaionnette() {
        return this.abscisse != 0;
    }

    public boolean estAbscisseNegatif() {
        return this.abscisse < 0;
    }

    public EntitePr(int pr, int departement) {
        this.numPr = pr;
        this.departement = departement;
        this.nomRoute = null;
        this.abscisse = 0;
    }

    public EntitePr(int pr, int departement, String route) {
        this.numPr = pr;
        this.departement = departement;
        this.nomRoute = route;
        this.abscisse = 0;
    }

    public EntitePr(int pr) {
        this.numPr = pr;
        this.departement = -1;
        this.nomRoute = null;
        this.abscisse = 0;
    }

    public EntitePr(String pr) {
        this.setEntitePr(pr);
    }

    public String getLibelle() {
        StringBuffer sb = new StringBuffer();
        sb.append("PR");
        sb.append(this.numPr);
        if (this.aDepartement()) {
            sb.append(" du d\u00e9partement ");
            sb.append(this.departement);
        }
        return sb.toString();
    }

    public void setEntitePr(String pr) {
        if (pr != null && !pr.equals("")) {
            int pos = pr.indexOf(40);
            if (pos < 0) {
                this.setPr(pr);
                this.departement = -1;
            } else {
                pos = pr.indexOf(41);
                if (pos > 0) {
                    this.setDepartement(pr.substring(1, pos));
                    this.setPr(pr.substring(pos + 1).trim());
                } else {
                    this.departement = -1;
                    this.numPr = -1;
                    this.abscisse = 0;
                }
            }
        } else {
            this.departement = -1;
            this.numPr = -1;
            this.abscisse = 0;
        }
    }

    public void setDepartement(String dpt) {
        try {
            this.departement = Integer.parseInt(dpt);
        }
        catch (Exception e) {
            this.departement = -1;
        }
    }

    public void setDepartement(int dpt) {
        this.departement = dpt;
    }

    public boolean aDepartement() {
        return this.departement != -1;
    }

    public int getDepartement() {
        return this.departement;
    }

    public int getPr() {
        return this.numPr;
    }

    public void setPr(int pr) {
        this.numPr = pr;
    }

    public void setPr(String pr) {
        if (!GLS.estVide(pr)) {
            int positionPlusPrpk = pr.indexOf(43);
            if (positionPlusPrpk == -1) {
                this.numPr = GLS.getInt(pr);
                this.setAbscisse(0);
            } else {
                this.numPr = GLS.getInt(pr.substring(0, positionPlusPrpk).trim());
                if (positionPlusPrpk == pr.length()) {
                    this.setAbscisse(0);
                } else {
                    this.setAbscisse(GLS.getInt(pr.substring(positionPlusPrpk + 1)));
                }
            }
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean afficherBaionnette) {
        return this.toString(afficherBaionnette, true);
    }

    public String toString(boolean afficherBaionnette, boolean afficherDepartement) {
        StringBuffer libellePr = new StringBuffer();
        if (!this.estNulle()) {
            if (afficherDepartement && this.aDepartement()) {
                libellePr.append("(" + this.departement + ")");
            }
            libellePr.append(String.valueOf(this.numPr));
            if (afficherBaionnette && this.estBaionnette()) {
                libellePr.append("+");
                libellePr.append(this.abscisse);
            }
        }
        return libellePr.toString();
    }

    public boolean equals(EntitePr pr) {
        return this.equals(pr, false);
    }

    public boolean equals(EntitePr pr, boolean testBaionnette) {
        boolean val = false;
        if (!this.estNulle() && pr != null && !pr.estNulle() && pr.getPr() == this.numPr) {
            val = pr.aDepartement() && this.aDepartement() ? (testBaionnette && (pr.estBaionnette() || this.estBaionnette()) ? (pr.getAbscisse() == this.abscisse || pr.getAbscisse() < -1 && this.abscisse < -1) && GestionPr.estMemeDepartement(pr.getDepartement(), this.departement) : GestionPr.estMemeDepartement(pr.getDepartement(), this.departement)) : (testBaionnette && (pr.estBaionnette() || this.estBaionnette()) ? pr.getAbscisse() == this.abscisse || pr.getAbscisse() < -1 && this.abscisse < -1 : true);
        }
        return val;
    }

    public boolean estNulle() {
        return this.numPr == -1;
    }

    public void setRoute(String nomRoute) {
        this.nomRoute = nomRoute;
    }

    public String getRoute() {
        return this.nomRoute;
    }

    public void formatRoutePrpk() {
        this.nomRoute = EntitePr.formatRoutePrpk(this.nomRoute);
    }

    public static String formatRoutePrpk(String route) {
        if (route.charAt(0) == 'A' || route.charAt(0) == 'N' || route.charAt(0) == 'D') {
            return route;
        }
        int taille = route.length();
        if (taille >= 8) {
            taille = 8;
        }
        String tmp = route.substring(3, 4);
        tmp = String.valueOf(tmp) + String.valueOf(Integer.parseInt(route.substring(4, taille))).trim();
        if (route.length() > 8) {
            tmp = String.valueOf(tmp) + route.substring(8);
        }
        return tmp;
    }
}

