/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.distance;

import gls.geometry.GeoPoint;
import gls.geometry.GeoPoints;
import gls.localisation.InfoTroncon;

public class DistanceInfo {
    private int distance;
    private String positionnement;
    private GeoPoints points;

    public DistanceInfo() {
        this(-1, null, new GeoPoints());
    }

    public DistanceInfo(int distance) {
        this(distance, null, new GeoPoints());
    }

    public DistanceInfo(int distance, String positionnement) {
        this(distance, positionnement, new GeoPoints());
    }

    public DistanceInfo(int distance, String positionnement, GeoPoints points) {
        this.distance = distance;
        this.positionnement = positionnement;
        this.points = points;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public void setDistance(double distance) {
        this.distance = (int)distance / 1;
    }

    public void setPositionnement(String positionnement) {
        this.positionnement = positionnement;
    }

    public int getDistance() {
        return this.distance;
    }

    public String getPositionnement() {
        return this.positionnement;
    }

    public GeoPoints getPoints() {
        return this.points;
    }

    public void setPoints(GeoPoints points) {
        this.points = points;
    }

    public void ajouterDistance(double distance) {
        this.ajouterDistance((int)distance);
    }

    public void ajouterDistance(int distance) {
        this.distance += distance;
    }

    public void enleverDistance(int distance) {
        this.distance -= distance;
    }

    public void ajouterDistance(DistanceInfo distance) {
        this.distance += distance.getDistance();
        this.ajouterPoints(distance.getPoints());
    }

    public void ajouterTronconInverse(InfoTroncon troncon) {
        this.ajouterDistance(troncon.getLongueur());
        this.ajouterPointsInverse(troncon.getPoints());
    }

    public void ajouterTroncon(InfoTroncon troncon) {
        this.ajouterDistance(troncon.getLongueur());
        this.ajouterPoints(troncon.getPoints());
    }

    public void ajouterPoint(Object point) {
        this.points.ajouter(point);
    }

    public void ajouterPoint(GeoPoint point) {
        this.points.ajouter(point);
    }

    public void ajouterPoints(GeoPoints points) {
        this.points.ajouter(points);
    }

    public void ajouterPointsInverse(GeoPoints points) {
        this.points.ajouterInverse(points);
    }

    public boolean estNulle() {
        return this.distance == -1;
    }
}

