/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.distance;

import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriBretelle;
import gls.localisation.tri.TriRoute;
import gls.outils.GLS;

public class Distance {
    private Localisation localisation = null;

    public Distance() {
    }

    public Distance(Localisation localisation) {
        this.localisation = localisation;
    }

    public static DistanceInfo distanceEntrePositionnements(Tri tri, GeoPositionnement positionFin) {
        return Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionFin);
    }

    public static DistanceInfo distanceEntrePositionnements(Tri tri, GeoPositionnement positionDebut, GeoPositionnement positionFin, int indicePositionDebut, int indicePositionFin) {
        DistanceInfo distanceInfo = new DistanceInfo(0);
        if (positionDebut != null && positionFin != null) {
            LocalisationInfo.ecrireLog("+--> Indice positionnements " + indicePositionDebut + " -- " + indicePositionFin);
            if (indicePositionDebut == indicePositionFin) {
                distanceInfo.ajouterPoint(positionDebut.getPoint());
                if (positionDebut.getDistanceDebut() > positionFin.getDistanceDebut()) {
                    distanceInfo.setDistance(positionDebut.getDistanceDebut() - positionFin.getDistanceDebut());
                    try {
                        distanceInfo.ajouterPointsInverse(positionDebut.getTroncon().getPoints(positionFin.getIndicePoint() + 1, positionDebut.getIndicePoint()));
                    }
                    catch (Exception e) {
                        LocalisationInfo.ecrireLogErreur("ERREUR AU NIVEAU DE LA RECUPERATION DES POINTS ENTRE LES POSITIONNEMENTS # IDEB " + positionDebut.getIndicePoint() + " - IFIN " + positionFin.getIndicePoint() + " - NB PTS " + positionDebut.getTroncon().getNbPoints());
                    }
                    distanceInfo.setPositionnement("t");
                } else {
                    distanceInfo.setDistance(positionFin.getDistanceDebut() - positionDebut.getDistanceDebut());
                    try {
                        distanceInfo.ajouterPoints(positionDebut.getTroncon().getPoints(positionDebut.getIndicePoint() + 1, positionFin.getIndicePoint()));
                    }
                    catch (Exception e) {
                        LocalisationInfo.ecrireLogErreur("ERREUR AU NIVEAU DE LA RECUPERATION DES POINTS ENTRE LES POSITIONNEMENTS # IDEB " + positionDebut.getIndicePoint() + " - IFIN " + positionFin.getIndicePoint() + " - NB PTS " + positionDebut.getTroncon().getNbPoints());
                    }
                    distanceInfo.setPositionnement("q");
                }
                distanceInfo.ajouterPoint(positionFin.getPoint());
            } else if (indicePositionDebut < indicePositionFin) {
                distanceInfo.ajouterDistance(positionDebut.getDistanceFin() + positionFin.getDistanceDebut());
                distanceInfo.ajouterPoint(positionDebut.getPoint());
                distanceInfo.ajouterPoints(positionDebut.getPointsFin());
                int i = indicePositionDebut + 1;
                while (i < indicePositionFin) {
                    distanceInfo.ajouterTroncon(tri.getTronconSansException(i));
                    ++i;
                }
                distanceInfo.ajouterPoints(positionFin.getPointsDebut());
                distanceInfo.ajouterPoint(positionFin.getPoint());
                distanceInfo.setPositionnement("q");
            } else {
                distanceInfo.ajouterDistance(positionDebut.getDistanceDebut() + positionFin.getDistanceFin());
                distanceInfo.ajouterPoint(positionDebut.getPoint());
                distanceInfo.ajouterPointsInverse(positionDebut.getPointsDebut());
                int i = indicePositionDebut - 1;
                while (i > indicePositionFin) {
                    distanceInfo.ajouterTronconInverse(tri.getTronconSansException(i));
                    --i;
                }
                distanceInfo.ajouterPointsInverse(positionFin.getPointsFin());
                distanceInfo.ajouterPoint(positionFin.getPoint());
                distanceInfo.setPositionnement("t");
            }
        }
        return distanceInfo;
    }

    public static DistanceInfo distanceEntrePositionnementsNonNulle(Tri tri, GeoPositionnement positionDebut, GeoPositionnement positionFin) {
        DistanceInfo distanceInfo = new DistanceInfo(0);
        if (tri != null && positionDebut != null && positionFin != null) {
            int indicePositionDebut = tri.getIndiceTronconAtIdgdf(positionDebut.getTroncon().getIdgdf());
            int indicePositionFin = tri.getIndiceTronconAtIdgdf(positionFin.getTroncon().getIdgdf());
            if (indicePositionDebut != -1 && indicePositionFin != -1) {
                distanceInfo = Distance.distanceEntrePositionnements(tri, positionDebut, positionFin, indicePositionDebut, indicePositionFin);
            } else {
                GLS.getLogs().error((Object)("ERREUR TRONCON PAS DANS LE TRI " + positionDebut.getTroncon().getIdgdf() + " -- " + positionFin.getTroncon().getIdgdf()));
                distanceInfo.setDistance(-1);
            }
        }
        return distanceInfo;
    }

    public static DistanceInfo distanceEntrePositionnements(Tri tri, GeoPositionnement positionDebut, GeoPositionnement positionFin) {
        DistanceInfo distanceInfo = new DistanceInfo(0);
        if (tri != null && positionDebut != null && positionFin != null) {
            int indicePositionDebut = tri.getIndiceTronconAtIdgdf(positionDebut.getTroncon().getIdgdf());
            int indicePositionFin = tri.getIndiceTronconAtIdgdf(positionFin.getTroncon().getIdgdf());
            distanceInfo = Distance.distanceEntrePositionnements(tri, positionDebut, positionFin, indicePositionDebut, indicePositionFin);
        }
        return distanceInfo;
    }

    public static DistanceInfo distanceEntrePositionnementsPr(Tri tri, GeoPositionnement positionPrPrimaire, GeoPositionnement positionPrSecondaire) {
        DistanceInfo distanceInfo = new DistanceInfo(0);
        if (tri != null && positionPrPrimaire != null && positionPrSecondaire != null) {
            int indicePositionDebut = tri.getIndiceTronconAtIdgdf(positionPrPrimaire.getTroncon().getIdgdf());
            int indicePositionFin = tri.getIndiceTronconAtIdgdf(positionPrSecondaire.getTroncon().getIdgdf());
            if (tri.estRocade() && indicePositionDebut < indicePositionFin) {
                indicePositionFin -= tri.getNbTroncons();
            }
            distanceInfo = Distance.distanceEntrePositionnementsPr(tri, positionPrPrimaire, positionPrSecondaire, indicePositionDebut, indicePositionFin);
        }
        return distanceInfo;
    }

    public static DistanceInfo distanceEntrePositionnementsPr(Tri tri, GeoPositionnement positionPrPrimaire, GeoPositionnement positionPrSecondaire, int indicePositionDebut, int indicePositionFin) {
        DistanceInfo distanceInfo = new DistanceInfo(0);
        if (positionPrPrimaire != null && positionPrSecondaire != null) {
            LocalisationInfo.ecrireLog("+--> Indice positionnements " + indicePositionDebut + " -- " + indicePositionFin);
            if (indicePositionDebut == indicePositionFin) {
                distanceInfo.ajouterPoint(positionPrPrimaire.getPoint());
                distanceInfo.setDistance(positionPrPrimaire.getDistanceDebut() - positionPrSecondaire.getDistanceDebut());
                try {
                    distanceInfo.ajouterPointsInverse(positionPrPrimaire.getTroncon().getPoints(positionPrSecondaire.getIndicePoint() + 1, positionPrPrimaire.getIndicePoint()));
                }
                catch (Exception e) {
                    LocalisationInfo.ecrireLogErreur("ERREUR AU NIVEAU DE LA RECUPERATION DES POINTS ENTRE LES POSITIONNEMENTS # IDEB " + positionPrPrimaire.getIndicePoint() + " - IFIN " + positionPrSecondaire.getIndicePoint() + " - NB PTS " + positionPrPrimaire.getTroncon().getNbPoints());
                }
                distanceInfo.setPositionnement("t");
                distanceInfo.ajouterPoint(positionPrSecondaire.getPoint());
            } else {
                distanceInfo.ajouterDistance(positionPrPrimaire.getDistanceDebut() + positionPrSecondaire.getDistanceFin());
                distanceInfo.ajouterPoint(positionPrPrimaire.getPoint());
                distanceInfo.ajouterPointsInverse(positionPrPrimaire.getPointsDebut());
                int i = indicePositionDebut - 1;
                while (i > indicePositionFin) {
                    distanceInfo.ajouterTronconInverse(tri.getTronconSansException(i));
                    --i;
                }
                distanceInfo.ajouterPointsInverse(positionPrSecondaire.getPointsFin());
                distanceInfo.ajouterPoint(positionPrSecondaire.getPoint());
                distanceInfo.setPositionnement("t");
            }
        }
        return distanceInfo;
    }

    public DistanceInfo distanceAtPoint(GeoPoint pointFin) {
        if (this.localisation != null) {
            return Distance.distanceAtPoint(this.localisation.getTri(), pointFin);
        }
        return new DistanceInfo();
    }

    public static DistanceInfo distanceAtPoint(Tri tri, GeoPoint pointFin) {
        DistanceInfo longueurCalculee = tri.estBretelle() ? Distance.calculLongueurClicBretelle((TriBretelle)tri, pointFin) : Distance.calculLongueurClicRoute(tri, pointFin);
        return longueurCalculee;
    }

    public static DistanceInfo calculLongueurClicBretelle(TriBretelle tri, GeoPoint pointFin) {
        DistanceInfo longueurTroncon = new DistanceInfo();
        GeoPositionnement tronconFin = new GeoPositionnement(pointFin);
        GeoPositionnement tronconFinRoute = new GeoPositionnement(pointFin);
        tronconFinRoute.setDistanceProjectionMaximum(30.0);
        tronconFin.setDistanceProjectionMaximum(30.0);
        boolean repositionner = false;
        LocalisationInfo.ecrireLog("+--> Longueur bretelle");
        tronconFin.repositionnerSiPlusProche(tri);
        BretelleInfo bretelleInfo = tri.getBretelleInfoAssociee();
        TriRoute triRoute = null;
        if (bretelleInfo != null) {
            triRoute = tri.getTriRouteAssociee();
            if (bretelleInfo.getPositionBretelle().equals("d")) {
                repositionner = tronconFinRoute.repositionnerSiPlusProche(triRoute.getTronconDepart());
                if (!repositionner || tronconFinRoute.getDistanceDebut() > triRoute.getGeoPositionnement().getDistanceDebut()) {
                    tronconFinRoute.initialiserPositionnement();
                }
                tronconFinRoute.repositionnerSiPlusProche(triRoute.getTronconsPrecedent());
            } else {
                repositionner = tronconFinRoute.repositionnerSiPlusProche(triRoute.getTronconDepart());
                if (!repositionner || tronconFinRoute.getDistanceDebut() < triRoute.getGeoPositionnement().getDistanceDebut()) {
                    tronconFinRoute.initialiserPositionnement();
                }
                tronconFinRoute.repositionnerSiPlusProche(triRoute.getTronconsSuivant());
            }
        }
        if (!tronconFin.estPositionne() && !tronconFinRoute.estPositionne()) {
            LocalisationInfo.ecrireLog("AUCUN TRONCON TROUVE SUR LA BRETELLE");
        } else if (tronconFin.getDistanceProjection() > tronconFinRoute.getDistanceProjection()) {
            longueurTroncon = Distance.distanceEntrePositionnements(triRoute, tronconFinRoute);
            if (bretelleInfo.getPositionBretelle().equals("d")) {
                longueurTroncon.ajouterDistance(tri.getDistanceDebut());
            } else {
                longueurTroncon.ajouterDistance(tri.getDistanceFin());
            }
        } else {
            longueurTroncon = Distance.distanceEntrePositionnements(tri, tronconFin);
        }
        return longueurTroncon;
    }

    public static DistanceInfo calculLongueurClicRoute(TriRoute tri, BretelleInfo bretelleInfo, GeoPoint pointFin) {
        DistanceInfo longueurTroncon;
        GeoPositionnement tronconFin = new GeoPositionnement(pointFin);
        if (bretelleInfo.getPositionBretelle().equals("d")) {
            tronconFin.repositionner(tri.getTronconDepart());
            if (tronconFin.getDistanceProjection() < 30.0 && tronconFin.getDistanceDebut() < tri.getGeoPositionnement().getDistanceDebut()) {
                tronconFin.repositionnerSiPlusProche(tri.getTronconsPrecedent());
            } else {
                tronconFin = Recherche.getPositionnementProcheAtPoint(tri.getTronconsPrecedent(), pointFin, 30.0);
            }
        } else {
            tronconFin.repositionner(tri.getTronconDepart());
            if (tronconFin.getDistanceProjection() < 30.0 && tronconFin.getDistanceDebut() > tri.getGeoPositionnement().getDistanceDebut()) {
                tronconFin.repositionnerSiPlusProche(tri.getTronconsSuivant());
            } else {
                tronconFin = Recherche.getPositionnementProcheAtPoint(tri.getTronconsSuivant(), pointFin, 30.0);
            }
        }
        if (tronconFin != null) {
            longueurTroncon = Distance.distanceEntrePositionnements(tri, tronconFin);
        } else {
            LocalisationInfo.ecrireLog("#--> Aucun troncon n'a ete trouve aux alentours");
            longueurTroncon = new DistanceInfo();
        }
        return longueurTroncon;
    }

    public static DistanceInfo calculLongueurClicRoute(Tri tri, GeoPoint pointFin) {
        DistanceInfo longueurTroncon;
        GeoPositionnement tronconFin = Recherche.getPositionnementProcheAtPoint(tri, pointFin, (double)LocalisationInfo.margeRechercheRoute);
        if (tronconFin != null) {
            longueurTroncon = Distance.distanceEntrePositionnements(tri, tronconFin);
        } else {
            LocalisationInfo.ecrireLog("#--> Aucun troncon n'a ete trouve aux alentours");
            longueurTroncon = new DistanceInfo();
        }
        return longueurTroncon;
    }
}

