/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.construction;

import cartoj.Enregistrement;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.pr.LocalisantPr;
import java.util.HashMap;
import java.util.Vector;

public class ConstructionInfo {
    public static final String CHAMP_DERNIER_POSITIONNEMENT = "dernierPositionnement";
    public static final String CHAMP_COMMUNE_PRIMAIRE = "commune";
    public static final String CHAMP_COMMUNE_SECONDAIRE = "commune2";
    public static final String CHAMP_DEPARTEMENT_PRIMAIRE = "departement";
    public static final String CHAMP_DEPARTEMENT_SECONDAIRE = "departement2";
    public static final String CHAMP_POSITIONNEMENT_PR_DEBUT = "positionPrDebut";
    public static final String CHAMP_POSITIONNEMENT_PR_FIN = "positionPrFin";
    public static final String CHAMP_POSITIONNEMENT_ALERTC_DEBUT = "positionAlertcDebut";
    public static final String CHAMP_POSITIONNEMENT_ALERTC_FIN = "positionAlertcFin";
    public static final String CHAMP_CEI = "cei";
    public static final String CHAMP_DISTRICT = "district";
    public static final String CHAMP_ADRESSE_DEBUT = "adresseDebut";
    public static final String CHAMP_ADRESSE_FIN = "adresseFin";
    private Vector<GeoPoint> listePoints;
    private LocalisantAlertc alertcDebut;
    private LocalisantAlertc alertcFin;
    private LocalisantPr prDebut;
    private LocalisantPr prFin;
    private double longueur;
    private HashMap<String, Object> valeurs = new HashMap();

    public void setListePoints(Vector<GeoPoint> listePoints) {
        this.listePoints = listePoints;
    }

    public void setAlertcDebut(LocalisantAlertc alertcDebut) {
        this.alertcDebut = alertcDebut;
    }

    public void setAlertcFin(LocalisantAlertc alertcFin) {
        this.alertcFin = alertcFin;
    }

    public void setPrDebut(LocalisantPr prDebut) {
        this.prDebut = prDebut;
    }

    public void setPrFin(LocalisantPr prFin) {
        this.prFin = prFin;
    }

    public Vector<GeoPoint> getListePoints() {
        return this.listePoints;
    }

    public LocalisantAlertc getAlertcDebut() {
        return this.alertcDebut;
    }

    public LocalisantAlertc getAlertcFin() {
        return this.alertcFin;
    }

    public LocalisantPr getPrDebut() {
        return this.prDebut;
    }

    public LocalisantPr getPrFin() {
        return this.prFin;
    }

    public GeoPositionnement getDernierPositionnement() {
        return (GeoPositionnement)this.getValeur(CHAMP_DERNIER_POSITIONNEMENT);
    }

    public void setDernierPositionnement(GeoPositionnement positionnement) {
        this.setValeur(CHAMP_DERNIER_POSITIONNEMENT, positionnement);
    }

    public double getLongueur() {
        return this.longueur;
    }

    public void setLongueur(double longueur) {
        this.longueur = longueur;
    }

    public Object getValeur(String champ) {
        return this.valeurs.get(champ);
    }

    public void setValeur(String champ, Object valeur) {
        this.valeurs.put(champ, valeur);
    }

    public void setDistrict(String district) {
        this.setValeur(CHAMP_DISTRICT, district);
    }

    public void setCei(String cei) {
        this.setValeur(CHAMP_CEI, cei);
    }

    public void setCommune(String commune) {
        this.setValeur(CHAMP_COMMUNE_PRIMAIRE, commune);
    }

    public void setInfoCommune(Enregistrement commune) {
        if (commune != null) {
            this.setValeur(CHAMP_COMMUNE_PRIMAIRE, commune.getValeur(0));
            this.setValeur(CHAMP_DEPARTEMENT_PRIMAIRE, commune.getValeur(3));
        } else {
            this.setValeur(CHAMP_COMMUNE_PRIMAIRE, null);
            this.setValeur(CHAMP_DEPARTEMENT_PRIMAIRE, null);
        }
    }

    public void setInfoCommuneSecondaire(Enregistrement commune) {
        if (commune != null) {
            this.setValeur(CHAMP_COMMUNE_SECONDAIRE, commune.getValeur(0));
            this.setValeur(CHAMP_DEPARTEMENT_SECONDAIRE, commune.getValeur(3));
        } else {
            this.setValeur(CHAMP_COMMUNE_SECONDAIRE, null);
            this.setValeur(CHAMP_DEPARTEMENT_SECONDAIRE, null);
        }
    }

    public void setInfoDIR(Enregistrement tronconDir) {
        if (tronconDir != null) {
            this.setValeur(CHAMP_CEI, tronconDir.getValeur(1));
            this.setValeur(CHAMP_DISTRICT, tronconDir.getValeur(0));
        } else {
            this.setValeur(CHAMP_CEI, null);
            this.setValeur(CHAMP_DISTRICT, null);
        }
    }

    public String getCommune() {
        return (String)this.getValeur(CHAMP_COMMUNE_PRIMAIRE);
    }

    public String getCei() {
        return (String)this.getValeur(CHAMP_CEI);
    }

    public String getDistrict() {
        return (String)this.getValeur(CHAMP_DISTRICT);
    }
}

