/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.construction;

import cartoj.Enregistrement;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPoints;
import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.GestionAlertc;
import gls.localisation.alertc.ListeEntiteAlertc;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.construction.ConstructionInfo;
import gls.localisation.distance.Distance;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.exception.ErreurAlertc;
import gls.localisation.exception.ErreurAxeInconnu;
import gls.localisation.exception.ErreurLimiteRoute;
import gls.localisation.exception.ErreurLocalisation;
import gls.localisation.exception.ErreurPR;
import gls.localisation.exception.ErreurTriTroncon;
import gls.localisation.exception.LocalisationErreurDistancePrpk;
import gls.localisation.pr.GestionPr;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriBretelle;
import gls.localisation.tri.TriRoute;
import gls.outils.GLS;
import gls.outils.ui.msgbox.MsgBox;
import java.util.Vector;

public class Construction {
    private Localisation localisation = null;

    public Construction() {
    }

    public Construction(Localisation localisation) {
        this.localisation = localisation;
    }

    public ConstructionInfo construitEvenement(Localisation localisation) throws ErreurLocalisation, ErreurAlertc, ErreurPR, ErreurTriTroncon {
        if (localisation != null && localisation.getTri() != null) {
            if (localisation.getEstBretelle()) {
                LocalisationInfo.ecrireLog("!--> Construction d'une bretelle");
                return this.construitEvenement(localisation, localisation.getTri(), false, false, true, new GeoPoints(), localisation.getLongueur(), false);
            }
            LocalisationInfo.ecrireLog("!--> Construction d'une route");
            return this.construitEvenement(localisation, localisation.getTri(), localisation.getRechercheAlertc(), localisation.getRecherchePrpk(), false, new GeoPoints(), localisation.getLongueur(), false);
        }
        return null;
    }

    public ConstructionInfo construitEvenement() throws ErreurLocalisation, ErreurAlertc, ErreurPR, ErreurTriTroncon {
        return this.construitEvenement(this.localisation);
    }

    public ConstructionInfo construitEvenement(Localisation localisation, Tri tri, boolean rechercheAlertc, boolean recherchePrpk, boolean traitementBretelle, GeoPoints listePointsDejaParcourus, double distanceAParcourir, boolean distanceDejaAtteinte) throws ErreurLocalisation, ErreurTriTroncon, ErreurAlertc, ErreurPR {
        GeoPositionnement positionPrFin;
        GeoPositionnement positionPrDebut;
        GeoPositionnement positionAlertcFin;
        GeoPositionnement positionAlertcDebut;
        GeoPositionnement positionFin;
        ConstructionInfo constructionInfo = new ConstructionInfo();
        LocalisantAlertc alertcPrimaire = new LocalisantAlertc();
        LocalisantAlertc alertcSecondaire = new LocalisantAlertc();
        LocalisantPr prDebut = new LocalisantPr();
        LocalisantPr prFin = new LocalisantPr();
        if (distanceAParcourir > (double)tri.getLongueur() && !traitementBretelle) {
            distanceAParcourir = tri.getLongueur();
        }
        boolean distanceAtteinte = distanceDejaAtteinte || distanceAParcourir == 0.0;
        GeoPositionnement positionDebut = tri.getGeoPositionnement();
        DistanceInfo distanceInfoTmp = new DistanceInfo();
        DistanceInfo distanceInfo = new DistanceInfo(0);
        distanceInfo.ajouterPoints(listePointsDejaParcourus);
        positionDebut.setIndiceTri(tri.getIndiceTronconDepart());
        if (!distanceDejaAtteinte) {
            distanceInfo.ajouterPoint(positionDebut.getPoint());
        }
        if (localisation.estEnTete()) {
            if (!distanceAtteinte) {
                try {
                    positionFin = Recherche.getPositionAtDistance(tri, distanceAParcourir, false);
                    distanceAtteinte = true;
                }
                catch (ErreurLimiteRoute e) {
                    positionFin = tri.getPremierPositionnement();
                    distanceAtteinte = false;
                }
                distanceInfo.ajouterDistance(Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionFin, tri.getIndiceTronconDepart(), positionFin.getIndiceTri()));
                if (distanceAtteinte) {
                    distanceInfo.setDistance(distanceAParcourir);
                }
            } else {
                positionFin = positionDebut;
            }
            if (rechercheAlertc && (positionAlertcDebut = GestionAlertc.getPositionAlertcSuivant(localisation.getTriRoute(), tri.getAlertcMin())) != null) {
                alertcPrimaire = (LocalisantAlertc)positionAlertcDebut.getObjet();
                distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionAlertcDebut, tri.getIndiceTronconDepart(), positionAlertcDebut.getIndiceTri());
                alertcPrimaire.setDistanceAlertc(distanceInfoTmp.getDistance());
                positionAlertcFin = GestionAlertc.getPositionAlertcPrecedent(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, alertcPrimaire);
                if (positionAlertcFin != null) {
                    alertcSecondaire = (LocalisantAlertc)positionAlertcFin.getObjet();
                    distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionAlertcFin, positionFin.getIndiceTri(), positionAlertcFin.getIndiceTri());
                    alertcSecondaire.setDistanceAlertc(distanceInfoTmp.getDistance());
                }
            }
            if (recherchePrpk) {
                if (localisation.getSens().getSensRoutePrpkOk()) {
                    positionPrDebut = GestionPr.getPositionPrPrecedent(localisation.getTriRoute(), null);
                    if (positionPrDebut != null) {
                        prDebut = (LocalisantPr)positionPrDebut.getObjet();
                        distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionPrDebut, tri.getIndiceTronconDepart(), positionPrDebut.getIndiceTri());
                        prDebut.setDistancePr(distanceInfoTmp.getDistance());
                        positionPrFin = GestionPr.getPositionPrPrecedent(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, null);
                        if (positionPrFin != null) {
                            prFin = (LocalisantPr)positionPrFin.getObjet();
                            distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionPrFin, positionFin.getIndiceTri(), positionPrFin.getIndiceTri());
                            prFin.setDistancePr(distanceInfoTmp.getDistance());
                        }
                    }
                } else {
                    positionPrDebut = GestionPr.getPositionPrSuivant(localisation.getTriRoute(), null);
                    if (positionPrDebut != null) {
                        prDebut = (LocalisantPr)positionPrDebut.getObjet();
                        distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionPrDebut, tri.getIndiceTronconDepart(), positionPrDebut.getIndiceTri());
                        prDebut.setDistancePr(distanceInfoTmp.getDistance());
                        positionPrFin = GestionPr.getPositionPrSuivant(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, null);
                        if (positionPrFin != null) {
                            prFin = (LocalisantPr)positionPrFin.getObjet();
                            distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionPrFin, positionFin.getIndiceTri(), positionPrFin.getIndiceTri());
                            prFin.setDistancePr(distanceInfoTmp.getDistance());
                        }
                    }
                }
            }
        } else {
            if (!distanceAtteinte) {
                try {
                    positionFin = Recherche.getPositionAtDistance(tri, distanceAParcourir, true);
                    distanceAtteinte = true;
                }
                catch (ErreurLimiteRoute e) {
                    positionFin = tri.getDernierPositionnement();
                    distanceAtteinte = false;
                }
                distanceInfo.ajouterDistance(Distance.distanceEntrePositionnements(tri, positionFin));
                if (distanceAtteinte) {
                    distanceInfo.setDistance(distanceAParcourir);
                }
            } else {
                positionFin = positionDebut;
            }
            if (rechercheAlertc && (positionAlertcDebut = GestionAlertc.getPositionAlertcSuivant(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, tri.getAlertcMin())) != null) {
                alertcPrimaire = (LocalisantAlertc)positionAlertcDebut.getObjet();
                distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionAlertcDebut, positionFin.getIndiceTri(), positionAlertcDebut.getIndiceTri());
                alertcPrimaire.setDistanceAlertc(distanceInfoTmp.getDistance());
                positionAlertcFin = GestionAlertc.getPositionAlertcPrecedent(localisation.getTriRoute(), alertcPrimaire);
                if (positionAlertcFin != null) {
                    alertcSecondaire = (LocalisantAlertc)positionAlertcFin.getObjet();
                    distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionAlertcFin, tri.getIndiceTronconDepart(), positionAlertcFin.getIndiceTri());
                    alertcSecondaire.setDistanceAlertc(distanceInfoTmp.getDistance());
                }
            }
            if (recherchePrpk) {
                if (localisation.getSens().getSensRoutePrpkOk()) {
                    positionPrDebut = GestionPr.getPositionPrPrecedent(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, null);
                    if (positionPrDebut != null) {
                        prDebut = (LocalisantPr)positionPrDebut.getObjet();
                        distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionPrDebut, positionFin.getIndiceTri(), positionPrDebut.getIndiceTri());
                        if (prDebut != null && prDebut.estBaionnette()) {
                            int distanceBaionnette = prDebut.getEntitePr().getAbscisse();
                            prDebut.setDistancePr(distanceInfoTmp.getDistance() - distanceBaionnette);
                        } else {
                            prDebut.setDistancePr(distanceInfoTmp.getDistance());
                        }
                        positionPrFin = GestionPr.getPositionPrPrecedent(localisation.getTriRoute(), null);
                        if (positionPrFin != null) {
                            prFin = (LocalisantPr)positionPrFin.getObjet();
                            distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionPrFin, tri.getIndiceTronconDepart(), positionPrFin.getIndiceTri());
                            prFin.setDistancePr(distanceInfoTmp.getDistance());
                        }
                    }
                } else {
                    positionPrDebut = GestionPr.getPositionPrSuivant(localisation.getTriRoute(), positionFin.getIndiceTri(), positionFin, null);
                    if (positionPrDebut != null) {
                        prDebut = (LocalisantPr)positionPrDebut.getObjet();
                        distanceInfoTmp = Distance.distanceEntrePositionnements(tri, positionFin, positionPrDebut, positionFin.getIndiceTri(), positionPrDebut.getIndiceTri());
                        prDebut.setDistancePr(distanceInfoTmp.getDistance());
                        positionPrFin = GestionPr.getPositionPrSuivant(localisation.getTriRoute(), null);
                        if (positionPrFin != null) {
                            prFin = (LocalisantPr)positionPrFin.getObjet();
                            distanceInfoTmp = Distance.distanceEntrePositionnements(tri, tri.getGeoPositionnement(), positionPrFin, tri.getIndiceTronconDepart(), positionPrFin.getIndiceTri());
                            prFin.setDistancePr(distanceInfoTmp.getDistance());
                        }
                    }
                }
            }
        }
        boolean bl = distanceAtteinte = (double)distanceInfo.getDistance() == distanceAParcourir;
        if (traitementBretelle) {
            BretelleInfo bretelleInfo = ((TriBretelle)tri).getBretelleInfoAssociee();
            GeoPoint pointCourant = bretelleInfo.getPoint();
            LocalisationInfo.ecrireLog("+--> Traitement bretelle");
            if (!distanceAtteinte) {
                if (bretelleInfo.getPositionBretelle().equals("d")) {
                    if (localisation.getPosition().equals("q")) {
                        distanceAtteinte = true;
                    }
                } else if (localisation.getPosition().equals("t")) {
                    distanceAtteinte = true;
                }
            }
            double distanceAParcourirRouteAssocie = distanceAtteinte ? 0.0 : distanceAParcourir - (double)distanceInfo.getDistance();
            LocalisationInfo.ecrireLog("+--> Distance a parcourrir route associee " + distanceAParcourirRouteAssocie + " -- " + distanceInfo.getDistance());
            constructionInfo = this.construitEvenement(localisation, ((TriBretelle)tri).getTriRouteAssociee(), localisation.getRechercheAlertc(), localisation.getRecherchePrpk(), false, distanceInfo.getPoints(), distanceAParcourirRouteAssocie, distanceAtteinte);
            LocalisationInfo.ecrireLog("+--> Distance a parcourrir route associee " + distanceAParcourirRouteAssocie);
            LocalisationInfo.ecrireLog("+--> Distance Bretelle " + distanceAParcourir + "  --  " + localisation.getLongueur() + "  --  " + distanceInfo.getDistance());
            if (distanceAParcourir > constructionInfo.getLongueur() + (double)distanceInfo.getDistance()) {
                distanceInfo.ajouterDistance(constructionInfo.getLongueur());
            } else {
                distanceInfo.setDistance(distanceAParcourir);
            }
            constructionInfo.setLongueur(distanceInfo.getDistance());
        } else {
            LocalisationInfo.ecrireLogDebug("Verification des referentiels...");
            if (!LocalisationInfo.getGestionRouteSansReferentiel() && (rechercheAlertc || recherchePrpk)) {
                if (rechercheAlertc) {
                    try {
                        localisation.getSens().setSensRouteAlertcOk(GestionAlertc.getSensAlertc(alertcSecondaire, alertcPrimaire));
                        localisation.setEstRouteAlertc(true);
                    }
                    catch (ErreurAlertc e) {
                        LocalisationInfo.ecrireLogErreur(e.toString());
                        localisation.setEstRouteAlertc(false);
                    }
                }
                if (recherchePrpk && !rechercheAlertc && localisation.getEstRoutePrpk()) {
                    if (prDebut.estVide() && prFin.estVide()) {
                        throw new ErreurPR("#--> ERREUR PRPK - Aucun prpk n'a ete trouve");
                    }
                    if (prDebut.estVide()) {
                        throw new ErreurPR("#--> ERREUR PRPK - Le prpk de d\u00e9but n'a pas ete trouve");
                    }
                    if (prFin.estVide()) {
                        throw new ErreurPR("#--> ERREUR PRPK - Le prpk de fin n'a pas ete trouve");
                    }
                } else if (rechercheAlertc && localisation.getEstRouteAlertc() && (alertcPrimaire.estVide() || alertcSecondaire.estVide())) {
                    if (prDebut.estVide() && prFin.estVide()) {
                        throw new ErreurLocalisation("#--> ERREUR DE LOCALISATION GENERALE - Cette route ne contient ni point alertc ni prpk");
                    }
                    if (prDebut.estVide()) {
                        throw new ErreurLocalisation("#--> ERREUR DE LOCALISATION GENERALE - Cette route ne contient pas de point alertc # ERREUR PRPK DEBUT");
                    }
                    if (prFin.estVide()) {
                        throw new ErreurLocalisation("#--> ERREUR DE LOCALISATION GENERALE - Cette route ne contient pas de point alertc # ERREUR PRPK FIN");
                    }
                }
            }
            if (!distanceAtteinte) {
                if (prDebut.getDistancePr() < 0L) {
                    LocalisationInfo.ecrireLog("#--> ERREUR DISTANCE PR DEBUT # " + prDebut.getDistancePr());
                    prDebut.setDistancePr(0L);
                }
                if (prFin.getDistancePr() < 0L) {
                    LocalisationInfo.ecrireLog("#--> ERREUR DISTANCE PR FIN # " + prFin.getDistancePr());
                    prFin.setDistancePr(0L);
                }
            }
            if (localisation.getSens().getDoubleSens()) {
                Vector listePointsDoubleSens = this.construitEvenementDoubleSens(localisation, (TriRoute)tri);
                int i = listePointsDoubleSens.size() - 1;
                while (i >= 0) {
                    distanceInfo.ajouterPoint(listePointsDoubleSens.get(i));
                    --i;
                }
                if (localisation.getLongueur() > 0.0) {
                    distanceInfo.ajouterPoint(positionDebut.getPoint());
                }
            }
            if (localisation.getRechercheCommune() && LocalisationInfo.getCoucheCommuneZone() != null) {
                Enregistrement enrcommune = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), positionDebut.getPoint(), 1);
                if (enrcommune == null) {
                    GeoPositionnement posCommune = Recherche.rechercherObjetPlusProche(LocalisationInfo.getCoucheCommuneZone(), positionDebut.getPoint(), 10000);
                    enrcommune = posCommune.getTroncon().getTroncon();
                }
                constructionInfo.setInfoCommune(enrcommune);
                enrcommune = Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), positionFin.getPoint(), 1);
                if (enrcommune == null) {
                    GeoPositionnement posCommune = Recherche.rechercherObjetPlusProche(LocalisationInfo.getCoucheCommuneZone(), positionFin.getPoint(), 10000);
                    enrcommune = posCommune.getTroncon().getTroncon();
                }
                constructionInfo.setInfoCommuneSecondaire(enrcommune);
            } else {
                constructionInfo.setInfoCommune(null);
                constructionInfo.setInfoCommuneSecondaire(null);
            }
            if (localisation.getRechercheCei()) {
                constructionInfo.setInfoDIR(Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheDIR(), positionDebut.getPoint(), 10));
            } else {
                constructionInfo.setInfoDIR(null);
            }
            constructionInfo.setDernierPositionnement(positionFin);
            constructionInfo.setLongueur(distanceInfo.getDistance());
            constructionInfo.setListePoints(distanceInfo.getPoints());
            constructionInfo.setAlertcDebut(alertcPrimaire);
            constructionInfo.setAlertcFin(alertcSecondaire);
            if (LocalisationInfo.estLocalisableParAdresse) {
                this.miseAJourAdresse(localisation, constructionInfo);
            }
            GestionPr.miseAJourDepartementPR(localisation.getTriRoute(), prDebut);
            GestionPr.miseAJourDepartementPR(localisation.getTriRoute(), prFin);
            if (!LocalisationInfo.prSensRoute) {
                constructionInfo.setPrDebut(prDebut);
                constructionInfo.setPrFin(prFin);
            } else {
                constructionInfo.setPrDebut(prFin);
                constructionInfo.setPrFin(prDebut);
            }
            if (localisation.getEstRoutePrpk() && prDebut != null && prDebut.getPr() == prFin.getPr() && distanceInfo.getDistance() > 0) {
                long differenceArrondi = Math.abs(prDebut.getDistancePr() - prFin.getDistancePr()) - (long)distanceInfo.getDistance();
                if (prDebut.getDistancePr() > prFin.getDistancePr()) {
                    if (prDebut.getDistancePr() - differenceArrondi >= 0L) {
                        prDebut.setDistancePr(prDebut.getDistancePr() - differenceArrondi);
                    }
                } else if (prFin.getDistancePr() - differenceArrondi >= 0L) {
                    prFin.setDistancePr(prFin.getDistancePr() - differenceArrondi);
                }
            }
        }
        return constructionInfo;
    }

    public void miseAJourAdresse(Localisation l, ConstructionInfo c) {
        String numAdresse;
        Enregistrement adresse = null;
        try {
            adresse = Recherche.getAdresseProche(l, l.getPoint(), 500);
        }
        catch (Exception e) {
            GLS.getLogs().debug((Object)("AUCUNE ADRESSE TROUVEE " + l.getRoute()), (Throwable)e);
        }
        if (adresse != null) {
            numAdresse = adresse.getValeur(1).concat(adresse.getValeur(2));
            c.setValeur("adresseDebut", numAdresse);
        }
        if (l.getLongueur() > 0.0) {
            adresse = null;
            try {
                adresse = Recherche.getAdresseProche(l, c.getDernierPositionnement().getPoint(), 500);
            }
            catch (Exception e) {
                GLS.getLogs().debug((Object)("AUCUNE ADRESSE TROUVEE " + l.getRoute()), (Throwable)e);
            }
            if (adresse != null) {
                numAdresse = adresse.getValeur(1).concat(adresse.getValeur(2));
                c.setValeur("adresseFin", numAdresse);
            }
        }
    }

    public ConstructionInfo getConstructionInfoSansRoute(GeoPoint point) {
        ConstructionInfo constructionInfo = new ConstructionInfo();
        if (this.localisation.getRechercheCommune()) {
            constructionInfo.setInfoCommune(Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), point, 1));
            constructionInfo.setInfoCommuneSecondaire(Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheCommuneZone(), point, 1));
        } else {
            constructionInfo.setInfoCommune(null);
            constructionInfo.setInfoCommuneSecondaire(null);
        }
        if (this.localisation.getRechercheCei()) {
            constructionInfo.setInfoDIR(Recherche.rechercherPremierEnregistrementDistance(LocalisationInfo.getCoucheDIR(), point, 10));
        } else {
            constructionInfo.setInfoDIR(null);
        }
        Vector<GeoPoint> points = new Vector<GeoPoint>();
        points.add(point);
        constructionInfo.setLongueur(0.0);
        constructionInfo.setListePoints(points);
        constructionInfo.setAlertcDebut(new LocalisantAlertc());
        constructionInfo.setAlertcFin(new LocalisantAlertc());
        constructionInfo.setPrDebut(new LocalisantPr());
        constructionInfo.setPrFin(new LocalisantPr());
        return constructionInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector construitEvenementDoubleSens(Localisation localisation, TriRoute tri) throws ErreurTriTroncon, ErreurLocalisation {
        Vector<GeoPoint> listePointsEvenementAutreSens = new Vector<GeoPoint>();
        GeoPositionnement tronconEnFace = null;
        boolean fin = false;
        InfoTroncon troncon = null;
        int i = 0;
        GeoPositionnement geoPositionnement = tri.getGeoPositionnement();
        if (geoPositionnement.getTroncon().estASensUnique()) {
            LocalisationInfo.ecrireLog("+--> Recherche du troncon a sens unique en face double sens");
            tronconEnFace = Recherche.getTronconEnFace(this.localisation);
            double distanceParcourue = 0.0;
            double distanceParcourueTmp = 0.0;
            double distanceAParcourir = localisation.getLongueur();
            boolean distanceAtteinte = false;
            tronconEnFace.inverser(Tri.tronconDepartInverse(tronconEnFace.getTroncon(), true));
            listePointsEvenementAutreSens.add(tronconEnFace.getPoint());
            boolean bl = distanceAtteinte = distanceParcourue >= distanceAParcourir;
            if (localisation.getPosition().equals("t")) {
                Vector listeTronconsEvenementDoubleSens = tri.getTronconsSuivant(tronconEnFace.getTroncon().getTroncon(), tronconEnFace.getTroncon().getCouche());
                LocalisationInfo.ecrireLog("+--> Troncons en face tete unique " + listeTronconsEvenementDoubleSens.size());
                if (!distanceAtteinte) {
                    float[] listeXTroncon = tronconEnFace.getTroncon().getX();
                    float[] listeYTroncon = tronconEnFace.getTroncon().getY();
                    distanceParcourue = tronconEnFace.getPoint().distance(listeXTroncon[tronconEnFace.getIndicePoint() + 1], listeYTroncon[tronconEnFace.getIndicePoint() + 1]);
                    listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[tronconEnFace.getIndicePoint() + 1], listeYTroncon[tronconEnFace.getIndicePoint() + 1]));
                    distanceAtteinte = distanceParcourue >= distanceAParcourir;
                    i = tronconEnFace.getIndicePoint() + 1;
                    fin = i >= listeXTroncon.length - 1;
                    while (!distanceAtteinte && !fin) {
                        distanceParcourueTmp = distanceParcourue;
                        listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i + 1], listeYTroncon[i + 1]));
                        distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i + 1], listeYTroncon[i + 1])) >= distanceAParcourir;
                        boolean bl2 = fin = ++i >= listeXTroncon.length - 1;
                    }
                    if (!distanceAtteinte) {
                        int iTroncon = 0;
                        int nbTroncon = listeTronconsEvenementDoubleSens.size();
                        boolean finTroncon = nbTroncon == 0;
                        while (!finTroncon && !distanceAtteinte) {
                            troncon = (InfoTroncon)listeTronconsEvenementDoubleSens.get(iTroncon);
                            listeXTroncon = troncon.getX();
                            listeYTroncon = troncon.getY();
                            fin = false;
                            i = 0;
                            while (!distanceAtteinte && !fin) {
                                distanceParcourueTmp = distanceParcourue;
                                listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i + 1], listeYTroncon[i + 1]));
                                distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i + 1], listeYTroncon[i + 1])) >= distanceAParcourir;
                                boolean bl3 = fin = ++i == listeXTroncon.length - 1;
                            }
                            boolean bl4 = finTroncon = ++iTroncon == nbTroncon;
                        }
                    }
                }
                if (!distanceAtteinte) {
                    LocalisationInfo.ecrireLog("#--> ERREUR LA DISTANCE N'A PAS PU ETRE ATTEINTE EN DOUBLE SENS");
                    return listePointsEvenementAutreSens;
                } else {
                    if (!(distanceAParcourir > 0.0)) return listePointsEvenementAutreSens;
                    LocalisationInfo.ecrireLog("+--> Recalcul longueur double sens");
                    try {
                        GeoPoint p1 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 2);
                        GeoPoint p2 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 1);
                        double tmpDistance = distanceParcourue - distanceParcourueTmp;
                        double distanceRecalcul = distanceParcourue - distanceAParcourir;
                        GeoPoint nouveauPoint = GeoPoint.recalculLongueur(p1, p2, 0.0, tmpDistance, tmpDistance - distanceRecalcul);
                        listePointsEvenementAutreSens.set(listePointsEvenementAutreSens.size() - 1, nouveauPoint);
                        return listePointsEvenementAutreSens;
                    }
                    catch (Exception e) {
                        LocalisationInfo.ecrireLog("#--> ERREUR RECALCUL DISTANCE EVENEMENT # " + e.toString());
                    }
                }
                return listePointsEvenementAutreSens;
            }
            Vector listeTronconsEvenementDoubleSens = tri.getTronconsPrecedent(tronconEnFace.getTroncon().getTroncon(), tronconEnFace.getTroncon().getCouche());
            LocalisationInfo.ecrireLog("+--> Troncons en face queu unique " + listeTronconsEvenementDoubleSens.size());
            if (!distanceAtteinte) {
                float[] listeXTroncon = tronconEnFace.getTroncon().getX();
                float[] listeYTroncon = tronconEnFace.getTroncon().getY();
                distanceParcourue = tronconEnFace.getPoint().distance(listeXTroncon[tronconEnFace.getIndicePoint()], listeYTroncon[tronconEnFace.getIndicePoint()]);
                listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[tronconEnFace.getIndicePoint()], listeYTroncon[tronconEnFace.getIndicePoint()]));
                distanceAtteinte = distanceParcourue >= distanceAParcourir;
                i = tronconEnFace.getIndicePoint();
                fin = i <= 0;
                while (!distanceAtteinte && !fin) {
                    distanceParcourueTmp = distanceParcourue;
                    listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]));
                    distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i - 1], listeYTroncon[i - 1])) >= distanceAParcourir;
                    boolean bl5 = fin = --i <= 0;
                }
                if (!distanceAtteinte) {
                    int iTroncon = 0;
                    int nbTroncon = listeTronconsEvenementDoubleSens.size();
                    boolean finTroncon = nbTroncon == 0;
                    while (!finTroncon && !distanceAtteinte) {
                        troncon = (InfoTroncon)listeTronconsEvenementDoubleSens.get(iTroncon);
                        listeXTroncon = troncon.getX();
                        listeYTroncon = troncon.getY();
                        fin = false;
                        i = listeXTroncon.length - 1;
                        while (!distanceAtteinte && !fin) {
                            distanceParcourueTmp = distanceParcourue;
                            listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]));
                            distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i - 1], listeYTroncon[i - 1])) >= distanceAParcourir;
                            boolean bl6 = fin = --i == 0;
                        }
                        boolean bl7 = finTroncon = ++iTroncon == nbTroncon;
                    }
                }
            }
            if (!distanceAtteinte) {
                LocalisationInfo.ecrireLog("#--> ERREUR LA DISTANCE N'A PAS PU ETRE ATTEINTE EN DOUBLE SENS");
                return listePointsEvenementAutreSens;
            }
            if (!(distanceAParcourir > 0.0)) return listePointsEvenementAutreSens;
            LocalisationInfo.ecrireLog("+--> Recalcul longueur double sens");
            try {
                GeoPoint p1 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 2);
                GeoPoint p2 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 1);
                double tmpDistance = distanceParcourue - distanceParcourueTmp;
                double distanceRecalcul = distanceParcourue - distanceAParcourir;
                GeoPoint nouveauPoint = GeoPoint.recalculLongueur(p1, p2, 0.0, tmpDistance, tmpDistance - distanceRecalcul);
                listePointsEvenementAutreSens.set(listePointsEvenementAutreSens.size() - 1, nouveauPoint);
                return listePointsEvenementAutreSens;
            }
            catch (Exception e) {
                LocalisationInfo.ecrireLog("#--> ERREUR RECALCUL DISTANCE EVENEMENT # " + e.toString());
            }
            return listePointsEvenementAutreSens;
        }
        if (!LocalisationInfo.estTronconDoubleSens(geoPositionnement.getTroncon())) return listePointsEvenementAutreSens;
        double distanceParcourue = 0.0;
        double distanceParcourueTmp = 0.0;
        double distanceAParcourir = localisation.getLongueur();
        boolean distanceAtteinte = false;
        LocalisationInfo.ecrireLogDebug("+--> Troncon depart inverse " + geoPositionnement.getTroncon().estInverse());
        GeoPositionnement geoPositionnementEnFace = new GeoPositionnement(geoPositionnement.getPoint(), geoPositionnement.getTroncon().getTroncon(), geoPositionnement.getTroncon().getCouche());
        geoPositionnementEnFace.inverser(!geoPositionnement.getTroncon().estInverse());
        geoPositionnementEnFace.repositionner();
        LocalisationInfo.ecrireLogDebug("Geopositionnement en face geo inv " + geoPositionnementEnFace.getTroncon().getPointDebut() + " --- " + geoPositionnementEnFace.getTroncon().getPointFin());
        LocalisationInfo.ecrireLogDebug("Geopositionnement geo inv " + geoPositionnement.getTroncon().getPointDebut() + " --- " + geoPositionnement.getTroncon().getPointFin());
        LocalisationInfo.ecrireLogDebug("+--> Troncon depart en face inverse " + geoPositionnementEnFace.getTroncon().estInverse() + " - " + geoPositionnement.getTroncon().estInverse() + " - " + localisation.getSens().getSensChainageOk());
        LocalisationInfo.ecrireLogDebug("+--> Inversion du troncon de depart " + geoPositionnementEnFace.getTroncon().estInverse());
        GeoPoint pointProjection = geoPositionnementEnFace.getPoint();
        listePointsEvenementAutreSens.add(pointProjection);
        distanceAtteinte = distanceParcourue >= distanceAParcourir;
        LocalisationInfo.ecrireLog("+--> SENS CHAINAGE OK " + localisation.getSens().getSensChainageOk() + " -- " + distanceAtteinte);
        if (localisation.getPosition().equals("t")) {
            Vector listeTronconsEvenementDoubleSens = tri.getTronconsSuivant(geoPositionnementEnFace.getTroncon());
            if (!distanceAtteinte) {
                float[] listeXTroncon = geoPositionnementEnFace.getTroncon().getX();
                float[] listeYTroncon = geoPositionnementEnFace.getTroncon().getY();
                int indicePoint = geoPositionnementEnFace.getIndicePoint();
                distanceParcourue = pointProjection.distance(listeXTroncon[indicePoint + 1], listeYTroncon[indicePoint + 1]);
                listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[indicePoint + 1], listeYTroncon[indicePoint + 1]));
                distanceAtteinte = distanceParcourue >= distanceAParcourir;
                i = indicePoint + 1;
                fin = i >= listeXTroncon.length - 1;
                while (!distanceAtteinte && !fin) {
                    distanceParcourueTmp = distanceParcourue;
                    listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i + 1], listeYTroncon[i + 1]));
                    distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i + 1], listeYTroncon[i + 1])) >= distanceAParcourir;
                    boolean bl = fin = ++i >= listeXTroncon.length - 1;
                }
                if (!distanceAtteinte) {
                    int iTroncon = 0;
                    int nbTroncon = listeTronconsEvenementDoubleSens.size();
                    boolean finTroncon = nbTroncon == 1;
                    while (!finTroncon && !distanceAtteinte) {
                        troncon = (InfoTroncon)listeTronconsEvenementDoubleSens.get(iTroncon);
                        listeXTroncon = troncon.getX();
                        listeYTroncon = troncon.getY();
                        LocalisationInfo.ecrireLog("Troncon inverse t " + troncon.estInverse() + " -- " + troncon.getPointDebut() + " -- " + troncon.getPointFin() + " -- " + listeXTroncon[0] + " -- " + listeYTroncon[0]);
                        fin = false;
                        i = 0;
                        while (!distanceAtteinte && !fin) {
                            distanceParcourueTmp = distanceParcourue;
                            LocalisationInfo.ecrireLogDebug("Point t " + listeXTroncon[i + 1] + " -- " + listeYTroncon[i + 1]);
                            listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i + 1], listeYTroncon[i + 1]));
                            distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i + 1], listeYTroncon[i + 1])) >= distanceAParcourir;
                            boolean bl = fin = ++i == listeXTroncon.length - 1;
                        }
                        boolean bl = finTroncon = ++iTroncon == nbTroncon;
                    }
                }
            }
            if (!distanceAtteinte) {
                LocalisationInfo.ecrireLog("#--> ERREUR LA DISTANCE N'A PAS PU ETRE ATTEINTE EN DOUBLE SENS");
                return listePointsEvenementAutreSens;
            } else {
                if (!(distanceAParcourir > 0.0)) return listePointsEvenementAutreSens;
                LocalisationInfo.ecrireLog("+--> Recalcul longueur double sens");
                try {
                    GeoPoint p1 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 2);
                    GeoPoint p2 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 1);
                    double tmpDistance = distanceParcourue - distanceParcourueTmp;
                    double distanceRecalcul = distanceParcourue - distanceAParcourir;
                    GeoPoint nouveauPoint = GeoPoint.recalculLongueur(p1, p2, 0.0, tmpDistance, tmpDistance - distanceRecalcul);
                    listePointsEvenementAutreSens.set(listePointsEvenementAutreSens.size() - 1, nouveauPoint);
                    return listePointsEvenementAutreSens;
                }
                catch (Exception e) {
                    LocalisationInfo.ecrireLog("#--> ERREUR RECALCUL DISTANCE EVENEMENT # " + e.toString());
                }
            }
            return listePointsEvenementAutreSens;
        }
        Vector listeTronconsEvenementDoubleSens = tri.getTronconsPrecedent(geoPositionnementEnFace.getTroncon(), new Vector<String>());
        LocalisationInfo.ecrireLog("+--> Liste troncons double sens trouve prec " + listeTronconsEvenementDoubleSens.size());
        if (!distanceAtteinte) {
            float[] listeXTroncon = geoPositionnementEnFace.getTroncon().getX();
            float[] listeYTroncon = geoPositionnementEnFace.getTroncon().getY();
            int indicePoint = geoPositionnementEnFace.getIndicePoint();
            distanceParcourue = pointProjection.distance(listeXTroncon[indicePoint], listeYTroncon[indicePoint]);
            listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[indicePoint], listeYTroncon[indicePoint]));
            distanceAtteinte = distanceParcourue >= distanceAParcourir;
            i = indicePoint;
            fin = i <= 0;
            while (!distanceAtteinte && !fin) {
                distanceParcourueTmp = distanceParcourue;
                listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]));
                distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i - 1], listeYTroncon[i - 1])) >= distanceAParcourir;
                boolean bl = fin = --i <= 0;
            }
            if (!distanceAtteinte) {
                int iTroncon = 0;
                int nbTroncon = listeTronconsEvenementDoubleSens.size();
                boolean finTroncon = nbTroncon <= 1;
                while (!finTroncon && !distanceAtteinte) {
                    troncon = (InfoTroncon)listeTronconsEvenementDoubleSens.get(iTroncon);
                    LocalisationInfo.ecrireLog("Troncon inverse q " + troncon.estInverse() + " -- " + troncon.getPointDebut() + " -- " + troncon.getPointFin() + " -- " + listeXTroncon[0] + " -- " + listeYTroncon[0]);
                    listeXTroncon = troncon.getX();
                    listeYTroncon = troncon.getY();
                    fin = false;
                    i = listeXTroncon.length - 1;
                    while (!distanceAtteinte && !fin) {
                        distanceParcourueTmp = distanceParcourue;
                        LocalisationInfo.ecrireLogDebug("Point q " + listeXTroncon[i - 1] + " -- " + listeYTroncon[i - 1]);
                        listePointsEvenementAutreSens.add(new GeoPoint(listeXTroncon[i - 1], listeYTroncon[i - 1]));
                        distanceAtteinte = (distanceParcourue += GeoPoint.distance(listeXTroncon[i], listeYTroncon[i], listeXTroncon[i - 1], listeYTroncon[i - 1])) > distanceAParcourir;
                        boolean bl = fin = --i == 0;
                    }
                    boolean bl = finTroncon = ++iTroncon == nbTroncon;
                }
            }
        }
        if (!distanceAtteinte) {
            LocalisationInfo.ecrireLog("#--> ERREUR LA DISTANCE N'A PAS PU ETRE ATTEINTE EN DOUBLE SENS");
            return listePointsEvenementAutreSens;
        }
        if (!(distanceAParcourir > 0.0)) return listePointsEvenementAutreSens;
        LocalisationInfo.ecrireLog("+--> Recalcul longueur double sens");
        try {
            GeoPoint p1 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 2);
            GeoPoint p2 = (GeoPoint)listePointsEvenementAutreSens.get(listePointsEvenementAutreSens.size() - 1);
            double tmpDistance = distanceParcourue - distanceParcourueTmp;
            double distanceRecalcul = distanceParcourue - distanceAParcourir;
            GeoPoint nouveauPoint = GeoPoint.recalculLongueur(p1, p2, 0.0, tmpDistance, tmpDistance - distanceRecalcul);
            listePointsEvenementAutreSens.set(listePointsEvenementAutreSens.size() - 1, nouveauPoint);
            return listePointsEvenementAutreSens;
        }
        catch (Exception e) {
            LocalisationInfo.ecrireLog("#--> ERREUR RECALCUL DISTANCE EVENEMENT # " + e.toString());
        }
        return listePointsEvenementAutreSens;
    }

    public ConstructionInfo construitEvenement(LocalisantPr prDebut, LocalisantPr prFin, String route, boolean sensPr) throws ErreurLocalisation, ErreurAxeInconnu, ErreurPR, ErreurAlertc, ErreurTriTroncon, LocalisationErreurDistancePrpk {
        return this.construitEvenement(this.localisation, prDebut, prFin, route, sensPr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstructionInfo construitEvenement(Localisation localisation, LocalisantPr prDebut, LocalisantPr prFin, String route, boolean sensPr) throws ErreurLocalisation, ErreurPR, ErreurAxeInconnu, ErreurAlertc, ErreurTriTroncon, LocalisationErreurDistancePrpk {
        DistanceInfo longueurEvenement;
        GeoPositionnement tronconPrFin;
        GeoPositionnement tronconPrDebut;
        LocalisantPr prFinRecherche;
        LocalisantPr prDebutRecherche;
        if (prDebut == null || localisation == null) throw new ErreurLocalisation("LES PR NE SONT PAS VALIDES");
        prDebut.setRoute(route);
        int distanceBaionnette = 0;
        if (prDebut == null || prDebut.estVide()) {
            throw new ErreurPR("Vous devez renseigner le PR de d\u00e9but");
        }
        if (localisation.estDepartementPrObligatoire() && !prDebut.aDepartement()) {
            throw new ErreurPR("Le PR de d\u00e9but doit comporter le num\u00e9ro du d\u00e9partement");
        }
        if (prFin == null || prFin.estVide()) {
            if (prFin == null) {
                prFin = new LocalisantPr(prDebut.getEntitePr(), prDebut.getDistancePr());
            } else {
                prFin.setLocalisantPr(prDebut);
            }
        } else if (!prFin.aDepartement()) {
            prFin.setDepartement(prDebut.getDepartement());
        }
        prFin.setRoute(route);
        if (LocalisationInfo.prSensRoute) {
            if (GestionPr.estMemeDepartement(prDebut, prFin) && !prDebut.equals(prFin, true)) {
                sensPr = prDebut.estAvant(prFin);
            }
            if (localisation.getPosition().equals("q")) {
                prDebutRecherche = new LocalisantPr(prDebut.getEntitePr(), prDebut.getDistancePr());
                prFinRecherche = new LocalisantPr(prFin.getEntitePr(), prFin.getDistancePr());
            } else {
                prFinRecherche = new LocalisantPr(prDebut.getEntitePr(), prDebut.getDistancePr());
                prDebutRecherche = new LocalisantPr(prFin.getEntitePr(), prFin.getDistancePr());
            }
        } else {
            if (GestionPr.estMemeDepartement(prDebut, prFin) && !prDebut.equals(prFin, true)) {
                sensPr = !prDebut.estAvant(prFin);
            }
            if (localisation.getPosition().equals("t")) {
                prDebutRecherche = new LocalisantPr(prDebut.getEntitePr(), prDebut.getDistancePr());
                prFinRecherche = new LocalisantPr(prFin.getEntitePr(), prFin.getDistancePr());
            } else {
                prFinRecherche = new LocalisantPr(prDebut.getEntitePr(), prDebut.getDistancePr());
                prDebutRecherche = new LocalisantPr(prFin.getEntitePr(), prFin.getDistancePr());
            }
        }
        if (prDebutRecherche.getDistancePr() < 0L && !prDebutRecherche.estAbscisseNegatif()) {
            prDebutRecherche.getEntitePr().setAbscisse((int)prDebutRecherche.getDistancePr());
        }
        if (prFinRecherche.getDistancePr() < 0L && !prFinRecherche.estAbscisseNegatif()) {
            prFinRecherche.getEntitePr().setAbscisse((int)prFinRecherche.getDistancePr());
        }
        GLS.getLogs().debug((Object)("#### SENS PR = " + sensPr));
        LocalisationInfo.ecrireLog("+--> POSITIONNEMENT AUX PR " + prDebutRecherche + " -- " + prFinRecherche + " -- " + sensPr);
        try {
            tronconPrDebut = Recherche.getPositionAtPR(prDebutRecherche, false);
        }
        catch (ErreurAxeInconnu e) {
            throw new ErreurAxeInconnu();
        }
        if (tronconPrDebut == null) {
            throw new ErreurPR("PR " + route + " " + prDebutRecherche + " NON TROUVE");
        }
        LocalisationInfo.ecrireLogDebug("GEOPOSITION " + tronconPrDebut.getTroncon().getLongueur() + " " + tronconPrDebut.getTroncon().getValeur(6) + " " + tronconPrDebut.getTroncon().getValeur(7) + " " + tronconPrDebut.getDistanceDebut());
        LocalisantPr prTmp = null;
        try {
            prTmp = (LocalisantPr)tronconPrDebut.getObjet();
        }
        catch (Exception e) {
            prTmp = null;
            GLS.getLogs().error((Object)"POINT BAIONNETTE ERREUR ", (Throwable)e);
            distanceBaionnette = 0;
        }
        if (prTmp != null && prTmp.estBaionnette()) {
            distanceBaionnette = prTmp.getEntitePr().getAbscisse();
            if (prTmp.estAbscisseNegatif()) {
                int distance = Math.abs(distanceBaionnette) - Math.abs((int)prDebutRecherche.getDistancePr());
                prDebutRecherche.initialiseDistancePr(distance);
                prDebutRecherche.getEntitePr().setAbscisse(distanceBaionnette);
            } else {
                prDebutRecherche.setDistancePr(prDebutRecherche.getDistancePr() - (long)distanceBaionnette);
            }
            if (prDebutRecherche.getDistancePr() < 0L) {
                if (!LocalisationInfo.correctionAutoBaionnette) {
                    throw new ErreurPR(localisation.getMessageErreurBaionnetteDebut(distanceBaionnette));
                }
                prDebutRecherche.setDistancePr(distanceBaionnette);
                if (LocalisationInfo.messageCorrectionAutoBaionnette) {
                    MsgBox.afficherInfo("Positionnement automatique au PR " + prDebutRecherche.toString(false) + ". Probl\u00e8me de cartographie.");
                }
            }
        } else {
            distanceBaionnette = 0;
        }
        localisation.initialiser(tronconPrDebut);
        if (!GestionPr.estMemeDepartement(prDebutRecherche, prFinRecherche)) {
            tronconPrFin = Recherche.getPositionAtPR(localisation.getTriRoute(), prFinRecherche, false);
            if (tronconPrFin == null) throw new ErreurPR("LE PR " + route + " " + prFinRecherche + " EST INTROUVABLE");
            if (localisation.getPosition().equals("t")) {
                sensPr = !GestionPr.getSensPr(localisation.getTriRoute(), tronconPrDebut, tronconPrFin);
            } else {
                boolean bl = sensPr = !GestionPr.getSensPr(localisation.getTriRoute(), tronconPrFin, tronconPrDebut);
            }
            if (!sensPr) {
                LocalisationInfo.ecrireLog("+--> On change le sens du tri");
                localisation.getSens().changer(false);
                tronconPrDebut = Recherche.getPositionAtPR(localisation.getTriRoute(), prDebutRecherche, false);
                tronconPrFin = Recherche.getPositionAtPR(localisation.getTriRoute(), prFinRecherche, false);
                if (tronconPrFin == null) throw new ErreurPR("LE PR " + route + " " + prFinRecherche + " EST INTROUVABLE");
                if (localisation.getPosition().equals("t")) {
                    sensPr = !GestionPr.getSensPr(localisation.getTriRoute(), tronconPrDebut, tronconPrFin);
                } else {
                    boolean bl = sensPr = !GestionPr.getSensPr(localisation.getTriRoute(), tronconPrFin, tronconPrDebut);
                }
                if (!sensPr) {
                    throw new ErreurLocalisation("Impossible de creer l'evenement dans le bon sens PR");
                }
                localisation.getTriRoute().reinitialiser(tronconPrDebut);
            }
            try {
                sensPr = !localisation.getTriRoute().estAvant(tronconPrFin);
            }
            catch (Exception e) {
                throw new ErreurPR(e.getMessage());
            }
        } else if (localisation.getSens().getSensRoutePrpkOk() != sensPr) {
            LocalisationInfo.ecrireLog("+--> On change le sens du tri");
            localisation.getSens().changer(false);
            if (localisation.getSens().getSensRoutePrpkOk() != sensPr) {
                throw new ErreurLocalisation("Impossible de creer l'evenement dans le bon sens PR");
            }
            tronconPrDebut = Recherche.getPositionAtPR(localisation.getTriRoute(), prDebutRecherche, false);
            localisation.getTriRoute().reinitialiser(tronconPrDebut);
        }
        tronconPrDebut.setIndiceTri(localisation.getTriRoute().getIndiceTronconDepart());
        LocalisationInfo.ecrireLog("+--> Dist deb fin troncon " + tronconPrDebut.getDistanceDebut() + " -- " + tronconPrDebut.getDistanceFin());
        if (localisation.getTri().getNbTroncons() == 1 && localisation.getTri().getNbPr() == 1) {
            LocalisationInfo.ecrireLog("+--> Tri \u00e0 un seul tron\u00e7on et 1 seul pr aucune reinitialisation d'inversion");
        } else {
            localisation.getTriRoute().initialiserInversionTronconDepart(localisation.getSens().getSensChainageOk());
        }
        DistanceInfo distanceInterPr = GestionPr.getDistanceInterPrSuivant(localisation.getTriRoute(), prDebutRecherche.estAbscisseNegatif() ? prTmp : prDebutRecherche, sensPr);
        LocalisationInfo.ecrireLog("+--> Distance inter pr debut " + distanceInterPr.getDistance());
        if (!GestionPr.verrificationDistanceInterPr(distanceInterPr.getDistance(), prDebutRecherche)) {
            throw new LocalisationErreurDistancePrpk("La distance inter pr d\u00e9but saisie (" + ((long)distanceBaionnette + prDebutRecherche.getDistancePr()) + "m) est sup\u00e9rieure \u00e0 la distance r\u00e9elle (" + (distanceBaionnette + distanceInterPr.getDistance()) + "m)");
        }
        try {
            tronconPrDebut = Recherche.getPositionAtDistance((Tri)localisation.getTriRoute(), prDebutRecherche.getDistancePr(), sensPr);
        }
        catch (ErreurLimiteRoute e) {
            tronconPrDebut = null;
        }
        if (tronconPrDebut == null) {
            throw new ErreurLocalisation("DISTANCE DEBUT " + route + " " + prDebutRecherche + " IMPOSSIBLE A ATTEINDRE");
        }
        localisation.getTriRoute().reinitialiser(tronconPrDebut, !tronconPrDebut.getTroncon().estInverse());
        System.out.println("###!!! INVERSE APRES " + tronconPrDebut.getTroncon().estInverse());
        tronconPrFin = Recherche.getPositionAtPR(localisation.getTriRoute(), prFinRecherche, false);
        if (tronconPrFin == null) {
            throw new ErreurPR("LE PR " + route + " " + prFinRecherche + " EST INTROUVABLE");
        }
        try {
            prTmp = (LocalisantPr)tronconPrFin.getObjet();
        }
        catch (Exception e) {
            GLS.getLogs().error((Object)"POINT BAIONNETTE ERREUR ", (Throwable)e);
            distanceBaionnette = 0;
            prTmp = null;
        }
        if (prTmp != null && prTmp.estBaionnette()) {
            distanceBaionnette = prTmp.getEntitePr().getAbscisse();
            if (prTmp.estAbscisseNegatif()) {
                int distance = Math.abs(distanceBaionnette) - Math.abs((int)prFinRecherche.getDistancePr());
                prFinRecherche.initialiseDistancePr(distance);
                prFinRecherche.getEntitePr().setAbscisse(distanceBaionnette);
            } else {
                prFinRecherche.setDistancePr(prFinRecherche.getDistancePr() - (long)distanceBaionnette);
            }
            if (prFinRecherche.getDistancePr() < 0L) {
                if (!LocalisationInfo.correctionAutoBaionnette) {
                    throw new ErreurPR(localisation.getMessageErreurBaionnetteFin(distanceBaionnette));
                }
                prFinRecherche.setDistancePr(distanceBaionnette);
                if (LocalisationInfo.messageCorrectionAutoBaionnette) {
                    MsgBox.afficherInfo("Positionnement automatique au PR " + prFinRecherche.toString(false) + ". Probl\u00e8me de cartographie.");
                }
            }
        } else {
            distanceBaionnette = 0;
        }
        distanceInterPr = GestionPr.getDistanceInterPrSuivant(localisation.getTriRoute(), tronconPrFin, prTmp, sensPr);
        LocalisationInfo.ecrireLog("+--> Distance inter pr fin " + distanceInterPr.getDistance());
        if (!GestionPr.verrificationDistanceInterPr(distanceInterPr.getDistance(), prFinRecherche)) {
            throw new LocalisationErreurDistancePrpk("La distance inter pr fin saisie (" + ((long)distanceBaionnette + prFinRecherche.getDistancePr()) + "m) est sup\u00e9rieure \u00e0 la distance r\u00e9elle (" + (distanceBaionnette + distanceInterPr.getDistance()) + "m)");
        }
        if (!prDebut.equals(prFin, true)) {
            try {
                tronconPrFin = Recherche.getPositionAtDistance(localisation.getTriRoute(), tronconPrFin, prFinRecherche.getDistancePr(), sensPr);
            }
            catch (ErreurLimiteRoute e) {
                tronconPrFin = null;
            }
            if (tronconPrFin == null) {
                throw new ErreurLocalisation("DISTANCE FIN " + route + " " + prFinRecherche + " IMPOSSIBLE A ATTEINDRE");
            }
            if (localisation.getTriRoute().estRocade() && tronconPrDebut.getIndiceTri() < tronconPrFin.getIndiceTri() && localisation.getPosition().equals("t")) {
                tronconPrFin.setIndiceTri(tronconPrFin.getIndiceTri() - localisation.getTriRoute().getNbTroncons());
            }
            longueurEvenement = Distance.distanceEntrePositionnements(localisation.getTriRoute(), tronconPrDebut, tronconPrFin, tronconPrDebut.getIndiceTri(), tronconPrFin.getIndiceTri());
        } else {
            longueurEvenement = prDebut.equals(prFin, true) ? new DistanceInfo(0) : new DistanceInfo((int)Math.abs(prDebut.getDistancePr() - prFin.getDistancePr()));
        }
        LocalisationInfo.ecrireLog("+--> Longueur evenement " + longueurEvenement.getDistance());
        if (longueurEvenement.estNulle()) {
            throw new ErreurLocalisation("ERREUR DISTANCE NULLE LOCALISATION IMPOSSIBLE");
        }
        localisation.setLongueur(longueurEvenement.getDistance());
        ConstructionInfo constructionInfo = this.construitEvenement(localisation, localisation.getTriRoute(), localisation.getRechercheAlertc(), false, false, new GeoPoints(), localisation.getLongueur(), false);
        constructionInfo.setPrDebut(prDebut);
        constructionInfo.setPrFin(prFin);
        return constructionInfo;
    }

    public ConstructionInfo construitEvenement(LocalisantAlertc alertcDebut, LocalisantAlertc alertcFin, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon {
        return this.construitEvenement(this.localisation, alertcDebut, alertcFin, -1.0, sensAlertc);
    }

    public ConstructionInfo construitEvenement(LocalisantAlertc alertcDebut, LocalisantAlertc alertcFin, double longueurAlertc, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon {
        return this.construitEvenement(this.localisation, alertcDebut, alertcFin, longueurAlertc, sensAlertc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstructionInfo construitEvenement(Localisation localisation, LocalisantAlertc alertcDebutRecherche, LocalisantAlertc alertcFinRecherche, double longueurAlertc, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon {
        boolean sensAlertcOk;
        LocalisantAlertc alertcFin;
        LocalisantAlertc alertcDebut;
        if (localisation == null || sensAlertc == null || alertcDebutRecherche == null || alertcFinRecherche == null || alertcDebutRecherche.estVide() || alertcFinRecherche.estVide()) throw new ErreurLocalisation("LES POINTS ALERTC NE SONT PAS VALIDES");
        GeoPositionnement tronconAlertcDebut = null;
        GeoPositionnement tronconAlertcFin = null;
        if (!ListeEntiteAlertc.sontDansLeMemeChainage(alertcFinRecherche.getEntiteAlertc(), alertcDebutRecherche.getEntiteAlertc())) {
            if (!LocalisationInfo.correctionAutoAlertc) throw new ErreurAlertc("LES POINTS NE SONT PAS DANS LE MEME CHAINAGE " + alertcDebutRecherche + " -- " + alertcFinRecherche);
            alertcDebut = new LocalisantAlertc(alertcDebutRecherche, "P");
            alertcFin = new LocalisantAlertc(alertcDebutRecherche, "P");
            sensAlertcOk = true;
        } else if (sensAlertc.equals("B")) {
            localisation.getSens().set(3);
            if (ListeEntiteAlertc.estDansLeChainageAlertcSuivant(alertcFinRecherche.getEntiteAlertc(), alertcDebutRecherche.getEntiteAlertc())) {
                alertcDebut = new LocalisantAlertc(alertcDebutRecherche, "P");
                alertcFin = new LocalisantAlertc(alertcFinRecherche, "P");
            } else {
                alertcDebut = new LocalisantAlertc(alertcFinRecherche, "P");
                alertcFin = new LocalisantAlertc(alertcDebutRecherche, "P");
            }
            sensAlertcOk = true;
        } else {
            alertcDebut = new LocalisantAlertc(alertcDebutRecherche, sensAlertc);
            alertcFin = new LocalisantAlertc(alertcFinRecherche, sensAlertc);
            localisation.getSens().set(sensAlertc.equals("P") ? 1 : 2);
            sensAlertcOk = sensAlertc.equals("P");
        }
        if (alertcDebut.equals(alertcFin) && alertcDebut.getDistanceAlertc() == alertcFin.getDistanceAlertc()) {
            longueurAlertc = 0.0;
        }
        LocalisationInfo.ecrireLog("+--> POSITIONNEMENT AUX ALERTC " + alertcDebut + " -- " + alertcFin + " -- " + sensAlertc);
        tronconAlertcDebut = Recherche.getPositionAtAlertc(alertcDebut);
        if (tronconAlertcDebut == null) {
            throw new ErreurAlertc("ALERTC DEBUT " + alertcDebut + " NON TROUVE");
        }
        localisation.initialiser(tronconAlertcDebut);
        if (localisation.getTri().getAlertcMax().equals(alertcDebut.getEntiteAlertc())) {
            tronconAlertcDebut = localisation.getTri().reinitialiser(alertcDebut);
        }
        LocalisationInfo.ecrireLog("GEOPOSITIONNEMENT ALERTC " + tronconAlertcDebut);
        LocalisationInfo.ecrireLogDebug("SENS ALERTC VERIF " + localisation.getSens().getSensRouteAlertcOk() + " -- " + sensAlertcOk);
        if (localisation.getSens().getSensRouteAlertcOk() != sensAlertcOk) {
            LocalisationInfo.ecrireLogDebug("Reinitialisation du sens alertc");
            localisation.getSens().changer(false);
            if (localisation.getSens().getSensRouteAlertcOk() != sensAlertcOk) {
                localisation.getTriRoute().reinitialiser(tronconAlertcDebut, localisation.getSens().getSensChainageOk());
            }
        }
        DistanceInfo distanceInterAlertc = GestionAlertc.getDistanceInterAlertcPrecedent(localisation.getTriRoute(), alertcDebut);
        LocalisationInfo.ecrireLog("+--> Distance inter alertc debut " + distanceInterAlertc.getDistance());
        if ((long)distanceInterAlertc.getDistance() < alertcDebut.getDistanceAlertc()) {
            if (longueurAlertc != -1.0) {
                alertcDebut.setDistanceAlertc(0L);
            } else if (!GestionAlertc.verificationDistanceInterAlertc(distanceInterAlertc.getDistance(), alertcDebut)) {
                throw new ErreurLocalisation("DISTANCE INTER ALERTC DEBUT ERREUR # " + distanceInterAlertc.getDistance() + " < " + alertcDebut.getDistanceAlertc());
            }
        }
        try {
            tronconAlertcDebut = Recherche.getPositionAtDistance(localisation.getTriRoute(), alertcDebut.getDistanceAlertc() * -1L);
        }
        catch (ErreurLimiteRoute e) {
            tronconAlertcDebut = null;
        }
        if (tronconAlertcDebut == null) {
            throw new ErreurLocalisation("DISTANCE DEBUT IMPOSSIBLE A ATTEINDRE");
        }
        if (longueurAlertc == -1.0) {
            localisation.getTriRoute().reinitialiser(tronconAlertcDebut, localisation.getSens().getSensChainageOk());
            tronconAlertcFin = Recherche.getPositionAtAlertc(localisation.getTriRoute(), alertcFin);
            if (tronconAlertcFin == null) {
                throw new ErreurAlertc("LE POINT ALERTC " + alertcFin + " EST INTROUVABLE");
            }
            try {
                if (localisation.getTriRoute().estApres(tronconAlertcFin)) {
                    throw new ErreurAlertc("LE POINT ALERTC DE FIN DOIT ETRE PLACE AVANT " + alertcFin);
                }
            }
            catch (Exception ex) {
                throw new ErreurAlertc("ERREUR LORS DE LA DETERMINATION DE LA POSITION DES POSITIONNEMENTS ALERTC " + alertcFin + " - " + localisation.getTriRoute() + " -- " + tronconAlertcFin + ex);
            }
            distanceInterAlertc = GestionAlertc.getDistanceInterAlertcSuivant(localisation.getTriRoute(), tronconAlertcFin, alertcFin);
            LocalisationInfo.ecrireLog("+--> Distance inter alertc fin " + distanceInterAlertc.getDistance());
            if (!GestionAlertc.verificationDistanceInterAlertc(distanceInterAlertc.getDistance(), alertcFin)) {
                throw new ErreurLocalisation("DISTANCE INTER ALERTC FIN ERREUR # " + distanceInterAlertc.getDistance() + "<" + alertcFin.getDistanceAlertc());
            }
            try {
                tronconAlertcFin = Recherche.getPositionAtDistance((Tri)localisation.getTriRoute(), tronconAlertcFin, alertcFin.getDistanceAlertc());
            }
            catch (ErreurLimiteRoute e) {
                tronconAlertcFin = null;
            }
            if (tronconAlertcFin == null) {
                throw new ErreurLocalisation("DISTANCE FIN IMPOSSIBLE A ATTEINDRE");
            }
            DistanceInfo longueurEvenement = Distance.distanceEntrePositionnements(localisation.getTriRoute(), tronconAlertcDebut, tronconAlertcFin);
            LocalisationInfo.ecrireLog("+--> Longueur evenement " + longueurEvenement.getDistance());
            if (longueurEvenement.estNulle()) {
                throw new ErreurLocalisation("ERREUR DISTANCE NULLE LOCALISATION IMPOSSIBLE");
            }
            localisation.setLongueur(longueurEvenement.getDistance());
        } else {
            localisation.setLongueur(longueurAlertc);
        }
        localisation.setPosition("t");
        ConstructionInfo constructionInfo = this.construitEvenement(localisation, localisation.getTriRoute(), false, localisation.getRecherchePrpk(), false, new GeoPoints(), localisation.getLongueur(), false);
        constructionInfo.setAlertcDebut(alertcDebut);
        constructionInfo.setAlertcFin(alertcFin);
        return constructionInfo;
    }

    private boolean aUnTronconEnFace(InfoTroncon troncon) {
        LocalisationInfo.ecrireLog("+--> Double sens ? " + troncon.getValeur(11) + "  " + troncon.getValeur(10));
        return (troncon.getValeur(11).equals("2") || troncon.getValeur(11).equals("1")) && troncon.getValeur(10).equals("3");
    }

    private boolean estDansLaListe(Vector vector, InfoTroncon infoTroncon) {
        boolean trouve = false;
        boolean finVecteur = false;
        int i = 0;
        finVecteur = i == vector.size();
        while (!trouve && !finVecteur) {
            if (infoTroncon.equals((InfoTroncon)vector.get(i))) {
                trouve = true;
            }
            boolean bl = finVecteur = ++i == vector.size();
        }
        return trouve;
    }
}

