/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.alertc;

import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.EntiteAlertc;
import gls.localisation.alertc.ListeEntiteAlertc;
import gls.outils.ConstantesGLS;

public class LocalisantAlertc {
    private EntiteAlertc entiteAlertc = null;
    private String sensAlertc = null;
    private long distanceAlertc = -1L;
    private static final String SEPARATEUR_DISTANCE = "+";

    public LocalisantAlertc() {
    }

    public LocalisantAlertc(LocalisantAlertc localisantAlertc) {
        this(localisantAlertc.getEntiteAlertc(), localisantAlertc.getDistanceAlertc(), localisantAlertc.getSensAlertc());
    }

    public LocalisantAlertc(LocalisantAlertc localisantAlertc, String sensAlertc) {
        this(localisantAlertc.getEntiteAlertc(), localisantAlertc.getDistanceAlertc(), sensAlertc);
    }

    public LocalisantAlertc(EntiteAlertc entiteAlertc, long distanceAlertc, String sensAlertc) {
        this.entiteAlertc = entiteAlertc;
        this.distanceAlertc = distanceAlertc;
        this.sensAlertc = sensAlertc;
    }

    public LocalisantAlertc(String localisant) throws Exception {
        this(localisant.split(SEPARATEUR_DISTANCE));
    }

    public LocalisantAlertc(String[] localisants) throws Exception {
        this(localisants[0], localisants[1]);
    }

    public LocalisantAlertc(String localisant, String distance) {
        this.setLocalisant(localisant);
        this.setDistanceAlertc(distance);
    }

    public LocalisantAlertc(String localisant, long distance) {
        this.setLocalisant(localisant);
        this.setDistanceAlertc(distance);
    }

    public LocalisantAlertc(long localisant, long distance) {
        this.setEntiteAlertc(localisant);
        this.setDistanceAlertc(distance);
    }

    public LocalisantAlertc(long localisant, String codePays, long distance) {
        this.setEntiteAlertc(localisant, codePays);
        this.setDistanceAlertc(distance);
    }

    public void setEntiteAlertc(long alertc) {
        this.setEntiteAlertc(ListeEntiteAlertc.getLocalisant(alertc));
    }

    public void setEntiteAlertc(long alertc, String codePays) {
        this.setEntiteAlertc(ListeEntiteAlertc.getLocalisant(alertc, codePays));
    }

    public void setEntiteAlertc(EntiteAlertc entiteAlertc) {
        this.entiteAlertc = entiteAlertc;
    }

    public EntiteAlertc getEntiteAlertc() {
        return this.entiteAlertc;
    }

    public void setLocalisantAlertc(String localisant, long distance) {
        this.setLocalisant(localisant);
        this.setDistanceAlertc(distance);
    }

    public void setLocalisantAlertc(LocalisantAlertc localisantAlertc) {
        this.setEntiteAlertc(localisantAlertc.getEntiteAlertc());
        this.sensAlertc = localisantAlertc.getSensAlertc();
        this.setDistanceAlertc(localisantAlertc.getDistanceAlertc());
    }

    public void setLocalisant(String localisant) {
        if (!LocalisationInfo.estVide(localisant)) {
            long idloc = -1L;
            char premierCaractere = localisant.charAt(0);
            String sensAlertc = null;
            String codePays = null;
            boolean estNumerique = ConstantesGLS.estNumerique(premierCaractere);
            try {
                if (estNumerique) {
                    idloc = Long.parseLong(localisant);
                } else if (premierCaractere == '(') {
                    int finCodePays = localisant.indexOf(41);
                    if (finCodePays > 0) {
                        codePays = localisant.substring(1, finCodePays);
                        if (!ConstantesGLS.estNumerique(localisant.charAt(finCodePays + 1))) {
                            sensAlertc = String.valueOf(localisant.charAt(finCodePays + 1));
                            idloc = Long.parseLong(localisant.substring(finCodePays + 2));
                        } else {
                            idloc = Long.parseLong(localisant.substring(finCodePays + 1));
                        }
                    } else {
                        idloc = -1L;
                    }
                } else {
                    idloc = Long.parseLong(localisant.substring(1).trim());
                    sensAlertc = String.valueOf(premierCaractere);
                }
            }
            catch (Exception e) {
                LocalisationInfo.ecrireLog("#--> LOCALISANT ALERTC NULL ");
            }
            if (idloc == -1L) {
                this.entiteAlertc = null;
                this.sensAlertc = null;
            } else {
                this.sensAlertc = sensAlertc == null ? "B" : sensAlertc;
                if (codePays == null) {
                    this.setEntiteAlertc(idloc);
                } else {
                    this.setEntiteAlertc(idloc, codePays);
                }
            }
        }
    }

    public boolean estVide() {
        return this.entiteAlertc == null || this.entiteAlertc.getLocalisant() == -1L;
    }

    public void setDistanceAlertc(String distance) {
        if (distance != null && !distance.equals("")) {
            long valDistance;
            try {
                valDistance = Long.parseLong(distance);
            }
            catch (Exception e) {
                LocalisationInfo.ecrireLog("#--> DISTANCE NULLE " + distance);
                valDistance = -1L;
            }
            this.setDistanceAlertc(valDistance);
        } else {
            this.distanceAlertc = -1L;
        }
    }

    public void setDistanceAlertc(long distanceAlertc) {
        this.distanceAlertc = this.entiteAlertc == null ? -1L : distanceAlertc;
    }

    public long getDistanceAlertc() {
        return this.distanceAlertc;
    }

    public void setSensAlertc(String sensAlertc) {
        this.sensAlertc = sensAlertc;
    }

    public String getSensAlertc() {
        return this.sensAlertc;
    }

    public boolean equals(EntiteAlertc alertc) {
        return !this.estVide() && this.entiteAlertc.equals(alertc);
    }

    public boolean equals(LocalisantAlertc alertc, boolean verifierSens) {
        return alertc != null && this.equals(alertc.getEntiteAlertc()) && (!verifierSens || verifierSens && this.sensAlertc != null && alertc.getSensAlertc() != null && this.sensAlertc.equals(alertc.getSensAlertc()));
    }

    public boolean equals(LocalisantAlertc alertc) {
        return this.equals(alertc, false);
    }

    public boolean contains(String champAlertc) {
        if (!LocalisationInfo.estVide(champAlertc) && !this.estVide()) {
            String[] listeAlertc = champAlertc.split(";");
            int i = 0;
            while (i < listeAlertc.length) {
                try {
                    LocalisantAlertc localisantAlertc = new LocalisantAlertc(listeAlertc[i], 0L);
                    if (this.equals(localisantAlertc, false)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        if (this.entiteAlertc == null) {
            return "";
        }
        return String.valueOf(this.entiteAlertc.toString(this.sensAlertc)) + (LocalisationInfo.estNulle(this.distanceAlertc) ? "" : " +" + this.distanceAlertc);
    }
}

