/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.alertc;

import gls.geometry.GeoPositionnement;
import gls.localisation.InfoTroncon;
import gls.localisation.LocalisationInfo;
import gls.localisation.alertc.ListeEntiteAlertc;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.distance.Distance;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.exception.ErreurAlertc;
import gls.localisation.exception.ErreurPR;
import gls.localisation.tri.TriRoute;

public class GestionAlertc {
    public static boolean verificationDistanceInterAlertc(int distanceInterAlertc, LocalisantAlertc alertc) {
        if ((long)distanceInterAlertc > alertc.getDistanceAlertc()) {
            return true;
        }
        LocalisationInfo.ecrireLog("ERREUR DISTANCE INTER ALERTC " + alertc + " ERREUR - distance ALERTC:" + distanceInterAlertc + " > " + alertc.getDistanceAlertc());
        if (LocalisationInfo.correctionAutoAlertc) {
            if (LocalisationInfo.differenceMaximumCorrectionAutoAbscisseAlertc == -1 || alertc.getDistanceAlertc() - (long)distanceInterAlertc < (long)LocalisationInfo.differenceMaximumCorrectionAutoAbscisseAlertc) {
                LocalisationInfo.ecrireLog("CORRECTION AUTO " + alertc + " --> NOUVELLE ABSCISSE ALERTC " + distanceInterAlertc);
                alertc.setDistanceAlertc(distanceInterAlertc);
                return true;
            }
            LocalisationInfo.ecrireLog("ERREUR CORRECTION AUTO IMPOSSIBLE " + (alertc.getDistanceAlertc() - (long)distanceInterAlertc) + " > " + LocalisationInfo.differenceMaximumCorrectionAutoAbscisseAlertc);
            return false;
        }
        return false;
    }

    public static DistanceInfo getDistanceInterAlertcPrecedent(TriRoute tri, LocalisantAlertc alertc, boolean sensPr) {
        if (!sensPr) {
            return GestionAlertc.getDistanceInterAlertcSuivant(tri, alertc);
        }
        return GestionAlertc.getDistanceInterAlertcPrecedent(tri, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcPrecedent(TriRoute tri, GeoPositionnement positionAlertc, LocalisantAlertc alertc, boolean sensAlertc) {
        if (!sensAlertc) {
            return GestionAlertc.getDistanceInterAlertcSuivant(tri, positionAlertc, alertc);
        }
        return GestionAlertc.getDistanceInterAlertcPrecedent(tri, positionAlertc, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcPrecedent(TriRoute tri, LocalisantAlertc alertc) {
        if (tri != null) {
            return GestionAlertc.getDistanceInterAlertcPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), alertc);
        }
        return new DistanceInfo();
    }

    public static DistanceInfo getDistanceInterAlertcPrecedent(TriRoute tri, int iTroncon, GeoPositionnement positionAlertc, LocalisantAlertc alertc) {
        DistanceInfo distanceInterAlertc = new DistanceInfo();
        if (!LocalisationInfo.estNulle(iTroncon)) {
            GeoPositionnement positionAlertcPrecedent = GestionAlertc.getPositionAlertcPrecedent(tri, iTroncon, positionAlertc, alertc);
            if (positionAlertcPrecedent != null) {
                LocalisationInfo.ecrireLog("+--> Le alertc alertc precedent a \u00e9t\u00e9 trouv\u00e9");
                distanceInterAlertc = Distance.distanceEntrePositionnements(tri, positionAlertc, positionAlertcPrecedent);
            } else {
                LocalisationInfo.ecrireLog("+--> Le alertc alertc precedent n'a pas \u00e9t\u00e9 trouv\u00e9");
                distanceInterAlertc.setDistance(positionAlertc.getDistanceDebut());
                int i = 0;
                while (i < iTroncon) {
                    distanceInterAlertc.ajouterDistance(tri.getTronconSansException(i).getLongueur());
                    ++i;
                }
            }
        }
        return distanceInterAlertc;
    }

    public static DistanceInfo getDistanceInterAlertcPrecedent(TriRoute tri, GeoPositionnement positionAlertc, LocalisantAlertc alertc) {
        int iTroncon = tri.getIndiceTroncon(positionAlertc.getTroncon());
        return GestionAlertc.getDistanceInterAlertcPrecedent(tri, iTroncon, positionAlertc, alertc);
    }

    public static LocalisantAlertc getAlertcPrecedent(TriRoute tri) {
        return GestionAlertc.getAlertcPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), null);
    }

    public static LocalisantAlertc getAlertcPrecedent(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        if (tronconRecherche != null) {
            LocalisantAlertc alertcPrecedent = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            LocalisationInfo.ecrireLogDebug("Est troncon alertc courant " + troncon.estAlertc());
            if (troncon.estAlertc()) {
                LocalisationInfo.ecrireLogDebug("Recherche sur troncon courant alertcecedents");
                alertcPrecedent = troncon.getAlertcMax(alertc, -1L, tronconRecherche.getDistanceDebut());
            }
            --i;
            while (alertcPrecedent == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                LocalisationInfo.ecrireLogDebug("Est troncon alertc alertcec " + troncon.estAlertc());
                alertcPrecedent = troncon.getAlertcMax(alertc);
                LocalisationInfo.ecrireLogDebug("Recherche sur les troncons alertcecedents " + i);
                --i;
            }
            return alertcPrecedent;
        }
        return null;
    }

    public static LocalisantAlertc getAlertcPrecedent(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getAlertcPrecedent(tri, i, tronconRecherche, alertc);
    }

    public static LocalisantAlertc getAlertcPrecedent(TriRoute tri, GeoPositionnement tronconRecherche) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getAlertcPrecedent(tri, i, tronconRecherche, null);
    }

    public static GeoPositionnement getPositionAlertcPrecedent(TriRoute tri, LocalisantAlertc alertc) {
        return GestionAlertc.getPositionAlertcPrecedent(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), alertc);
    }

    public static GeoPositionnement getPositionAlertcPrecedent(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        if (tronconRecherche != null) {
            GeoPositionnement positionnementAlertcPrecedent = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            if (troncon.estAlertc()) {
                LocalisationInfo.ecrireLog("+--> ALERTC A EVITER " + alertc);
                positionnementAlertcPrecedent = troncon.getPositionnementAlertc(troncon.getAlertcMax(alertc, -1L, tronconRecherche.getDistanceDebut()));
                if (positionnementAlertcPrecedent != null) {
                    positionnementAlertcPrecedent.setIndiceTri(i);
                }
            }
            --i;
            while (positionnementAlertcPrecedent == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                if (troncon.estAlertc() && (positionnementAlertcPrecedent = troncon.getPositionnementAlertc(troncon.getAlertcMax(alertc))) != null) {
                    positionnementAlertcPrecedent.setIndiceTri(i);
                }
                --i;
            }
            return positionnementAlertcPrecedent;
        }
        return null;
    }

    public static GeoPositionnement getPositionAlertcPrecedent(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getPositionAlertcPrecedent(tri, i, tronconRecherche, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcSuivant(TriRoute tri, LocalisantAlertc alertc, boolean sensAlertc) {
        if (sensAlertc) {
            return GestionAlertc.getDistanceInterAlertcSuivant(tri, alertc);
        }
        return GestionAlertc.getDistanceInterAlertcPrecedent(tri, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcSuivant(TriRoute tri, GeoPositionnement positionAlertc, LocalisantAlertc alertc, boolean sensAlertc) {
        if (sensAlertc) {
            return GestionAlertc.getDistanceInterAlertcSuivant(tri, positionAlertc, alertc);
        }
        return GestionAlertc.getDistanceInterAlertcPrecedent(tri, positionAlertc, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcSuivant(TriRoute tri, LocalisantAlertc alertc) {
        if (tri != null) {
            return GestionAlertc.getDistanceInterAlertcSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), alertc);
        }
        return new DistanceInfo();
    }

    public static DistanceInfo getDistanceInterAlertcSuivant(TriRoute tri, GeoPositionnement positionAlertc, LocalisantAlertc alertc) {
        int iTroncon = tri.getIndiceTroncon(positionAlertc.getTroncon());
        return GestionAlertc.getDistanceInterAlertcSuivant(tri, iTroncon, positionAlertc, alertc);
    }

    public static DistanceInfo getDistanceInterAlertcSuivant(TriRoute tri, int iTroncon, GeoPositionnement positionAlertc, LocalisantAlertc alertc) {
        DistanceInfo distanceInterAlertc = new DistanceInfo();
        if (!LocalisationInfo.estNulle(iTroncon)) {
            GeoPositionnement positionAlertcSuivant = GestionAlertc.getPositionAlertcSuivant(tri, positionAlertc, alertc);
            if (positionAlertcSuivant != null) {
                LocalisationInfo.ecrireLog("+--> Le alertc suivant a \u00e9t\u00e9 trouv\u00e9");
                distanceInterAlertc = Distance.distanceEntrePositionnements(tri, positionAlertc, positionAlertcSuivant);
            } else {
                LocalisationInfo.ecrireLog("+--> Le alertc suivant n'a pas \u00e9t\u00e9 trouv\u00e9");
                distanceInterAlertc.setDistance(positionAlertc.getDistanceFin());
                int i = iTroncon + 1;
                while (i < tri.getNbTroncons()) {
                    distanceInterAlertc.ajouterDistance(tri.getTronconSansException(i).getLongueur());
                    ++i;
                }
            }
        }
        return distanceInterAlertc;
    }

    public static LocalisantAlertc getAlertcSuivant(TriRoute tri) {
        if (tri != null) {
            return GestionAlertc.getAlertcSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), null);
        }
        return null;
    }

    public static LocalisantAlertc getAlertcSuivant(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        if (tronconRecherche != null) {
            LocalisantAlertc alertcSuivant = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            if (troncon.estAlertc()) {
                alertcSuivant = troncon.getAlertcMin(alertc, tronconRecherche.getDistanceDebut(), Long.MAX_VALUE);
            }
            ++i;
            while (alertcSuivant == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                alertcSuivant = troncon.getAlertcMin(alertc);
                ++i;
            }
            return alertcSuivant;
        }
        return null;
    }

    public static LocalisantAlertc getAlertcSuivant(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getAlertcSuivant(tri, i, tronconRecherche, alertc);
    }

    public static LocalisantAlertc getAlertcSuivant(TriRoute tri, GeoPositionnement tronconRecherche) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getAlertcSuivant(tri, i, tronconRecherche, null);
    }

    public static GeoPositionnement getPositionAlertcSuivant(TriRoute tri, LocalisantAlertc alertc) {
        if (tri != null) {
            return GestionAlertc.getPositionAlertcSuivant(tri, tri.getIndiceTronconDepart(), tri.getGeoPositionnement(), alertc);
        }
        return null;
    }

    public static GeoPositionnement getPositionAlertcSuivant(TriRoute tri, int i, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        if (tronconRecherche != null) {
            GeoPositionnement positionnementAlertcSuivant = null;
            InfoTroncon troncon = tronconRecherche.getTroncon();
            LocalisationInfo.ecrireLogDebug("Nb troncons " + tri.getNbTroncons());
            if (troncon.estAlertc()) {
                LocalisationInfo.ecrireLogDebug("Est alertc troncon recherche");
                positionnementAlertcSuivant = troncon.getPositionnementAlertc(troncon.getAlertcMin(alertc, tronconRecherche.getDistanceDebut(), Long.MAX_VALUE));
                if (positionnementAlertcSuivant != null) {
                    positionnementAlertcSuivant.setIndiceTri(i);
                }
            }
            ++i;
            while (positionnementAlertcSuivant == null && troncon != null) {
                troncon = tri.getTronconSansException(i);
                if (troncon == null) continue;
                LocalisationInfo.ecrireLogDebug("Recherche sur le troncon " + i + troncon.estPR());
                if (troncon.estAlertc() && (positionnementAlertcSuivant = troncon.getPositionnementAlertc(troncon.getAlertcMin(alertc))) != null) {
                    positionnementAlertcSuivant.setIndiceTri(i);
                }
                ++i;
            }
            return positionnementAlertcSuivant;
        }
        return null;
    }

    public static GeoPositionnement getPositionAlertcSuivant(TriRoute tri, GeoPositionnement tronconRecherche, LocalisantAlertc alertc) {
        int i = tri.getIndiceTronconAtIdgdf(tronconRecherche.getTroncon().getIdgdf());
        return GestionAlertc.getPositionAlertcSuivant(tri, i, tronconRecherche, alertc);
    }

    public static boolean getSensAlertc(TriRoute tri, GeoPositionnement positionnementDebut, GeoPositionnement positionnementFin) throws ErreurPR {
        if (tri != null) {
            try {
                return tri.estApres(positionnementDebut, positionnementFin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ErreurPR("#--> SENS PR IMPOSSIBLE A DETERMINER # TRI NUL");
    }

    public static boolean getSensAlertc(LocalisantAlertc alertcSecondaire, LocalisantAlertc alertcPrimaire) throws ErreurAlertc {
        if (alertcSecondaire != null && alertcPrimaire != null && !alertcSecondaire.estVide() && !alertcPrimaire.estVide()) {
            if (ListeEntiteAlertc.estDansLeChainageAlertcSuivant(alertcSecondaire.getEntiteAlertc(), alertcPrimaire.getEntiteAlertc())) {
                return true;
            }
            if (ListeEntiteAlertc.estDansLeChainageAlertcSuivant(alertcPrimaire.getEntiteAlertc(), alertcSecondaire.getEntiteAlertc())) {
                return false;
            }
            if (LocalisationInfo.autoriserErreurChainageAlertcMemeRoute && alertcSecondaire.getEntiteAlertc().getNomRoute().equals(alertcPrimaire.getEntiteAlertc().getNomRoute())) {
                return alertcSecondaire.getSensAlertc().equals("P");
            }
            throw new ErreurAlertc("ERREUR SENS ALERTC # LES POINTS ALERTC N'APPARTIENNENT PAS A LA MEME ROUTE");
        }
        throw new ErreurAlertc("ERREUR SENS ALERTC # LES POINTS ALERTC SONT VIDES");
    }
}

