/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation.alertc;

import gls.localisation.LocalisationInfo;
import gls.outils.GLS;

public class EntiteAlertc {
    private long localisant;
    private String libelle;
    private long localisantSuivant;
    private long localisantPrecedent;
    private String sousType;
    private String codePays;
    private String nomRoute;
    private String nomCouche;
    private String point;
    private static final int NB_CHAMPS_ALERTC_SANS_COUCHE = 6;
    private static final int NB_CHAMPS_ALERTC_AVEC_COUCHE = 7;

    public EntiteAlertc(String[] nouvelleEntite) {
        if (nouvelleEntite.length > 6) {
            this.localisant = Long.parseLong(nouvelleEntite[0]);
            this.sousType = nouvelleEntite[1];
            this.libelle = nouvelleEntite[2];
            try {
                this.localisantPrecedent = Long.parseLong(nouvelleEntite[3]);
            }
            catch (Exception e) {
                this.localisantPrecedent = 0L;
            }
            try {
                this.localisantSuivant = Long.parseLong(nouvelleEntite[4]);
            }
            catch (Exception e) {
                this.localisantSuivant = 0L;
            }
            this.codePays = nouvelleEntite[5];
            this.nomRoute = nouvelleEntite[6];
            this.nomCouche = nouvelleEntite.length > 7 ? nouvelleEntite[7] : null;
            this.point = nouvelleEntite.length > 8 ? nouvelleEntite[8] : null;
        }
    }

    public String getPoint() {
        return this.point;
    }

    public void setPoint(String point) {
        this.point = point;
    }

    public boolean aGeometry() {
        return !GLS.estVide(this.point);
    }

    public void setLocalisant(long valeur) {
        this.localisant = valeur;
    }

    public void setLibelle(String valeur) {
        this.libelle = valeur;
    }

    public void setLocalisantSuivant(long valeur) {
        this.localisantSuivant = valeur;
    }

    public void setLocalisantPrecedent(long valeur) {
        this.localisantPrecedent = valeur;
    }

    public void setSousType(String valeur) {
        this.sousType = valeur;
    }

    public void setCodePays(String valeur) {
        this.codePays = valeur;
    }

    public void setNomRoute(String valeur) {
        this.nomRoute = valeur;
    }

    public long getLocalisant() {
        return this.localisant;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public long getLocalisantSuivant() {
        return this.localisantSuivant;
    }

    public long getLocalisantPrecedent() {
        return this.localisantPrecedent;
    }

    public String getSousType() {
        return this.sousType;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public String getNomRoute() {
        return this.nomRoute;
    }

    public void setNomCouche(String nomCouche) {
        this.nomCouche = nomCouche;
    }

    public String getNomCouche() {
        return this.nomCouche;
    }

    public String toString(String sensAlertc) {
        return "(" + this.codePays + ")" + (LocalisationInfo.estNulle(sensAlertc) ? "" : sensAlertc) + this.localisant;
    }

    public String toString() {
        return "(" + this.codePays + ")" + this.localisant;
    }

    public boolean contains(String alertc) {
        return !LocalisationInfo.estNulle(this.toString().indexOf(alertc));
    }

    public boolean contains(String alertc, String sensAlertc) {
        return this.toString(sensAlertc).indexOf(alertc) > -1;
    }

    public boolean equals(long localisant, String codePays) {
        return this.localisant != -1L && this.codePays != null && localisant != -1L && codePays != null && localisant == this.localisant && this.codePays.equals(codePays);
    }

    public boolean equals(EntiteAlertc alertc) {
        return alertc != null && this.codePays != null && !LocalisationInfo.estNulle(alertc.getLocalisant()) && this.localisant == alertc.getLocalisant() && this.codePays.equals(alertc.getCodePays());
    }
}

