/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import gls.localisation.Localisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.exception.ErreurLocalisation;
import gls.localisation.exception.ErreurTriTroncon;
import gls.localisation.recherche.Recherche;

public class Sens {
    private Localisation localisation = null;
    private boolean sensChainageOk;
    private boolean doubleSens;
    private int sensEvenement;
    private boolean sensRouteAlertcOk;
    private boolean sensRoutePrpkOk;

    public Sens(Localisation localisation) {
        this.localisation = localisation;
        this.initialiser();
    }

    public void initialiser() {
        this.sensChainageOk = true;
        this.doubleSens = false;
        this.sensEvenement = 1;
    }

    public void setSensChainage(boolean sensChainage) {
        this.sensChainageOk = sensChainage;
    }

    public boolean miseAJourSensChainage() {
        if (this.sensEvenement != 0) {
            if (this.localisation.getTri().getTronconDepart().estASensUnique()) {
                this.sensChainageOk = true;
            } else if (this.localisation.getTri().getTronconDepart().estADoubleSens()) {
                this.sensChainageOk = !this.sensChainageOk;
            }
        } else {
            this.sensChainageOk = true;
        }
        LocalisationInfo.ecrireLog("+--> SENS CHAINAGE " + this.sensChainageOk);
        return this.sensChainageOk;
    }

    public int getSensReferentiel() throws ErreurLocalisation {
        if (this.localisation.getEstRoutePrpk()) {
            if (this.sensRoutePrpkOk) {
                return 1;
            }
            return 2;
        }
        if (this.localisation.getEstRouteAlertc()) {
            if (this.sensRouteAlertcOk) {
                return 1;
            }
            return 2;
        }
        if (LocalisationInfo.gestionRouteSansReferentiel) {
            if (this.sensChainageOk) {
                return 1;
            }
            return 2;
        }
        LocalisationInfo.ecrireLog("#--> ERREUR ROUTE NON LOCALISABLE #");
        throw new ErreurLocalisation("ERREUR ROUTE NON LOCALISABLE");
    }

    public int getSensEvenement() throws ErreurLocalisation {
        if (!this.doubleSens) {
            return this.getSensReferentiel();
        }
        if (this.localisation.getEstRouteAlertc() || this.localisation.getEstRoutePrpk() || LocalisationInfo.gestionRouteSansReferentiel) {
            return 3;
        }
        throw new ErreurLocalisation("ERREUR ROUTE NON LOCALISABLE");
    }

    public int get() {
        return this.sensEvenement;
    }

    public boolean getSensChainageOk() {
        if (this.localisation.getTroncon() != null && this.localisation.getTroncon().estASensUnique()) {
            return true;
        }
        return this.sensChainageOk;
    }

    public void setDoubleSens(boolean doubleSens) {
        this.doubleSens = doubleSens;
    }

    public boolean getDoubleSens() {
        return this.doubleSens;
    }

    public void setSensRoutePrpkOk(boolean sensRoutePrpkOk) {
        this.sensRoutePrpkOk = sensRoutePrpkOk;
    }

    public void setSensRouteAlertcOk(boolean sensRouteAlertcOk) {
        this.sensRouteAlertcOk = sensRouteAlertcOk;
    }

    public boolean getSensRoutePrpkOk() {
        return this.sensRoutePrpkOk;
    }

    public boolean getSensRouteAlertcOk() {
        return this.sensRouteAlertcOk;
    }

    public String getSensDatex() {
        if (this.doubleSens) {
            return "B";
        }
        if (this.sensRouteAlertcOk) {
            return "P";
        }
        return "N";
    }

    public boolean estFixe() {
        return this.localisation.getTri().getTronconDepart().estUnRondPoint() || this.localisation.getTri().estBretelle();
    }

    public void verifier() throws ErreurLocalisation, ErreurTriTroncon {
        this.sensEvenement = this.getSensEvenement();
    }

    public void changer() throws ErreurLocalisation, ErreurTriTroncon {
        this.changer(true);
    }

    public void changer(boolean verifierSens) throws ErreurLocalisation, ErreurTriTroncon {
        if (!this.estFixe()) {
            if (this.localisation.getTri().getTronconDepart().estASensUnique()) {
                this.sensChainageOk = true;
                this.localisation.initialiserTri(Recherche.getTronconEnFace(this.localisation));
            } else {
                this.miseAJourSensChainage();
                if (this.localisation.getTri().getNbPr() == 1) {
                    this.localisation.getGeoPositionnement().getTroncon().setInverse(!this.sensChainageOk);
                    this.localisation.getGeoPositionnement().repositionner();
                    try {
                        this.localisation.initialiserTri(this.localisation.getGeoPositionnement());
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        this.localisation.initialiserTri(this.localisation.getDernierPositionnement());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.localisation.reinitialiser(verifierSens);
        }
    }

    public void verifier(boolean sensReferentiel) throws ErreurLocalisation, ErreurTriTroncon {
        if (sensReferentiel) {
            this.verifier(1);
        } else {
            this.verifier(2);
        }
    }

    public void verifier(int sens) throws ErreurLocalisation, ErreurTriTroncon {
        LocalisationInfo.ecrireLog("+--> Verif sens evenement " + this.getSensEvenement() + " -- " + sens);
        if (!this.estFixe()) {
            if (this.getSensEvenement() != sens) {
                this.set(sens);
                if (this.doubleSens) {
                    if (this.getSensReferentiel() != 1) {
                        this.changer(false);
                    }
                } else if (this.getSensReferentiel() != sens) {
                    this.changer(false);
                }
                if (sens != this.getSensEvenement()) {
                    throw new ErreurLocalisation("ERREUR LE SENS N'EST PAS CORRECT " + sens);
                }
            } else if (this.doubleSens && this.getSensReferentiel() != 1) {
                this.changer(false);
            }
            LocalisationInfo.ecrireLog("+--> Verif sens referentiel " + this.getSensReferentiel() + " -- " + sens);
        }
    }

    public void miseAJour() throws ErreurLocalisation, ErreurTriTroncon {
        this.miseAJour(true);
    }

    public void miseAJour(boolean verifierSens) throws ErreurLocalisation, ErreurTriTroncon {
        if (verifierSens && this.localisation.getTronconRoute() != null && this.localisation.getTronconRoute().estADoubleSens()) {
            LocalisationInfo.ecrireLogDebug("Verification du sens sur route \u00e0 double sens");
            if (this.sensEvenement == 0) {
                this.verifier(1);
            } else {
                this.verifier(this.sensEvenement);
            }
        }
        this.sensEvenement = this.getSensEvenement();
        if (this.sensEvenement == 0) {
            throw new ErreurLocalisation("#--> ERREUR AUCUN REFERENTIEL DISPONIBLE");
        }
    }

    public void set(int sens) {
        if (this.sensEvenement != sens) {
            this.sensEvenement = sens;
            this.doubleSens = sens == 3;
        }
    }
}

