/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import cartoj.Cartes;
import cartoj.Enregistrement;
import cartoj.EntGeo;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import commun.UnPoint;
import gls.application.version.Version;
import gls.comparator.CollatorFactory;
import gls.comparator.MyCollator;
import gls.localisation.InfoDepartements;
import gls.localisation.InfoTroncon;
import gls.localisation.InfoVoieLocalisation;
import gls.localisation.alertc.ListeEntiteAlertc;
import gls.localisation.recherche.Recherche;
import gls.outils.ConstantesGLS;
import gls.outils.GLS;
import gls.outils.fichier.FichierCONFIG;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LocalisationInfo {
    public static String VERSION = new Version(2, 0, 0).toString();
    public static final int ZONE_UTM_DEFAUT = 30;
    public static final String HEMISPHERE_UTM_DEFAUT = "N";
    public static Logger log = GLS.getLogs();
    public static final String SENS_POSITIF = "P";
    public static final String SENS_NEGATIF = "N";
    public static final String DOUBLE_SENS = "B";
    public static final String POSITION_TETE = "t";
    public static final String POSITION_QUEUE = "q";
    public static String POSITION_DEFAUT = "q";
    public static String CALQUE_RONDPOINT = "rondPoint";
    public static String CALQUE_TURNAROUND = "turnaround";
    public static String[] CALQUES_RONDPOINT = new String[]{CALQUE_RONDPOINT, CALQUE_TURNAROUND};
    public static String CALQUE_MAINROAD = "mainroad";
    public static String CALQUE_CLASS1 = "class1";
    public static String CALQUE_CLASS2 = "class2";
    public static String CALQUE_CLASS3 = "class3";
    public static String CALQUE_CLASS4 = "class4";
    public static String CALQUE_CLASS5 = "class5";
    public static String CALQUE_CLASS6 = "class6";
    public static String CALQUE_CLASS7 = "class7";
    public static String CALQUE_CLASS8 = "class8";
    public static String CALQUE_SLIPROAD = "sliproad";
    public static String CALQUE_SLIPROAD2 = "sliproad2";
    public static String CALQUE_ITINIRAIRE_CYCLABLE = "ic";
    public static final String CALQUE_PLO = "plo";
    public static final String CALQUE_PR = "pr";
    public static final String CALQUE_PRPK = "prpk";
    public static final String CALQUE_ALERTC = "alertc";
    public static final String CALQUE_ADRESSE = "adresse";
    public static boolean MAP_MATCHING = false;
    public static boolean CREER_TRONCON_DYNAMIQUE = true;
    public static boolean CREER_TRONCON_PAR_AXE = true;
    public static final String CALQUE_COMMUNE = "commune";
    public static final String CALQUE_ZONECOMMUNE = "zonecommune";
    public static final String CALQUE_ZONEDEPARTEMENT = "zonedepartement";
    public static String[] LISTE_ITINIRAIRES_CYCLABLES = new String[]{CALQUE_ITINIRAIRE_CYCLABLE};
    public static String[] LISTE_ROUTES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8, CALQUE_SLIPROAD, CALQUE_SLIPROAD2};
    public static String[] LISTE_BRETELLES = new String[]{CALQUE_SLIPROAD, CALQUE_SLIPROAD2};
    public static String[] LISTE_ROUTES_PRINCIPALES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_SLIPROAD2};
    public static String[] LISTE_ROUTES_SECONDAIRES = new String[]{CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8, CALQUE_SLIPROAD};
    public static String[] LISTE_TOUTES_ROUTES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8};
    private static final String TOUTES_VOIES_LOCALISATION = "ROUTE";
    private static final InfoVoieLocalisation VOIE_LOCALISATION_DEFAUT = new InfoVoieLocalisation("ROUTE", LISTE_ROUTES_PRINCIPALES, LISTE_ROUTES_SECONDAIRES, true, true, true);
    private static InfoVoieLocalisation VOIE_LOCALISATION_DYNAMIQUE = null;
    private static Map<String, InfoVoieLocalisation> VOIES_LOCALISATION = new HashMap<String, InfoVoieLocalisation>();
    private static Map<String, ICouche> COUCHES = null;
    public static final int CHAMP_IDGDF_ROUTE = 0;
    public static final int CHAMP_NOM_ROUTE = 1;
    public static final int CHAMP_IDGDFDEB_ROUTE = 2;
    public static final int CHAMP_IDGDFFIN_ROUTE = 3;
    public static final int CHAMP_LONGUEUR_ROUTE = 4;
    public static final int CHAMP_EST_ROUTE_ALERTC = 5;
    public static final int CHAMP_NUMERO_PRPK = 6;
    public static final int CHAMP_DISTANCE_PRPK = 7;
    public static final int CHAMP_LOCALISANT_ALERTC = 8;
    public static final int CHAMP_DISTANCE_ALERTC = 9;
    public static final int CHAMP_SENS_ROUTE = 10;
    public static final int CHAMP_TYPE_ROUTE = 11;
    public static final int CHAMP_NOM_COMPLEMENTAIRE_TRONCON = 12;
    public static final int CHAMP_PR_DEBUT_TRONCON = 13;
    public static final int CHAMP_ABSCISSE_PR_DEBUT_TRONCON = 14;
    public static final int CHAMP_POSITION_BRETELLE = 12;
    public static final int CHAMP_DIRECTION_BRETELLE = 13;
    public static final int CHAMP_NOM_CEI = 1;
    public static final int CHAMP_NOM_DISTRICT = 0;
    public static final int CHAMP_ROUTE_CEI = 0;
    public static final int CHAMP_PRDEB_CEI = 2;
    public static final int CHAMP_ABSCISSEPRDEB_CEI = 3;
    public static final int CHAMP_PRFIN_CEI = 4;
    public static final int CHAMP_ABSCISSEPRFIN_CEI = 5;
    public static final int CHAMP_CLASS_CEI = 6;
    public static final int CHAMP_NOM_COMMUNE = 0;
    public static final int CHAMP_CODE_INSEE = 2;
    public static final int CHAMP_CODE_POSTAL = 4;
    public static final int CHAMP_NUMERO_DEPARTEMENT_COMMUNE = 3;
    public static final int CHAMP_NOM_DEPARTEMENT = 0;
    public static final int CHAMP_NUMERO_DEPARTEMENT = 1;
    public static final int CHAMP_PRPK_ROUTE = 0;
    public static final int CHAMP_PRPK_NUM = 1;
    public static final int CHAMP_PRPK_DPT = 2;
    public static final int CHAMP_PRPK_TYPE = 3;
    public static final int CHAMP_PRPK_LIBELLE = 4;
    public static final String VAL_TYPE_PR = "PR";
    public static final String VAL_TYPE_PB = "PB";
    public static final String VAL_TYPE_ROUTE_ROND_POINT = "4";
    public static final String VAL_TYPE_ROUTE_DOUBLE_SENS = "3";
    public static final String VAL_TYPE_ROUTE_SENS_UNIQUE_AUTRES = "2";
    public static final String VAL_TYPE_ROUTE_SENS_UNIQUE_AUTOROUTE = "1";
    public static final String VAL_TYPE_AUTOROUTE = "1";
    public static final String VAL_TYPE_CHAUSSEE_UNIQUE = "3";
    public static final String VAL_TYPE_CHAUSSEES_MULTIPLES = "2";
    public static final String VAL_TYPE_BRETELLE = "10";
    public static final String VAL_TYPE_SPECIAL = "17";
    public static final String VAL_TYPE_NON_DEFINI = "";
    public static final String DF_INTERDIT = "4";
    public static final String DF_POSITIF = "3";
    public static final String DF_NEGATIF = "2";
    public static final String[] DF_DOUBLE_SENS = new String[]{"", "1"};
    public static final String[] VAL_EST_DOUBLE_SENS = new String[]{"", "3"};
    public static final String VAL_EST_ROUTE_ALERTC = "1";
    public static final double VAL_DBL_NEANT = -1.0;
    public static final int VAL_INT_NEANT = -1;
    public static final String VAL_STR_NEANT = "";
    public static final String VAL_STR_NEANT_CARTOJ = " ";
    public static final String VAL_INT_NEANT_CARTOJ = "-1";
    public static final String SEPARATEUR_LOCALISATION = ";";
    public static int margeRechercheRoute = 0;
    public static ListeEntiteAlertc listeEntiteAlertc;
    public static boolean appliquerMalusDistanceInterPr;
    public static boolean prSensRoute;
    public static boolean gestionFinRoute;
    public static boolean gestionRouteSansReferentiel;
    public static boolean appliquerChangementFinRoute;
    public static boolean autoriserErreurChainageAlertcMemeRoute;
    public static boolean creationPrVirtuelFinRouteSensVariable;
    public static boolean autoriserPrNonConsecutif;
    public static boolean correctionAutoAbscissePr;
    public static int differenceMaximumCorrectionAutoAbscissePr;
    public static boolean correctionAutoAlertc;
    public static int differenceMaximumCorrectionAutoAbscisseAlertc;
    public static boolean rechercheTronconAlertcGeographique;
    public static boolean correctionAutoBaionnette;
    public static boolean messageCorrectionAutoBaionnette;
    public static boolean rechercheMultiCouche;
    public static boolean departementPrObligatoire;
    public static boolean estLocalisableParAlertc;
    public static boolean estLocalisableParCei;
    public static boolean estLocalisableParPrpk;
    public static boolean estLocalisableParCommune;
    public static boolean estLocalisableParAdresse;
    public static boolean aCoucheDepartement;
    public static final int POSITION = 10;
    public static final int ERREUR_AUCUNE_ROUTE = 0;
    public static final int ERREUR_ROUTE_SANS_PR = 1;
    public static final int ERREUR_ROUTE_MODIFICATION = 2;
    public static final int SENS_PRPK_POSITIF = 0;
    public static final int SENS_PRPK_NEGATIF = 1;
    public static final int SENS_EVENEMENT_AUCUN = 0;
    public static final int SENS_EVENEMENT_POSITIF = 1;
    public static final int SENS_EVENEMENT_NEGATIF = 2;
    public static final int SENS_EVENEMENT_BIDIRECTIONNEL = 3;
    public static final int VECINFO_COUCHE = 0;
    public static final int VECINFO_POINT = 1;
    public static final int VECINFO_POSITION_POINT = 2;
    public static final int VECINFO_ENREGISTREMENT = 3;
    public static final int DISTANCE_MAX_RECHERCHE_ADRESSE = 500;
    public static int DISTANCE_MAX_RECHERCHE_TRONCON_EN_FACE;
    public static final int DISTANCE_MAX_RECHERCHE_TRONCON = 1000;
    public static final int[] DISTANCE_RECHERCHE_DEPARTEMENT;
    public static final String POSITION_DEBUT = "d";
    public static final String POSITION_FIN = "f";
    private static ICouche coucheBretellePrincipale;
    private static IFichierDon donBretellePrincipale;
    private static IFichierCont contBretellePrincipale;
    private static Vector listeTronconBretellePrincipale;
    private static ICouche coucheBretelleSecondaire;
    private static IFichierDon donBretelleSecondaire;
    private static IFichierCont contBretelleSecondaire;
    private static Vector listeTronconBretelleSecondaire;
    private static ICouche coucheRondPoint;
    private static IFichierDon donRondPoint;
    private static IFichierCont contRondPoint;
    private static Vector listeTronconRondPoint;
    private static ICouche coucheDepartement;
    private static IFichierCont contDepartement;
    private static IFichierDon donDepartement;
    private static InfoDepartements listeDepartements;
    private static ICouche coucheCommuneZone;
    private static IFichierCont contCommuneZone;
    private static IFichierDon donCommuneZone;
    private static String[] listeNomsCommunes;
    private static String[] listeDptCommunes;
    private static ICouche coucheDIR;
    private static IFichierCont contDIR;
    private static IFichierDon donDIR;
    private static ICouche couchePrpk;
    private static IFichierDon donPrpk;
    private static IFichierCont contPrpk;
    private static ICouche coucheAlertc;
    private static IFichierDon donAlertc;
    private static IFichierCont contAlertc;
    public static int zoneUTM;
    public static String hemisphereUTM;
    private static Map<String, String[]> axeCommunes;

    static {
        rechercheMultiCouche = false;
        departementPrObligatoire = true;
        DISTANCE_MAX_RECHERCHE_TRONCON_EN_FACE = 300;
        int[] nArray = new int[3];
        nArray[1] = 200;
        nArray[2] = 500;
        DISTANCE_RECHERCHE_DEPARTEMENT = nArray;
        zoneUTM = 30;
        hemisphereUTM = "N";
    }

    public static ICouche getCouche(String couche) {
        return COUCHES.get(couche);
    }

    public static boolean estCoucheBretelle(ICouche couche) {
        if (couche != null) {
            return couche.getNom().startsWith("sliproad");
        }
        return false;
    }

    public static String[] getAxesCommune(String commune) {
        if (axeCommunes != null) {
            return axeCommunes.get(commune);
        }
        return null;
    }

    public static void ecrireLog(String message) {
        if (log != null && message != null) {
            log.debug((Object)message);
        }
    }

    public static void ecrireLogErreur(String message) {
        if (log != null && message != null) {
            log.error((Object)("#--> " + message));
        }
    }

    public static void ecrireLogInfo(String message) {
        if (log != null && message != null) {
            log.info((Object)("!--> " + message));
        }
    }

    public static void ecrireLogDebug(String message) {
        if (log != null && message != null) {
            log.debug((Object)("+--> " + message));
        }
    }

    public static boolean estTronconNormal(String FW) {
        return FW.equals("1") || FW.equals("2") || FW.equals("3") || FW.equals("") || FW.equals(VAL_TYPE_BRETELLE) || FW.equals(VAL_TYPE_SPECIAL);
    }

    public static boolean estTronconDoubleSens(String DF, String FW) {
        return LocalisationInfo.estTronconNormal(FW) && (DF.equals(DF_DOUBLE_SENS[0]) || DF.equals(DF_DOUBLE_SENS[1]));
    }

    public static boolean estTronconSensUnique(String DF, String FW) {
        return LocalisationInfo.estTronconNormal(FW) && (DF.equals("3") || DF.equals("2"));
    }

    public static boolean estTronconRondPoint(String type) {
        return "4".equals(type);
    }

    public static boolean estTronconDoubleSens(Enregistrement troncon) {
        return LocalisationInfo.estTronconDoubleSens(troncon.getValeur(10), troncon.getValeur(11));
    }

    public static boolean estTronconSensUnique(Enregistrement troncon) {
        return LocalisationInfo.estTronconSensUnique(troncon.getValeur(10), troncon.getValeur(11));
    }

    public static boolean estTronconDoubleSens(InfoTroncon troncon) {
        return LocalisationInfo.estTronconDoubleSens(troncon.getDF(), troncon.getType());
    }

    public static boolean estTronconSensUnique(InfoTroncon troncon) {
        return LocalisationInfo.estTronconSensUnique(troncon.getDF(), troncon.getType());
    }

    public static boolean estTronconRondPoint(Enregistrement troncon) {
        return LocalisationInfo.estTronconRondPoint(troncon.getValeur(11));
    }

    public static Vector<Enregistrement> getPointBaionnette(Enregistrement[] listePr) {
        return LocalisationInfo.getPrParType(listePr, VAL_TYPE_PB);
    }

    public static Vector<Enregistrement> getPr(Enregistrement[] pointsBaionnettes) {
        return LocalisationInfo.getPrParType(pointsBaionnettes, VAL_TYPE_PR);
    }

    public static Vector<Enregistrement> getPrParType(Enregistrement[] listePr, String type) {
        Vector<Enregistrement> listePrParType = new Vector<Enregistrement>();
        Enregistrement[] enregistrementArray = listePr;
        int n = listePr.length;
        int n2 = 0;
        while (n2 < n) {
            Enregistrement pr = enregistrementArray[n2];
            if (GLS.egal(pr.getValeur(3), type)) {
                listePrParType.add(pr);
            }
            ++n2;
        }
        return listePrParType;
    }

    public static Enregistrement getPrRoute(String entitePrpk, String nomRoute) {
        Object enrPr = null;
        try {
            int[] champs = new int[]{0, 1};
            String[] valeurs = new String[]{nomRoute, entitePrpk};
            ICouche couche = LocalisationInfo.getCouche(CALQUE_PRPK);
            Object[] enrs = Recherche.getEnregistrements(couche, champs, valeurs);
            if (!GLS.estVide(enrs)) {
                Vector<Enregistrement> listePr = LocalisationInfo.getPr((Enregistrement[])enrs);
                Vector<Enregistrement> listePb = LocalisationInfo.getPointBaionnette((Enregistrement[])enrs);
                log.debug((Object)("Resultat recherche --> PR : " + listePr.size() + " - PB : " + listePb.size()));
                if (!GLS.estVide(listePr)) {
                    log.debug((Object)"Le r\u00ef\u00bf\u00bdsultat est un PR");
                    enrPr = listePr.get(0);
                } else if (!GLS.estVide(listePb)) {
                    log.debug((Object)"Le r\u00ef\u00bf\u00bdsultat est un PB");
                    enrPr = listePb.get(0);
                } else {
                    enrPr = enrs[0];
                    log.debug((Object)("Le r\u00ef\u00bf\u00bdsultat est de type indetermin\u00ef\u00bf\u00bd " + enrPr.getValeur(3)));
                }
            }
        }
        catch (Exception erreurPR) {
            log.debug((Object)("#--> ERREUR PR INEXISTANT " + entitePrpk + " -- " + nomRoute), (Throwable)erreurPR);
        }
        return enrPr;
    }

    public static void setCoucheBretellePrincipale(ICouche couche) {
        if (couche != null) {
            coucheBretellePrincipale = couche;
            donBretellePrincipale = couche.getDon();
            contBretellePrincipale = couche.getCont();
        } else {
            coucheBretellePrincipale = null;
            donBretellePrincipale = null;
            contBretellePrincipale = null;
        }
    }

    public static ICouche getCoucheBretellePrincipale() {
        return coucheBretellePrincipale;
    }

    public static ICouche getCoucheBretelleSecondaire() {
        return coucheBretelleSecondaire;
    }

    public static void setCoucheBretelleSecondaire(ICouche couche) {
        if (couche != null) {
            coucheBretelleSecondaire = couche;
            donBretelleSecondaire = couche.getDon();
            contBretelleSecondaire = couche.getCont();
        } else {
            coucheBretelleSecondaire = null;
            donBretelleSecondaire = null;
            contBretelleSecondaire = null;
        }
    }

    public static IFichierCont getContBretellePrincipale() {
        return contBretellePrincipale;
    }

    public static IFichierCont getContBretelleSecondaire() {
        return contBretelleSecondaire;
    }

    public static IFichierDon getDonBretellePrincipale() {
        return donBretellePrincipale;
    }

    public static IFichierDon getDonBretelleSecondaire() {
        return donBretelleSecondaire;
    }

    public static ICouche getCoucheRondPoint() {
        return coucheRondPoint;
    }

    public static void setCoucheRondPoint() {
        ICouche couche = LocalisationInfo.getCouche("rondPoint");
        if (couche == null) {
            couche = LocalisationInfo.getCouche("turnaround");
        }
        LocalisationInfo.setCoucheRondPoint(couche);
    }

    public static void setCoucheRondPoint(ICouche couche) {
        if (couche != null) {
            coucheRondPoint = couche;
            donRondPoint = couche.getDon();
            contRondPoint = couche.getCont();
        } else {
            coucheRondPoint = null;
            donRondPoint = null;
            contRondPoint = null;
        }
    }

    public static ICouche getCouchePrpk() {
        return couchePrpk;
    }

    public static void setCouchePrpk() {
        ICouche couche = LocalisationInfo.getCouche(CALQUE_PRPK);
        if (couche == null) {
            couche = LocalisationInfo.getCouche(CALQUE_PR);
        }
        LocalisationInfo.setCouchePrpk(couche);
    }

    public static void setCouchePrpk(ICouche couche) {
        if (couche != null) {
            couchePrpk = couche;
            donPrpk = couche.getDon();
            contPrpk = couche.getCont();
            estLocalisableParPrpk = true;
        } else {
            couchePrpk = null;
            donPrpk = null;
            contPrpk = null;
            estLocalisableParPrpk = false;
        }
    }

    public static ICouche getCoucheDIR() {
        return coucheDIR;
    }

    public static void setCoucheDIR(ICouche couche) {
        if (couche != null) {
            coucheDIR = couche;
            donDIR = couche.getDon();
            contDIR = couche.getCont();
            estLocalisableParCei = true;
        } else {
            coucheDIR = null;
            donDIR = null;
            contDIR = null;
            estLocalisableParCei = false;
        }
    }

    public static ICouche getCoucheAlertc() {
        return coucheAlertc;
    }

    public static void setCoucheAlertc(ICouche couche) {
        if (couche != null) {
            coucheAlertc = couche;
            donAlertc = couche.getDon();
            contAlertc = couche.getCont();
            estLocalisableParAlertc = true;
        } else {
            coucheAlertc = null;
            donAlertc = null;
            contAlertc = null;
            estLocalisableParAlertc = false;
        }
    }

    public static ICouche getCoucheCommuneZone() {
        return coucheCommuneZone;
    }

    public static void setCoucheCommuneZone(ICouche couche) {
        if (couche != null) {
            coucheCommuneZone = couche;
            donCommuneZone = couche.getDon();
            contCommuneZone = couche.getCont();
            listeNomsCommunes = donCommuneZone.getColonne(0).getValeursToString();
            listeDptCommunes = donCommuneZone.getColonne(3).getValeursToString();
            estLocalisableParCommune = true;
        } else {
            coucheCommuneZone = null;
            donCommuneZone = null;
            contCommuneZone = null;
            listeNomsCommunes = null;
            listeDptCommunes = null;
            estLocalisableParCommune = false;
        }
    }

    public static void miseAJourListeDepartements() {
        listeDepartements = new InfoDepartements();
    }

    public static IFichierDon getDonDepartement() {
        return donDepartement;
    }

    public static void setCoucheDepartement(ICouche couche) {
        if (couche != null) {
            aCoucheDepartement = true;
            coucheDepartement = couche;
            donDepartement = couche.getDon();
            contDepartement = couche.getCont();
            LocalisationInfo.miseAJourListeDepartements();
        } else {
            coucheDepartement = null;
            donDepartement = null;
            contCommuneZone = null;
            listeDepartements = null;
            aCoucheDepartement = false;
        }
    }

    public static Vector<String> sortRD(Vector<String> array) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String elt : array) {
            map.put(LocalisationInfo.getNumRD(elt), elt);
        }
        Iterator it = map.values().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add((String)it.next());
        }
        return eltTrie;
    }

    public static String getNumAdresse(String adresse) {
        if (!GLS.estVide(adresse) && GLS.estNumerique(adresse.charAt(0))) {
            String tmp = "";
            String tmpAdresse = "";
            String tmpFinAdresse = "";
            int i = 0;
            boolean fin = adresse.length() == 0;
            boolean finNumerique = false;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            while (!fin) {
                char c = adresse.charAt(i++);
                if (!finNumerique && GLS.estNumerique(c)) {
                    tmpAdresse = String.valueOf(tmpAdresse) + c;
                } else {
                    tmpFinAdresse = String.valueOf(tmpFinAdresse) + c;
                    finNumerique = true;
                }
                boolean bl = fin = i >= adresse.length();
            }
            tmp = nf.format(GLS.getDouble(tmpAdresse)).concat(tmpFinAdresse);
            return tmp;
        }
        return adresse;
    }

    public static void initialiserVoiesLocalisation(List<InfoVoieLocalisation> listeVoies) {
        if (VOIES_LOCALISATION == null) {
            VOIES_LOCALISATION = new HashMap<String, InfoVoieLocalisation>();
        }
        if (!GLS.estVide(listeVoies)) {
            for (InfoVoieLocalisation v : listeVoies) {
                VOIES_LOCALISATION.put(v.getLibelle(), v);
            }
        }
        if (!VOIES_LOCALISATION.containsKey(TOUTES_VOIES_LOCALISATION)) {
            VOIES_LOCALISATION.put(TOUTES_VOIES_LOCALISATION, LocalisationInfo.getVoiesLocalisationDynamique());
        }
    }

    public static InfoVoieLocalisation getVoiesLocalisationDynamique() {
        return VOIE_LOCALISATION_DEFAUT;
    }

    public static String getNumRD(String rd) {
        if (rd.length() >= 2 && GLS.egal(String.valueOf(rd.charAt(0)), "D") && GLS.estNumerique(rd.charAt(1))) {
            String tmp = "";
            String tmpNumRd = "";
            String tmpFinRd = "";
            int i = 1;
            boolean fin = false;
            boolean finNumerique = false;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            tmp = String.valueOf(rd.charAt(0));
            while (!fin) {
                char c = rd.charAt(i++);
                if (!finNumerique && GLS.estNumerique(c)) {
                    tmpNumRd = String.valueOf(tmpNumRd) + c;
                } else {
                    tmpFinRd = String.valueOf(tmpFinRd) + c;
                    finNumerique = true;
                }
                boolean bl = fin = i >= rd.length();
            }
            tmp = tmp.concat(nf.format(GLS.getDouble(tmpNumRd)).concat(tmpFinRd));
            return tmp;
        }
        return rd;
    }

    public static Vector<String> getPr(String route, boolean pourComboBox) {
        Vector<String> listePr = new Vector<String>();
        try {
            int[] indices = new int[1];
            String[] valeurs = new String[]{route};
            Object[] enregistrements = Recherche.getEnregistrements(LocalisationInfo.getCouche(CALQUE_PRPK), indices, valeurs);
            if (!GLS.estVide(enregistrements)) {
                Object[] objectArray = enregistrements;
                int n = enregistrements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object enr = objectArray[n2];
                    String pr = enr.getValeur(1);
                    if (GLS.estVide(pr) || !GLS.estDansLaListe(listePr, (Object)pr)) {
                        // empty if block
                    }
                    listePr.add(pr);
                    ++n2;
                }
            }
        }
        catch (Exception erreur) {
            log.debug((Object)("#--> ERREUR GET PR ROUTE INEXISTANT " + route), (Throwable)erreur);
        }
        MyCollator cfr_ignored_0 = (MyCollator)CollatorFactory.create();
        listePr = MyCollator.sortInteger(listePr);
        if (pourComboBox) {
            listePr.add(0, "");
        }
        return listePr;
    }

    public static InfoDepartements getListeDepartements() {
        if (listeDepartements == null) {
            return new InfoDepartements();
        }
        return listeDepartements;
    }

    public static Vector getListeTronconRondPoint() {
        return listeTronconRondPoint;
    }

    public static ICouche getCoucheDepartement() {
        return coucheDepartement;
    }

    public static void initialiserListeRondPoint() {
        listeTronconRondPoint = new Vector();
        if (coucheRondPoint != null) {
            int nbVal = donRondPoint.getNbval();
            int i = 0;
            while (i < nbVal) {
                listeTronconRondPoint.add(new InfoTroncon(donRondPoint.getEnreg(i), coucheRondPoint));
                ++i;
            }
        }
    }

    public static void initialiserListeBretelle() {
        int i;
        int nbVal;
        listeTronconBretellePrincipale = new Vector();
        if (coucheBretellePrincipale != null) {
            nbVal = donBretellePrincipale.getNbval();
            i = 0;
            while (i < nbVal) {
                listeTronconBretellePrincipale.add(new InfoTroncon(donBretellePrincipale.getEnreg(i), coucheBretellePrincipale));
                ++i;
            }
        }
        listeTronconBretelleSecondaire = new Vector();
        if (coucheBretelleSecondaire != null) {
            nbVal = donBretelleSecondaire.getNbval();
            i = 0;
            while (i < nbVal) {
                listeTronconBretelleSecondaire.add(new InfoTroncon(donBretelleSecondaire.getEnreg(i), coucheBretelleSecondaire));
                ++i;
            }
        }
    }

    public static InfoVoieLocalisation getVoieLocalisation(String valeur) {
        if (valeur != null && VOIES_LOCALISATION != null && VOIES_LOCALISATION.containsKey(valeur)) {
            return VOIES_LOCALISATION.get(valeur);
        }
        return LocalisationInfo.getVoiesLocalisationDynamique();
    }

    public static Vector getListeTronconBretellePrincipale() {
        return listeTronconBretellePrincipale;
    }

    public static Vector getListeTronconBretelleSecondaire() {
        return listeTronconBretelleSecondaire;
    }

    public static boolean getGestionRouteSansReferentiel() {
        return gestionRouteSansReferentiel;
    }

    public static void initialiserAlertc(String cheminAlertc) {
        LocalisationInfo.ecrireLog("!--> Initialisation des points alertc");
        listeEntiteAlertc = new ListeEntiteAlertc(cheminAlertc);
        LocalisationInfo.ecrireLog("!--> Initialisation des points alertc termin\u00ef\u00bf\u00bde");
    }

    public static boolean estCommuneAvecDepartement(String commune) {
        return commune.length() > 2 && ConstantesGLS.estNumerique(commune.charAt(0)) && ConstantesGLS.estNumerique(commune.charAt(1));
    }

    public static boolean estDejaParcouru(Vector vec, String valeur) {
        boolean trouve = false;
        boolean finVecteur = false;
        if (!LocalisationInfo.estNulle(valeur)) {
            int i = 0;
            finVecteur = i == vec.size();
            while (!trouve && !finVecteur) {
                if (valeur.equals((String)vec.get(i))) {
                    trouve = true;
                }
                boolean bl = finVecteur = ++i == vec.size();
            }
        }
        return trouve;
    }

    public static boolean estNulle(int valeur) {
        return valeur == -1;
    }

    public static boolean estNulle(long valeur) {
        return valeur == -1L;
    }

    public static boolean estNulle(double valeur) {
        return valeur == -1.0;
    }

    public static boolean estNulle(String valeur) {
        return valeur == null;
    }

    public static boolean estVide(String valeur) {
        return valeur == null || valeur.trim().equals("");
    }

    public static int getInt(String valeur) {
        return LocalisationInfo.getInt(valeur, -1);
    }

    public static int getInt(String valeur, int defaut) {
        int i;
        try {
            i = Integer.parseInt(valeur);
        }
        catch (Exception e) {
            i = defaut;
        }
        return i;
    }

    public static double getDouble(String valeur) {
        double d;
        try {
            d = Double.parseDouble(valeur);
        }
        catch (Exception e) {
            d = -1.0;
        }
        return d;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector recupDonneesLocalisation(String champAlertc) {
        block1: {
            listeDonneesAlertc = new Vector<String>();
            if (champAlertc.equals("")) break block1;
            pos = champAlertc.indexOf(";");
            if (pos != -1) ** GOTO lbl12
            listeDonneesAlertc.add(champAlertc);
            break block1;
lbl-1000:
            // 1 sources

            {
                listeDonneesAlertc.add(champAlertc.substring(0, pos));
                champAlertc = champAlertc.substring(pos + 1);
                pos = champAlertc.indexOf(";");
lbl12:
                // 2 sources

                ** while (pos != -1)
            }
lbl13:
            // 1 sources

            listeDonneesAlertc.add(champAlertc);
        }
        return listeDonneesAlertc;
    }

    public static void initialiserRoutes(String mainroad, String class1, String class2, String class3, String class4, String class5, String class6, String class7, String class8, String sliproad, String sliproad2) {
        if (mainroad != null && !mainroad.equals("")) {
            CALQUE_MAINROAD = mainroad;
        }
        if (class1 != null && !class1.equals("")) {
            CALQUE_CLASS1 = class1;
        }
        if (class2 != null && !class2.equals("")) {
            CALQUE_CLASS2 = class2;
        }
        if (class3 != null && !class3.equals("")) {
            CALQUE_CLASS3 = class3;
        }
        if (class4 != null && !class4.equals("")) {
            CALQUE_CLASS4 = class4;
        }
        if (class5 != null && !class5.equals("")) {
            CALQUE_CLASS5 = class5;
        }
        if (class6 != null && !class6.equals("")) {
            CALQUE_CLASS6 = class6;
        }
        if (class7 != null && !class7.equals("")) {
            CALQUE_CLASS7 = class7;
        }
        if (class8 != null && !class8.equals("")) {
            CALQUE_CLASS8 = class8;
        }
        if (sliproad != null && !sliproad.equals("")) {
            CALQUE_SLIPROAD = sliproad;
        }
        if (sliproad2 != null && !sliproad2.equals("")) {
            CALQUE_SLIPROAD2 = sliproad2;
        }
        LISTE_ROUTES = null;
        LISTE_ROUTES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8, CALQUE_SLIPROAD, CALQUE_SLIPROAD2};
        LISTE_BRETELLES = null;
        LISTE_BRETELLES = new String[]{CALQUE_SLIPROAD, CALQUE_SLIPROAD2};
        LISTE_ROUTES_PRINCIPALES = null;
        LISTE_ROUTES_PRINCIPALES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_SLIPROAD2};
        LISTE_ROUTES_SECONDAIRES = null;
        LISTE_ROUTES_SECONDAIRES = new String[]{CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8, CALQUE_SLIPROAD};
        LISTE_TOUTES_ROUTES = null;
        LISTE_TOUTES_ROUTES = new String[]{CALQUE_MAINROAD, CALQUE_CLASS1, CALQUE_CLASS2, CALQUE_CLASS3, CALQUE_CLASS4, CALQUE_CLASS5, CALQUE_CLASS6, CALQUE_CLASS7, CALQUE_CLASS8};
    }

    public static void initialiser(FichierCONFIG config, Cartes carte) {
        COUCHES = null;
        COUCHES = new HashMap<String, ICouche>();
        int i = 0;
        while (i < carte.getNbcouches()) {
            ICouche c = carte.getCouche(i);
            COUCHES.put(carte.getCouche(i).getNom(), c);
            ++i;
        }
        LocalisationInfo.initialiser(config, COUCHES);
    }

    public static void initialiser(FichierCONFIG config, Map<String, ICouche> couchesCarto) {
        if (config != null) {
            margeRechercheRoute = config.getInt("margeroute", 10);
            gestionFinRoute = config.getBoolean("gestionFinRoute", false);
            gestionRouteSansReferentiel = config.getBoolean("gestionRouteSansReferentiel", false);
            appliquerChangementFinRoute = config.getBoolean("appliquerChangementFinRoute", false);
            rechercheMultiCouche = config.getBoolean("rechercheMultiCouche", false);
            zoneUTM = config.getInt("zoneUTM", 30);
            hemisphereUTM = config.getString("hemisphereUTM", "N");
            autoriserErreurChainageAlertcMemeRoute = config.getBoolean("autoriserErreurChainageAlertcMemeRoute", true);
            departementPrObligatoire = config.getBoolean("departementPrObligatoire", true);
            creationPrVirtuelFinRouteSensVariable = config.getBoolean("creationPrVirtuelFinRouteSensVariable", false);
            autoriserPrNonConsecutif = config.getBoolean("autoriserPrNonConsecutif", false);
            correctionAutoAbscissePr = config.getBoolean("correctionAutoAbscissePr", false);
            differenceMaximumCorrectionAutoAbscissePr = config.getInt("differenceMaximumCorrectionAutoAbscissePr", -1);
            correctionAutoAlertc = config.getBoolean("correctionAutoAlertc", false);
            differenceMaximumCorrectionAutoAbscisseAlertc = config.getInt("differenceMaximumCorrectionAutoAbscisseAlertc", -1);
            rechercheTronconAlertcGeographique = config.getBoolean("rechercheTronconAlertcGeographique", false);
            prSensRoute = config.getBoolean("prSensRoute", false);
            appliquerMalusDistanceInterPr = config.getBoolean("appliquerMalusDistanceInterPr", false);
            correctionAutoBaionnette = config.getBoolean("correctionAutoBaionnette", false);
            estLocalisableParAdresse = config.getBoolean("rechercheAdresse", estLocalisableParAdresse);
        } else {
            margeRechercheRoute = 10;
            gestionFinRoute = true;
            gestionRouteSansReferentiel = false;
            appliquerChangementFinRoute = false;
            rechercheMultiCouche = false;
            zoneUTM = 30;
            hemisphereUTM = "N";
            autoriserErreurChainageAlertcMemeRoute = true;
            departementPrObligatoire = true;
            creationPrVirtuelFinRouteSensVariable = false;
            autoriserPrNonConsecutif = false;
            correctionAutoAbscissePr = false;
            differenceMaximumCorrectionAutoAbscissePr = -1;
            differenceMaximumCorrectionAutoAbscisseAlertc = -1;
            rechercheTronconAlertcGeographique = false;
            prSensRoute = false;
            appliquerMalusDistanceInterPr = false;
            correctionAutoBaionnette = false;
        }
        COUCHES = couchesCarto;
        if (!VOIES_LOCALISATION.containsKey(TOUTES_VOIES_LOCALISATION)) {
            VOIES_LOCALISATION.put(TOUTES_VOIES_LOCALISATION, LocalisationInfo.getVoiesLocalisationDynamique());
        }
        LocalisationInfo.setCouchePrpk();
        LocalisationInfo.setCoucheAlertc(LocalisationInfo.getCouche(CALQUE_ALERTC));
        LocalisationInfo.setCoucheDIR(LocalisationInfo.getCouche("dir"));
        LocalisationInfo.setCoucheCommuneZone(LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE));
        LocalisationInfo.setCoucheDepartement(LocalisationInfo.getCouche(CALQUE_ZONEDEPARTEMENT));
        LocalisationInfo.ecrireLog("+--> Initialisation rond point");
        LocalisationInfo.setCoucheRondPoint();
        LocalisationInfo.initialiserListeRondPoint();
        LocalisationInfo.ecrireLog("+--> Initialisation bretelle");
        LocalisationInfo.setCoucheBretellePrincipale(LocalisationInfo.getCouche("sliproad2"));
        LocalisationInfo.setCoucheBretelleSecondaire(LocalisationInfo.getCouche("sliproad"));
        LocalisationInfo.initialiserListeBretelle();
    }

    public static void setListeNomsCommunes(String[] listeNomsCommunes) {
        LocalisationInfo.listeNomsCommunes = listeNomsCommunes;
    }

    public static void setListeDptCommunes(String[] listeDptCommunes) {
        LocalisationInfo.listeDptCommunes = listeDptCommunes;
    }

    public static String[] getListeNomsCommunes() {
        return listeNomsCommunes;
    }

    public static String[] getListeDptCommunes() {
        return listeDptCommunes;
    }

    public static Vector<String> getListeRoutes() {
        Vector<String> routes = new Vector<String>();
        TreeMap hRoutes = new TreeMap();
        ICouche couche = LocalisationInfo.getCouche(CALQUE_PR);
        if (couche != null) {
            String[] axes;
            String[] stringArray = axes = couche.getDon().getColonne(0).getValeursToString();
            int n = axes.length;
            int n2 = 0;
            while (n2 < n) {
                String axe = stringArray[n2];
                routes.add(axe);
                ++n2;
            }
        }
        return LocalisationInfo.sortRD(routes);
    }

    public static Double[] getCommuneBounds(String commune) {
        Double[] bounds = null;
        Enregistrement[] enr = LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE).getDon().getEnreg(0, commune);
        if (enr.length > 0) {
            EntGeo ent = LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE).getCont().getEnt(enr[0].getNum());
            UnPoint p1 = new UnPoint(ent.getMinX(), ent.getMinY()).toLL(zoneUTM, hemisphereUTM);
            UnPoint p2 = new UnPoint(ent.getMaxX(), ent.getMaxY()).toLL(zoneUTM, hemisphereUTM);
            bounds = new Double[]{p1.X, p1.Y, p2.X, p2.Y};
        }
        return bounds;
    }

    public static Double[] getAdresseBounds(String commune, String adresse) {
        ICouche couche = LocalisationInfo.getCouche(CALQUE_ADRESSE);
        Double[] bounds = null;
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        int[] indiceRecheerche = new int[]{3, 5};
        String[] criteres = new String[]{adresse, commune};
        Enregistrement[] enr = couche.getDon().getEnreg(indiceRecheerche, criteres);
        if (enr.length > 0) {
            Enregistrement[] enregistrementArray = enr;
            int n = enr.length;
            int n2 = 0;
            while (n2 < n) {
                Enregistrement e = enregistrementArray[n2];
                EntGeo ent = couche.getCont().getEnt(enr[0].getNum());
                if (ent.getMinX() < minX) {
                    minX = ent.getMinX();
                }
                if (ent.getMaxX() > maxX) {
                    maxX = ent.getMaxX();
                }
                if (ent.getMinY() < minY) {
                    minY = ent.getMinY();
                }
                if (ent.getMaxY() > maxY) {
                    maxY = ent.getMinX();
                }
                ++n2;
            }
            UnPoint p1 = new UnPoint(minX, minY).toLL(zoneUTM, hemisphereUTM);
            UnPoint p2 = new UnPoint(maxX, maxY).toLL(zoneUTM, hemisphereUTM);
            bounds = new Double[]{p1.X, p1.Y, p2.X, p2.Y};
        }
        return bounds;
    }

    public static Vector<String> getListePr(String axe) {
        TreeMap<Integer, String> hPR = new TreeMap<Integer, String>();
        if (LocalisationInfo.getCouche(CALQUE_PR) != null) {
            Enregistrement[] prs;
            Enregistrement[] enregistrementArray = prs = LocalisationInfo.getCouche(CALQUE_PR).getDon().getEnreg(0, axe);
            int n = prs.length;
            int n2 = 0;
            while (n2 < n) {
                Enregistrement pr = enregistrementArray[n2];
                try {
                    hPR.put(Integer.valueOf(pr.getValeur(1)), pr.getValeur(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return new Vector<String>(hPR.values());
    }

    public static Vector<String> getListeAdresse(String commune) {
        Enregistrement[] enr;
        Vector<String> listeAdresse = new Vector<String>();
        if (LocalisationInfo.getCouche(CALQUE_ADRESSE) != null && LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE) != null && (enr = LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE).getDon().getEnreg(0, commune)).length == 1) {
            Enregistrement[] adresses;
            String insee = enr[0].getValeur(1);
            Enregistrement[] enregistrementArray = adresses = LocalisationInfo.getCouche(CALQUE_ADRESSE).getDon().getEnreg(4, insee);
            int n = adresses.length;
            int n2 = 0;
            while (n2 < n) {
                Enregistrement adresse = enregistrementArray[n2];
                listeAdresse.add(adresse.getValeur(3));
                ++n2;
            }
        }
        return LocalisationInfo.sortRD(listeAdresse);
    }

    public static Vector<String> getListeNumero(String commune, String adresse) {
        Enregistrement[] enr;
        TreeMap<Object, String> hAdresse = new TreeMap<Object, String>(MyCollator.create());
        if (LocalisationInfo.getCouche(CALQUE_ADRESSE) != null && LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE) != null && (enr = LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE).getDon().getEnreg(0, commune)).length == 1) {
            Enregistrement[] adresses;
            String insee = enr[0].getValeur(1);
            int[] indiceRecherche = new int[]{3, 4};
            String[] critere = new String[]{adresse, insee};
            Enregistrement[] enregistrementArray = adresses = LocalisationInfo.getCouche(CALQUE_ADRESSE).getDon().getEnreg(indiceRecherche, critere);
            int n = adresses.length;
            int n2 = 0;
            while (n2 < n) {
                Enregistrement adr = enregistrementArray[n2];
                String n3 = adr.getValeur(1);
                String c = adr.getValeur(2);
                hAdresse.put(LocalisationInfo.getNumAdresse(String.valueOf(n3) + c), String.valueOf(n3) + (GLS.estVide(c) ? "" : VAL_STR_NEANT_CARTOJ + c));
                ++n2;
            }
        }
        Iterator it = hAdresse.values().iterator();
        Vector<String> eltTrie = new Vector<String>();
        while (it.hasNext()) {
            eltTrie.add((String)it.next());
        }
        return eltTrie;
    }

    public static Double[] getNumeroBounds(String commune, String adresse, String numero) {
        Enregistrement[] enr;
        Double[] bounds = null;
        if (LocalisationInfo.getCouche(CALQUE_ADRESSE) != null && LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE) != null && (enr = LocalisationInfo.getCouche(CALQUE_ZONECOMMUNE).getDon().getEnreg(0, commune)).length == 1) {
            String insee = enr[0].getValeur(1);
            String[] numreRep = numero.split(VAL_STR_NEANT_CARTOJ);
            int[] indiceRecherche = new int[]{1, 2, 3, 4};
            String[] critere = new String[]{numreRep[0], numreRep.length == 2 ? numreRep[1] : "", adresse, insee};
            Enregistrement[] adresses = LocalisationInfo.getCouche(CALQUE_ADRESSE).getDon().getEnreg(indiceRecherche, critere);
            if (adresses.length > 0) {
                EntGeo ent = LocalisationInfo.getCouche(CALQUE_ADRESSE).getCont().getEnt(adresses[0].getNum());
                UnPoint p1 = new UnPoint(ent.getX()[0], ent.getY()[0]).toLL(zoneUTM, hemisphereUTM);
                bounds = new Double[]{p1.X, p1.Y};
            }
        }
        return bounds;
    }

    public static Double[] getPrBounds(String axe, String pr) {
        Double[] bounds = null;
        if (LocalisationInfo.getCouche(CALQUE_PR) != null) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] indiceRecherche = nArray;
            String[] critere = new String[]{axe, pr};
            Enregistrement[] prs = LocalisationInfo.getCouche(CALQUE_PR).getDon().getEnreg(indiceRecherche, critere);
            if (prs.length > 0) {
                EntGeo ent = LocalisationInfo.getCouche(CALQUE_PR).getCont().getEnt(prs[0].getNum());
                UnPoint p1 = new UnPoint(ent.getX()[0], ent.getY()[0]).toLL(zoneUTM, hemisphereUTM);
                bounds = new Double[]{p1.X, p1.Y};
            }
        }
        return bounds;
    }

    public static void initialiserAxeCommune(String fichierAxecommune) {
        axeCommunes = null;
        axeCommunes = new HashMap<String, String[]>();
        FichierCONFIG conf = new FichierCONFIG(fichierAxecommune);
        for (Object k : conf.getChamps()) {
            axeCommunes.put(k.toString(), conf.getTableauString(k.toString()));
        }
    }

    public static Map<String, InfoVoieLocalisation> getVoiesLocalisation() {
        return VOIES_LOCALISATION;
    }

    public static Double[] getPrBounds(String dpt, String axe, String pr) {
        Double[] bounds = null;
        if (LocalisationInfo.getCouche(CALQUE_PR) != null) {
            int[] nArray = new int[3];
            nArray[0] = 2;
            nArray[2] = 1;
            int[] indiceRecherche = nArray;
            String[] critere = new String[]{dpt, axe, pr};
            Enregistrement[] prs = LocalisationInfo.getCouche(CALQUE_PR).getDon().getEnreg(indiceRecherche, critere);
            if (prs.length > 0) {
                EntGeo ent = LocalisationInfo.getCouche(CALQUE_PR).getCont().getEnt(prs[0].getNum());
                UnPoint p1 = new UnPoint(ent.getX()[0], ent.getY()[0]).toLL(zoneUTM, hemisphereUTM);
                bounds = new Double[]{p1.X, p1.Y};
            }
        }
        return bounds;
    }
}

