/*
 * Decompiled with CFR 0.152.
 */
package gls.localisation;

import cartoj.Enregistrement;
import cartoj.ICouche;
import cartoj.IFichierCont;
import cartoj.IFichierDon;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.geometry.Geometry;
import gls.localisation.GestionRoute;
import gls.localisation.InfoTroncon;
import gls.localisation.InfoVoieLocalisation;
import gls.localisation.LocalisationInfo;
import gls.localisation.Sens;
import gls.localisation.alertc.LocalisantAlertc;
import gls.localisation.construction.Construction;
import gls.localisation.construction.ConstructionInfo;
import gls.localisation.distance.Distance;
import gls.localisation.distance.DistanceInfo;
import gls.localisation.exception.ErreurAlertc;
import gls.localisation.exception.ErreurAucuneRoute;
import gls.localisation.exception.ErreurAxeInconnu;
import gls.localisation.exception.ErreurLimiteRoute;
import gls.localisation.exception.ErreurLocalisation;
import gls.localisation.exception.ErreurPR;
import gls.localisation.exception.ErreurRouteModification;
import gls.localisation.exception.ErreurTriTroncon;
import gls.localisation.exception.LocalisationErreurDistancePrpk;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.localisation.tri.BretelleInfo;
import gls.localisation.tri.Tri;
import gls.localisation.tri.TriBretelle;
import gls.localisation.tri.TriFactory;
import gls.localisation.tri.TriRoute;
import gls.outils.GLS;
import java.util.Vector;

public class Localisation {
    public static final String AUCUNE_ROUTE = "";
    private boolean verrouillerNomRoute = false;
    private boolean verrouillerIdgdfBretelle = false;
    private boolean verrouillerIdgdf = false;
    private boolean rechercheAlertcRoute;
    private boolean recherchePrpkRoute;
    private boolean rechercheCommuneRoute;
    private boolean rechercheCeiRoute;
    private boolean autoriserLocalisationSansRoute;
    private boolean estRouteAlertc;
    private boolean estRoutePrpk;
    protected boolean positionnee;
    protected boolean initialisee;
    private boolean departementPrObligatoire = true;
    private String positionEvenement;
    protected GeoPoint pointCourant;
    private String nomRouteSelectionnee = null;
    private String idgdfRouteAssociee = null;
    private String idgdfRoute = null;
    private double longueurEvenement;
    private boolean clicDroit = false;
    private GeoPositionnement dernierPositionnement;
    protected Recherche recherche = new Recherche(this);
    protected Distance distance = null;
    protected Construction construction = new Construction(this);
    protected ConstructionInfo constructionInfo = null;
    protected Sens sens = new Sens(this);
    protected GestionRoute gestionRoute = new GestionRoute(this);
    protected Tri tri = null;
    protected String[] couchesPrimaires;
    protected String[] couchesSecondaires;

    public Distance getDistance() {
        return this.distance;
    }

    public Localisation() {
        this.distance = new Distance(this);
        this.rechercheAlertcRoute = true;
        this.recherchePrpkRoute = true;
        this.rechercheCommuneRoute = LocalisationInfo.estLocalisableParCommune;
        this.rechercheCeiRoute = LocalisationInfo.estLocalisableParCei;
        this.positionnee = false;
        this.initialisee = false;
        this.positionEvenement = LocalisationInfo.POSITION_DEFAUT;
        this.longueurEvenement = 0.0;
        this.nomRouteSelectionnee = null;
        this.idgdfRouteAssociee = null;
        this.verrouillerIdgdfBretelle = false;
        this.verrouillerNomRoute = false;
        this.autoriserLocalisationSansRoute = false;
        this.departementPrObligatoire = LocalisationInfo.departementPrObligatoire;
        this.couchesPrimaires = LocalisationInfo.LISTE_ROUTES_PRINCIPALES;
        this.couchesSecondaires = LocalisationInfo.LISTE_ROUTES_SECONDAIRES;
    }

    public Localisation(boolean rechercheAlertc, boolean recherchePrpk, boolean rechercheCommune, boolean rechercheCei) {
        this.distance = new Distance(this);
        this.rechercheAlertcRoute = rechercheAlertc;
        this.recherchePrpkRoute = recherchePrpk;
        this.rechercheCommuneRoute = rechercheCommune;
        this.rechercheCeiRoute = rechercheCei;
        this.positionnee = false;
        this.initialisee = false;
        this.positionEvenement = LocalisationInfo.POSITION_DEFAUT;
        this.longueurEvenement = 0.0;
        this.nomRouteSelectionnee = null;
        this.idgdfRouteAssociee = null;
        this.verrouillerIdgdfBretelle = false;
        this.verrouillerNomRoute = false;
        this.autoriserLocalisationSansRoute = false;
        this.departementPrObligatoire = LocalisationInfo.departementPrObligatoire;
        this.couchesPrimaires = LocalisationInfo.LISTE_ROUTES_PRINCIPALES;
        this.couchesSecondaires = LocalisationInfo.LISTE_ROUTES_SECONDAIRES;
    }

    public Localisation(boolean rechercheAlertc, boolean recherchePrpk, boolean rechercheCommune, boolean rechercheCei, boolean initialisee, boolean positionnee, String position, double longueur, String nomRoute, String idgdfRouteAssociee, boolean verrouillerIdgdfBretelle, boolean verrouillerNomRoute) {
        this.distance = new Distance(this);
        this.rechercheAlertcRoute = rechercheAlertc;
        this.recherchePrpkRoute = recherchePrpk;
        this.rechercheCommuneRoute = rechercheCommune;
        this.rechercheCeiRoute = rechercheCei;
        this.positionnee = positionnee;
        this.initialisee = initialisee;
        this.positionEvenement = position;
        this.longueurEvenement = longueur;
        this.nomRouteSelectionnee = nomRoute;
        this.idgdfRouteAssociee = idgdfRouteAssociee;
        this.verrouillerIdgdfBretelle = verrouillerIdgdfBretelle;
        this.verrouillerNomRoute = verrouillerNomRoute;
        this.autoriserLocalisationSansRoute = false;
        this.departementPrObligatoire = LocalisationInfo.departementPrObligatoire;
        this.couchesPrimaires = LocalisationInfo.LISTE_ROUTES_PRINCIPALES;
        this.couchesSecondaires = LocalisationInfo.LISTE_ROUTES_SECONDAIRES;
    }

    public boolean distanceAtPoint(GeoPoint pointFin) throws ErreurLocalisation, ErreurTriTroncon, ErreurPR, ErreurAlertc, ErreurLimiteRoute {
        DistanceInfo distanceInfo = this.distance.distanceAtPoint(pointFin);
        if (distanceInfo != null && !distanceInfo.estNulle()) {
            this.setPosition(distanceInfo.getPositionnement());
            this.setLongueur(distanceInfo.getDistance());
            return true;
        }
        return false;
    }

    public String getMessageErreurBaionnetteDebut(int distanceBaionnette) {
        return "Le PR de d\u00e9but est un point ba\u00efonnette - la distance minimum requise est de " + distanceBaionnette;
    }

    public String getMessageErreurBaionnetteFin(int distanceBaionnette) {
        return "Le PR de fin est un point ba\u00efonnette - la distance minimum requise est de " + distanceBaionnette;
    }

    public boolean estAutoriserLocalisationSansRoute() {
        return this.autoriserLocalisationSansRoute;
    }

    public void setAutoriserLocalisationSansRoute(boolean autoriserLocalisationSansRoute) {
        this.autoriserLocalisationSansRoute = autoriserLocalisationSansRoute;
    }

    public void initialiser(double x, double y) throws ErreurLocalisation, ErreurAucuneRoute, ErreurRouteModification, ErreurTriTroncon, Exception {
        this.initialiser(new GeoPoint(x, y), false);
    }

    public void relocaliser(GeoPoint point) throws ErreurLocalisation, ErreurPR, ErreurLimiteRoute, ErreurAucuneRoute, ErreurRouteModification, ErreurTriTroncon, Exception {
        this.relocaliser(point, false);
    }

    public void initialiser(GeoPoint point) throws ErreurLocalisation, ErreurAucuneRoute, ErreurRouteModification, ErreurTriTroncon, Exception {
        this.initialiser(point, false);
    }

    public void initialiser(GeoPoint point, boolean clicDroit) throws ErreurLocalisation, ErreurAucuneRoute, ErreurRouteModification, ErreurTriTroncon, Exception {
        this.initialisee = false;
        GeoPositionnement geoPositionnement = null;
        this.clicDroit = clicDroit;
        geoPositionnement = this.recherche.getRouteAtPoint(point, clicDroit);
        this.pointCourant = point;
        if (!Localisation.estRattacheAUneRoute(geoPositionnement) && this.autoriserLocalisationSansRoute) {
            this.initialisee = true;
            this.tri = null;
            this.constructionInfo = this.construction.getConstructionInfoSansRoute(point);
            this.nomRouteSelectionnee = AUCUNE_ROUTE;
        } else {
            this.initialiser(geoPositionnement);
        }
    }

    public boolean estSansRoute() {
        return this.tri == null && GLS.estVide(this.nomRouteSelectionnee) && this.autoriserLocalisationSansRoute;
    }

    public static boolean estRattacheAUneRoute(GeoPositionnement position) {
        return position == null || position.getTroncon() != null;
    }

    public void relocaliser(GeoPoint point, boolean clicDroit) throws ErreurLocalisation, ErreurLimiteRoute, ErreurPR, ErreurAucuneRoute, ErreurRouteModification, ErreurTriTroncon, Exception {
        this.initialiser(point, clicDroit);
        if (!this.estSansRoute()) {
            this.relocaliser();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void relocaliser() throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute {
        if (!this.estSansRoute()) {
            if (!this.initialisee) throw new ErreurLocalisation("#--> LOCALISATION NON INITIALISEE");
            this.positionnee = false;
            this.constructionInfo = this.construction.construitEvenement();
            this.positionnee = true;
            if (this.constructionInfo.getLongueur() < this.getLongueur()) {
                this.setLongueur(this.constructionInfo.getLongueur());
                throw new ErreurLimiteRoute();
            }
        } else {
            this.positionnee = true;
        }
        LocalisationInfo.ecrireLogDebug("Relocalisation terminee");
    }

    public void relocaliser(long alertcDebut, long distanceAlertcDebut, long alertcFin, long distanceAlertcFin, double distanceAlertc, String sensAlertc, String codePays) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute {
        this.relocaliser(new LocalisantAlertc(alertcDebut, codePays, distanceAlertcDebut), new LocalisantAlertc(alertcFin, codePays, distanceAlertcFin), distanceAlertc, sensAlertc);
    }

    public void relocaliser(long alertcDebut, long distanceAlertcDebut, long alertcFin, long distanceAlertcFin, double distanceAlertc, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute {
        this.relocaliser(alertcDebut, distanceAlertcDebut, alertcFin, distanceAlertcFin, distanceAlertc, sensAlertc, "F32");
    }

    public void relocaliser(long alertcDebut, long distanceAlertcDebut, long alertcFin, long distanceAlertcFin, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute {
        this.relocaliser(new LocalisantAlertc(alertcDebut, distanceAlertcDebut), new LocalisantAlertc(alertcFin, distanceAlertcFin), -1.0, sensAlertc);
    }

    public void relocaliser(LocalisantAlertc alertcDebut, LocalisantAlertc alertcFin, double distanceAlertc, String sensAlertc) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute {
        this.positionnee = false;
        this.constructionInfo = this.construction.construitEvenement(alertcDebut, alertcFin, distanceAlertc, sensAlertc);
        this.positionnee = true;
        if (this.constructionInfo.getLongueur() < this.getLongueur()) {
            this.setLongueur(this.constructionInfo.getLongueur());
            throw new ErreurLimiteRoute();
        }
    }

    public void relocaliser(String prDebut, String prFin, String route, boolean sensPr) throws ErreurLocalisation, ErreurPR, ErreurAlertc, ErreurAxeInconnu, ErreurTriTroncon, ErreurLimiteRoute, LocalisationErreurDistancePrpk {
        this.relocaliser(new LocalisantPr(prDebut), new LocalisantPr(prFin), route, sensPr);
    }

    public void relocaliser(LocalisantPr prDebut, LocalisantPr prFin, String route, boolean sensPr) throws ErreurLocalisation, ErreurAxeInconnu, ErreurPR, ErreurAlertc, ErreurTriTroncon, ErreurLimiteRoute, LocalisationErreurDistancePrpk {
        this.positionnee = false;
        if (this.verrouillerNomRoute && route != null && !route.equals(this.nomRouteSelectionnee)) {
            throw new ErreurLocalisation("LA ROUTE N'EST PAS LA MEME");
        }
        this.constructionInfo = this.construction.construitEvenement(prDebut, prFin, route, sensPr);
        this.positionnee = true;
        if (this.constructionInfo.getLongueur() < this.getLongueur()) {
            this.setLongueur(this.constructionInfo.getLongueur());
            throw new ErreurLimiteRoute();
        }
    }

    public void relocaliser(String position) throws ErreurLocalisation, ErreurPR, ErreurLimiteRoute, Exception {
        this.positionnee = false;
        this.positionEvenement = position;
        this.relocaliser();
    }

    public void relocaliser(double longueur) throws ErreurLocalisation, ErreurPR, ErreurLimiteRoute, Exception {
        this.positionnee = false;
        this.longueurEvenement = longueur;
        this.relocaliser();
    }

    public GeoPoint getPoint() {
        if (this.estSansRoute()) {
            return this.pointCourant;
        }
        return this.tri.getGeoPositionnement().getPoint();
    }

    public GeoPoint getPointClic() {
        if (this.pointCourant != null) {
            return this.pointCourant;
        }
        return this.tri.getGeoPositionnement().getPoint();
    }

    public String getRoute() {
        if (this.tri != null) {
            return this.tri.getRoute();
        }
        return this.nomRouteSelectionnee;
    }

    public String getAdresse() {
        int iFinAdresse;
        String route = this.getRoute();
        int iDebAdresse = route.indexOf("(");
        if (iDebAdresse > 0 && (iFinAdresse = route.indexOf(")")) == route.length() - 1) {
            route = route.substring(iDebAdresse + 1, iFinAdresse);
        }
        return route;
    }

    public Vector getRoutes() {
        Vector listeRoutes = new Vector();
        if (this.tri != null) {
            if (this.tri.estBretelle()) {
                listeRoutes = ((TriBretelle)this.tri).getListeNomRoutes();
            } else if (!LocalisationInfo.estNulle(this.tri.getRoute())) {
                listeRoutes.add(this.tri.getRoute());
            }
        }
        return listeRoutes;
    }

    public GestionRoute getGestionRoute() {
        return this.gestionRoute;
    }

    public void setRoute(String route) {
        this.nomRouteSelectionnee = route;
    }

    public String getIdgdfRouteAssociee() {
        return this.idgdfRouteAssociee;
    }

    public void setIdgdfRouteAssociee(String idgdfRouteAssociee) {
        this.idgdfRouteAssociee = idgdfRouteAssociee;
    }

    public ICouche getCouche() {
        if (this.tri != null && this.tri.getTronconDepart() != null) {
            return this.tri.getTronconDepart().getCouche();
        }
        return null;
    }

    public ICouche getCoucheRoute() {
        if (this.tri != null) {
            return TriFactory.getCoucheRoute(this.tri);
        }
        return null;
    }

    public IFichierCont getContRoute() {
        if (this.tri != null) {
            return TriFactory.getCoucheRoute(this.tri).getCont();
        }
        return null;
    }

    public IFichierDon getDonRoute() {
        if (this.tri != null) {
            return TriFactory.getCoucheRoute(this.tri).getDon();
        }
        return null;
    }

    public static void initialiserAlertc(String cheminAlertc) {
        LocalisationInfo.initialiserAlertc(cheminAlertc);
    }

    public boolean estPositionnee() {
        return this.positionnee && this.initialisee;
    }

    public boolean estInitialisee() {
        return this.initialisee;
    }

    public void setEstInitialisee(boolean etat) {
        this.positionnee = etat;
    }

    public LocalisantPr getPrDebut() {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getPrDebut();
        }
        return null;
    }

    public LocalisantPr getPrFin() {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getPrFin();
        }
        return null;
    }

    public LocalisantAlertc getAlertcDebut() {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getAlertcDebut();
        }
        return null;
    }

    public GeoPositionnement getDernierPositionnement() throws Exception {
        if (this.dernierPositionnement != null) {
            return this.dernierPositionnement;
        }
        return this.tri.getGeoPositionnement();
    }

    public void setDernierPositionnement(GeoPositionnement dernierPositionnement) {
        this.dernierPositionnement = dernierPositionnement;
    }

    public LocalisantAlertc getAlertcFin() {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getAlertcFin();
        }
        return null;
    }

    public Vector<GeoPoint> getListePoints() {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getListePoints();
        }
        return null;
    }

    public float[][] getPoints() {
        if (this.constructionInfo != null) {
            return Geometry.toFloat(this.constructionInfo.getListePoints());
        }
        return null;
    }

    public GeoPoint getDernierPoint() throws Exception {
        if (!GLS.estVide(this.constructionInfo.getListePoints())) {
            return this.constructionInfo.getListePoints().lastElement();
        }
        throw new Exception("LA LISTE DES POINTS EST VIDE # IMPOSSIBLE DE DETERMINER LE DERNIER POINT");
    }

    public ConstructionInfo getConstructionInfo() {
        return this.constructionInfo;
    }

    public void setConstructionInfo(ConstructionInfo constructionInfo) {
        this.constructionInfo = constructionInfo;
    }

    public GeoPositionnement getDernierGeoPositionnement() throws Exception {
        if (this.constructionInfo != null) {
            return this.constructionInfo.getDernierPositionnement();
        }
        throw new Exception("ERREUR LE DERNIER POSITIONNEMENT EST VIDE");
    }

    public void setEstPositionnee(boolean etat) {
        this.positionnee = etat;
    }

    public void setPosition(String position) {
        this.positionEvenement = position;
    }

    public String getPosition() {
        return this.positionEvenement;
    }

    public boolean estEnTete() {
        return this.getPosition().equals("t");
    }

    public boolean estEnQueue() {
        return this.getPosition().equals("q");
    }

    public void setLongueur(double longueur) {
        this.longueurEvenement = Math.round(longueur);
    }

    public double getLongueur() {
        return Math.round(this.longueurEvenement);
    }

    public void setRechercheAlertc(boolean recherche) {
        this.rechercheAlertcRoute = recherche;
    }

    public boolean getRechercheAlertc() {
        return this.rechercheAlertcRoute;
    }

    public void setRecherchePrpk(boolean recherche) {
        this.recherchePrpkRoute = recherche;
    }

    public boolean getRecherchePrpk() {
        return this.recherchePrpkRoute;
    }

    public void setRechercheCommune(boolean recherche) {
        this.rechercheCommuneRoute = recherche;
    }

    public boolean getRechercheCommune() {
        return this.rechercheCommuneRoute;
    }

    public void setRechercheCei(boolean recherche) {
        this.rechercheCeiRoute = recherche;
    }

    public boolean getRechercheCei() {
        return this.rechercheCeiRoute;
    }

    public boolean estEvenementDoubleSens() {
        return this.sens.getDoubleSens();
    }

    public void initialiserTri(GeoPositionnement geoPositionnement) {
        this.tri = TriFactory.initialiser(this, geoPositionnement, this.tri);
    }

    public void initialiser(ICouche couche, Enregistrement troncon, GeoPoint point) throws ErreurLocalisation, ErreurTriTroncon {
        this.initialiser(new GeoPositionnement(point, troncon, couche));
    }

    public void reinitialiser() throws ErreurLocalisation, ErreurTriTroncon {
        this.reinitialiser(true);
    }

    public void reinitialiser(boolean verifierSens) throws ErreurLocalisation, ErreurTriTroncon {
        this.initialisee = false;
        TriFactory.trier(this, this.tri);
        this.gestionRoute.traitementReferentiels();
        this.sens.miseAJour(verifierSens);
        this.initialisee = true;
    }

    public void reinitialiserTri(GeoPositionnement positionnement) throws Exception {
        boolean sensTri = this.tri.getSensTroncon(positionnement.getTroncon());
        this.reinitialiserTri(positionnement, sensTri);
    }

    public void reinitialiserTri(GeoPositionnement positionnement, boolean sensTri) throws Exception {
        this.tri.reinitialiser(positionnement, sensTri);
        this.sens.setSensChainage(sensTri);
    }

    public void initialiser(GeoPositionnement geoPositionnement) throws ErreurLocalisation, ErreurTriTroncon {
        this.initialiser(geoPositionnement, true);
    }

    public void initialiser(GeoPositionnement geoPositionnement, boolean verifierSens) throws ErreurLocalisation, ErreurTriTroncon {
        LocalisationInfo.ecrireLog("+--> Initialisation de la localisation");
        this.tri = TriFactory.initialiser(this, geoPositionnement, this.tri);
        this.reinitialiser(verifierSens);
    }

    public void reinitialiserBretelle() throws ErreurLocalisation, ErreurTriTroncon {
        this.initialisee = false;
        this.gestionRoute.traitementReferentiels();
        this.sens.miseAJour();
        this.initialisee = true;
    }

    public void setEstRoutePrpk(boolean estRoutePrpk) {
        this.estRoutePrpk = estRoutePrpk;
    }

    public boolean getEstRoutePrpk() {
        return this.estRoutePrpk;
    }

    public boolean getEstRouteAlertc() {
        return this.estRouteAlertc;
    }

    public boolean getEstBretelle() {
        if (this.tri != null) {
            return this.tri.estBretelle();
        }
        return false;
    }

    public void setEstRouteAlertc(boolean estRouteAlertc) {
        this.estRouteAlertc = estRouteAlertc;
    }

    public Sens getSens() {
        return this.sens;
    }

    public Tri getTri() {
        return this.tri;
    }

    public GeoPositionnement getGeoPositionnement() {
        return this.tri.getGeoPositionnement();
    }

    public InfoTroncon getTronconRoute() {
        if (this.getTriRoute() != null) {
            return this.getTriRoute().getTronconDepart();
        }
        return null;
    }

    public InfoTroncon getTroncon() {
        return this.tri.getTronconDepart();
    }

    public TriRoute getTriRoute(Tri tri) {
        return TriFactory.getTriRoute(tri);
    }

    public BretelleInfo getTronconAssocie() {
        if (this.tri.estBretelle()) {
            return ((TriBretelle)this.tri).getBretelleInfoAssociee();
        }
        return null;
    }

    public TriRoute getTriRoute() {
        return this.getTriRoute(this.tri);
    }

    public void initialiserBretelle(int numRoute) throws ErreurLocalisation, ErreurTriTroncon {
        if (this.tri.estBretelle()) {
            ((TriBretelle)this.tri).setBretelleInfoAssociee(numRoute);
            try {
                ((TriBretelle)this.tri).trierRouteAssociee();
                this.reinitialiserBretelle();
            }
            catch (ErreurLocalisation erreur) {
                ((TriBretelle)this.tri).supprimerRouteAssociee();
                throw erreur;
            }
            catch (ErreurTriTroncon erreur) {
                ((TriBretelle)this.tri).supprimerRouteAssociee();
                throw erreur;
            }
        }
    }

    public String getCei() {
        return this.constructionInfo.getCei();
    }

    public String getDistrict() {
        return this.constructionInfo.getDistrict();
    }

    public String getCommune() {
        return this.constructionInfo.getCommune();
    }

    public boolean getVerrouillageNomRoute() {
        return this.verrouillerNomRoute;
    }

    public void setVerrouillageNomRoute(boolean verrouiller, String nomRoute) {
        this.verrouillerNomRoute = verrouiller;
        this.nomRouteSelectionnee = nomRoute;
    }

    public String getNomRouteVerrouillee() {
        if (this.verrouillerNomRoute) {
            return this.nomRouteSelectionnee;
        }
        return null;
    }

    public boolean getVerrouillageIdgdfRouteAssociee() {
        return this.verrouillerIdgdfBretelle;
    }

    public boolean getVerrouillageIdgdfRoute() {
        return this.verrouillerIdgdf;
    }

    public String getIdgdfRoute() {
        return this.idgdfRoute;
    }

    public void setVerrouillageIdgdfRouteAssociee(boolean verrouiller, String idgdfRouteAssocie) {
        this.verrouillerIdgdfBretelle = verrouiller;
        this.idgdfRouteAssociee = idgdfRouteAssocie;
    }

    public void setVerrouillageIdgdfRoute(boolean verrouiller, String idgdfRoute) {
        this.verrouillerIdgdf = verrouiller;
        this.idgdfRoute = idgdfRoute;
    }

    public String getInfoBretelle() {
        if (this.tri != null && this.tri.estBretelle()) {
            return ((TriBretelle)this.tri).getBretelleInfoAssociee().getInfoTroncon().getIdgdf();
        }
        return AUCUNE_ROUTE;
    }

    public boolean estDepartementPrObligatoire() {
        return this.departementPrObligatoire;
    }

    public void setDepartementPrObligatoire(boolean departementPrObligatoire) {
        this.departementPrObligatoire = departementPrObligatoire;
    }

    public String[] getCouchesPrimaires() {
        return this.couchesPrimaires;
    }

    public void setCouchesPrimaires(String[] couchesPrimaires) {
        this.couchesPrimaires = couchesPrimaires;
    }

    public String[] getCouchesSecondaires() {
        return this.couchesSecondaires;
    }

    public void setCouchesSecondaires(String[] couchesSecondaires) {
        this.couchesSecondaires = couchesSecondaires;
    }

    public void miseAJourVoieLocalisation(String valeur) {
        InfoVoieLocalisation v = LocalisationInfo.getVoieLocalisation(valeur);
        this.couchesPrimaires = v.getCouchesPrincipales();
        this.couchesSecondaires = v.getCouchesSecondaires();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Axe = " + this.getRoute());
        sb.append("\n");
        if (this.estRoutePrpk) {
            sb.append("PR debut = " + this.getPrDebut().toString());
            sb.append("\n");
            sb.append("PR fin = " + this.getPrFin().toString());
            sb.append("\n");
            sb.append(this.getSens().getSensRoutePrpkOk());
        }
        return sb.toString();
    }
}

